"""
    EVENTS AND TRANSCRIPTS API

    <p>The Calendar Events API provides access to FactSet’s Event Calendar data alongside business logic that allows users to replicate views and functionality consistent with the experience provided by the Workstation. This API provides the ability to pull Event Calendar data based on specific filters.</p> <p>Events Audio API provides access to historical as well as the latest audio recordings of various company events covered by FactSet. The events include, but are not limited to: earnings calls, conferences, and investor days. This API also provides relevant metadata such as timestamps and identifiers around each audio file.</p> <p>The  Near Real-time Transcripts API enables access to Near Real-time Transcripts provided by CallStreet to time-sensitive clients. This API also provides the relevant speaker metadata along with their confidence scores. This data caters to quant clients interested in building machine learning models. Clients can leverage this API to perform sentiment analysis through natural language processing or machine learning. It can also be used to complement analysis using FactSet's transcripts service.</p> <p>Transcripts API provides conference call transcripts for companies' publicly held conference calls and a wealth of information regarding upcoming corporate events, such as conference call date and time, phone number and password, type of conference call, and important company investor relations contact information.</p>    # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.EventsandTranscripts.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.EventsandTranscripts.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.EventsandTranscripts.exceptions import ApiException
from fds.sdk.EventsandTranscripts.model.error import Error
from fds.sdk.EventsandTranscripts.model.indexed_nrt import IndexedNrt
from fds.sdk.EventsandTranscripts.model.nrt_calls import NrtCalls
from fds.sdk.EventsandTranscripts.model.nrt_speaker_ids import NrtSpeakerIds





class NearRealTimeTranscriptsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.get_bulk_documents_nrt_v1_calls_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (NrtCalls,), 400: (Error,), 401: (Error,), 403: (Error,), 500: (Error,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/nrt/by-ticker',
                'operation_id': 'get_bulk_documents_nrt_v1_calls',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ticker',
                    'entity_id',
                    'call_status',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'call_status',
                    'sort',
                ],
                'validation': [
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'max_items': 2,
                    },
                },
                'allowed_values': {
                    ('call_status',): {

                        "INPROGRESS": "InProgress",
                        "ENDED": "Ended",
                        "EWN": "EWN",
                        "ISSUEATSOURCE": "IssueAtSource"
                    },
                    ('sort',): {

                        "EVENTDATETIMEUTC": "eventDatetimeUtc",
                        "-EVENTDATETIMEUTC": "-eventDatetimeUtc"
                    },
                },
                'openapi_types': {
                    'ticker':
                        (str,),
                    'entity_id':
                        (str,),
                    'call_status':
                        (str,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'ticker': 'ticker',
                    'entity_id': 'entityId',
                    'call_status': 'callStatus',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'ticker': 'query',
                    'entity_id': 'query',
                    'call_status': 'query',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_bulk_documents_nrt_v1_calls_by_audio_source_id_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (NrtCalls,), 400: (Error,), 401: (Error,), 403: (Error,), 500: (Error,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/nrt/by-ids',
                'operation_id': 'get_bulk_documents_nrt_v1_calls_by_audio_source_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'audio_source_id',
                    'report_id',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'max_items': 2,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "EVENTDATETIMEUTC": "eventDatetimeUtc",
                        "-EVENTDATETIMEUTC": "-eventDatetimeUtc"
                    },
                },
                'openapi_types': {
                    'audio_source_id':
                        (int,),
                    'report_id':
                        (int,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'audio_source_id': 'audioSourceId',
                    'report_id': 'reportId',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'audio_source_id': 'query',
                    'report_id': 'query',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_bulk_documents_nrt_v1_indexedrt_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (IndexedNrt,), 400: (Error,), 401: (Error,), 403: (Error,), 500: (Error,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/nrt/indexed',
                'operation_id': 'get_bulk_documents_nrt_v1_indexedrt',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'audio_source_id',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [
                    'audio_source_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'pagination_limit',
                ]
            },
            root_map={
                'validations': {
                    ('pagination_limit',): {

                        'inclusive_maximum': 50,
                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'audio_source_id':
                        (int,),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'audio_source_id': 'audioSourceId',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'audio_source_id': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_bulk_documents_nrt_v1_speaker_ids_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (NrtSpeakerIds,), 400: (Error,), 401: (Error,), 403: (Error,), 500: (Error,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/nrt/speakerids',
                'operation_id': 'get_bulk_documents_nrt_v1_speaker_ids',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'audio_source_id',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [
                    'audio_source_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'max_items': 2,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "SPEAKERSTARTOFFSET": "speakerStartOffset",
                        "-SPEAKERSTARTOFFSET": "-speakerStartOffset"
                    },
                },
                'openapi_types': {
                    'audio_source_id':
                        (int,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'audio_source_id': 'audioSourceId',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'audio_source_id': 'query',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )


    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")


    def get_bulk_documents_nrt_v1_calls(
        self,
        **kwargs
    ) -> NrtCalls:
        """Returns the active calls happening at the moment based on ticker,call status and entity ID.  # noqa: E501

        Returns the active calls happening at the moment  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            ticker (str): Ticker-region identifier for the company hosting the event.. [optional]
            entity_id (str): Factset entity level identifier for the company hosting the event.. [optional]
            call_status (str): Status of the call, i.e., Ended, InProgress, EndedWithoutNotification, or IssueAtSource.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDatetimeUtc. . [optional] if omitted the server will use the default value of ["-eventDatetimeUtc"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            NrtCalls
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_bulk_documents_nrt_v1_calls_endpoint.call_with_http_info(**kwargs)

    def get_bulk_documents_nrt_v1_calls_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[NrtCalls, int, typing.MutableMapping]:
        """Returns the active calls happening at the moment based on ticker,call status and entity ID.  # noqa: E501

        Returns the active calls happening at the moment  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            ticker (str): Ticker-region identifier for the company hosting the event.. [optional]
            entity_id (str): Factset entity level identifier for the company hosting the event.. [optional]
            call_status (str): Status of the call, i.e., Ended, InProgress, EndedWithoutNotification, or IssueAtSource.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDatetimeUtc. . [optional] if omitted the server will use the default value of ["-eventDatetimeUtc"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            NrtCalls
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_bulk_documents_nrt_v1_calls_endpoint.call_with_http_info(**kwargs)

    def get_bulk_documents_nrt_v1_calls_async(
        self,
        **kwargs
    ) -> "ApplyResult[NrtCalls]":
        """Returns the active calls happening at the moment based on ticker,call status and entity ID.  # noqa: E501

        Returns the active calls happening at the moment  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            ticker (str): Ticker-region identifier for the company hosting the event.. [optional]
            entity_id (str): Factset entity level identifier for the company hosting the event.. [optional]
            call_status (str): Status of the call, i.e., Ended, InProgress, EndedWithoutNotification, or IssueAtSource.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDatetimeUtc. . [optional] if omitted the server will use the default value of ["-eventDatetimeUtc"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[NrtCalls]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_bulk_documents_nrt_v1_calls_endpoint.call_with_http_info(**kwargs)

    def get_bulk_documents_nrt_v1_calls_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[NrtCalls, int, typing.MutableMapping]]":
        """Returns the active calls happening at the moment based on ticker,call status and entity ID.  # noqa: E501

        Returns the active calls happening at the moment  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            ticker (str): Ticker-region identifier for the company hosting the event.. [optional]
            entity_id (str): Factset entity level identifier for the company hosting the event.. [optional]
            call_status (str): Status of the call, i.e., Ended, InProgress, EndedWithoutNotification, or IssueAtSource.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDatetimeUtc. . [optional] if omitted the server will use the default value of ["-eventDatetimeUtc"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(NrtCalls, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_bulk_documents_nrt_v1_calls_endpoint.call_with_http_info(**kwargs)


    def get_bulk_documents_nrt_v1_calls_by_audio_source_id(
        self,
        **kwargs
    ) -> NrtCalls:
        """Returns the active calls happening at the moment based on audio source ID and report ID.  # noqa: E501

        Returns the active calls happening at the moment  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (dial-in or webcast). One ReportID can have multiple AudioSourceIDs.. [optional]
            report_id (int): Unique identifier for an event.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDatetimeUtc. . [optional] if omitted the server will use the default value of ["-eventDatetimeUtc"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            NrtCalls
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_bulk_documents_nrt_v1_calls_by_audio_source_id_endpoint.call_with_http_info(**kwargs)

    def get_bulk_documents_nrt_v1_calls_by_audio_source_id_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[NrtCalls, int, typing.MutableMapping]:
        """Returns the active calls happening at the moment based on audio source ID and report ID.  # noqa: E501

        Returns the active calls happening at the moment  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (dial-in or webcast). One ReportID can have multiple AudioSourceIDs.. [optional]
            report_id (int): Unique identifier for an event.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDatetimeUtc. . [optional] if omitted the server will use the default value of ["-eventDatetimeUtc"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            NrtCalls
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_bulk_documents_nrt_v1_calls_by_audio_source_id_endpoint.call_with_http_info(**kwargs)

    def get_bulk_documents_nrt_v1_calls_by_audio_source_id_async(
        self,
        **kwargs
    ) -> "ApplyResult[NrtCalls]":
        """Returns the active calls happening at the moment based on audio source ID and report ID.  # noqa: E501

        Returns the active calls happening at the moment  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (dial-in or webcast). One ReportID can have multiple AudioSourceIDs.. [optional]
            report_id (int): Unique identifier for an event.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDatetimeUtc. . [optional] if omitted the server will use the default value of ["-eventDatetimeUtc"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[NrtCalls]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_bulk_documents_nrt_v1_calls_by_audio_source_id_endpoint.call_with_http_info(**kwargs)

    def get_bulk_documents_nrt_v1_calls_by_audio_source_id_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[NrtCalls, int, typing.MutableMapping]]":
        """Returns the active calls happening at the moment based on audio source ID and report ID.  # noqa: E501

        Returns the active calls happening at the moment  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (dial-in or webcast). One ReportID can have multiple AudioSourceIDs.. [optional]
            report_id (int): Unique identifier for an event.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDatetimeUtc. . [optional] if omitted the server will use the default value of ["-eventDatetimeUtc"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(NrtCalls, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_bulk_documents_nrt_v1_calls_by_audio_source_id_endpoint.call_with_http_info(**kwargs)


    def get_bulk_documents_nrt_v1_indexedrt(
        self,
        audio_source_id,
        **kwargs
    ) -> IndexedNrt:
        """Returns the  indexed transcript data  in small increments throughout the duration of an active call.  # noqa: E501

        Returns the  indexed transcript data  in small increments throughout the duration of an active call.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (dial-in or webcast). One ReportID can have multiple AudioSourceIDs.

        Keyword Args:
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            IndexedNrt
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['audio_source_id'] = \
            audio_source_id
        return self.get_bulk_documents_nrt_v1_indexedrt_endpoint.call_with_http_info(**kwargs)

    def get_bulk_documents_nrt_v1_indexedrt_with_http_info(
        self,
        audio_source_id,
        **kwargs
    ) -> typing.Tuple[IndexedNrt, int, typing.MutableMapping]:
        """Returns the  indexed transcript data  in small increments throughout the duration of an active call.  # noqa: E501

        Returns the  indexed transcript data  in small increments throughout the duration of an active call.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (dial-in or webcast). One ReportID can have multiple AudioSourceIDs.

        Keyword Args:
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            IndexedNrt
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['audio_source_id'] = \
            audio_source_id
        return self.get_bulk_documents_nrt_v1_indexedrt_endpoint.call_with_http_info(**kwargs)

    def get_bulk_documents_nrt_v1_indexedrt_async(
        self,
        audio_source_id,
        **kwargs
    ) -> "ApplyResult[IndexedNrt]":
        """Returns the  indexed transcript data  in small increments throughout the duration of an active call.  # noqa: E501

        Returns the  indexed transcript data  in small increments throughout the duration of an active call.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (dial-in or webcast). One ReportID can have multiple AudioSourceIDs.

        Keyword Args:
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[IndexedNrt]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['audio_source_id'] = \
            audio_source_id
        return self.get_bulk_documents_nrt_v1_indexedrt_endpoint.call_with_http_info(**kwargs)

    def get_bulk_documents_nrt_v1_indexedrt_with_http_info_async(
        self,
        audio_source_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[IndexedNrt, int, typing.MutableMapping]]":
        """Returns the  indexed transcript data  in small increments throughout the duration of an active call.  # noqa: E501

        Returns the  indexed transcript data  in small increments throughout the duration of an active call.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (dial-in or webcast). One ReportID can have multiple AudioSourceIDs.

        Keyword Args:
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(IndexedNrt, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['audio_source_id'] = \
            audio_source_id
        return self.get_bulk_documents_nrt_v1_indexedrt_endpoint.call_with_http_info(**kwargs)


    def get_bulk_documents_nrt_v1_speaker_ids(
        self,
        audio_source_id,
        **kwargs
    ) -> NrtSpeakerIds:
        """Returns the latest speakerIds with the confidence scores generated for an active call.  # noqa: E501

        Returns the latest speakerIds with the confidence scores generated for an active call.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (dial-in or webcast). One ReportID can have multiple AudioSourceIDs.

        Keyword Args:
            sort ([str]): Enables sorting data in ascending or descending chronological order based on the start offset of the speaker. . [optional] if omitted the server will use the default value of ["-speakerStartOffset"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            NrtSpeakerIds
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['audio_source_id'] = \
            audio_source_id
        return self.get_bulk_documents_nrt_v1_speaker_ids_endpoint.call_with_http_info(**kwargs)

    def get_bulk_documents_nrt_v1_speaker_ids_with_http_info(
        self,
        audio_source_id,
        **kwargs
    ) -> typing.Tuple[NrtSpeakerIds, int, typing.MutableMapping]:
        """Returns the latest speakerIds with the confidence scores generated for an active call.  # noqa: E501

        Returns the latest speakerIds with the confidence scores generated for an active call.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (dial-in or webcast). One ReportID can have multiple AudioSourceIDs.

        Keyword Args:
            sort ([str]): Enables sorting data in ascending or descending chronological order based on the start offset of the speaker. . [optional] if omitted the server will use the default value of ["-speakerStartOffset"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            NrtSpeakerIds
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['audio_source_id'] = \
            audio_source_id
        return self.get_bulk_documents_nrt_v1_speaker_ids_endpoint.call_with_http_info(**kwargs)

    def get_bulk_documents_nrt_v1_speaker_ids_async(
        self,
        audio_source_id,
        **kwargs
    ) -> "ApplyResult[NrtSpeakerIds]":
        """Returns the latest speakerIds with the confidence scores generated for an active call.  # noqa: E501

        Returns the latest speakerIds with the confidence scores generated for an active call.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (dial-in or webcast). One ReportID can have multiple AudioSourceIDs.

        Keyword Args:
            sort ([str]): Enables sorting data in ascending or descending chronological order based on the start offset of the speaker. . [optional] if omitted the server will use the default value of ["-speakerStartOffset"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[NrtSpeakerIds]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['audio_source_id'] = \
            audio_source_id
        return self.get_bulk_documents_nrt_v1_speaker_ids_endpoint.call_with_http_info(**kwargs)

    def get_bulk_documents_nrt_v1_speaker_ids_with_http_info_async(
        self,
        audio_source_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[NrtSpeakerIds, int, typing.MutableMapping]]":
        """Returns the latest speakerIds with the confidence scores generated for an active call.  # noqa: E501

        Returns the latest speakerIds with the confidence scores generated for an active call.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            audio_source_id (int): Unique ID for an Internal recording specific to reportID. For example, ReportID X would have multiple recordings from different source (dial-in or webcast). One ReportID can have multiple AudioSourceIDs.

        Keyword Args:
            sort ([str]): Enables sorting data in ascending or descending chronological order based on the start offset of the speaker. . [optional] if omitted the server will use the default value of ["-speakerStartOffset"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(NrtSpeakerIds, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['audio_source_id'] = \
            audio_source_id
        return self.get_bulk_documents_nrt_v1_speaker_ids_endpoint.call_with_http_info(**kwargs)


