"""
    EVENTS AND TRANSCRIPTS API

    <p>The Calendar Events API provides access to FactSet’s Event Calendar data alongside business logic that allows users to replicate views and functionality consistent with the experience provided by the Workstation. This API provides the ability to pull Event Calendar data based on specific filters.</p> <p>Events Audio API provides access to historical as well as the latest audio recordings of various company events covered by FactSet. The events include, but are not limited to: earnings calls, conferences, and investor days. This API also provides relevant metadata such as timestamps and identifiers around each audio file.</p> <p>The  Near Real-time Transcripts API enables access to Near Real-time Transcripts provided by CallStreet to time-sensitive clients. This API also provides the relevant speaker metadata along with their confidence scores. This data caters to quant clients interested in building machine learning models. Clients can leverage this API to perform sentiment analysis through natural language processing or machine learning. It can also be used to complement analysis using FactSet's transcripts service.</p> <p>Transcripts API provides conference call transcripts for companies' publicly held conference calls and a wealth of information regarding upcoming corporate events, such as conference call date and time, phone number and password, type of conference call, and important company investor relations contact information.</p>    # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.EventsandTranscripts.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.EventsandTranscripts.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.EventsandTranscripts.exceptions import ApiException
from fds.sdk.EventsandTranscripts.model.error import Error
from fds.sdk.EventsandTranscripts.model.response_categories import ResponseCategories
from fds.sdk.EventsandTranscripts.model.response_time import ResponseTime
from fds.sdk.EventsandTranscripts.model.transcripts import Transcripts
from fds.sdk.EventsandTranscripts.model.transcripts_one import TranscriptsOne





class TranscriptsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.get_timezone_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (ResponseTime,), 400: (Error,), 401: (Error,), 403: (Error,), 500: (Error,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/reference/time-zones',
                'operation_id': 'get_timezone',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_transcripts_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (Transcripts,), 400: (Error,), 401: (Error,), 403: (Error,), 500: (Error,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/transcripts/search',
                'operation_id': 'get_transcripts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'search_text',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'max_items': 2,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "STORYDATETIME": "storyDateTime",
                        "-STORYDATETIME": "-storyDateTime"
                    },
                },
                'openapi_types': {
                    'search_text':
                        (str,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'search_text': 'searchText',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'search_text': 'query',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_transcripts_dates_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (Transcripts,), 400: (Error,), 401: (Error,), 403: (Error,), 500: (Error,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/transcripts/dates',
                'operation_id': 'get_transcripts_dates',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'start_date_relative',
                    'end_date_relative',
                    'time_zone',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'max_items': 2,
                    },
                },
                'allowed_values': {
                    ('sort',): {

                        "STORYDATETIME": "storyDateTime",
                        "-STORYDATETIME": "-storyDateTime"
                    },
                },
                'openapi_types': {
                    'start_date':
                        (date,),
                    'end_date':
                        (date,),
                    'start_date_relative':
                        (int,),
                    'end_date_relative':
                        (int,),
                    'time_zone':
                        (str,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'start_date_relative': 'startDateRelative',
                    'end_date_relative': 'endDateRelative',
                    'time_zone': 'timeZone',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'start_date_relative': 'query',
                    'end_date_relative': 'query',
                    'time_zone': 'query',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_transcripts_events_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (Transcripts,), 400: (Error,), 401: (Error,), 403: (Error,), 500: (Error,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/transcripts/events',
                'operation_id': 'get_transcripts_events',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_ids',
                    'event_type',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'event_type',
                    'sort',
                ],
                'validation': [
                    'event_ids',
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('event_ids',): {

                        'max_items': 1000,
                    },
                    ('sort',): {

                        'max_items': 2,
                    },
                },
                'allowed_values': {
                    ('event_type',): {

                        "EARNINGS": "Earnings",
                        "GUIDANCE": "Guidance",
                        "ANALYSTSSHAREHOLDERSMEETING": "AnalystsShareholdersMeeting",
                        "CONFERENCEPRESENTATION": "ConferencePresentation",
                        "SALESREVENUE": "SalesRevenue",
                        "SPECIALSITUATION": "SpecialSituation"
                    },
                    ('sort',): {

                        "STORYDATETIME": "storyDateTime",
                        "-STORYDATETIME": "-storyDateTime"
                    },
                },
                'openapi_types': {
                    'event_ids':
                        ([str],),
                    'event_type':
                        (str,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'event_ids': 'eventIds',
                    'event_type': 'eventType',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'event_ids': 'query',
                    'event_type': 'query',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'event_ids': 'csv',
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_transcripts_ids_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (TranscriptsOne,), 400: (Error,), 401: (Error,), 403: (Error,), 500: (Error,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/transcripts/ids',
                'operation_id': 'get_transcripts_ids',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'primary_id',
                    'ids',
                    'report_ids',
                    'categories',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'primary_id',
                    'sort',
                ],
                'validation': [
                    'ids',
                    'report_ids',
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('ids',): {

                        'max_items': 1000,
                    },
                    ('report_ids',): {

                        'max_items': 1000,
                    },
                    ('sort',): {

                        'max_items': 2,
                    },
                },
                'allowed_values': {
                    ('primary_id',): {

                        "TRUE": True,
                        "FALSE": False
                    },
                    ('sort',): {

                        "STORYDATETIME": "storyDateTime",
                        "-STORYDATETIME": "-storyDateTime"
                    },
                },
                'openapi_types': {
                    'primary_id':
                        (bool,),
                    'ids':
                        ([str],),
                    'report_ids':
                        ([str],),
                    'categories':
                        ([str],),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'primary_id': 'primaryId',
                    'ids': 'ids',
                    'report_ids': 'reportIds',
                    'categories': 'categories',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'primary_id': 'query',
                    'ids': 'query',
                    'report_ids': 'query',
                    'categories': 'query',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'ids': 'csv',
                    'report_ids': 'csv',
                    'categories': 'csv',
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.getcategories_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (ResponseCategories,), 400: (Error,), 401: (Error,), 403: (Error,), 500: (Error,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/reference/categories',
                'operation_id': 'getcategories',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )


    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")


    def get_timezone(
        self,
        **kwargs
    ) -> ResponseTime:
        """Returns the time zones.  # noqa: E501

        Retrieves and delivers a comprehensive list of all available `timeZones`.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ResponseTime
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_timezone_endpoint.call_with_http_info(**kwargs)

    def get_timezone_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[ResponseTime, int, typing.MutableMapping]:
        """Returns the time zones.  # noqa: E501

        Retrieves and delivers a comprehensive list of all available `timeZones`.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ResponseTime
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_timezone_endpoint.call_with_http_info(**kwargs)

    def get_timezone_async(
        self,
        **kwargs
    ) -> "ApplyResult[ResponseTime]":
        """Returns the time zones.  # noqa: E501

        Retrieves and delivers a comprehensive list of all available `timeZones`.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[ResponseTime]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_timezone_endpoint.call_with_http_info(**kwargs)

    def get_timezone_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[ResponseTime, int, typing.MutableMapping]]":
        """Returns the time zones.  # noqa: E501

        Retrieves and delivers a comprehensive list of all available `timeZones`.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(ResponseTime, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_timezone_endpoint.call_with_http_info(**kwargs)


    def get_transcripts(
        self,
        **kwargs
    ) -> Transcripts:
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on search text.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            search_text (str): Restricts the search to include only document stories which include the text searched.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            Transcripts
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_transcripts_endpoint.call_with_http_info(**kwargs)

    def get_transcripts_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[Transcripts, int, typing.MutableMapping]:
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on search text.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            search_text (str): Restricts the search to include only document stories which include the text searched.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            Transcripts
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_transcripts_endpoint.call_with_http_info(**kwargs)

    def get_transcripts_async(
        self,
        **kwargs
    ) -> "ApplyResult[Transcripts]":
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on search text.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            search_text (str): Restricts the search to include only document stories which include the text searched.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[Transcripts]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_transcripts_endpoint.call_with_http_info(**kwargs)

    def get_transcripts_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[Transcripts, int, typing.MutableMapping]]":
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on search text.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            search_text (str): Restricts the search to include only document stories which include the text searched.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(Transcripts, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_transcripts_endpoint.call_with_http_info(**kwargs)


    def get_transcripts_dates(
        self,
        **kwargs
    ) -> Transcripts:
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on specific date range and time zones.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            start_date (date): Start Date. Format is YYYY-MM-DD    **The API supports data from 1999 onwards. Ensure that the provided Date falls within this range for accurate results.** . [optional]
            end_date (date): End Date. Format is YYYY-MM-DD.. [optional]
            start_date_relative (int): The earliest date of the feed file the API should fetch based on the file timestamp.  - Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.   - *Either `startDate` or `startDateRelative` should be used, but not both.* - *If both `startDate` and `startDateRelative` are provided in the same request, the API will return an error.* - *If users provide future dates in requests for `startDate` or `startDateRelative`, the API will not return any data.* . [optional]
            end_date_relative (int): The latest date of the feed file the API should fetch for based on the file timestamp.  - Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.   - *Either `endDate` or `endDateRelative` should be used, but not both.* - *If both `endDate` and `endDateRelative` are provided in the same request, the API will return an error.* - *If users provide future dates in requests for `endDate` or `endDateRelative`, the API will not return any data.* . [optional]
            time_zone (str): timeZone to return story dates and times.Time zones, represented in POSIX format, are automatically adjusted for daylight savings. timeZone names are sourced from the IANA timezone registry. The time fields in the response will adhere to this specified timezone.. [optional] if omitted the server will use the default value of "America/New_York"
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            Transcripts
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_transcripts_dates_endpoint.call_with_http_info(**kwargs)

    def get_transcripts_dates_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[Transcripts, int, typing.MutableMapping]:
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on specific date range and time zones.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            start_date (date): Start Date. Format is YYYY-MM-DD    **The API supports data from 1999 onwards. Ensure that the provided Date falls within this range for accurate results.** . [optional]
            end_date (date): End Date. Format is YYYY-MM-DD.. [optional]
            start_date_relative (int): The earliest date of the feed file the API should fetch based on the file timestamp.  - Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.   - *Either `startDate` or `startDateRelative` should be used, but not both.* - *If both `startDate` and `startDateRelative` are provided in the same request, the API will return an error.* - *If users provide future dates in requests for `startDate` or `startDateRelative`, the API will not return any data.* . [optional]
            end_date_relative (int): The latest date of the feed file the API should fetch for based on the file timestamp.  - Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.   - *Either `endDate` or `endDateRelative` should be used, but not both.* - *If both `endDate` and `endDateRelative` are provided in the same request, the API will return an error.* - *If users provide future dates in requests for `endDate` or `endDateRelative`, the API will not return any data.* . [optional]
            time_zone (str): timeZone to return story dates and times.Time zones, represented in POSIX format, are automatically adjusted for daylight savings. timeZone names are sourced from the IANA timezone registry. The time fields in the response will adhere to this specified timezone.. [optional] if omitted the server will use the default value of "America/New_York"
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            Transcripts
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_transcripts_dates_endpoint.call_with_http_info(**kwargs)

    def get_transcripts_dates_async(
        self,
        **kwargs
    ) -> "ApplyResult[Transcripts]":
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on specific date range and time zones.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            start_date (date): Start Date. Format is YYYY-MM-DD    **The API supports data from 1999 onwards. Ensure that the provided Date falls within this range for accurate results.** . [optional]
            end_date (date): End Date. Format is YYYY-MM-DD.. [optional]
            start_date_relative (int): The earliest date of the feed file the API should fetch based on the file timestamp.  - Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.   - *Either `startDate` or `startDateRelative` should be used, but not both.* - *If both `startDate` and `startDateRelative` are provided in the same request, the API will return an error.* - *If users provide future dates in requests for `startDate` or `startDateRelative`, the API will not return any data.* . [optional]
            end_date_relative (int): The latest date of the feed file the API should fetch for based on the file timestamp.  - Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.   - *Either `endDate` or `endDateRelative` should be used, but not both.* - *If both `endDate` and `endDateRelative` are provided in the same request, the API will return an error.* - *If users provide future dates in requests for `endDate` or `endDateRelative`, the API will not return any data.* . [optional]
            time_zone (str): timeZone to return story dates and times.Time zones, represented in POSIX format, are automatically adjusted for daylight savings. timeZone names are sourced from the IANA timezone registry. The time fields in the response will adhere to this specified timezone.. [optional] if omitted the server will use the default value of "America/New_York"
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[Transcripts]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_transcripts_dates_endpoint.call_with_http_info(**kwargs)

    def get_transcripts_dates_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[Transcripts, int, typing.MutableMapping]]":
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on specific date range and time zones.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            start_date (date): Start Date. Format is YYYY-MM-DD    **The API supports data from 1999 onwards. Ensure that the provided Date falls within this range for accurate results.** . [optional]
            end_date (date): End Date. Format is YYYY-MM-DD.. [optional]
            start_date_relative (int): The earliest date of the feed file the API should fetch based on the file timestamp.  - Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.   - *Either `startDate` or `startDateRelative` should be used, but not both.* - *If both `startDate` and `startDateRelative` are provided in the same request, the API will return an error.* - *If users provide future dates in requests for `startDate` or `startDateRelative`, the API will not return any data.* . [optional]
            end_date_relative (int): The latest date of the feed file the API should fetch for based on the file timestamp.  - Format: Specify the date using a relative term as an integer: '0' for today, '-1' for yesterday, '-2' for two days ago, and so forth. Negative values are used to represent past dates.   - *Either `endDate` or `endDateRelative` should be used, but not both.* - *If both `endDate` and `endDateRelative` are provided in the same request, the API will return an error.* - *If users provide future dates in requests for `endDate` or `endDateRelative`, the API will not return any data.* . [optional]
            time_zone (str): timeZone to return story dates and times.Time zones, represented in POSIX format, are automatically adjusted for daylight savings. timeZone names are sourced from the IANA timezone registry. The time fields in the response will adhere to this specified timezone.. [optional] if omitted the server will use the default value of "America/New_York"
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(Transcripts, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_transcripts_dates_endpoint.call_with_http_info(**kwargs)


    def get_transcripts_events(
        self,
        **kwargs
    ) -> Transcripts:
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on eventIds and eventType.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            event_ids ([str]): Requests Event IDs. This is a comma-separated list with a maximum limit of 1000.. [optional]
            event_type (str): Specifies the type of event you want to retrieve.   Earnings - Denotes an Earnings event.   Guidance - Denotes a Guidance event.   AnalystsShareholdersMeeting - Denotes an Analysts and Shareholders Meeting event.   ConferencePresentation - Denotes a Conference Presentation event.   SalesRevenue - Denotes a Sales/Revenue event.   SpecialSituation - Denotes a Special Situation event (i.e. Merger/Acquisition).. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            Transcripts
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_transcripts_events_endpoint.call_with_http_info(**kwargs)

    def get_transcripts_events_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[Transcripts, int, typing.MutableMapping]:
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on eventIds and eventType.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            event_ids ([str]): Requests Event IDs. This is a comma-separated list with a maximum limit of 1000.. [optional]
            event_type (str): Specifies the type of event you want to retrieve.   Earnings - Denotes an Earnings event.   Guidance - Denotes a Guidance event.   AnalystsShareholdersMeeting - Denotes an Analysts and Shareholders Meeting event.   ConferencePresentation - Denotes a Conference Presentation event.   SalesRevenue - Denotes a Sales/Revenue event.   SpecialSituation - Denotes a Special Situation event (i.e. Merger/Acquisition).. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            Transcripts
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_transcripts_events_endpoint.call_with_http_info(**kwargs)

    def get_transcripts_events_async(
        self,
        **kwargs
    ) -> "ApplyResult[Transcripts]":
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on eventIds and eventType.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            event_ids ([str]): Requests Event IDs. This is a comma-separated list with a maximum limit of 1000.. [optional]
            event_type (str): Specifies the type of event you want to retrieve.   Earnings - Denotes an Earnings event.   Guidance - Denotes a Guidance event.   AnalystsShareholdersMeeting - Denotes an Analysts and Shareholders Meeting event.   ConferencePresentation - Denotes a Conference Presentation event.   SalesRevenue - Denotes a Sales/Revenue event.   SpecialSituation - Denotes a Special Situation event (i.e. Merger/Acquisition).. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[Transcripts]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_transcripts_events_endpoint.call_with_http_info(**kwargs)

    def get_transcripts_events_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[Transcripts, int, typing.MutableMapping]]":
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on eventIds and eventType.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            event_ids ([str]): Requests Event IDs. This is a comma-separated list with a maximum limit of 1000.. [optional]
            event_type (str): Specifies the type of event you want to retrieve.   Earnings - Denotes an Earnings event.   Guidance - Denotes a Guidance event.   AnalystsShareholdersMeeting - Denotes an Analysts and Shareholders Meeting event.   ConferencePresentation - Denotes a Conference Presentation event.   SalesRevenue - Denotes a Sales/Revenue event.   SpecialSituation - Denotes a Special Situation event (i.e. Merger/Acquisition).. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(Transcripts, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_transcripts_events_endpoint.call_with_http_info(**kwargs)


    def get_transcripts_ids(
        self,
        **kwargs
    ) -> TranscriptsOne:
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on specific IDs.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            primary_id (bool): Type of identifier search * true - Returns headlines of stories that have the searched identifier(s) as the primary  identifier. * false - Returns headlines of stories that mentioned or referred to the  identifier.. [optional] if omitted the server will use the default value of False
            ids ([str]): Requested symbols or securities.  This is a comma-separated list with a maximum limit of 1000.  Each symbol can be a FactSet exchange symbol, CUSIP, or SEDOL.. [optional]
            report_ids ([str]): Requests Report IDs. This is a comma-separated list with a maximum limit of 1000. [optional]
            categories ([str]): Code for categories to include. This is a comma-separated list.which represent country, industry, and subject codes. Use the ```/reference/categories``` endpoint to get the list of available categories.  Default = All categories.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            TranscriptsOne
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_transcripts_ids_endpoint.call_with_http_info(**kwargs)

    def get_transcripts_ids_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[TranscriptsOne, int, typing.MutableMapping]:
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on specific IDs.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            primary_id (bool): Type of identifier search * true - Returns headlines of stories that have the searched identifier(s) as the primary  identifier. * false - Returns headlines of stories that mentioned or referred to the  identifier.. [optional] if omitted the server will use the default value of False
            ids ([str]): Requested symbols or securities.  This is a comma-separated list with a maximum limit of 1000.  Each symbol can be a FactSet exchange symbol, CUSIP, or SEDOL.. [optional]
            report_ids ([str]): Requests Report IDs. This is a comma-separated list with a maximum limit of 1000. [optional]
            categories ([str]): Code for categories to include. This is a comma-separated list.which represent country, industry, and subject codes. Use the ```/reference/categories``` endpoint to get the list of available categories.  Default = All categories.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            TranscriptsOne
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_transcripts_ids_endpoint.call_with_http_info(**kwargs)

    def get_transcripts_ids_async(
        self,
        **kwargs
    ) -> "ApplyResult[TranscriptsOne]":
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on specific IDs.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            primary_id (bool): Type of identifier search * true - Returns headlines of stories that have the searched identifier(s) as the primary  identifier. * false - Returns headlines of stories that mentioned or referred to the  identifier.. [optional] if omitted the server will use the default value of False
            ids ([str]): Requested symbols or securities.  This is a comma-separated list with a maximum limit of 1000.  Each symbol can be a FactSet exchange symbol, CUSIP, or SEDOL.. [optional]
            report_ids ([str]): Requests Report IDs. This is a comma-separated list with a maximum limit of 1000. [optional]
            categories ([str]): Code for categories to include. This is a comma-separated list.which represent country, industry, and subject codes. Use the ```/reference/categories``` endpoint to get the list of available categories.  Default = All categories.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[TranscriptsOne]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_transcripts_ids_endpoint.call_with_http_info(**kwargs)

    def get_transcripts_ids_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[TranscriptsOne, int, typing.MutableMapping]]":
        """Returns the transcript documents in XML format and related metadata within FactSet coverage based on specific IDs.  # noqa: E501

        Returns the transcripts documents within FactSet coverage along with other response fields.   All transcripts originate from Factset Callstreet Transcripts.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            primary_id (bool): Type of identifier search * true - Returns headlines of stories that have the searched identifier(s) as the primary  identifier. * false - Returns headlines of stories that mentioned or referred to the  identifier.. [optional] if omitted the server will use the default value of False
            ids ([str]): Requested symbols or securities.  This is a comma-separated list with a maximum limit of 1000.  Each symbol can be a FactSet exchange symbol, CUSIP, or SEDOL.. [optional]
            report_ids ([str]): Requests Report IDs. This is a comma-separated list with a maximum limit of 1000. [optional]
            categories ([str]): Code for categories to include. This is a comma-separated list.which represent country, industry, and subject codes. Use the ```/reference/categories``` endpoint to get the list of available categories.  Default = All categories.. [optional]
            sort ([str]): Enables sorting data in ascending or descending chronological order based on eventDate. . [optional] if omitted the server will use the default value of ["-storyDateTime"]
            pagination_limit (int): Number of results to return per page.. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Page number of the results to return.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(TranscriptsOne, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_transcripts_ids_endpoint.call_with_http_info(**kwargs)


    def getcategories(
        self,
        **kwargs
    ) -> ResponseCategories:
        """Returns the categories.  # noqa: E501

        Retrieves and delivers a comprehensive list of all available `categories`which are defined as country, industry, and subject codes. The data is returned as a comma-separated list.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ResponseCategories
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.getcategories_endpoint.call_with_http_info(**kwargs)

    def getcategories_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[ResponseCategories, int, typing.MutableMapping]:
        """Returns the categories.  # noqa: E501

        Retrieves and delivers a comprehensive list of all available `categories`which are defined as country, industry, and subject codes. The data is returned as a comma-separated list.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ResponseCategories
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.getcategories_endpoint.call_with_http_info(**kwargs)

    def getcategories_async(
        self,
        **kwargs
    ) -> "ApplyResult[ResponseCategories]":
        """Returns the categories.  # noqa: E501

        Retrieves and delivers a comprehensive list of all available `categories`which are defined as country, industry, and subject codes. The data is returned as a comma-separated list.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[ResponseCategories]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.getcategories_endpoint.call_with_http_info(**kwargs)

    def getcategories_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[ResponseCategories, int, typing.MutableMapping]]":
        """Returns the categories.  # noqa: E501

        Retrieves and delivers a comprehensive list of all available `categories`which are defined as country, industry, and subject codes. The data is returned as a comma-separated list.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(ResponseCategories, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.getcategories_endpoint.call_with_http_info(**kwargs)


