"""The module that defines the ``StartPaymentCoursePriceCloseTabData`` model.

SPDX-License-Identifier: AGPL-3.0-only OR BSD-3-Clause-Clear
"""

from __future__ import annotations

import typing as t
from dataclasses import dataclass, field

import cg_request_args as rqa

from ..utils import to_dict


@dataclass
class StartPaymentCoursePriceCloseTabData:
    """ """

    #: We should close the tab after the payment has completed
    mode: t.Literal["close_tab"]

    raw_data: t.Optional[t.Dict[str, t.Any]] = field(init=False, repr=False)

    data_parser: t.ClassVar = rqa.Lazy(
        lambda: rqa.FixedMapping(
            rqa.RequiredArgument(
                "mode",
                rqa.StringEnum("close_tab"),
                doc="We should close the tab after the payment has completed",
            ),
        ).use_readable_describe(True)
    )

    def to_dict(self) -> t.Dict[str, t.Any]:
        res: t.Dict[str, t.Any] = {
            "mode": to_dict(self.mode),
        }
        return res

    @classmethod
    def from_dict(
        cls: t.Type[StartPaymentCoursePriceCloseTabData], d: t.Dict[str, t.Any]
    ) -> StartPaymentCoursePriceCloseTabData:
        parsed = cls.data_parser.try_parse(d)

        res = cls(
            mode=parsed.mode,
        )
        res.raw_data = d
        return res
