"""Threat Types and Enums."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from typing import Optional, List, Dict, Union, Any, Tuple


from enum import Enum


from dataclasses import dataclass, field
from dataclasses_json import dataclass_json, config


class ThreatParentType(str, Enum):
    """ThreatParentType."""

    IP = "IP"
    DOMAIN = "DOMAIN"
    FILE = "FILE"


class ThreatIndicatorClass(str, Enum):
    """ThreatIndicatorClass."""

    IPV4 = "ipv4"
    IPV6 = "ipv6"
    CIDR = "cidr"
    URL = "url"
    DOMAIN = "domain"
    MD5 = "md5"
    SHA256 = "sha256"
    SHA1 = "sha1"
    UNKNOWN = "unknown"


class ThreatPatternType(str, Enum):
    """ThreatPatternType."""

    STIX = "stix"
    PCRE = "pcre"
    SIGMA = "sigma"
    SNORT = "snort"
    SURICATA = "suricata"
    YARA = "yara"


class ThreatIdentityClass(str, Enum):
    """ThreatIdentityClass."""

    INDIVIDUAL = "individual"
    GROUP = "group"
    SYSTEM = "system"
    ORGANIZATION = "organization"
    CLASS = "class"
    UNSPECIFIED = "unspecified"


class ThreatIndustrySectors(str, Enum):
    """ThreatIndustrySectors."""

    AGRICULTURE = "agriculture"
    AEROSPACE = "aerospace"
    AUTOMOTIVE = "automotive"
    CHEMICAL = "chemical"
    COMMERCIAL = "commercial"
    COMMUNICATIONS = "communications"
    CONSTRUCTION = "construction"
    DEFENSE = "defense"
    EDUCATION = "education"
    ENERGY = "energy"
    ENTERTAINMENT = "entertainment"
    FINANCIAL_SERVICES = "financial_services"
    EMERGENCY_SERVICES = "emergency_services"
    GOVERNMENT_LOCAL = "government_local"
    GOVERNMENT_NATIONAL = "government_national"
    GOVERNMENT_PUBLIC_SERVICES = "government_public_services"
    GOVERNMENT_REGIONAL = "government_regional"
    HEALTHCARE = "healthcare"
    HOSPITALITY_LEISURE = "hospitality_leisure"
    INFRASTRUCTURE_DAMS = "infrastructure_dams"
    INFRASTRUCTURE_NUCLEAR = "infrastructure_nuclear"
    INFRASTRUCTURE_WATER = "infrastructure_water"
    INSURANCE = "insurance"
    MANUFACTURING = "manufacturing"
    MINING = "mining"
    NON_PROFIT = "non_profit"
    PHARMACEUTICALS = "pharmaceuticals"
    RETAIL = "retail"
    TECHNOLOGY = "technology"
    TELECOMMUNICATIONS = "telecommunications"
    TRANSPORTATION = "transportation"
    UTILITIES = "utilities"


class ThreatIndicatorType(str, Enum):
    """ThreatIndicatorType."""

    ANOMALOUS_ACTIVITY = "anomalous_activity"
    ANONYMIZATION = "anonymization"
    BENIGN = "benign"
    COMPROMISED = "compromised"
    MALICIOUS_ACTIVITY = "malicious_activity"
    ATTRIBUTION = "attribution"
    UNKNOWN = "unknown"


class ThreatRelationshipType(str, Enum):
    """ThreatRelationshipType."""

    TARGETS = "targets"
    USES = "uses"
    ATTRIBUTED_TO = "attributed_to"
    COMPROMISES = "compromises"
    ORIGINATES_FROM = "originates_from"
    INVESTIGATES = "investigates"
    MITIGATES = "mitigates"
    REMEDIATES = "remediates"
    LOCATED_AT = "located_at"
    IMPERSONATES = "impersonates"
    BASED_ON = "based_on"
    COMMUNICATES_WITH = "communicates_with"
    CONSISTS_OF = "consists_of"
    CONTROLS = "controls"
    DELIVERS = "delivers"
    HAS = "has"
    HOSTS = "hosts"
    BEACONS_TO = "beacons_to"
    EXFILTRATES_TO = "exfiltrates_to"
    OWNS = "owns"
    INDICATES = "indicates"
    AUTHORED_BY = "authored_by"
    DOWNLOADS = "downloads"
    DROPS = "drops"
    EXPLOITS = "exploits"
    VARIANT_OF = "variant_of"
    CHARACTERIZES = "characterizes"
    ANALYSIS_OF = "analysis_of"
    STATIC_ANALYSIS_OF = "static_analysis_of"
    DYNAMIC_ANALYSIS_OF = "dynamic_analysis_of"
    LISTS = "lists"
    LISTED_ON = "listed_on"
    RELATED_TO = "related_to"
    INDIRECT = "indirect"


class ThreatMalwareType(str, Enum):
    """ThreatMalwareType."""

    ADWARE = "adware"
    BACKDOOR = "backdoor"
    BOT = "bot"
    BOOTKIT = "bootkit"
    DDOS = "ddos"
    DOWNLOADER = "downloader"
    DROPPER = "dropper"
    EXPLOIT_KIT = "exploit_kit"
    IRC_BOTNET = "irc_botnet"
    KEYLOGGER = "keylogger"
    RANSOMWARE = "ransomware"
    REMOTE_ACCESS_TROJAN = "remote_access_trojan"
    RESOURCE_EXPLOITATION = "resource_exploitation"
    ROGUE_SECURITY_SOFTWARE = "rogue_security_software"
    ROOTKIT = "rootkit"
    SCREEN_CAPTURE = "screen_capture"
    SPYWARE = "spyware"
    TROJAN = "trojan"
    UNKNOWN = "unknown"
    VIRUS = "virus"
    WEBSHELL = "webshell"
    WIPER = "wiper"
    WORM = "worm"


class ThreatCapabilities(str, Enum):
    """ThreatCapabilities."""

    ACCESSES_REMOTE_MACHINES = "accesses_remote_machines"
    ANTI_DEBUGGING = "anti_debugging"
    ANTI_DISASSEMBLY = "anti_disassembly"
    ANTI_EMULATION = "anti_emulation"
    ANTI_MEMORY_FORENSICS = "anti_memory_forensics"
    ANTI_SANDBOX = "anti_sandbox"
    ANTI_VM = "anti_vm"
    CAPTURES_INPUT_PERIPHERALS = "captures_input_peripherals"
    CAPTURES_OUTPUT_PERIPHERALS = "captures_output_peripherals"
    CAPTURES_SYSTEM_STATE_DATA = "captures_system_state_data"
    CLEANS_TRACES_OF_INFECTION = "cleans_traces_of_infection"
    COMMITS_FRAUD = "commits_fraud"
    COMMUNICATES_WITH_C2 = "communicates_with_c2"
    COMPROMISES_DATA_AVAILABILITY = "compromises_data_availability"
    COMPROMISES_DATA_INTEGRITY = "compromises_data_integrity"
    COMPROMISES_SYSTEM_AVAILABILITY = "compromises_system_availability"
    CONTROLS_LOCAL_MACHINE = "controls_local_machine"
    DEGRADES_SECURITY_SOFTWARE = "degrades_security_software"
    DEGRADES_SYSTEM_UPDATES = "degrades_system_updates"
    DETERMINES_C2_SERVER = "determines_c2_server"
    EMAILS_SPAM = "emails_spam"
    ESCALATES_PRIVILEGES = "escalates_privileges"
    EVADES_AV = "evades_av"
    EXFILTRATES_DATA = "exfiltrates_data"
    FINGERPRINTS_HOST = "fingerprints_host"
    HIDES_ARTIFACTS = "hides_artifacts"
    HIDES_EXECUTING_CODE = "hides_executing_code"
    INFECTS_FILES = "infects_files"
    INFECTS_REMOTE_MACHINES = "infects_remote_machines"
    INSTALLS_OTHER_COMPONENTS = "installs_other_components"
    PERSISTS_AFTER_SYSTEM_REBOOT = "persists_after_system_reboot"
    PREVENTS_ARTIFACT_ACCESS = "prevents_artifact_access"
    PREVENTS_ARTIFACT_DELETION = "prevents_artifact_deletion"
    PROBES_NETWORK_ENVIRONMENT = "probes_network_environment"
    SELF_MODIFIES = "self_modifies"
    STEALS_AUTHENTICATION_CREDENTIALS = "steals_authentication_credentials"
    VIOLATES_SYSTEM_OPERATIONAL_INTEGRITY = "violates_system_operational_integrity"


class ThreatArchitectureExecutionEnvs(str, Enum):
    """ThreatArchitectureExecutionEnvs."""

    ALPHA = "alpha"
    ARM = "arm"
    IA_64 = "ia_64"
    MIPS = "mips"
    POWERPC = "powerpc"
    SPARC = "sparc"
    X86 = "x86"
    X86_64 = "x86_64"


class ThreatImplementationLanguages(str, Enum):
    """ThreatImplementationLanguages."""

    APPLESCRIPT = "applescript"
    BASH = "bash"
    C = "c"
    C_PLUS_PLUS = "c_plus_plus"
    C_SHARP = "c_sharp"
    GO = "go"
    JAVA = "java"
    JAVASCRIPT = "javascript"
    LUA = "lua"
    OBJECTIVE_C = "objective_c"
    PERL = "perl"
    PHP = "php"
    POWERSHELL = "powershell"
    PYTHON = "python"
    RUBY = "ruby"
    SCALA = "scala"
    SWIFT = "swift"
    TYPESCRIPT = "typescript"
    VISUAL_BASIC = "visual_basic"
    X86_32 = "x86_32"
    X86_64 = "x86_64"


class ThreatObjectType(str, Enum):
    """ThreatObjectType."""

    INDICATOR = "indicator"
    IDENTITY = "identity"
    RELATIONSHIP = "relationship"
    MALWARE = "malware"
    INTRUSIONSET = "intrusionset"
    REPORT = "report"


class ListAction(str, Enum):
    """ListAction."""

    ALLOW = "allow"
    BLOCK = "block"
    WARN = "warn"


class ItemType(str, Enum):
    """ItemType."""

    USER = "user"
    CERTIFICATE = "certificate"
    ASSET = "asset"
    DOMAIN = "domain"
    IPV4 = "ipv4"
    IPV6 = "ipv6"
    CIDR = "cidr"
    URL = "url"
    MD5 = "md5"
    SHA256 = "sha256"
    SHA1 = "sha1"
    UNKNOWN = "unknown"


class OrderByOptions(str, Enum):
    """OrderByOptions."""

    ASC = "asc"
    DESC = "desc"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PageInfo:
    """PageInfo."""

    end_cursor: Optional[str] = field(
        default=None, metadata=config(field_name="endCursor")
    )
    has_next_page: Optional[bool] = field(
        default=None, metadata=config(field_name="hasNextPage")
    )
    start_cursor: Optional[str] = field(
        default=None, metadata=config(field_name="startCursor")
    )
    has_previous_page: Optional[bool] = field(
        default=None, metadata=config(field_name="hasPreviousPage")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatKillChainPhase:
    """ThreatKillChainPhase."""

    kill_chain_name: Optional[str] = field(
        default=None, metadata=config(field_name="kill_chain_name")
    )
    phase_name: Optional[str] = field(
        default=None, metadata=config(field_name="phase_name")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatHashes:
    """ThreatHashes."""

    md5: Optional[str] = field(default=None, metadata=config(field_name="MD5"))
    sha256: Optional[str] = field(default=None, metadata=config(field_name="SHA256"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatDNSInfo:
    """ThreatDNSInfo."""

    domain: Optional[str] = field(default=None, metadata=config(field_name="Domain"))
    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="Hostname")
    )
    subdomain: Optional[str] = field(
        default=None, metadata=config(field_name="Subdomain")
    )
    tld: Optional[str] = field(default=None, metadata=config(field_name="Tld"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatURLInfo:
    """ThreatURLInfo."""

    query: Optional[str] = field(default=None, metadata=config(field_name="Query"))
    scheme: Optional[str] = field(default=None, metadata=config(field_name="Scheme"))
    port: Optional[str] = field(default=None, metadata=config(field_name="Port"))
    path: Optional[str] = field(default=None, metadata=config(field_name="Path"))
    request_uri: Optional[str] = field(
        default=None, metadata=config(field_name="RequestURI")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatTip:
    """ThreatTip."""

    id: Optional[str] = field(default=None, metadata=config(field_name="ID"))
    name: Optional[str] = field(default=None, metadata=config(field_name="Name"))
    active: Optional[bool] = field(default=None, metadata=config(field_name="Active"))
    content: Optional[str] = field(default=None, metadata=config(field_name="Content"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="CreatedAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="UpdatedAt")
    )
    reference: Optional[str] = field(
        default=None, metadata=config(field_name="Reference")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatSwid:
    """ThreatSwid."""

    id: Optional[str] = field(default=None, metadata=config(field_name="Id"))
    author: Optional[str] = field(default=None, metadata=config(field_name="Author"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="CreatedAt")
    )
    engine_group_name: Optional[str] = field(
        default=None, metadata=config(field_name="EngineGroupName")
    )
    file_name: Optional[str] = field(
        default=None, metadata=config(field_name="FileName")
    )
    priority: Optional[int] = field(
        default=None, metadata=config(field_name="Priority")
    )
    priority_value: Optional[str] = field(
        default=None, metadata=config(field_name="PriorityValue")
    )
    revision: Optional[int] = field(
        default=None, metadata=config(field_name="Revision")
    )
    swid: Optional[int] = field(default=None, metadata=config(field_name="Swid"))
    swid_name: Optional[str] = field(
        default=None, metadata=config(field_name="SwidName")
    )
    text: Optional[str] = field(default=None, metadata=config(field_name="Text"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatSwidInput:
    """ThreatSwidInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="Id"))
    author: Optional[str] = field(default=None, metadata=config(field_name="Author"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="CreatedAt")
    )
    engine_group_name: Optional[str] = field(
        default=None, metadata=config(field_name="EngineGroupName")
    )
    file_name: Optional[str] = field(
        default=None, metadata=config(field_name="FileName")
    )
    priority: Optional[int] = field(
        default=None, metadata=config(field_name="Priority")
    )
    priority_value: Optional[str] = field(
        default=None, metadata=config(field_name="PriorityValue")
    )
    revision: Optional[int] = field(
        default=None, metadata=config(field_name="Revision")
    )
    swid: Optional[int] = field(default=None, metadata=config(field_name="Swid"))
    swid_name: Optional[str] = field(
        default=None, metadata=config(field_name="SwidName")
    )
    text: Optional[str] = field(default=None, metadata=config(field_name="Text"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatGroupInput:
    """ThreatGroupInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    objectives: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Objectives")
    )
    aliases: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Aliases")
    )
    tools: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Tools")
    )
    motivation: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Motivation")
    )
    intended_effect: Optional[List[str]] = field(
        default=None, metadata=config(field_name="IntendedEffect")
    )
    target_sectors: Optional[List[str]] = field(
        default=None, metadata=config(field_name="TargetSectors")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="Description")
    )
    active_since: Optional[str] = field(
        default=None, metadata=config(field_name="ActiveSince")
    )
    last_known_activity: Optional[str] = field(
        default=None, metadata=config(field_name="LastKnownActivity")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatAnalysis:
    """ThreatAnalysis."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="Name"))
    content: Optional[str] = field(default=None, metadata=config(field_name="Content"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="CreatedAt")
    )
    publication_date: Optional[str] = field(
        default=None, metadata=config(field_name="PublicationDate")
    )
    tlp: Optional[str] = field(default=None, metadata=config(field_name="TLP"))
    reference: Optional[str] = field(
        default=None, metadata=config(field_name="Reference")
    )
    report_id: Optional[str] = field(
        default=None, metadata=config(field_name="ReportID")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatLocation:
    """ThreatLocation."""

    longitude: Optional[float] = field(
        default=None, metadata=config(field_name="Longitude")
    )
    latitude: Optional[float] = field(
        default=None, metadata=config(field_name="Latitude")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatWhois:
    """ThreatWhois."""

    domain_name: Optional[str] = field(
        default=None, metadata=config(field_name="DomainName")
    )
    registrar_name: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrarName")
    )
    contact_email: Optional[str] = field(
        default=None, metadata=config(field_name="ContactEmail")
    )
    whois_server: Optional[str] = field(
        default=None, metadata=config(field_name="WhoisServer")
    )
    name_servers: Optional[str] = field(
        default=None, metadata=config(field_name="NameServers")
    )
    created_date: Optional[str] = field(
        default=None, metadata=config(field_name="CreatedDate")
    )
    updated_date: Optional[str] = field(
        default=None, metadata=config(field_name="UpdatedDate")
    )
    expires_date: Optional[str] = field(
        default=None, metadata=config(field_name="ExpiresDate")
    )
    standard_reg_created_date: Optional[str] = field(
        default=None, metadata=config(field_name="StandardRegCreatedDate")
    )
    standard_reg_updated_date: Optional[str] = field(
        default=None, metadata=config(field_name="StandardRegUpdatedDate")
    )
    standard_reg_expires_date: Optional[str] = field(
        default=None, metadata=config(field_name="StandardRegExpiresDate")
    )
    status: Optional[str] = field(default=None, metadata=config(field_name="Status"))
    audit_audit_updated_date: Optional[str] = field(
        default=None, metadata=config(field_name="AuditAuditUpdatedDate")
    )
    registrant_email: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantEmail")
    )
    registrant_name: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantName")
    )
    registrant_organization: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantOrganization")
    )
    registrant_street1: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantStreet1")
    )
    registrant_city: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantCity")
    )
    registrant_state: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantState")
    )
    registrant_postal_code: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantPostalCode")
    )
    registrant_country: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantCountry")
    )
    registrant_fax: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantFax")
    )
    registrant_telephone: Optional[str] = field(
        default=None, metadata=config(field_name="RegistrantTelephone")
    )
    administrative_contact_email: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactEmail")
    )
    administrative_contact_name: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactName")
    )
    administrative_contact_organization: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactOrganization")
    )
    administrative_contact_street1: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactStreet1")
    )
    administrative_contact_city: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactCity")
    )
    administrative_contact_state: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactState")
    )
    administrative_contact_postal_code: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactPostalCode")
    )
    administrative_contact_country: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactCountry")
    )
    administrative_contact_fax: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactFax")
    )
    administrative_contact_telephone: Optional[str] = field(
        default=None, metadata=config(field_name="AdministrativeContactTelephone")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatHashesInput:
    """ThreatHashesInput."""

    md5: Optional[str] = field(default=None, metadata=config(field_name="MD5"))
    sha256: Optional[str] = field(default=None, metadata=config(field_name="SHA256"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatKillChainPhaseInput:
    """ThreatKillChainPhaseInput."""

    kill_chain_name: Optional[str] = field(
        default=None, metadata=config(field_name="kill_chain_name")
    )
    phase_name: Optional[str] = field(
        default=None, metadata=config(field_name="phase_name")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatAdvisory:
    """ThreatAdvisory."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="Name"))
    content: Optional[str] = field(default=None, metadata=config(field_name="Content"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="CreatedAt")
    )
    publication_date: Optional[str] = field(
        default=None, metadata=config(field_name="PublicationDate")
    )
    tlp: Optional[str] = field(default=None, metadata=config(field_name="TLP"))
    reference: Optional[str] = field(
        default=None, metadata=config(field_name="Reference")
    )
    report_id: Optional[str] = field(
        default=None, metadata=config(field_name="ReportID")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatPublication:
    """ThreatPublication."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    type: Optional[str] = field(default=None, metadata=config(field_name="Type"))
    name: Optional[str] = field(default=None, metadata=config(field_name="Name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="Description")
    )
    published: Optional[str] = field(
        default=None, metadata=config(field_name="Published")
    )
    content: Optional[str] = field(default=None, metadata=config(field_name="Content"))
    tlp: Optional[str] = field(default=None, metadata=config(field_name="TLP"))
    vid: Optional[str] = field(default=None, metadata=config(field_name="VID"))
    report_id: Optional[str] = field(
        default=None, metadata=config(field_name="ReportID")
    )
    reference: Optional[str] = field(
        default=None, metadata=config(field_name="Reference")
    )
    category: Optional[str] = field(
        default=None, metadata=config(field_name="Category")
    )
    language: Optional[str] = field(
        default=None, metadata=config(field_name="Language")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatReportInput:
    """ThreatReportInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    created: Optional[str] = field(default=None, metadata=config(field_name="created"))
    modified: Optional[str] = field(
        default=None, metadata=config(field_name="modified")
    )
    published: Optional[str] = field(
        default=None, metadata=config(field_name="published")
    )
    object_refs: Optional[List[str]] = field(
        default=None, metadata=config(field_name="object_refs")
    )
    content: Optional[str] = field(default=None, metadata=config(field_name="content"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ListOwner:
    """ListOwner."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenant_id")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="created_at")
    )
    modified_at: Optional[str] = field(
        default=None, metadata=config(field_name="modified_at")
    )
    age_at: Optional[str] = field(default=None, metadata=config(field_name="age_at"))
    deleted_at: Optional[str] = field(
        default=None, metadata=config(field_name="deleted_at")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeleteListInput:
    """DeleteListInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatGroup:
    """ThreatGroup."""

    spec_version: Optional[str] = field(
        default=None, metadata=config(field_name="spec_version")
    )
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="sharing_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    objectives: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Objectives")
    )
    aliases: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Aliases")
    )
    tools: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Tools")
    )
    motivation: Optional[List[str]] = field(
        default=None, metadata=config(field_name="Motivation")
    )
    intended_effect: Optional[List[str]] = field(
        default=None, metadata=config(field_name="IntendedEffect")
    )
    target_sectors: Optional[List[str]] = field(
        default=None, metadata=config(field_name="TargetSectors")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="Description")
    )
    active_since: Optional[str] = field(
        default=None, metadata=config(field_name="ActiveSince")
    )
    last_known_activity: Optional[str] = field(
        default=None, metadata=config(field_name="LastKnownActivity")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    type: Optional[ThreatObjectType] = field(
        default=None, metadata=config(field_name="type")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatReport:
    """ThreatReport."""

    spec_version: Optional[str] = field(
        default=None, metadata=config(field_name="spec_version")
    )
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    created: Optional[str] = field(default=None, metadata=config(field_name="created"))
    modified: Optional[str] = field(
        default=None, metadata=config(field_name="modified")
    )
    published: Optional[str] = field(
        default=None, metadata=config(field_name="published")
    )
    object_refs: Optional[List[str]] = field(
        default=None, metadata=config(field_name="object_refs")
    )
    content: Optional[str] = field(default=None, metadata=config(field_name="content"))
    sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="sharing_id")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    type: Optional[ThreatObjectType] = field(
        default=None, metadata=config(field_name="type")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ListItem:
    """ListItem."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    reference_id: Optional[str] = field(
        default=None, metadata=config(field_name="reference_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )
    severity: Optional[int] = field(
        default=None, metadata=config(field_name="severity")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="created_at")
    )
    modified_at: Optional[str] = field(
        default=None, metadata=config(field_name="modified_at")
    )
    age_at: Optional[str] = field(default=None, metadata=config(field_name="age_at"))
    deleted_at: Optional[str] = field(
        default=None, metadata=config(field_name="deleted_at")
    )
    item_type: Optional[ItemType] = field(
        default=None, metadata=config(field_name="item_type")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ListInfo:
    """ListInfo."""

    list_id: Optional[str] = field(default=None, metadata=config(field_name="list_id"))
    list_item_count: Optional[int] = field(
        default=None, metadata=config(field_name="list_item_count")
    )
    list_name: Optional[str] = field(
        default=None, metadata=config(field_name="list_name")
    )
    list_action: Optional[ListAction] = field(
        default=None, metadata=config(field_name="list_action")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Lists:
    """Lists."""

    list_info: Optional[List[ListInfo]] = field(
        default=None, metadata=config(field_name="list_info")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ListItemToList:
    """ListItemToList."""

    list_id: Optional[str] = field(default=None, metadata=config(field_name="listID"))
    list_name: Optional[str] = field(
        default=None, metadata=config(field_name="listName")
    )
    list_item: Optional[ListItem] = field(
        default=None, metadata=config(field_name="listItem")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ListItems:
    """ListItems."""

    list_item_map: Optional[List[ListItemToList]] = field(
        default=None, metadata=config(field_name="listItemMap")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ListItemInput:
    """ListItemInput."""

    reference_id: Optional[str] = field(
        default=None, metadata=config(field_name="reference_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )
    severity: Optional[int] = field(
        default=None, metadata=config(field_name="severity")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    item_type: Optional[ItemType] = field(
        default=None, metadata=config(field_name="item_type")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ListsArguments:
    """ListsArguments."""

    global_: Optional[bool] = field(default=None, metadata=config(field_name="global"))
    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(default=None, metadata=config(field_name="perPage"))
    order_by: Optional[OrderByOptions] = field(
        default=None, metadata=config(field_name="orderBy")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatIdentityInput:
    """ThreatIdentityInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    roles: Optional[List[str]] = field(
        default=None, metadata=config(field_name="roles")
    )
    contact_information: Optional[str] = field(
        default=None, metadata=config(field_name="contact_information")
    )
    natural_key: Optional[str] = field(
        default=None, metadata=config(field_name="natural_key")
    )
    download_url: Optional[str] = field(
        default=None, metadata=config(field_name="download_URL")
    )
    internal: Optional[bool] = field(
        default=None, metadata=config(field_name="internal")
    )
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )
    reason: Optional[List[str]] = field(
        default=None, metadata=config(field_name="reason")
    )
    identity_class: Optional[ThreatIdentityClass] = field(
        default=None, metadata=config(field_name="identity_class")
    )
    sectors: Optional[List[ThreatIndustrySectors]] = field(
        default=None, metadata=config(field_name="sectors")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreateListInput:
    """CreateListInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    download_url: Optional[str] = field(
        default=None, metadata=config(field_name="download_url")
    )
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )
    severity: Optional[int] = field(
        default=None, metadata=config(field_name="severity")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    items: Optional[List[ListItemInput]] = field(
        default=None, metadata=config(field_name="items")
    )
    list_action: Optional[ListAction] = field(
        default=None, metadata=config(field_name="list_action")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatVid:
    """ThreatVid."""

    id: Optional[str] = field(default=None, metadata=config(field_name="ID"))
    name: Optional[str] = field(default=None, metadata=config(field_name="Name"))
    swids: Optional[List[ThreatSwid]] = field(
        default=None, metadata=config(field_name="Swids")
    )
    threat_analyses: Optional[List[ThreatAnalysis]] = field(
        default=None, metadata=config(field_name="ThreatAnalyses")
    )
    threat_groups: Optional[List[ThreatGroup]] = field(
        default=None, metadata=config(field_name="ThreatGroups")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatIdentity:
    """ThreatIdentity."""

    spec_version: Optional[str] = field(
        default=None, metadata=config(field_name="spec_version")
    )
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="sharing_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    created: Optional[str] = field(default=None, metadata=config(field_name="created"))
    modified: Optional[str] = field(
        default=None, metadata=config(field_name="modified")
    )
    roles: Optional[List[str]] = field(
        default=None, metadata=config(field_name="roles")
    )
    contact_information: Optional[str] = field(
        default=None, metadata=config(field_name="contact_information")
    )
    natural_key: Optional[str] = field(
        default=None, metadata=config(field_name="natural_key")
    )
    download_url: Optional[str] = field(
        default=None, metadata=config(field_name="download_URL")
    )
    internal: Optional[bool] = field(
        default=None, metadata=config(field_name="internal")
    )
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )
    reason: Optional[List[str]] = field(
        default=None, metadata=config(field_name="reason")
    )
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    type: Optional[ThreatObjectType] = field(
        default=None, metadata=config(field_name="type")
    )
    identity_class: Optional[ThreatIdentityClass] = field(
        default=None, metadata=config(field_name="identity_class")
    )
    sectors: Optional[List[ThreatIndustrySectors]] = field(
        default=None, metadata=config(field_name="sectors")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatRelationshipInput:
    """ThreatRelationshipInput."""

    source_sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="source_sharing_id")
    )
    target_sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="target_sharing_id")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    src_desc: Optional[str] = field(
        default=None, metadata=config(field_name="src_desc")
    )
    tgt_desc: Optional[str] = field(
        default=None, metadata=config(field_name="tgt_desc")
    )
    mitre_attack_categories: Optional[List[str]] = field(
        default=None, metadata=config(field_name="mitre_attack_categories")
    )
    source_ref: Optional[str] = field(
        default=None, metadata=config(field_name="source_ref")
    )
    target_ref: Optional[str] = field(
        default=None, metadata=config(field_name="target_ref")
    )
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    source_internal: Optional[bool] = field(
        default=None, metadata=config(field_name="source_internal")
    )
    reference: Optional[str] = field(
        default=None, metadata=config(field_name="reference")
    )
    start_time: Optional[str] = field(
        default=None, metadata=config(field_name="start_time")
    )
    stop_time: Optional[str] = field(
        default=None, metadata=config(field_name="stop_time")
    )
    type: Optional[ThreatObjectType] = field(
        default=None, metadata=config(field_name="type")
    )
    relationship_type: Optional[ThreatRelationshipType] = field(
        default=None, metadata=config(field_name="relationship_type")
    )
    indicator_class: Optional[ThreatIndicatorClass] = field(
        default=None, metadata=config(field_name="indicator_class")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatRelationship:
    """ThreatRelationship."""

    spec_version: Optional[str] = field(
        default=None, metadata=config(field_name="spec_version")
    )
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="sharing_id")
    )
    source_sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="source_sharing_id")
    )
    target_sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="target_sharing_id")
    )
    created: Optional[str] = field(default=None, metadata=config(field_name="created"))
    modified: Optional[str] = field(
        default=None, metadata=config(field_name="modified")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    src_desc: Optional[str] = field(
        default=None, metadata=config(field_name="src_desc")
    )
    tgt_desc: Optional[str] = field(
        default=None, metadata=config(field_name="tgt_desc")
    )
    mitre_attack_categories: Optional[List[str]] = field(
        default=None, metadata=config(field_name="mitre_attack_categories")
    )
    source_ref: Optional[str] = field(
        default=None, metadata=config(field_name="source_ref")
    )
    target_ref: Optional[str] = field(
        default=None, metadata=config(field_name="target_ref")
    )
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    start_time: Optional[str] = field(
        default=None, metadata=config(field_name="start_time")
    )
    stop_time: Optional[str] = field(
        default=None, metadata=config(field_name="stop_time")
    )
    source_internal: Optional[bool] = field(
        default=None, metadata=config(field_name="source_internal")
    )
    reference: Optional[str] = field(
        default=None, metadata=config(field_name="reference")
    )
    type: Optional[ThreatObjectType] = field(
        default=None, metadata=config(field_name="type")
    )
    relationship_type: Optional[ThreatRelationshipType] = field(
        default=None, metadata=config(field_name="relationship_type")
    )
    indicator_class: Optional[ThreatIndicatorClass] = field(
        default=None, metadata=config(field_name="indicator_class")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatIndicatorInput:
    """ThreatIndicatorInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    pattern: Optional[str] = field(default=None, metadata=config(field_name="pattern"))
    pattern_version: Optional[str] = field(
        default=None, metadata=config(field_name="pattern_version")
    )
    valid_from: Optional[str] = field(
        default=None, metadata=config(field_name="valid_from")
    )
    valid_until: Optional[str] = field(
        default=None, metadata=config(field_name="valid_until")
    )
    score: Optional[int] = field(default=None, metadata=config(field_name="score"))
    indicator_types: Optional[List[ThreatIndicatorType]] = field(
        default=None, metadata=config(field_name="indicator_types")
    )
    pattern_type: Optional[ThreatPatternType] = field(
        default=None, metadata=config(field_name="pattern_type")
    )
    kill_chain_phases: Optional[List[ThreatKillChainPhaseInput]] = field(
        default=None, metadata=config(field_name="kill_chain_phases")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatList:
    """ThreatList."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    download_url: Optional[str] = field(
        default=None, metadata=config(field_name="download_url")
    )
    item_count: Optional[int] = field(
        default=None, metadata=config(field_name="item_count")
    )
    global_: Optional[bool] = field(default=None, metadata=config(field_name="global"))
    internal: Optional[bool] = field(
        default=None, metadata=config(field_name="internal")
    )
    confidence: Optional[int] = field(
        default=None, metadata=config(field_name="confidence")
    )
    severity: Optional[int] = field(
        default=None, metadata=config(field_name="severity")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="created_at")
    )
    modified_at: Optional[str] = field(
        default=None, metadata=config(field_name="modified_at")
    )
    age_at: Optional[str] = field(default=None, metadata=config(field_name="age_at"))
    deleted_at: Optional[str] = field(
        default=None, metadata=config(field_name="deleted_at")
    )
    owner: Optional[ListOwner] = field(
        default=None, metadata=config(field_name="owner")
    )
    items: Optional[List[ListItem]] = field(
        default=None, metadata=config(field_name="items")
    )
    list_action: Optional[ListAction] = field(
        default=None, metadata=config(field_name="list_action")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatMalware:
    """ThreatMalware."""

    spec_version: Optional[str] = field(
        default=None, metadata=config(field_name="spec_version")
    )
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="sharing_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    created: Optional[str] = field(default=None, metadata=config(field_name="created"))
    modified: Optional[str] = field(
        default=None, metadata=config(field_name="modified")
    )
    family: Optional[str] = field(default=None, metadata=config(field_name="family"))
    aliases: Optional[List[str]] = field(
        default=None, metadata=config(field_name="aliases")
    )
    first_seen: Optional[str] = field(
        default=None, metadata=config(field_name="first_seen")
    )
    last_seen: Optional[str] = field(
        default=None, metadata=config(field_name="last_seen")
    )
    operating_system_refs: Optional[List[str]] = field(
        default=None, metadata=config(field_name="operating_system_refs")
    )
    sample_refs: Optional[List[str]] = field(
        default=None, metadata=config(field_name="sample_refs")
    )
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    public_summary: Optional[str] = field(
        default=None, metadata=config(field_name="public_summary")
    )
    solution: Optional[str] = field(
        default=None, metadata=config(field_name="solution")
    )
    technical_details: Optional[str] = field(
        default=None, metadata=config(field_name="technical_details")
    )
    type: Optional[ThreatObjectType] = field(
        default=None, metadata=config(field_name="type")
    )
    malware_types: Optional[List[ThreatMalwareType]] = field(
        default=None, metadata=config(field_name="malware_types")
    )
    kill_chain_phases: Optional[List[ThreatKillChainPhase]] = field(
        default=None, metadata=config(field_name="kill_chain_phases")
    )
    architecture_execution_envs: Optional[
        List[ThreatArchitectureExecutionEnvs]
    ] = field(default=None, metadata=config(field_name="architecture_execution_envs"))
    implementation_languages: Optional[List[ThreatImplementationLanguages]] = field(
        default=None, metadata=config(field_name="implementation_languages")
    )
    capabilities: Optional[List[ThreatCapabilities]] = field(
        default=None, metadata=config(field_name="capabilities")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatIndicator:
    """ThreatIndicator."""

    spec_version: Optional[str] = field(
        default=None, metadata=config(field_name="spec_version")
    )
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    sharing_id: Optional[str] = field(
        default=None, metadata=config(field_name="sharing_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    created: Optional[str] = field(default=None, metadata=config(field_name="created"))
    modified: Optional[str] = field(
        default=None, metadata=config(field_name="modified")
    )
    pattern: Optional[str] = field(default=None, metadata=config(field_name="pattern"))
    pattern_version: Optional[str] = field(
        default=None, metadata=config(field_name="pattern_version")
    )
    mitre_attack_categories: Optional[List[str]] = field(
        default=None, metadata=config(field_name="mitre_attack_categories")
    )
    valid_from: Optional[str] = field(
        default=None, metadata=config(field_name="valid_from")
    )
    valid_until: Optional[str] = field(
        default=None, metadata=config(field_name="valid_until")
    )
    score: Optional[int] = field(default=None, metadata=config(field_name="score"))
    original_indicator: Optional[str] = field(
        default=None, metadata=config(field_name="original_indicator")
    )
    ipv4: Optional[str] = field(default=None, metadata=config(field_name="ipv4"))
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    no_results: Optional[bool] = field(
        default=None, metadata=config(field_name="noResults")
    )
    type: Optional[ThreatObjectType] = field(
        default=None, metadata=config(field_name="type")
    )
    indicator_types: Optional[List[ThreatIndicatorType]] = field(
        default=None, metadata=config(field_name="indicator_types")
    )
    pattern_type: Optional[ThreatPatternType] = field(
        default=None, metadata=config(field_name="pattern_type")
    )
    kill_chain_phases: Optional[List[ThreatKillChainPhase]] = field(
        default=None, metadata=config(field_name="kill_chain_phases")
    )
    indicator_class: Optional[ThreatIndicatorClass] = field(
        default=None, metadata=config(field_name="indicator_class")
    )
    dns: Optional[ThreatDNSInfo] = field(
        default=None, metadata=config(field_name="dns")
    )
    whois: Optional[ThreatWhois] = field(
        default=None, metadata=config(field_name="whois")
    )
    url_info: Optional[ThreatURLInfo] = field(
        default=None, metadata=config(field_name="url_info")
    )
    location: Optional[ThreatLocation] = field(
        default=None, metadata=config(field_name="location")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatIdentityRelationship:
    """ThreatIdentityRelationship."""

    identity: Optional[ThreatIdentity] = field(
        default=None, metadata=config(field_name="identity")
    )
    relationship: Optional[ThreatRelationship] = field(
        default=None, metadata=config(field_name="relationship")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatReportRelationship:
    """ThreatReportRelationship."""

    report: Optional[ThreatReport] = field(
        default=None, metadata=config(field_name="report")
    )
    relationship: Optional[ThreatRelationship] = field(
        default=None, metadata=config(field_name="relationship")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatMalwareRelationship:
    """ThreatMalwareRelationship."""

    malware: Optional[ThreatMalware] = field(
        default=None, metadata=config(field_name="malware")
    )
    relationship: Optional[ThreatRelationship] = field(
        default=None, metadata=config(field_name="relationship")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatGroupRelationship:
    """ThreatGroupRelationship."""

    group: Optional[ThreatGroup] = field(
        default=None, metadata=config(field_name="group")
    )
    relationship: Optional[ThreatRelationship] = field(
        default=None, metadata=config(field_name="relationship")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatVidIntelligence:
    """ThreatVidIntelligence."""

    reports: Optional[List[ThreatReportRelationship]] = field(
        default=None, metadata=config(field_name="reports")
    )
    malware: Optional[List[ThreatMalwareRelationship]] = field(
        default=None, metadata=config(field_name="malware")
    )
    groups: Optional[List[ThreatGroupRelationship]] = field(
        default=None, metadata=config(field_name="groups")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatIndicatorIntelligence:
    """ThreatIndicatorIntelligence."""

    indicator: Optional[ThreatIndicator] = field(
        default=None, metadata=config(field_name="indicator")
    )
    identities: Optional[List[ThreatIdentityRelationship]] = field(
        default=None, metadata=config(field_name="identities")
    )
    reports: Optional[List[ThreatReportRelationship]] = field(
        default=None, metadata=config(field_name="reports")
    )
    malware: Optional[List[ThreatMalwareRelationship]] = field(
        default=None, metadata=config(field_name="malware")
    )
    groups: Optional[List[ThreatGroupRelationship]] = field(
        default=None, metadata=config(field_name="groups")
    )


ThreatResult = Union[
    ThreatIdentity,
    ThreatIndicator,
    ThreatMalware,
    ThreatRelationship,
]
