

# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

from __future__ import annotations
import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime
import threading
import itertools
import traceback
import typing
import platform

# Used for default argument values
_DEFAULT = object() # type: typing.Any


class _UniffiRustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_uint64),
        ("len", ctypes.c_uint64),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def default():
        return _UniffiRustBuffer(0, 0, None)

    @staticmethod
    def alloc(size):
        return _uniffi_rust_call(_UniffiLib.ffi_nbis_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return _uniffi_rust_call(_UniffiLib.ffi_nbis_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return _uniffi_rust_call(_UniffiLib.ffi_nbis_rustbuffer_free, self)

    def __str__(self):
        return "_UniffiRustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def alloc_with_builder(*args):
        """Context-manger to allocate a buffer using a _UniffiRustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = _UniffiRustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consume_with_stream(self):
        """Context-manager to consume a buffer using a _UniffiRustBufferStream.

        The _UniffiRustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = _UniffiRustBufferStream.from_rust_buffer(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer at end of consume_with_stream")
        finally:
            self.free()

    @contextlib.contextmanager
    def read_with_stream(self):
        """Context-manager to read a buffer using a _UniffiRustBufferStream.

        This is like consume_with_stream, but doesn't free the buffer afterwards.
        It should only be used with borrowed `_UniffiRustBuffer` data.
        """
        s = _UniffiRustBufferStream.from_rust_buffer(self)
        yield s
        if s.remaining() != 0:
            raise RuntimeError("junk data left in buffer at end of read_with_stream")

class _UniffiForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "_UniffiForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class _UniffiRustBufferStream:
    """
    Helper for structured reading of bytes from a _UniffiRustBuffer
    """

    def __init__(self, data, len):
        self.data = data
        self.len = len
        self.offset = 0

    @classmethod
    def from_rust_buffer(cls, buf):
        return cls(buf.data, buf.len)

    def remaining(self):
        return self.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        data = self.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def read_i8(self):
        return self._unpack_from(1, ">b")

    def read_u8(self):
        return self._unpack_from(1, ">B")

    def read_i16(self):
        return self._unpack_from(2, ">h")

    def read_u16(self):
        return self._unpack_from(2, ">H")

    def read_i32(self):
        return self._unpack_from(4, ">i")

    def read_u32(self):
        return self._unpack_from(4, ">I")

    def read_i64(self):
        return self._unpack_from(8, ">q")

    def read_u64(self):
        return self._unpack_from(8, ">Q")

    def read_float(self):
        v = self._unpack_from(4, ">f")
        return v

    def read_double(self):
        return self._unpack_from(8, ">d")

class _UniffiRustBufferBuilder:
    """
    Helper for structured writing of bytes into a _UniffiRustBuffer.
    """

    def __init__(self):
        self.rbuf = _UniffiRustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, num_bytes):
        if self.rbuf.len + num_bytes > self.rbuf.capacity:
            self.rbuf = _UniffiRustBuffer.reserve(self.rbuf, num_bytes)
        yield None
        self.rbuf.len += num_bytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write_i8(self, v):
        self._pack_into(1, ">b", v)

    def write_u8(self, v):
        self._pack_into(1, ">B", v)

    def write_i16(self, v):
        self._pack_into(2, ">h", v)

    def write_u16(self, v):
        self._pack_into(2, ">H", v)

    def write_i32(self, v):
        self._pack_into(4, ">i", v)

    def write_u32(self, v):
        self._pack_into(4, ">I", v)

    def write_i64(self, v):
        self._pack_into(8, ">q", v)

    def write_u64(self, v):
        self._pack_into(8, ">Q", v)

    def write_float(self, v):
        self._pack_into(4, ">f", v)

    def write_double(self, v):
        self._pack_into(8, ">d", v)

    def write_c_size_t(self, v):
        self._pack_into(ctypes.sizeof(ctypes.c_size_t) , "@N", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class _UniffiRustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", _UniffiRustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_UNEXPECTED_ERROR = 2

    @staticmethod
    def default():
        return _UniffiRustCallStatus(code=_UniffiRustCallStatus.CALL_SUCCESS, error_buf=_UniffiRustBuffer.default())

    def __str__(self):
        if self.code == _UniffiRustCallStatus.CALL_SUCCESS:
            return "_UniffiRustCallStatus(CALL_SUCCESS)"
        elif self.code == _UniffiRustCallStatus.CALL_ERROR:
            return "_UniffiRustCallStatus(CALL_ERROR)"
        elif self.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
            return "_UniffiRustCallStatus(CALL_UNEXPECTED_ERROR)"
        else:
            return "_UniffiRustCallStatus(<invalid code>)"

def _uniffi_rust_call(fn, *args):
    # Call a rust function
    return _uniffi_rust_call_with_error(None, fn, *args)

def _uniffi_rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the _UniffiConverter for the error class that corresponds to the result.
    call_status = _UniffiRustCallStatus.default()

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    _uniffi_check_call_status(error_ffi_converter, call_status)
    return result

def _uniffi_check_call_status(error_ffi_converter, call_status):
    if call_status.code == _UniffiRustCallStatus.CALL_SUCCESS:
        pass
    elif call_status.code == _UniffiRustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.error_buf.free()
            raise InternalError("_uniffi_rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
        # When the rust code sees a panic, it tries to construct a _UniffiRustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = _UniffiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid _UniffiRustCallStatus code: {}".format(
            call_status.code))

def _uniffi_trait_interface_call(call_status, make_call, write_return_value):
    try:
        return write_return_value(make_call())
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))

def _uniffi_trait_interface_call_with_error(call_status, make_call, write_return_value, error_type, lower_error):
    try:
        try:
            return write_return_value(make_call())
        except error_type as e:
            call_status.code = _UniffiRustCallStatus.CALL_ERROR
            call_status.error_buf = lower_error(e)
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))
class _UniffiHandleMap:
    """
    A map where inserting, getting and removing data is synchronized with a lock.
    """

    def __init__(self):
        # type Handle = int
        self._map = {}  # type: Dict[Handle, Any]
        self._lock = threading.Lock()
        self._counter = itertools.count()

    def insert(self, obj):
        with self._lock:
            handle = next(self._counter)
            self._map[handle] = obj
            return handle

    def get(self, handle):
        try:
            with self._lock:
                return self._map[handle]
        except KeyError:
            raise InternalError("_UniffiHandleMap.get: Invalid handle")

    def remove(self, handle):
        try:
            with self._lock:
                return self._map.pop(handle)
        except KeyError:
            raise InternalError("_UniffiHandleMap.remove: Invalid handle")

    def __len__(self):
        return len(self._map)
# Types conforming to `_UniffiConverterPrimitive` pass themselves directly over the FFI.
class _UniffiConverterPrimitive:
    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return value

class _UniffiConverterPrimitiveInt(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__index__()
        except Exception:
            raise TypeError("'{}' object cannot be interpreted as an integer".format(type(value).__name__))
        if not isinstance(value, int):
            raise TypeError("__index__ returned non-int (type {})".format(type(value).__name__))
        if not cls.VALUE_MIN <= value < cls.VALUE_MAX:
            raise ValueError("{} requires {} <= value < {}".format(cls.CLASS_NAME, cls.VALUE_MIN, cls.VALUE_MAX))

class _UniffiConverterPrimitiveFloat(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__float__()
        except Exception:
            raise TypeError("must be real number, not {}".format(type(value).__name__))
        if not isinstance(value, float):
            raise TypeError("__float__ returned non-float (type {})".format(type(value).__name__))

# Helper class for wrapper types that will always go through a _UniffiRustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class _UniffiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consume_with_stream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code, and the FFI Function declarations.
# Define some ctypes FFI types that we use in the library

"""
Function pointer for a Rust task, which a callback function that takes a opaque pointer
"""
_UNIFFI_RUST_TASK = ctypes.CFUNCTYPE(None, ctypes.c_void_p, ctypes.c_int8)

def _uniffi_future_callback_t(return_type):
    """
    Factory function to create callback function types for async functions
    """
    return ctypes.CFUNCTYPE(None, ctypes.c_uint64, return_type, _UniffiRustCallStatus)

def _uniffi_load_indirect():
    """
    This is how we find and load the dynamic library provided by the component.
    For now we just look it up by name.
    """
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    libname = libname.format("nbis")
    path = os.path.join(os.path.dirname(__file__), libname)
    lib = ctypes.cdll.LoadLibrary(path)
    return lib

def _uniffi_check_contract_api_version(lib):
    # Get the bindings contract version from our ComponentInterface
    bindings_contract_version = 29
    # Get the scaffolding contract version by calling the into the dylib
    scaffolding_contract_version = lib.ffi_nbis_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version:
        raise InternalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")

def _uniffi_check_api_checksums(lib):
    if lib.uniffi_nbis_checksum_func_annotate_minutiae() != 40897:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_nbis_checksum_func_annotate_minutiae_from_image_file() != 39830:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_nbis_checksum_func_extract_minutiae() != 31551:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_nbis_checksum_func_extract_minutiae_from_image_file() != 9638:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_nbis_checksum_func_load_iso_19794_2_2005() != 19419:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_nbis_checksum_method_minutia_angle() != 52761:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_nbis_checksum_method_minutia_kind() != 40353:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_nbis_checksum_method_minutia_position() != 53525:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_nbis_checksum_method_minutia_reliability() != 21196:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_nbis_checksum_method_minutia_x() != 62575:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_nbis_checksum_method_minutia_y() != 50671:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_nbis_checksum_method_minutiae_compare() != 16630:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_nbis_checksum_method_minutiae_get() != 15862:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_nbis_checksum_method_minutiae_to_iso_19794_2_2005() != 6241:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniffiLib = _uniffi_load_indirect()
_UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.c_int8,
)
_UNIFFI_FOREIGN_FUTURE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
_UNIFFI_CALLBACK_INTERFACE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
class _UniffiForeignFuture(ctypes.Structure):
    _fields_ = [
        ("handle", ctypes.c_uint64),
        ("free", _UNIFFI_FOREIGN_FUTURE_FREE),
    ]
class _UniffiForeignFutureStructU8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU8,
)
class _UniffiForeignFutureStructI8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI8,
)
class _UniffiForeignFutureStructU16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU16,
)
class _UniffiForeignFutureStructI16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI16,
)
class _UniffiForeignFutureStructU32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU32,
)
class _UniffiForeignFutureStructI32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI32,
)
class _UniffiForeignFutureStructU64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU64,
)
class _UniffiForeignFutureStructI64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI64,
)
class _UniffiForeignFutureStructF32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_float),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF32,
)
class _UniffiForeignFutureStructF64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_double),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF64,
)
class _UniffiForeignFutureStructPointer(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_void_p),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_POINTER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructPointer,
)
class _UniffiForeignFutureStructRustBuffer(ctypes.Structure):
    _fields_ = [
        ("return_value", _UniffiRustBuffer),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructRustBuffer,
)
class _UniffiForeignFutureStructVoid(ctypes.Structure):
    _fields_ = [
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructVoid,
)
_UniffiLib.uniffi_nbis_fn_clone_minutia.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_clone_minutia.restype = ctypes.c_void_p
_UniffiLib.uniffi_nbis_fn_free_minutia.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_free_minutia.restype = None
_UniffiLib.uniffi_nbis_fn_method_minutia_angle.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_method_minutia_angle.restype = ctypes.c_double
_UniffiLib.uniffi_nbis_fn_method_minutia_kind.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_method_minutia_kind.restype = _UniffiRustBuffer
_UniffiLib.uniffi_nbis_fn_method_minutia_position.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_method_minutia_position.restype = _UniffiRustBuffer
_UniffiLib.uniffi_nbis_fn_method_minutia_reliability.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_method_minutia_reliability.restype = ctypes.c_double
_UniffiLib.uniffi_nbis_fn_method_minutia_x.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_method_minutia_x.restype = ctypes.c_int32
_UniffiLib.uniffi_nbis_fn_method_minutia_y.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_method_minutia_y.restype = ctypes.c_int32
_UniffiLib.uniffi_nbis_fn_clone_minutiae.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_clone_minutiae.restype = ctypes.c_void_p
_UniffiLib.uniffi_nbis_fn_free_minutiae.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_free_minutiae.restype = None
_UniffiLib.uniffi_nbis_fn_method_minutiae_compare.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_method_minutiae_compare.restype = ctypes.c_int32
_UniffiLib.uniffi_nbis_fn_method_minutiae_get.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_method_minutiae_get.restype = _UniffiRustBuffer
_UniffiLib.uniffi_nbis_fn_method_minutiae_to_iso_19794_2_2005.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_method_minutiae_to_iso_19794_2_2005.restype = _UniffiRustBuffer
_UniffiLib.uniffi_nbis_fn_func_annotate_minutiae.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_func_annotate_minutiae.restype = _UniffiRustBuffer
_UniffiLib.uniffi_nbis_fn_func_annotate_minutiae_from_image_file.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_func_annotate_minutiae_from_image_file.restype = _UniffiRustBuffer
_UniffiLib.uniffi_nbis_fn_func_extract_minutiae.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_func_extract_minutiae.restype = ctypes.c_void_p
_UniffiLib.uniffi_nbis_fn_func_extract_minutiae_from_image_file.argtypes = (
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_func_extract_minutiae_from_image_file.restype = ctypes.c_void_p
_UniffiLib.uniffi_nbis_fn_func_load_iso_19794_2_2005.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_nbis_fn_func_load_iso_19794_2_2005.restype = ctypes.c_void_p
_UniffiLib.ffi_nbis_rustbuffer_alloc.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rustbuffer_alloc.restype = _UniffiRustBuffer
_UniffiLib.ffi_nbis_rustbuffer_from_bytes.argtypes = (
    _UniffiForeignBytes,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rustbuffer_from_bytes.restype = _UniffiRustBuffer
_UniffiLib.ffi_nbis_rustbuffer_free.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rustbuffer_free.restype = None
_UniffiLib.ffi_nbis_rustbuffer_reserve.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rustbuffer_reserve.restype = _UniffiRustBuffer
_UniffiLib.ffi_nbis_rust_future_poll_u8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_poll_u8.restype = None
_UniffiLib.ffi_nbis_rust_future_cancel_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_cancel_u8.restype = None
_UniffiLib.ffi_nbis_rust_future_free_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_free_u8.restype = None
_UniffiLib.ffi_nbis_rust_future_complete_u8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rust_future_complete_u8.restype = ctypes.c_uint8
_UniffiLib.ffi_nbis_rust_future_poll_i8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_poll_i8.restype = None
_UniffiLib.ffi_nbis_rust_future_cancel_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_cancel_i8.restype = None
_UniffiLib.ffi_nbis_rust_future_free_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_free_i8.restype = None
_UniffiLib.ffi_nbis_rust_future_complete_i8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rust_future_complete_i8.restype = ctypes.c_int8
_UniffiLib.ffi_nbis_rust_future_poll_u16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_poll_u16.restype = None
_UniffiLib.ffi_nbis_rust_future_cancel_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_cancel_u16.restype = None
_UniffiLib.ffi_nbis_rust_future_free_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_free_u16.restype = None
_UniffiLib.ffi_nbis_rust_future_complete_u16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rust_future_complete_u16.restype = ctypes.c_uint16
_UniffiLib.ffi_nbis_rust_future_poll_i16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_poll_i16.restype = None
_UniffiLib.ffi_nbis_rust_future_cancel_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_cancel_i16.restype = None
_UniffiLib.ffi_nbis_rust_future_free_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_free_i16.restype = None
_UniffiLib.ffi_nbis_rust_future_complete_i16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rust_future_complete_i16.restype = ctypes.c_int16
_UniffiLib.ffi_nbis_rust_future_poll_u32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_poll_u32.restype = None
_UniffiLib.ffi_nbis_rust_future_cancel_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_cancel_u32.restype = None
_UniffiLib.ffi_nbis_rust_future_free_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_free_u32.restype = None
_UniffiLib.ffi_nbis_rust_future_complete_u32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rust_future_complete_u32.restype = ctypes.c_uint32
_UniffiLib.ffi_nbis_rust_future_poll_i32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_poll_i32.restype = None
_UniffiLib.ffi_nbis_rust_future_cancel_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_cancel_i32.restype = None
_UniffiLib.ffi_nbis_rust_future_free_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_free_i32.restype = None
_UniffiLib.ffi_nbis_rust_future_complete_i32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rust_future_complete_i32.restype = ctypes.c_int32
_UniffiLib.ffi_nbis_rust_future_poll_u64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_poll_u64.restype = None
_UniffiLib.ffi_nbis_rust_future_cancel_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_cancel_u64.restype = None
_UniffiLib.ffi_nbis_rust_future_free_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_free_u64.restype = None
_UniffiLib.ffi_nbis_rust_future_complete_u64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rust_future_complete_u64.restype = ctypes.c_uint64
_UniffiLib.ffi_nbis_rust_future_poll_i64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_poll_i64.restype = None
_UniffiLib.ffi_nbis_rust_future_cancel_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_cancel_i64.restype = None
_UniffiLib.ffi_nbis_rust_future_free_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_free_i64.restype = None
_UniffiLib.ffi_nbis_rust_future_complete_i64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rust_future_complete_i64.restype = ctypes.c_int64
_UniffiLib.ffi_nbis_rust_future_poll_f32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_poll_f32.restype = None
_UniffiLib.ffi_nbis_rust_future_cancel_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_cancel_f32.restype = None
_UniffiLib.ffi_nbis_rust_future_free_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_free_f32.restype = None
_UniffiLib.ffi_nbis_rust_future_complete_f32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rust_future_complete_f32.restype = ctypes.c_float
_UniffiLib.ffi_nbis_rust_future_poll_f64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_poll_f64.restype = None
_UniffiLib.ffi_nbis_rust_future_cancel_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_cancel_f64.restype = None
_UniffiLib.ffi_nbis_rust_future_free_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_free_f64.restype = None
_UniffiLib.ffi_nbis_rust_future_complete_f64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rust_future_complete_f64.restype = ctypes.c_double
_UniffiLib.ffi_nbis_rust_future_poll_pointer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_poll_pointer.restype = None
_UniffiLib.ffi_nbis_rust_future_cancel_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_cancel_pointer.restype = None
_UniffiLib.ffi_nbis_rust_future_free_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_free_pointer.restype = None
_UniffiLib.ffi_nbis_rust_future_complete_pointer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rust_future_complete_pointer.restype = ctypes.c_void_p
_UniffiLib.ffi_nbis_rust_future_poll_rust_buffer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_poll_rust_buffer.restype = None
_UniffiLib.ffi_nbis_rust_future_cancel_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_cancel_rust_buffer.restype = None
_UniffiLib.ffi_nbis_rust_future_free_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_free_rust_buffer.restype = None
_UniffiLib.ffi_nbis_rust_future_complete_rust_buffer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rust_future_complete_rust_buffer.restype = _UniffiRustBuffer
_UniffiLib.ffi_nbis_rust_future_poll_void.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_poll_void.restype = None
_UniffiLib.ffi_nbis_rust_future_cancel_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_cancel_void.restype = None
_UniffiLib.ffi_nbis_rust_future_free_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_nbis_rust_future_free_void.restype = None
_UniffiLib.ffi_nbis_rust_future_complete_void.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_nbis_rust_future_complete_void.restype = None
_UniffiLib.uniffi_nbis_checksum_func_annotate_minutiae.argtypes = (
)
_UniffiLib.uniffi_nbis_checksum_func_annotate_minutiae.restype = ctypes.c_uint16
_UniffiLib.uniffi_nbis_checksum_func_annotate_minutiae_from_image_file.argtypes = (
)
_UniffiLib.uniffi_nbis_checksum_func_annotate_minutiae_from_image_file.restype = ctypes.c_uint16
_UniffiLib.uniffi_nbis_checksum_func_extract_minutiae.argtypes = (
)
_UniffiLib.uniffi_nbis_checksum_func_extract_minutiae.restype = ctypes.c_uint16
_UniffiLib.uniffi_nbis_checksum_func_extract_minutiae_from_image_file.argtypes = (
)
_UniffiLib.uniffi_nbis_checksum_func_extract_minutiae_from_image_file.restype = ctypes.c_uint16
_UniffiLib.uniffi_nbis_checksum_func_load_iso_19794_2_2005.argtypes = (
)
_UniffiLib.uniffi_nbis_checksum_func_load_iso_19794_2_2005.restype = ctypes.c_uint16
_UniffiLib.uniffi_nbis_checksum_method_minutia_angle.argtypes = (
)
_UniffiLib.uniffi_nbis_checksum_method_minutia_angle.restype = ctypes.c_uint16
_UniffiLib.uniffi_nbis_checksum_method_minutia_kind.argtypes = (
)
_UniffiLib.uniffi_nbis_checksum_method_minutia_kind.restype = ctypes.c_uint16
_UniffiLib.uniffi_nbis_checksum_method_minutia_position.argtypes = (
)
_UniffiLib.uniffi_nbis_checksum_method_minutia_position.restype = ctypes.c_uint16
_UniffiLib.uniffi_nbis_checksum_method_minutia_reliability.argtypes = (
)
_UniffiLib.uniffi_nbis_checksum_method_minutia_reliability.restype = ctypes.c_uint16
_UniffiLib.uniffi_nbis_checksum_method_minutia_x.argtypes = (
)
_UniffiLib.uniffi_nbis_checksum_method_minutia_x.restype = ctypes.c_uint16
_UniffiLib.uniffi_nbis_checksum_method_minutia_y.argtypes = (
)
_UniffiLib.uniffi_nbis_checksum_method_minutia_y.restype = ctypes.c_uint16
_UniffiLib.uniffi_nbis_checksum_method_minutiae_compare.argtypes = (
)
_UniffiLib.uniffi_nbis_checksum_method_minutiae_compare.restype = ctypes.c_uint16
_UniffiLib.uniffi_nbis_checksum_method_minutiae_get.argtypes = (
)
_UniffiLib.uniffi_nbis_checksum_method_minutiae_get.restype = ctypes.c_uint16
_UniffiLib.uniffi_nbis_checksum_method_minutiae_to_iso_19794_2_2005.argtypes = (
)
_UniffiLib.uniffi_nbis_checksum_method_minutiae_to_iso_19794_2_2005.restype = ctypes.c_uint16
_UniffiLib.ffi_nbis_uniffi_contract_version.argtypes = (
)
_UniffiLib.ffi_nbis_uniffi_contract_version.restype = ctypes.c_uint32

_uniffi_check_contract_api_version(_UniffiLib)
# _uniffi_check_api_checksums(_UniffiLib)

# Public interface members begin here.


class _UniffiConverterInt32(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "i32"
    VALUE_MIN = -2**31
    VALUE_MAX = 2**31

    @staticmethod
    def read(buf):
        return buf.read_i32()

    @staticmethod
    def write(value, buf):
        buf.write_i32(value)

class _UniffiConverterInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "i64"
    VALUE_MIN = -2**63
    VALUE_MAX = 2**63

    @staticmethod
    def read(buf):
        return buf.read_i64()

    @staticmethod
    def write(value, buf):
        buf.write_i64(value)

class _UniffiConverterDouble(_UniffiConverterPrimitiveFloat):
    @staticmethod
    def read(buf):
        return buf.read_double()

    @staticmethod
    def write(value, buf):
        buf.write_double(value)

class _UniffiConverterString:
    @staticmethod
    def check_lower(value):
        if not isinstance(value, str):
            raise TypeError("argument must be str, not {}".format(type(value).__name__))
        return value

    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8_bytes = buf.read(size)
        return utf8_bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        utf8_bytes = value.encode("utf-8")
        buf.write_i32(len(utf8_bytes))
        buf.write(utf8_bytes)

    @staticmethod
    def lift(buf):
        with buf.consume_with_stream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()

class _UniffiConverterBytes(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative byte string length")
        return buf.read(size)

    @staticmethod
    def check_lower(value):
        try:
            memoryview(value)
        except TypeError:
            raise TypeError("a bytes-like object is required, not {!r}".format(type(value).__name__))

    @staticmethod
    def write(value, buf):
        buf.write_i32(len(value))
        buf.write(value)






class Position:
    x: "int"
    y: "int"
    def __init__(self, *, x: "int", y: "int"):
        self.x = x
        self.y = y

    def __str__(self):
        return "Position(x={}, y={})".format(self.x, self.y)

    def __eq__(self, other):
        if self.x != other.x:
            return False
        if self.y != other.y:
            return False
        return True

class _UniffiConverterTypePosition(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Position(
            x=_UniffiConverterInt32.read(buf),
            y=_UniffiConverterInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterInt32.check_lower(value.x)
        _UniffiConverterInt32.check_lower(value.y)

    @staticmethod
    def write(value, buf):
        _UniffiConverterInt32.write(value.x, buf)
        _UniffiConverterInt32.write(value.y, buf)





class MinutiaKind(enum.Enum):
    RIDGE_ENDING = 1
    
    BIFURCATION = 2
    


class _UniffiConverterTypeMinutiaKind(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return MinutiaKind.RIDGE_ENDING
        if variant == 2:
            return MinutiaKind.BIFURCATION
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == MinutiaKind.RIDGE_ENDING:
            return
        if value == MinutiaKind.BIFURCATION:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == MinutiaKind.RIDGE_ENDING:
            buf.write_i32(1)
        if value == MinutiaKind.BIFURCATION:
            buf.write_i32(2)




# NbisError
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class NbisError(Exception):
    pass

_UniffiTempNbisError = NbisError

class NbisError:  # type: ignore
    class ImageLoadError(_UniffiTempNbisError):
        def __init__(self):
            pass

        def __repr__(self):
            return "NbisError.ImageLoadError({})".format(str(self))
    _UniffiTempNbisError.ImageLoadError = ImageLoadError # type: ignore
    class FileReadError(_UniffiTempNbisError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "NbisError.FileReadError({})".format(str(self))
    _UniffiTempNbisError.FileReadError = FileReadError # type: ignore
    class InvalidQuality(_UniffiTempNbisError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], float):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'float', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "NbisError.InvalidQuality({})".format(str(self))
    _UniffiTempNbisError.InvalidQuality = InvalidQuality # type: ignore
    class UnexpectedError(_UniffiTempNbisError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], int):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'int', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "NbisError.UnexpectedError({})".format(str(self))
    _UniffiTempNbisError.UnexpectedError = UnexpectedError # type: ignore
    class InvalidTemplate(_UniffiTempNbisError):
        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            if not isinstance(values[0], str):
                raise TypeError(f"unexpected type for tuple element 0 - expected 'str', got '{type(values[0])}'")
            super().__init__(", ".join(map(repr, values)))
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __repr__(self):
            return "NbisError.InvalidTemplate({})".format(str(self))
    _UniffiTempNbisError.InvalidTemplate = InvalidTemplate # type: ignore

NbisError = _UniffiTempNbisError # type: ignore
del _UniffiTempNbisError


class _UniffiConverterTypeNbisError(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return NbisError.ImageLoadError(
            )
        if variant == 2:
            return NbisError.FileReadError(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return NbisError.InvalidQuality(
                _UniffiConverterDouble.read(buf),
            )
        if variant == 4:
            return NbisError.UnexpectedError(
                _UniffiConverterInt64.read(buf),
            )
        if variant == 5:
            return NbisError.InvalidTemplate(
                _UniffiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if isinstance(value, NbisError.ImageLoadError):
            return
        if isinstance(value, NbisError.FileReadError):
            _UniffiConverterString.check_lower(value._values[0])
            return
        if isinstance(value, NbisError.InvalidQuality):
            _UniffiConverterDouble.check_lower(value._values[0])
            return
        if isinstance(value, NbisError.UnexpectedError):
            _UniffiConverterInt64.check_lower(value._values[0])
            return
        if isinstance(value, NbisError.InvalidTemplate):
            _UniffiConverterString.check_lower(value._values[0])
            return

    @staticmethod
    def write(value, buf):
        if isinstance(value, NbisError.ImageLoadError):
            buf.write_i32(1)
        if isinstance(value, NbisError.FileReadError):
            buf.write_i32(2)
            _UniffiConverterString.write(value._values[0], buf)
        if isinstance(value, NbisError.InvalidQuality):
            buf.write_i32(3)
            _UniffiConverterDouble.write(value._values[0], buf)
        if isinstance(value, NbisError.UnexpectedError):
            buf.write_i32(4)
            _UniffiConverterInt64.write(value._values[0], buf)
        if isinstance(value, NbisError.InvalidTemplate):
            buf.write_i32(5)
            _UniffiConverterString.write(value._values[0], buf)



class _UniffiConverterOptionalDouble(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterDouble.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterDouble.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterDouble.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterSequenceTypeMinutia(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeMinutia.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeMinutia.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeMinutia.read(buf) for i in range(count)
        ]

# objects.
class MinutiaProtocol(typing.Protocol):
    """
    A lightweight, fully-safe copy of one minutia.
    (Add more fields if you need them.)
    """

    def angle(self, ):
        """
        Get the angle in degrees (0-360) for this minutia starting from the X axis (east).
        """

        raise NotImplementedError
    def kind(self, ):
        """
        Get the kind of minutia (ridge ending or bifurcation).
        """

        raise NotImplementedError
    def position(self, ):
        """
        Get the position as a tuple (x, y).
        """

        raise NotImplementedError
    def reliability(self, ):
        """
        Get the reliability score (0.0 to 1.0).
        """

        raise NotImplementedError
    def x(self, ):
        raise NotImplementedError
    def y(self, ):
        raise NotImplementedError
# Minutia is a Rust-only trait - it's a wrapper around a Rust implementation.
class Minutia():
    """
    A lightweight, fully-safe copy of one minutia.
    (Add more fields if you need them.)
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_nbis_fn_free_minutia, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_nbis_fn_clone_minutia, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def angle(self, ) -> "float":
        """
        Get the angle in degrees (0-360) for this minutia starting from the X axis (east).
        """

        return _UniffiConverterDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_nbis_fn_method_minutia_angle,self._uniffi_clone_pointer(),)
        )





    def kind(self, ) -> "MinutiaKind":
        """
        Get the kind of minutia (ridge ending or bifurcation).
        """

        return _UniffiConverterTypeMinutiaKind.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_nbis_fn_method_minutia_kind,self._uniffi_clone_pointer(),)
        )





    def position(self, ) -> "Position":
        """
        Get the position as a tuple (x, y).
        """

        return _UniffiConverterTypePosition.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_nbis_fn_method_minutia_position,self._uniffi_clone_pointer(),)
        )





    def reliability(self, ) -> "float":
        """
        Get the reliability score (0.0 to 1.0).
        """

        return _UniffiConverterDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_nbis_fn_method_minutia_reliability,self._uniffi_clone_pointer(),)
        )





    def x(self, ) -> "int":
        return _UniffiConverterInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_nbis_fn_method_minutia_x,self._uniffi_clone_pointer(),)
        )





    def y(self, ) -> "int":
        return _UniffiConverterInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_nbis_fn_method_minutia_y,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeMinutia:

    @staticmethod
    def lift(value: int):
        return Minutia._make_instance_(value)

    @staticmethod
    def check_lower(value: Minutia):
        if not isinstance(value, Minutia):
            raise TypeError("Expected Minutia instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: MinutiaProtocol):
        if not isinstance(value, Minutia):
            raise TypeError("Expected Minutia instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: MinutiaProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
class MinutiaeProtocol(typing.Protocol):
    """
    A set of minutiae extracted from a fingerprint image.
    """

    def compare(self, other: "Minutiae"):
        """
        Similarity via Bozorth‑3 (higher = more similar). A score > 50 is a likely match.

        # Arguments
        * `other` — another `Minutiae` object to compare against.

        Returns an `i32` score representing the similarity between the two sets of minutiae.
        A higher score indicates more similarity.
        """

        raise NotImplementedError
    def get(self, ):
        """
        Returns a vector of `Minutia` objects representing the minutiae in this set.
        """

        raise NotImplementedError
    def to_iso_19794_2_2005(self, ):
        """
        Convert this set of minutiae into an ISO/IEC 19794-2:2005 template.
        The result is a `Vec<u8>` containing the full template data.
        """

        raise NotImplementedError
# Minutiae is a Rust-only trait - it's a wrapper around a Rust implementation.
class Minutiae():
    """
    A set of minutiae extracted from a fingerprint image.
    """

    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_nbis_fn_free_minutiae, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_nbis_fn_clone_minutiae, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def compare(self, other: "Minutiae") -> "int":
        """
        Similarity via Bozorth‑3 (higher = more similar). A score > 50 is a likely match.

        # Arguments
        * `other` — another `Minutiae` object to compare against.

        Returns an `i32` score representing the similarity between the two sets of minutiae.
        A higher score indicates more similarity.
        """

        _UniffiConverterTypeMinutiae.check_lower(other)
        
        return _UniffiConverterInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_nbis_fn_method_minutiae_compare,self._uniffi_clone_pointer(),
        _UniffiConverterTypeMinutiae.lower(other))
        )





    def get(self, ) -> "typing.List[Minutia]":
        """
        Returns a vector of `Minutia` objects representing the minutiae in this set.
        """

        return _UniffiConverterSequenceTypeMinutia.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_nbis_fn_method_minutiae_get,self._uniffi_clone_pointer(),)
        )





    def to_iso_19794_2_2005(self, ) -> "bytes":
        """
        Convert this set of minutiae into an ISO/IEC 19794-2:2005 template.
        The result is a `Vec<u8>` containing the full template data.
        """

        return _UniffiConverterBytes.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_nbis_fn_method_minutiae_to_iso_19794_2_2005,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeMinutiae:

    @staticmethod
    def lift(value: int):
        return Minutiae._make_instance_(value)

    @staticmethod
    def check_lower(value: Minutiae):
        if not isinstance(value, Minutiae):
            raise TypeError("Expected Minutiae instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: MinutiaeProtocol):
        if not isinstance(value, Minutiae):
            raise TypeError("Expected Minutiae instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: MinutiaeProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))

# Async support

def annotate_minutiae(image: "bytes",ppi: "typing.Optional[float]",min_quality: "typing.Optional[float]") -> "bytes":
    """
    Annotates a fingerprint image with its extracted minutiae.

    # Arguments
    * `image` — the bytes of any image (PNG, JPEG, etc.) that can be converted
    * `ppi`  — (Optional) scanner resolution in dpi. Default is 500 dpi.
    * `min_quality` — (Optional) minimum reliability threshold for minutiae

    Returns the bytes of a PNG image with the minutiae annotated.
    """

    _UniffiConverterBytes.check_lower(image)
    
    _UniffiConverterOptionalDouble.check_lower(ppi)
    
    _UniffiConverterOptionalDouble.check_lower(min_quality)
    
    return _UniffiConverterBytes.lift(_uniffi_rust_call_with_error(_UniffiConverterTypeNbisError,_UniffiLib.uniffi_nbis_fn_func_annotate_minutiae,
        _UniffiConverterBytes.lower(image),
        _UniffiConverterOptionalDouble.lower(ppi),
        _UniffiConverterOptionalDouble.lower(min_quality)))


def annotate_minutiae_from_image_file(path: "str",ppi: "typing.Optional[float]",min_quality: "typing.Optional[float]") -> "bytes":
    """
    Annotates a fingerprint image with its extracted minutiae.

    # Arguments
    * `path` — the path to the image file.
    * `ppi`  — (Optional) scanner resolution in dpi. Default is 500
    * `min_quality` — (Optional) minimum reliability threshold for minutiae

    Returns the bytes of a PNG image with the minutiae annotated.

    If the image cannot be processed, returns an [`NbisError`].
    """

    _UniffiConverterString.check_lower(path)
    
    _UniffiConverterOptionalDouble.check_lower(ppi)
    
    _UniffiConverterOptionalDouble.check_lower(min_quality)
    
    return _UniffiConverterBytes.lift(_uniffi_rust_call_with_error(_UniffiConverterTypeNbisError,_UniffiLib.uniffi_nbis_fn_func_annotate_minutiae_from_image_file,
        _UniffiConverterString.lower(path),
        _UniffiConverterOptionalDouble.lower(ppi),
        _UniffiConverterOptionalDouble.lower(min_quality)))


def extract_minutiae(image: "bytes",ppi: "typing.Optional[float]") -> "Minutiae":
    """
    Extracts minutiae from an 8‑bit grayscale fingerprint image using the
    **NIST LFS v2** algorithm.

    * `image` — the bytes of any image (PNG, JPEG, etc.) that can be converted
    * `ppi`  — (Optional) scanner resolution in dpi. Default is 500 dpi.

    Returns an [`Minutiae`] object containing the extracted minutiae.

    If the image cannot be processed, returns an [`NbisError`].

    This function is the main entry point for fingerprint minutiae extraction.
    """

    _UniffiConverterBytes.check_lower(image)
    
    _UniffiConverterOptionalDouble.check_lower(ppi)
    
    return _UniffiConverterTypeMinutiae.lift(_uniffi_rust_call_with_error(_UniffiConverterTypeNbisError,_UniffiLib.uniffi_nbis_fn_func_extract_minutiae,
        _UniffiConverterBytes.lower(image),
        _UniffiConverterOptionalDouble.lower(ppi)))


def extract_minutiae_from_image_file(path: "str",ppi: "typing.Optional[float]") -> "Minutiae":
    """
    Extracts minutiae from an 8‑bit grayscale fingerprint image using the
    **NIST LFS v2** algorithm.

    * `image` — the bytes of any image (PNG, JPEG, etc.) that can be converted
    * `ppi`  — (Optional) scanner resolution in dpi. Default is 500 dpi.

    Returns an [`LfsResult`] on success or the negative error code propagated
    from the C library.
    """

    _UniffiConverterString.check_lower(path)
    
    _UniffiConverterOptionalDouble.check_lower(ppi)
    
    return _UniffiConverterTypeMinutiae.lift(_uniffi_rust_call_with_error(_UniffiConverterTypeNbisError,_UniffiLib.uniffi_nbis_fn_func_extract_minutiae_from_image_file,
        _UniffiConverterString.lower(path),
        _UniffiConverterOptionalDouble.lower(ppi)))


def load_iso_19794_2_2005(template_bytes: "bytes") -> "Minutiae":
    """
    Loads an ISO/IEC 19794-2:2005 fingerprint template from bytes.

    # Arguments
    * `template_bytes` — the raw bytes of the ISO template.

    Returns a [`Minutiae`] object containing the decoded minutiae.

    If the template is invalid or cannot be parsed, returns an [`NbisError`].
    """

    _UniffiConverterBytes.check_lower(template_bytes)
    
    return _UniffiConverterTypeMinutiae.lift(_uniffi_rust_call_with_error(_UniffiConverterTypeNbisError,_UniffiLib.uniffi_nbis_fn_func_load_iso_19794_2_2005,
        _UniffiConverterBytes.lower(template_bytes)))


__all__ = [
    "InternalError",
    "MinutiaKind",
    "NbisError",
    "Position",
    "annotate_minutiae",
    "annotate_minutiae_from_image_file",
    "extract_minutiae",
    "extract_minutiae_from_image_file",
    "load_iso_19794_2_2005",
    "Minutia",
    "Minutiae",
]

