import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [iotwireless](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotcoreforlorawan.html).
 *
 * @experimental
 */
export declare class Iotwireless extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to link partner accounts with Aws account.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateAwsAccountWithPartnerAccount.html
     *
     * @experimental
     */
    toAssociateAwsAccountWithPartnerAccount(): this;
    /**
     * (experimental) Grants permission to associate the wireless device with AWS IoT thing for a given wirelessDeviceId.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessDeviceWithThing.html
     *
     * @experimental
     */
    toAssociateWirelessDeviceWithThing(): this;
    /**
     * (experimental) Grants permission to associate a WirelessGateway with the IoT Core Identity certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessGatewayWithCertificate.html
     *
     * @experimental
     */
    toAssociateWirelessGatewayWithCertificate(): this;
    /**
     * (experimental) Grants permission to associate the wireless gateway with AWS IoT thing for a given wirelessGatewayId.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessGatewayWithThing.html
     *
     * @experimental
     */
    toAssociateWirelessGatewayWithThing(): this;
    /**
     * (experimental) Grants permission to create a Destination resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDestination.html
     *
     * @experimental
     */
    toCreateDestination(): this;
    /**
     * (experimental) Grants permission to create a DeviceProfile resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDeviceProfile.html
     *
     * @experimental
     */
    toCreateDeviceProfile(): this;
    /**
     * (experimental) Grants permission to create a ServiceProfile resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateServiceProfile.html
     *
     * @experimental
     */
    toCreateServiceProfile(): this;
    /**
     * (experimental) Grants permission to create a WirelessDevice resource with given Destination.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessDevice.html
     *
     * @experimental
     */
    toCreateWirelessDevice(): this;
    /**
     * (experimental) Grants permission to create a WirelessGateway resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGateway.html
     *
     * @experimental
     */
    toCreateWirelessGateway(): this;
    /**
     * (experimental) Grants permission to create a task for a given WirelessGateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGatewayTask.html
     *
     * @experimental
     */
    toCreateWirelessGatewayTask(): this;
    /**
     * (experimental) Grants permission to create a WirelessGateway task definition.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGatewayTaskDefinition.html
     *
     * @experimental
     */
    toCreateWirelessGatewayTaskDefinition(): this;
    /**
     * (experimental) Grants permission to delete a Destination.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteDestination.html
     *
     * @experimental
     */
    toDeleteDestination(): this;
    /**
     * (experimental) Grants permission to delete a DeviceProfile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteDeviceProfile.html
     *
     * @experimental
     */
    toDeleteDeviceProfile(): this;
    /**
     * (experimental) Grants permission to delete a ServiceProfile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteServiceProfile.html
     *
     * @experimental
     */
    toDeleteServiceProfile(): this;
    /**
     * (experimental) Grants permission to delete a WirelessDevice.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessDevice.html
     *
     * @experimental
     */
    toDeleteWirelessDevice(): this;
    /**
     * (experimental) Grants permission to delete a WirelessGateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessGateway.html
     *
     * @experimental
     */
    toDeleteWirelessGateway(): this;
    /**
     * (experimental) Grants permission to delete task for a given WirelessGateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessGatewayTask.html
     *
     * @experimental
     */
    toDeleteWirelessGatewayTask(): this;
    /**
     * (experimental) Grants permission to delete a WirelessGateway task definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessGatewayTaskDefinition.html
     *
     * @experimental
     */
    toDeleteWirelessGatewayTaskDefinition(): this;
    /**
     * (experimental) Grants permission to disassociate an AWS account from a partner account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateAwsAccountFromPartnerAccount.html
     *
     * @experimental
     */
    toDisassociateAwsAccountFromPartnerAccount(): this;
    /**
     * (experimental) Grants permission to disassociate a wireless device from a AWS IoT thing.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessDeviceFromThing.html
     *
     * @experimental
     */
    toDisassociateWirelessDeviceFromThing(): this;
    /**
     * (experimental) Grants permission to disassociate a WirelessGateway from a IoT Core Identity certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessGatewayFromCertificate.html
     *
     * @experimental
     */
    toDisassociateWirelessGatewayFromCertificate(): this;
    /**
     * (experimental) Grants permission to disassociate a WirelessGateway from a IoT Core thing.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessGatewayFromThing.html
     *
     * @experimental
     */
    toDisassociateWirelessGatewayFromThing(): this;
    /**
     * (experimental) Grants permission to get the Destination.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetDestination.html
     *
     * @experimental
     */
    toGetDestination(): this;
    /**
     * (experimental) Grants permission to get the DeviceProfile.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetDeviceProfile.html
     *
     * @experimental
     */
    toGetDeviceProfile(): this;
    /**
     * (experimental) Grants permission to get log levels by resource types.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetLogLevelsByResourceTypes.html
     *
     * @experimental
     */
    toGetLogLevelsByResourceTypes(): this;
    /**
     * (experimental) Grants permission to get the associated PartnerAccount.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetPartnerAccount.html
     *
     * @experimental
     */
    toGetPartnerAccount(): this;
    /**
     * (experimental) Grants permission to retrieve the customer account specific endpoint for CUPS protocol connection or LoRaWAN Network Server (LNS) protocol connection, and optionally server trust certificate in PEM format.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetServiceEndpoint.html
     *
     * @experimental
     */
    toGetServiceEndpoint(): this;
    /**
     * (experimental) Grants permission to get the ServiceProfile.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetServiceProfile.html
     *
     * @experimental
     */
    toGetServiceProfile(): this;
    /**
     * (experimental) Grants permission to get the WirelessDevice.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessDevice.html
     *
     * @experimental
     */
    toGetWirelessDevice(): this;
    /**
     * (experimental) Grants permission to get statistics info for a given WirelessDevice.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessDeviceStatistics.html
     *
     * @experimental
     */
    toGetWirelessDeviceStatistics(): this;
    /**
     * (experimental) Grants permission to get the WirelessGateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGateway.html
     *
     * @experimental
     */
    toGetWirelessGateway(): this;
    /**
     * (experimental) Grants permission to get the IoT Core Identity certificate id associated with the WirelessGateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayCertificate.html
     *
     * @experimental
     */
    toGetWirelessGatewayCertificate(): this;
    /**
     * (experimental) Grants permission to get Current firmware version and other information for the WirelessGateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayFirmwareInformation.html
     *
     * @experimental
     */
    toGetWirelessGatewayFirmwareInformation(): this;
    /**
     * (experimental) Grants permission to get statistics info for a given WirelessGateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayStatistics.html
     *
     * @experimental
     */
    toGetWirelessGatewayStatistics(): this;
    /**
     * (experimental) Grants permission to get the task for a given WirelessGateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayTask.html
     *
     * @experimental
     */
    toGetWirelessGatewayTask(): this;
    /**
     * (experimental) Grants permission to get the given WirelessGateway task definition.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayTaskDefinition.html
     *
     * @experimental
     */
    toGetWirelessGatewayTaskDefinition(): this;
    /**
     * (experimental) List information of available Destinations based on the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListDestinations.html
     *
     * @experimental
     */
    toListDestinations(): this;
    /**
     * (experimental) Grants permission to list information of available DeviceProfiles based on the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListDeviceProfiles.html
     *
     * @experimental
     */
    toListDeviceProfiles(): this;
    /**
     * (experimental) Grants permission to list the available partner accounts.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListPartnerAccounts.html
     *
     * @experimental
     */
    toListPartnerAccounts(): this;
    /**
     * (experimental) Grants permission to list information of available ServiceProfiles based on the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListServiceProfiles.html
     *
     * @experimental
     */
    toListServiceProfiles(): this;
    /**
     * (experimental) Grants permission to list all tags for a given resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list information of available WirelessDevices based on the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListWirelessDevices.html
     *
     * @experimental
     */
    toListWirelessDevices(): this;
    /**
     * (experimental) Grants permission to list information of available WirelessGateway task definitions based on the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListWirelessGatewayTaskDefinitions.html
     *
     * @experimental
     */
    toListWirelessGatewayTaskDefinitions(): this;
    /**
     * (experimental) Grants permission to list information of available WirelessGateways based on the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListWirelessGateways.html
     *
     * @experimental
     */
    toListWirelessGateways(): this;
    /**
     * (experimental) Grants permission to send the decrypted application data frame to the target device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_SendDataToWirelessDevice.html
     *
     * @experimental
     */
    toSendDataToWirelessDevice(): this;
    /**
     * (experimental) Grants permission to tag a given resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to simulate a provisioned device to send an uplink data with payload of 'Hello'.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_TestWirelessDevice.html
     *
     * @experimental
     */
    toTestWirelessDevice(): this;
    /**
     * (experimental) Grants permission to remove the given tags from the resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a Destination resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateDestination.html
     *
     * @experimental
     */
    toUpdateDestination(): this;
    /**
     * (experimental) Grants permission to update log levels by resource types.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateLogLevelsByResourceTypes.html
     *
     * @experimental
     */
    toUpdateLogLevelsByResourceTypes(): this;
    /**
     * (experimental) Grants permission to update a partner account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdatePartnerAccount.html
     *
     * @experimental
     */
    toUpdatePartnerAccount(): this;
    /**
     * (experimental) Grants permission to update a WirelessDevice resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateWirelessDevice.html
     *
     * @experimental
     */
    toUpdateWirelessDevice(): this;
    /**
     * (experimental) Grants permission to update a WirelessGateway resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateWirelessGateway.html
     *
     * @experimental
     */
    toUpdateWirelessGateway(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type WirelessDevice to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessDevice.html
     *
     * @param wirelessDeviceId - Identifier for the wirelessDeviceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWirelessDevice(wirelessDeviceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type WirelessGateway to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGateway.html
     *
     * @param wirelessGatewayId - Identifier for the wirelessGatewayId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWirelessGateway(wirelessGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type DeviceProfile to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDeviceProfile.html
     *
     * @param deviceProfileId - Identifier for the deviceProfileId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDeviceProfile(deviceProfileId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type ServiceProfile to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateServiceProfile.html
     *
     * @param serviceProfileId - Identifier for the serviceProfileId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onServiceProfile(serviceProfileId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Destination to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDestination.html
     *
     * @param destinationName - Identifier for the destinationName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDestination(destinationName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type SidewalkAccount to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateAwsAccountWithPartnerAccount.html
     *
     * @param sidewalkId - Identifier for the sidewalkId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSidewalkAccount(sidewalkId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type WirelessGatewayTaskDefinition to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGatewayTaskDefinition.html
     *
     * @param wirelessGatewayTaskDefinitionId - Identifier for the wirelessGatewayTaskDefinitionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWirelessGatewayTaskDefinition(wirelessGatewayTaskDefinitionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type thing to the statement.
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/thing-registry.html
     *
     * @param thingName - Identifier for the thingName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onThing(thingName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type cert to the statement.
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html
     *
     * @param certificate - Identifier for the certificate.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onCert(certificate: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [iotwireless](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotcoreforlorawan.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
