# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ModelComponentModelArgs',
    'ModelMetricArgs',
    'ModelMetricDatasetSummaryArgs',
    'ModelMetricLabelMetricsReportArgs',
    'ModelMetricLabelMetricsReportConfidenceEntryArgs',
    'ModelMetricOverallMetricsReportArgs',
    'ModelMetricOverallMetricsReportConfidenceEntryArgs',
    'ModelTestingDatasetArgs',
    'ModelTrainingDatasetArgs',
    'ModelValidationDatasetArgs',
    'ProcessorJobInputLocationArgs',
    'ProcessorJobInputLocationObjectLocationArgs',
    'ProcessorJobOutputLocationArgs',
    'ProcessorJobProcessorConfigArgs',
    'ProcessorJobProcessorConfigFeatureArgs',
    'GetModelsFilterArgs',
    'GetProjectsFilterArgs',
]

@pulumi.input_type
class ModelComponentModelArgs:
    def __init__(__self__, *,
                 model_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_id", value)


@pulumi.input_type
class ModelMetricArgs:
    def __init__(__self__, *,
                 dataset_summaries: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricDatasetSummaryArgs']]]] = None,
                 label_metrics_reports: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportArgs']]]] = None,
                 model_type: Optional[pulumi.Input[str]] = None,
                 overall_metrics_reports: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricDatasetSummaryArgs']]] dataset_summaries: Summary of count of samples used during model training.
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportArgs']]] label_metrics_reports: List of metrics entries per label.
        :param pulumi.Input[str] model_type: The type of the Document model.
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportArgs']]] overall_metrics_reports: Overall Metrics report for Document Classification Model.
        """
        if dataset_summaries is not None:
            pulumi.set(__self__, "dataset_summaries", dataset_summaries)
        if label_metrics_reports is not None:
            pulumi.set(__self__, "label_metrics_reports", label_metrics_reports)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if overall_metrics_reports is not None:
            pulumi.set(__self__, "overall_metrics_reports", overall_metrics_reports)

    @property
    @pulumi.getter(name="datasetSummaries")
    def dataset_summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricDatasetSummaryArgs']]]]:
        """
        Summary of count of samples used during model training.
        """
        return pulumi.get(self, "dataset_summaries")

    @dataset_summaries.setter
    def dataset_summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricDatasetSummaryArgs']]]]):
        pulumi.set(self, "dataset_summaries", value)

    @property
    @pulumi.getter(name="labelMetricsReports")
    def label_metrics_reports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportArgs']]]]:
        """
        List of metrics entries per label.
        """
        return pulumi.get(self, "label_metrics_reports")

    @label_metrics_reports.setter
    def label_metrics_reports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportArgs']]]]):
        pulumi.set(self, "label_metrics_reports", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_type", value)

    @property
    @pulumi.getter(name="overallMetricsReports")
    def overall_metrics_reports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportArgs']]]]:
        """
        Overall Metrics report for Document Classification Model.
        """
        return pulumi.get(self, "overall_metrics_reports")

    @overall_metrics_reports.setter
    def overall_metrics_reports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportArgs']]]]):
        pulumi.set(self, "overall_metrics_reports", value)


@pulumi.input_type
class ModelMetricDatasetSummaryArgs:
    def __init__(__self__, *,
                 test_sample_count: Optional[pulumi.Input[int]] = None,
                 training_sample_count: Optional[pulumi.Input[int]] = None,
                 validation_sample_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] test_sample_count: Number of samples used for testing the model.
        :param pulumi.Input[int] training_sample_count: Number of samples used for training the model.
        :param pulumi.Input[int] validation_sample_count: Number of samples used for validating the model.
        """
        if test_sample_count is not None:
            pulumi.set(__self__, "test_sample_count", test_sample_count)
        if training_sample_count is not None:
            pulumi.set(__self__, "training_sample_count", training_sample_count)
        if validation_sample_count is not None:
            pulumi.set(__self__, "validation_sample_count", validation_sample_count)

    @property
    @pulumi.getter(name="testSampleCount")
    def test_sample_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of samples used for testing the model.
        """
        return pulumi.get(self, "test_sample_count")

    @test_sample_count.setter
    def test_sample_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "test_sample_count", value)

    @property
    @pulumi.getter(name="trainingSampleCount")
    def training_sample_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of samples used for training the model.
        """
        return pulumi.get(self, "training_sample_count")

    @training_sample_count.setter
    def training_sample_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "training_sample_count", value)

    @property
    @pulumi.getter(name="validationSampleCount")
    def validation_sample_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of samples used for validating the model.
        """
        return pulumi.get(self, "validation_sample_count")

    @validation_sample_count.setter
    def validation_sample_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "validation_sample_count", value)


@pulumi.input_type
class ModelMetricLabelMetricsReportArgs:
    def __init__(__self__, *,
                 confidence_entries: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportConfidenceEntryArgs']]]] = None,
                 document_count: Optional[pulumi.Input[int]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 mean_average_precision: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportConfidenceEntryArgs']]] confidence_entries: List of document classification confidence report.
        :param pulumi.Input[int] document_count: Total test documents in the label.
        :param pulumi.Input[str] label: Label name
        :param pulumi.Input[float] mean_average_precision: Mean average precision under different thresholds
        """
        if confidence_entries is not None:
            pulumi.set(__self__, "confidence_entries", confidence_entries)
        if document_count is not None:
            pulumi.set(__self__, "document_count", document_count)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if mean_average_precision is not None:
            pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportConfidenceEntryArgs']]]]:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @confidence_entries.setter
    def confidence_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportConfidenceEntryArgs']]]]):
        pulumi.set(self, "confidence_entries", value)

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> Optional[pulumi.Input[int]]:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @document_count.setter
    def document_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "document_count", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Label name
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> Optional[pulumi.Input[float]]:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")

    @mean_average_precision.setter
    def mean_average_precision(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "mean_average_precision", value)


@pulumi.input_type
class ModelMetricLabelMetricsReportConfidenceEntryArgs:
    def __init__(__self__, *,
                 accuracy: Optional[pulumi.Input[float]] = None,
                 f1score: Optional[pulumi.Input[float]] = None,
                 precision: Optional[pulumi.Input[float]] = None,
                 recall: Optional[pulumi.Input[float]] = None,
                 threshold: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] accuracy: accuracy under the threshold
        :param pulumi.Input[float] f1score: f1Score under the threshold
        :param pulumi.Input[float] precision: Precision under the threshold
        :param pulumi.Input[float] recall: Recall under the threshold
        :param pulumi.Input[float] threshold: Threshold used to calculate precision and recall.
        """
        if accuracy is not None:
            pulumi.set(__self__, "accuracy", accuracy)
        if f1score is not None:
            pulumi.set(__self__, "f1score", f1score)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if recall is not None:
            pulumi.set(__self__, "recall", recall)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> Optional[pulumi.Input[float]]:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @accuracy.setter
    def accuracy(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "accuracy", value)

    @property
    @pulumi.getter
    def f1score(self) -> Optional[pulumi.Input[float]]:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @f1score.setter
    def f1score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "f1score", value)

    @property
    @pulumi.getter
    def precision(self) -> Optional[pulumi.Input[float]]:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @precision.setter
    def precision(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "precision", value)

    @property
    @pulumi.getter
    def recall(self) -> Optional[pulumi.Input[float]]:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @recall.setter
    def recall(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "recall", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[float]]:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold", value)


@pulumi.input_type
class ModelMetricOverallMetricsReportArgs:
    def __init__(__self__, *,
                 confidence_entries: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportConfidenceEntryArgs']]]] = None,
                 document_count: Optional[pulumi.Input[int]] = None,
                 mean_average_precision: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportConfidenceEntryArgs']]] confidence_entries: List of document classification confidence report.
        :param pulumi.Input[int] document_count: Total test documents in the label.
        :param pulumi.Input[float] mean_average_precision: Mean average precision under different thresholds
        """
        if confidence_entries is not None:
            pulumi.set(__self__, "confidence_entries", confidence_entries)
        if document_count is not None:
            pulumi.set(__self__, "document_count", document_count)
        if mean_average_precision is not None:
            pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportConfidenceEntryArgs']]]]:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @confidence_entries.setter
    def confidence_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportConfidenceEntryArgs']]]]):
        pulumi.set(self, "confidence_entries", value)

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> Optional[pulumi.Input[int]]:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @document_count.setter
    def document_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "document_count", value)

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> Optional[pulumi.Input[float]]:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")

    @mean_average_precision.setter
    def mean_average_precision(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "mean_average_precision", value)


@pulumi.input_type
class ModelMetricOverallMetricsReportConfidenceEntryArgs:
    def __init__(__self__, *,
                 accuracy: Optional[pulumi.Input[float]] = None,
                 f1score: Optional[pulumi.Input[float]] = None,
                 precision: Optional[pulumi.Input[float]] = None,
                 recall: Optional[pulumi.Input[float]] = None,
                 threshold: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] accuracy: accuracy under the threshold
        :param pulumi.Input[float] f1score: f1Score under the threshold
        :param pulumi.Input[float] precision: Precision under the threshold
        :param pulumi.Input[float] recall: Recall under the threshold
        :param pulumi.Input[float] threshold: Threshold used to calculate precision and recall.
        """
        if accuracy is not None:
            pulumi.set(__self__, "accuracy", accuracy)
        if f1score is not None:
            pulumi.set(__self__, "f1score", f1score)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if recall is not None:
            pulumi.set(__self__, "recall", recall)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> Optional[pulumi.Input[float]]:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @accuracy.setter
    def accuracy(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "accuracy", value)

    @property
    @pulumi.getter
    def f1score(self) -> Optional[pulumi.Input[float]]:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @f1score.setter
    def f1score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "f1score", value)

    @property
    @pulumi.getter
    def precision(self) -> Optional[pulumi.Input[float]]:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @precision.setter
    def precision(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "precision", value)

    @property
    @pulumi.getter
    def recall(self) -> Optional[pulumi.Input[float]]:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @recall.setter
    def recall(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "recall", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[float]]:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold", value)


@pulumi.input_type
class ModelTestingDatasetArgs:
    def __init__(__self__, *,
                 dataset_type: pulumi.Input[str],
                 bucket: Optional[pulumi.Input[str]] = None,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] dataset_type: The dataset type, based on where it is stored.
        :param pulumi.Input[str] bucket: The name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[str] dataset_id: OCID of the Data Labeling dataset.
        :param pulumi.Input[str] namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[str] object: The object name of the input data file.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> pulumi.Input[str]:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @dataset_type.setter
    def dataset_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset_type", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        The object name of the input data file.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class ModelTrainingDatasetArgs:
    def __init__(__self__, *,
                 dataset_type: pulumi.Input[str],
                 bucket: Optional[pulumi.Input[str]] = None,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] dataset_type: The dataset type, based on where it is stored.
        :param pulumi.Input[str] bucket: The name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[str] dataset_id: OCID of the Data Labeling dataset.
        :param pulumi.Input[str] namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[str] object: The object name of the input data file.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> pulumi.Input[str]:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @dataset_type.setter
    def dataset_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset_type", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        The object name of the input data file.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class ModelValidationDatasetArgs:
    def __init__(__self__, *,
                 dataset_type: pulumi.Input[str],
                 bucket: Optional[pulumi.Input[str]] = None,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] dataset_type: The dataset type, based on where it is stored.
        :param pulumi.Input[str] bucket: The name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[str] dataset_id: OCID of the Data Labeling dataset.
        :param pulumi.Input[str] namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[str] object: The object name of the input data file.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> pulumi.Input[str]:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @dataset_type.setter
    def dataset_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset_type", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        The object name of the input data file.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class ProcessorJobInputLocationArgs:
    def __init__(__self__, *,
                 source_type: pulumi.Input[str],
                 data: Optional[pulumi.Input[str]] = None,
                 object_locations: Optional[pulumi.Input[Sequence[pulumi.Input['ProcessorJobInputLocationObjectLocationArgs']]]] = None):
        """
        :param pulumi.Input[str] source_type: The type of input location. The allowed values are:
        :param pulumi.Input[str] data: Raw document data with Base64 encoding.
        :param pulumi.Input[Sequence[pulumi.Input['ProcessorJobInputLocationObjectLocationArgs']]] object_locations: The list of ObjectLocations.
        """
        pulumi.set(__self__, "source_type", source_type)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if object_locations is not None:
            pulumi.set(__self__, "object_locations", object_locations)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[str]:
        """
        The type of input location. The allowed values are:
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        Raw document data with Base64 encoding.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProcessorJobInputLocationObjectLocationArgs']]]]:
        """
        The list of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")

    @object_locations.setter
    def object_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProcessorJobInputLocationObjectLocationArgs']]]]):
        pulumi.set(self, "object_locations", value)


@pulumi.input_type
class ProcessorJobInputLocationObjectLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: The Object Storage bucket name.
        :param pulumi.Input[str] namespace: The Object Storage namespace.
        :param pulumi.Input[str] object: The Object Storage object name.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        The Object Storage object name.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class ProcessorJobOutputLocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 prefix: pulumi.Input[str]):
        """
        :param pulumi.Input[str] bucket: The Object Storage bucket name.
        :param pulumi.Input[str] namespace: The Object Storage namespace.
        :param pulumi.Input[str] prefix: The Object Storage folder name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[str]:
        """
        The Object Storage folder name.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class ProcessorJobProcessorConfigArgs:
    def __init__(__self__, *,
                 features: pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigFeatureArgs']]],
                 processor_type: pulumi.Input[str],
                 document_type: Optional[pulumi.Input[str]] = None,
                 is_zip_output_enabled: Optional[pulumi.Input[bool]] = None,
                 language: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigFeatureArgs']]] features: The types of document analysis requested.
        :param pulumi.Input[str] processor_type: The type of the processor.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] document_type: The document type.
        :param pulumi.Input[bool] is_zip_output_enabled: Whether or not to generate a ZIP file containing the results.
        :param pulumi.Input[str] language: The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        """
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "processor_type", processor_type)
        if document_type is not None:
            pulumi.set(__self__, "document_type", document_type)
        if is_zip_output_enabled is not None:
            pulumi.set(__self__, "is_zip_output_enabled", is_zip_output_enabled)
        if language is not None:
            pulumi.set(__self__, "language", language)

    @property
    @pulumi.getter
    def features(self) -> pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigFeatureArgs']]]:
        """
        The types of document analysis requested.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigFeatureArgs']]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter(name="processorType")
    def processor_type(self) -> pulumi.Input[str]:
        """
        The type of the processor.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "processor_type")

    @processor_type.setter
    def processor_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "processor_type", value)

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> Optional[pulumi.Input[str]]:
        """
        The document type.
        """
        return pulumi.get(self, "document_type")

    @document_type.setter
    def document_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "document_type", value)

    @property
    @pulumi.getter(name="isZipOutputEnabled")
    def is_zip_output_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to generate a ZIP file containing the results.
        """
        return pulumi.get(self, "is_zip_output_enabled")

    @is_zip_output_enabled.setter
    def is_zip_output_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_zip_output_enabled", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[str]]:
        """
        The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language", value)


@pulumi.input_type
class ProcessorJobProcessorConfigFeatureArgs:
    def __init__(__self__, *,
                 feature_type: pulumi.Input[str],
                 generate_searchable_pdf: Optional[pulumi.Input[bool]] = None,
                 max_results: Optional[pulumi.Input[int]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 tenancy_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] feature_type: The type of document analysis requested. The allowed values are:
        :param pulumi.Input[bool] generate_searchable_pdf: Whether or not to generate a searchable PDF file.
        :param pulumi.Input[int] max_results: The maximum number of results to return.
        :param pulumi.Input[str] model_id: The custom model ID.
        :param pulumi.Input[str] tenancy_id: The custom model tenancy ID when modelId represents aliasName.
        """
        pulumi.set(__self__, "feature_type", feature_type)
        if generate_searchable_pdf is not None:
            pulumi.set(__self__, "generate_searchable_pdf", generate_searchable_pdf)
        if max_results is not None:
            pulumi.set(__self__, "max_results", max_results)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)

    @property
    @pulumi.getter(name="featureType")
    def feature_type(self) -> pulumi.Input[str]:
        """
        The type of document analysis requested. The allowed values are:
        """
        return pulumi.get(self, "feature_type")

    @feature_type.setter
    def feature_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "feature_type", value)

    @property
    @pulumi.getter(name="generateSearchablePdf")
    def generate_searchable_pdf(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to generate a searchable PDF file.
        """
        return pulumi.get(self, "generate_searchable_pdf")

    @generate_searchable_pdf.setter
    def generate_searchable_pdf(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "generate_searchable_pdf", value)

    @property
    @pulumi.getter(name="maxResults")
    def max_results(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of results to return.
        """
        return pulumi.get(self, "max_results")

    @max_results.setter
    def max_results(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_results", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[str]]:
        """
        The custom model ID.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The custom model tenancy ID when modelId represents aliasName.
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_id", value)


@pulumi.input_type
class GetModelsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetProjectsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


