# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedDatabaseSqlTuningSetsResult',
    'AwaitableGetManagedDatabaseSqlTuningSetsResult',
    'get_managed_database_sql_tuning_sets',
    'get_managed_database_sql_tuning_sets_output',
]

@pulumi.output_type
class GetManagedDatabaseSqlTuningSetsResult:
    """
    A collection of values returned by getManagedDatabaseSqlTuningSets.
    """
    def __init__(__self__, filters=None, id=None, managed_database_id=None, name_contains=None, owner=None, sql_tuning_set_collections=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if name_contains and not isinstance(name_contains, str):
            raise TypeError("Expected argument 'name_contains' to be a str")
        pulumi.set(__self__, "name_contains", name_contains)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if sql_tuning_set_collections and not isinstance(sql_tuning_set_collections, list):
            raise TypeError("Expected argument 'sql_tuning_set_collections' to be a list")
        pulumi.set(__self__, "sql_tuning_set_collections", sql_tuning_set_collections)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedDatabaseSqlTuningSetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        """
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter(name="nameContains")
    def name_contains(self) -> Optional[str]:
        return pulumi.get(self, "name_contains")

    @property
    @pulumi.getter
    def owner(self) -> Optional[str]:
        """
        The owner of the SQL tuning set.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="sqlTuningSetCollections")
    def sql_tuning_set_collections(self) -> Sequence['outputs.GetManagedDatabaseSqlTuningSetsSqlTuningSetCollectionResult']:
        """
        The list of sql_tuning_set_collection.
        """
        return pulumi.get(self, "sql_tuning_set_collections")


class AwaitableGetManagedDatabaseSqlTuningSetsResult(GetManagedDatabaseSqlTuningSetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseSqlTuningSetsResult(
            filters=self.filters,
            id=self.id,
            managed_database_id=self.managed_database_id,
            name_contains=self.name_contains,
            owner=self.owner,
            sql_tuning_set_collections=self.sql_tuning_set_collections)


def get_managed_database_sql_tuning_sets(filters: Optional[Sequence[pulumi.InputType['GetManagedDatabaseSqlTuningSetsFilterArgs']]] = None,
                                         managed_database_id: Optional[str] = None,
                                         name_contains: Optional[str] = None,
                                         owner: Optional[str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseSqlTuningSetsResult:
    """
    This data source provides the list of Managed Database Sql Tuning Sets in Oracle Cloud Infrastructure Database Management service.

    Lists the SQL tuning sets for the specified Managed Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_sql_tuning_sets = oci.DatabaseManagement.get_managed_database_sql_tuning_sets(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        name_contains=var["managed_database_sql_tuning_set_name_contains"],
        owner=var["managed_database_sql_tuning_set_owner"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name_contains: Allow searching the name of the SQL tuning set by partial matching. The search is case insensitive.
    :param str owner: The owner of the SQL tuning set.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['managedDatabaseId'] = managed_database_id
    __args__['nameContains'] = name_contains
    __args__['owner'] = owner
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseSqlTuningSets:getManagedDatabaseSqlTuningSets', __args__, opts=opts, typ=GetManagedDatabaseSqlTuningSetsResult).value

    return AwaitableGetManagedDatabaseSqlTuningSetsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        name_contains=pulumi.get(__ret__, 'name_contains'),
        owner=pulumi.get(__ret__, 'owner'),
        sql_tuning_set_collections=pulumi.get(__ret__, 'sql_tuning_set_collections'))


@_utilities.lift_output_func(get_managed_database_sql_tuning_sets)
def get_managed_database_sql_tuning_sets_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagedDatabaseSqlTuningSetsFilterArgs']]]]] = None,
                                                managed_database_id: Optional[pulumi.Input[str]] = None,
                                                name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                                                owner: Optional[pulumi.Input[Optional[str]]] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseSqlTuningSetsResult]:
    """
    This data source provides the list of Managed Database Sql Tuning Sets in Oracle Cloud Infrastructure Database Management service.

    Lists the SQL tuning sets for the specified Managed Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_sql_tuning_sets = oci.DatabaseManagement.get_managed_database_sql_tuning_sets(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        name_contains=var["managed_database_sql_tuning_set_name_contains"],
        owner=var["managed_database_sql_tuning_set_owner"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name_contains: Allow searching the name of the SQL tuning set by partial matching. The search is case insensitive.
    :param str owner: The owner of the SQL tuning set.
    """
    ...
