# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetKeyVersionResult',
    'AwaitableGetKeyVersionResult',
    'get_key_version',
    'get_key_version_output',
]

@pulumi.output_type
class GetKeyVersionResult:
    """
    A collection of values returned by getKeyVersion.
    """
    def __init__(__self__, compartment_id=None, id=None, is_primary=None, key_id=None, key_version_id=None, management_endpoint=None, public_key=None, replica_details=None, restored_from_key_id=None, restored_from_key_version_id=None, state=None, time_created=None, time_of_deletion=None, vault_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_primary and not isinstance(is_primary, bool):
            raise TypeError("Expected argument 'is_primary' to be a bool")
        pulumi.set(__self__, "is_primary", is_primary)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if key_version_id and not isinstance(key_version_id, str):
            raise TypeError("Expected argument 'key_version_id' to be a str")
        pulumi.set(__self__, "key_version_id", key_version_id)
        if management_endpoint and not isinstance(management_endpoint, str):
            raise TypeError("Expected argument 'management_endpoint' to be a str")
        pulumi.set(__self__, "management_endpoint", management_endpoint)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)
        if replica_details and not isinstance(replica_details, list):
            raise TypeError("Expected argument 'replica_details' to be a list")
        pulumi.set(__self__, "replica_details", replica_details)
        if restored_from_key_id and not isinstance(restored_from_key_id, str):
            raise TypeError("Expected argument 'restored_from_key_id' to be a str")
        pulumi.set(__self__, "restored_from_key_id", restored_from_key_id)
        if restored_from_key_version_id and not isinstance(restored_from_key_version_id, str):
            raise TypeError("Expected argument 'restored_from_key_version_id' to be a str")
        pulumi.set(__self__, "restored_from_key_version_id", restored_from_key_version_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_of_deletion and not isinstance(time_of_deletion, str):
            raise TypeError("Expected argument 'time_of_deletion' to be a str")
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains this key version.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the key version.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> bool:
        """
        A boolean that will be true when key version is primary, and will be false when key version is a replica from a primary key version.
        """
        return pulumi.get(self, "is_primary")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        The OCID of the master encryption key associated with this key version.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyVersionId")
    def key_version_id(self) -> str:
        """
        The OCID of the key version.
        """
        return pulumi.get(self, "key_version_id")

    @property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> str:
        return pulumi.get(self, "management_endpoint")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        The public key in PEM format. (This value pertains only to RSA and ECDSA keys.)
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> Sequence['outputs.GetKeyVersionReplicaDetailResult']:
        """
        KeyVersion replica details
        """
        return pulumi.get(self, "replica_details")

    @property
    @pulumi.getter(name="restoredFromKeyId")
    def restored_from_key_id(self) -> str:
        return pulumi.get(self, "restored_from_key_id")

    @property
    @pulumi.getter(name="restoredFromKeyVersionId")
    def restored_from_key_version_id(self) -> str:
        """
        The OCID of the key version from which this key version was restored.
        """
        return pulumi.get(self, "restored_from_key_version_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The key version's current lifecycle state.  Example: `ENABLED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time this key version was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: "2018-04-03T21:10:29.600Z"
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        An optional property to indicate when to delete the key version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The OCID of the vault that contains this key version.
        """
        return pulumi.get(self, "vault_id")


class AwaitableGetKeyVersionResult(GetKeyVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyVersionResult(
            compartment_id=self.compartment_id,
            id=self.id,
            is_primary=self.is_primary,
            key_id=self.key_id,
            key_version_id=self.key_version_id,
            management_endpoint=self.management_endpoint,
            public_key=self.public_key,
            replica_details=self.replica_details,
            restored_from_key_id=self.restored_from_key_id,
            restored_from_key_version_id=self.restored_from_key_version_id,
            state=self.state,
            time_created=self.time_created,
            time_of_deletion=self.time_of_deletion,
            vault_id=self.vault_id)


def get_key_version(key_id: Optional[str] = None,
                    key_version_id: Optional[str] = None,
                    management_endpoint: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyVersionResult:
    """
    This data source provides details about a specific Key Version resource in Oracle Cloud Infrastructure Kms service.

    Gets information about the specified key version.

    As a management operation, this call is subject to a Key Management limit that applies to the total number
    of requests across all management read operations. Key Management might throttle this call to reject an
    otherwise valid request when the total rate of management read operations exceeds 10 requests per second
    for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_key_version = oci.Kms.get_key_version(key_id=oci_kms_key["test_key"]["id"],
        key_version_id=oci_kms_key_version["test_key_version"]["id"],
        management_endpoint=var["key_version_management_endpoint"])
    ```


    :param str key_id: The OCID of the key.
    :param str key_version_id: The OCID of the key version.
    :param str management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
    """
    __args__ = dict()
    __args__['keyId'] = key_id
    __args__['keyVersionId'] = key_version_id
    __args__['managementEndpoint'] = management_endpoint
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Kms/getKeyVersion:getKeyVersion', __args__, opts=opts, typ=GetKeyVersionResult).value

    return AwaitableGetKeyVersionResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        is_primary=pulumi.get(__ret__, 'is_primary'),
        key_id=pulumi.get(__ret__, 'key_id'),
        key_version_id=pulumi.get(__ret__, 'key_version_id'),
        management_endpoint=pulumi.get(__ret__, 'management_endpoint'),
        public_key=pulumi.get(__ret__, 'public_key'),
        replica_details=pulumi.get(__ret__, 'replica_details'),
        restored_from_key_id=pulumi.get(__ret__, 'restored_from_key_id'),
        restored_from_key_version_id=pulumi.get(__ret__, 'restored_from_key_version_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_of_deletion=pulumi.get(__ret__, 'time_of_deletion'),
        vault_id=pulumi.get(__ret__, 'vault_id'))


@_utilities.lift_output_func(get_key_version)
def get_key_version_output(key_id: Optional[pulumi.Input[str]] = None,
                           key_version_id: Optional[pulumi.Input[str]] = None,
                           management_endpoint: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKeyVersionResult]:
    """
    This data source provides details about a specific Key Version resource in Oracle Cloud Infrastructure Kms service.

    Gets information about the specified key version.

    As a management operation, this call is subject to a Key Management limit that applies to the total number
    of requests across all management read operations. Key Management might throttle this call to reject an
    otherwise valid request when the total rate of management read operations exceeds 10 requests per second
    for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_key_version = oci.Kms.get_key_version(key_id=oci_kms_key["test_key"]["id"],
        key_version_id=oci_kms_key_version["test_key_version"]["id"],
        management_endpoint=var["key_version_management_endpoint"])
    ```


    :param str key_id: The OCID of the key.
    :param str key_version_id: The OCID of the key version.
    :param str management_endpoint: The service endpoint to perform management operations against. Management operations include 'Create,' 'Update,' 'List,' 'Get,' and 'Delete' operations. See Vault Management endpoint.
    """
    ...
