# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MysqlDbSystemArgs', 'MysqlDbSystem']

@pulumi.input_type
class MysqlDbSystemArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 shape_name: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 backup_policy: Optional[pulumi.Input['MysqlDbSystemBackupPolicyArgs']] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 crash_recovery: Optional[pulumi.Input[str]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deletion_policies: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemDeletionPolicyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hostname_label: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 is_highly_available: Optional[pulumi.Input[bool]] = None,
                 maintenance: Optional[pulumi.Input['MysqlDbSystemMaintenanceArgs']] = None,
                 mysql_version: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_x: Optional[pulumi.Input[int]] = None,
                 shutdown_type: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input['MysqlDbSystemSourceArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MysqlDbSystem resource.
        :param pulumi.Input[str] availability_domain: The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
               
               In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.
               
               For a standalone DB System, this defines the availability domain in which the DB System is placed.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[str] shape_name: (Updatable) The name of the shape. The shape determines the resources allocated
               * CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        :param pulumi.Input[str] subnet_id: The OCID of the subnet the DB System is associated with.
        :param pulumi.Input[str] admin_password: The password for the administrative user. The password must be between 8 and 32 characters long, and must contain at least 1 numeric character, 1 lowercase character, 1 uppercase character, and 1 special (nonalphanumeric) character.
        :param pulumi.Input[str] admin_username: The username for the administrative user.
        :param pulumi.Input['MysqlDbSystemBackupPolicyArgs'] backup_policy: (Updatable) Backup policy as optionally used for DB System Creation.
        :param pulumi.Input[str] configuration_id: (Updatable) The OCID of the Configuration to be used for this DB System.
        :param pulumi.Input[str] crash_recovery: (Updatable) Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        :param pulumi.Input[int] data_storage_size_in_gb: (Updatable) Initial size of the data volume in GBs that will be created and attached. Keep in mind that this only specifies the size of the database data volume, the log volume for the database will be scaled appropriately with its shape. It is required if you are creating a new database. It cannot be set if you are creating a database from a backup.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemDeletionPolicyArgs']]] deletion_policies: (Updatable) Policy for how the DB System and related resources should be handled at the time of its deletion.
        :param pulumi.Input[str] description: (Updatable) User-provided data about the DB System.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the DB System. It does not have to be unique.
        :param pulumi.Input[str] fault_domain: The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
               
               In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.
               
               For a standalone DB System, this defines the fault domain in which the DB System is placed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] hostname_label: The hostname for the primary endpoint of the DB System. Used for DNS.
               
               The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com").
               
               Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        :param pulumi.Input[str] ip_address: The IP address the DB System is configured to listen on. A private IP address of your choice to assign to the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        :param pulumi.Input[bool] is_highly_available: (Updatable) Specifies if the DB System is highly available.
               
               When creating a DB System with High Availability, three instances are created and placed according to your region- and subnet-type. The secondaries are placed automatically in the other two availability or fault domains.  You can choose the preferred location of your primary instance, only.
        :param pulumi.Input['MysqlDbSystemMaintenanceArgs'] maintenance: (Updatable) The Maintenance Policy for the DB System or Read Replica that this model is included in. `maintenance` and `backup_policy` cannot be updated in the same request.
        :param pulumi.Input[str] mysql_version: The specific MySQL version identifier.
        :param pulumi.Input[int] port: The port for primary endpoint of the DB System to listen on.
        :param pulumi.Input[int] port_x: The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        :param pulumi.Input[str] shutdown_type: It is applicable only for stopping a DB System. Could be set to `FAST`, `SLOW` or `IMMEDIATE`. Default value is `FAST`.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['MysqlDbSystemSourceArgs'] source: Parameters detailing how to provision the initial data of the system.
        :param pulumi.Input[str] state: (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "shape_name", shape_name)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if backup_policy is not None:
            pulumi.set(__self__, "backup_policy", backup_policy)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if crash_recovery is not None:
            pulumi.set(__self__, "crash_recovery", crash_recovery)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deletion_policies is not None:
            pulumi.set(__self__, "deletion_policies", deletion_policies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname_label is not None:
            pulumi.set(__self__, "hostname_label", hostname_label)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if is_highly_available is not None:
            pulumi.set(__self__, "is_highly_available", is_highly_available)
        if maintenance is not None:
            pulumi.set(__self__, "maintenance", maintenance)
        if mysql_version is not None:
            pulumi.set(__self__, "mysql_version", mysql_version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_x is not None:
            pulumi.set(__self__, "port_x", port_x)
        if shutdown_type is not None:
            pulumi.set(__self__, "shutdown_type", shutdown_type)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[str]:
        """
        The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the availability domain in which the DB System is placed.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The name of the shape. The shape determines the resources allocated
        * CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "shape_name", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The OCID of the subnet the DB System is associated with.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the administrative user. The password must be between 8 and 32 characters long, and must contain at least 1 numeric character, 1 lowercase character, 1 uppercase character, and 1 special (nonalphanumeric) character.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        The username for the administrative user.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> Optional[pulumi.Input['MysqlDbSystemBackupPolicyArgs']]:
        """
        (Updatable) Backup policy as optionally used for DB System Creation.
        """
        return pulumi.get(self, "backup_policy")

    @backup_policy.setter
    def backup_policy(self, value: Optional[pulumi.Input['MysqlDbSystemBackupPolicyArgs']]):
        pulumi.set(self, "backup_policy", value)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the Configuration to be used for this DB System.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_id", value)

    @property
    @pulumi.getter(name="crashRecovery")
    def crash_recovery(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        """
        return pulumi.get(self, "crash_recovery")

    @crash_recovery.setter
    def crash_recovery(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crash_recovery", value)

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Initial size of the data volume in GBs that will be created and attached. Keep in mind that this only specifies the size of the database data volume, the log volume for the database will be scaled appropriately with its shape. It is required if you are creating a new database. It cannot be set if you are creating a database from a backup.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @data_storage_size_in_gb.setter
    def data_storage_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_storage_size_in_gb", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deletionPolicies")
    def deletion_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemDeletionPolicyArgs']]]]:
        """
        (Updatable) Policy for how the DB System and related resources should be handled at the time of its deletion.
        """
        return pulumi.get(self, "deletion_policies")

    @deletion_policies.setter
    def deletion_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemDeletionPolicyArgs']]]]):
        pulumi.set(self, "deletion_policies", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User-provided data about the DB System.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The user-friendly name for the DB System. It does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the fault domain in which the DB System is placed.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname for the primary endpoint of the DB System. Used for DNS.

        The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com").

        Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        """
        return pulumi.get(self, "hostname_label")

    @hostname_label.setter
    def hostname_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname_label", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address the DB System is configured to listen on. A private IP address of your choice to assign to the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="isHighlyAvailable")
    def is_highly_available(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Specifies if the DB System is highly available.

        When creating a DB System with High Availability, three instances are created and placed according to your region- and subnet-type. The secondaries are placed automatically in the other two availability or fault domains.  You can choose the preferred location of your primary instance, only.
        """
        return pulumi.get(self, "is_highly_available")

    @is_highly_available.setter
    def is_highly_available(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_highly_available", value)

    @property
    @pulumi.getter
    def maintenance(self) -> Optional[pulumi.Input['MysqlDbSystemMaintenanceArgs']]:
        """
        (Updatable) The Maintenance Policy for the DB System or Read Replica that this model is included in. `maintenance` and `backup_policy` cannot be updated in the same request.
        """
        return pulumi.get(self, "maintenance")

    @maintenance.setter
    def maintenance(self, value: Optional[pulumi.Input['MysqlDbSystemMaintenanceArgs']]):
        pulumi.set(self, "maintenance", value)

    @property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> Optional[pulumi.Input[str]]:
        """
        The specific MySQL version identifier.
        """
        return pulumi.get(self, "mysql_version")

    @mysql_version.setter
    def mysql_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mysql_version", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port for primary endpoint of the DB System to listen on.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portX")
    def port_x(self) -> Optional[pulumi.Input[int]]:
        """
        The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @port_x.setter
    def port_x(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_x", value)

    @property
    @pulumi.getter(name="shutdownType")
    def shutdown_type(self) -> Optional[pulumi.Input[str]]:
        """
        It is applicable only for stopping a DB System. Could be set to `FAST`, `SLOW` or `IMMEDIATE`. Default value is `FAST`.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "shutdown_type")

    @shutdown_type.setter
    def shutdown_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shutdown_type", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['MysqlDbSystemSourceArgs']]:
        """
        Parameters detailing how to provision the initial data of the system.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['MysqlDbSystemSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _MysqlDbSystemState:
    def __init__(__self__, *,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 backup_policy: Optional[pulumi.Input['MysqlDbSystemBackupPolicyArgs']] = None,
                 channels: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 crash_recovery: Optional[pulumi.Input[str]] = None,
                 current_placements: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemCurrentPlacementArgs']]]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deletion_policies: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemDeletionPolicyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemEndpointArgs']]]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 heat_wave_clusters: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemHeatWaveClusterArgs']]]] = None,
                 hostname_label: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 is_heat_wave_cluster_attached: Optional[pulumi.Input[bool]] = None,
                 is_highly_available: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 maintenance: Optional[pulumi.Input['MysqlDbSystemMaintenanceArgs']] = None,
                 mysql_version: Optional[pulumi.Input[str]] = None,
                 point_in_time_recovery_details: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemPointInTimeRecoveryDetailArgs']]]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_x: Optional[pulumi.Input[int]] = None,
                 shape_name: Optional[pulumi.Input[str]] = None,
                 shutdown_type: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input['MysqlDbSystemSourceArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MysqlDbSystem resources.
        :param pulumi.Input[str] admin_password: The password for the administrative user. The password must be between 8 and 32 characters long, and must contain at least 1 numeric character, 1 lowercase character, 1 uppercase character, and 1 special (nonalphanumeric) character.
        :param pulumi.Input[str] admin_username: The username for the administrative user.
        :param pulumi.Input[str] availability_domain: The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
               
               In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.
               
               For a standalone DB System, this defines the availability domain in which the DB System is placed.
        :param pulumi.Input['MysqlDbSystemBackupPolicyArgs'] backup_policy: (Updatable) Backup policy as optionally used for DB System Creation.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelArgs']]] channels: A list with a summary of all the Channels attached to the DB System.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[str] configuration_id: (Updatable) The OCID of the Configuration to be used for this DB System.
        :param pulumi.Input[str] crash_recovery: (Updatable) Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemCurrentPlacementArgs']]] current_placements: The availability domain and fault domain a DB System is placed in.
        :param pulumi.Input[int] data_storage_size_in_gb: (Updatable) Initial size of the data volume in GBs that will be created and attached. Keep in mind that this only specifies the size of the database data volume, the log volume for the database will be scaled appropriately with its shape. It is required if you are creating a new database. It cannot be set if you are creating a database from a backup.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemDeletionPolicyArgs']]] deletion_policies: (Updatable) Policy for how the DB System and related resources should be handled at the time of its deletion.
        :param pulumi.Input[str] description: (Updatable) User-provided data about the DB System.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the DB System. It does not have to be unique.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemEndpointArgs']]] endpoints: The network endpoints available for this DB System.
        :param pulumi.Input[str] fault_domain: The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
               
               In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.
               
               For a standalone DB System, this defines the fault domain in which the DB System is placed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemHeatWaveClusterArgs']]] heat_wave_clusters: A summary of a HeatWave cluster.
        :param pulumi.Input[str] hostname_label: The hostname for the primary endpoint of the DB System. Used for DNS.
               
               The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com").
               
               Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        :param pulumi.Input[str] ip_address: The IP address the DB System is configured to listen on. A private IP address of your choice to assign to the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        :param pulumi.Input[bool] is_heat_wave_cluster_attached: If the DB System has a HeatWave Cluster attached.
        :param pulumi.Input[bool] is_highly_available: (Updatable) Specifies if the DB System is highly available.
               
               When creating a DB System with High Availability, three instances are created and placed according to your region- and subnet-type. The secondaries are placed automatically in the other two availability or fault domains.  You can choose the preferred location of your primary instance, only.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycleState.
        :param pulumi.Input['MysqlDbSystemMaintenanceArgs'] maintenance: (Updatable) The Maintenance Policy for the DB System or Read Replica that this model is included in. `maintenance` and `backup_policy` cannot be updated in the same request.
        :param pulumi.Input[str] mysql_version: The specific MySQL version identifier.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemPointInTimeRecoveryDetailArgs']]] point_in_time_recovery_details: Point-in-time Recovery details like earliest and latest recovery time point for the DB System.
        :param pulumi.Input[int] port: The port for primary endpoint of the DB System to listen on.
        :param pulumi.Input[int] port_x: The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        :param pulumi.Input[str] shape_name: (Updatable) The name of the shape. The shape determines the resources allocated
               * CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        :param pulumi.Input[str] shutdown_type: It is applicable only for stopping a DB System. Could be set to `FAST`, `SLOW` or `IMMEDIATE`. Default value is `FAST`.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['MysqlDbSystemSourceArgs'] source: Parameters detailing how to provision the initial data of the system.
        :param pulumi.Input[str] state: (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        :param pulumi.Input[str] subnet_id: The OCID of the subnet the DB System is associated with.
        :param pulumi.Input[str] time_created: The date and time the DB System was created.
        :param pulumi.Input[str] time_updated: The time the DB System was last updated.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_policy is not None:
            pulumi.set(__self__, "backup_policy", backup_policy)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if crash_recovery is not None:
            pulumi.set(__self__, "crash_recovery", crash_recovery)
        if current_placements is not None:
            pulumi.set(__self__, "current_placements", current_placements)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deletion_policies is not None:
            pulumi.set(__self__, "deletion_policies", deletion_policies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if heat_wave_clusters is not None:
            pulumi.set(__self__, "heat_wave_clusters", heat_wave_clusters)
        if hostname_label is not None:
            pulumi.set(__self__, "hostname_label", hostname_label)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if is_heat_wave_cluster_attached is not None:
            pulumi.set(__self__, "is_heat_wave_cluster_attached", is_heat_wave_cluster_attached)
        if is_highly_available is not None:
            pulumi.set(__self__, "is_highly_available", is_highly_available)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenance is not None:
            pulumi.set(__self__, "maintenance", maintenance)
        if mysql_version is not None:
            pulumi.set(__self__, "mysql_version", mysql_version)
        if point_in_time_recovery_details is not None:
            pulumi.set(__self__, "point_in_time_recovery_details", point_in_time_recovery_details)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_x is not None:
            pulumi.set(__self__, "port_x", port_x)
        if shape_name is not None:
            pulumi.set(__self__, "shape_name", shape_name)
        if shutdown_type is not None:
            pulumi.set(__self__, "shutdown_type", shutdown_type)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the administrative user. The password must be between 8 and 32 characters long, and must contain at least 1 numeric character, 1 lowercase character, 1 uppercase character, and 1 special (nonalphanumeric) character.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        The username for the administrative user.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the availability domain in which the DB System is placed.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> Optional[pulumi.Input['MysqlDbSystemBackupPolicyArgs']]:
        """
        (Updatable) Backup policy as optionally used for DB System Creation.
        """
        return pulumi.get(self, "backup_policy")

    @backup_policy.setter
    def backup_policy(self, value: Optional[pulumi.Input['MysqlDbSystemBackupPolicyArgs']]):
        pulumi.set(self, "backup_policy", value)

    @property
    @pulumi.getter
    def channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelArgs']]]]:
        """
        A list with a summary of all the Channels attached to the DB System.
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemChannelArgs']]]]):
        pulumi.set(self, "channels", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the Configuration to be used for this DB System.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_id", value)

    @property
    @pulumi.getter(name="crashRecovery")
    def crash_recovery(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        """
        return pulumi.get(self, "crash_recovery")

    @crash_recovery.setter
    def crash_recovery(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crash_recovery", value)

    @property
    @pulumi.getter(name="currentPlacements")
    def current_placements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemCurrentPlacementArgs']]]]:
        """
        The availability domain and fault domain a DB System is placed in.
        """
        return pulumi.get(self, "current_placements")

    @current_placements.setter
    def current_placements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemCurrentPlacementArgs']]]]):
        pulumi.set(self, "current_placements", value)

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Initial size of the data volume in GBs that will be created and attached. Keep in mind that this only specifies the size of the database data volume, the log volume for the database will be scaled appropriately with its shape. It is required if you are creating a new database. It cannot be set if you are creating a database from a backup.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @data_storage_size_in_gb.setter
    def data_storage_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_storage_size_in_gb", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deletionPolicies")
    def deletion_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemDeletionPolicyArgs']]]]:
        """
        (Updatable) Policy for how the DB System and related resources should be handled at the time of its deletion.
        """
        return pulumi.get(self, "deletion_policies")

    @deletion_policies.setter
    def deletion_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemDeletionPolicyArgs']]]]):
        pulumi.set(self, "deletion_policies", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User-provided data about the DB System.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The user-friendly name for the DB System. It does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemEndpointArgs']]]]:
        """
        The network endpoints available for this DB System.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the fault domain in which the DB System is placed.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="heatWaveClusters")
    def heat_wave_clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemHeatWaveClusterArgs']]]]:
        """
        A summary of a HeatWave cluster.
        """
        return pulumi.get(self, "heat_wave_clusters")

    @heat_wave_clusters.setter
    def heat_wave_clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemHeatWaveClusterArgs']]]]):
        pulumi.set(self, "heat_wave_clusters", value)

    @property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname for the primary endpoint of the DB System. Used for DNS.

        The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com").

        Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        """
        return pulumi.get(self, "hostname_label")

    @hostname_label.setter
    def hostname_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname_label", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address the DB System is configured to listen on. A private IP address of your choice to assign to the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="isHeatWaveClusterAttached")
    def is_heat_wave_cluster_attached(self) -> Optional[pulumi.Input[bool]]:
        """
        If the DB System has a HeatWave Cluster attached.
        """
        return pulumi.get(self, "is_heat_wave_cluster_attached")

    @is_heat_wave_cluster_attached.setter
    def is_heat_wave_cluster_attached(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_heat_wave_cluster_attached", value)

    @property
    @pulumi.getter(name="isHighlyAvailable")
    def is_highly_available(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Specifies if the DB System is highly available.

        When creating a DB System with High Availability, three instances are created and placed according to your region- and subnet-type. The secondaries are placed automatically in the other two availability or fault domains.  You can choose the preferred location of your primary instance, only.
        """
        return pulumi.get(self, "is_highly_available")

    @is_highly_available.setter
    def is_highly_available(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_highly_available", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def maintenance(self) -> Optional[pulumi.Input['MysqlDbSystemMaintenanceArgs']]:
        """
        (Updatable) The Maintenance Policy for the DB System or Read Replica that this model is included in. `maintenance` and `backup_policy` cannot be updated in the same request.
        """
        return pulumi.get(self, "maintenance")

    @maintenance.setter
    def maintenance(self, value: Optional[pulumi.Input['MysqlDbSystemMaintenanceArgs']]):
        pulumi.set(self, "maintenance", value)

    @property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> Optional[pulumi.Input[str]]:
        """
        The specific MySQL version identifier.
        """
        return pulumi.get(self, "mysql_version")

    @mysql_version.setter
    def mysql_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mysql_version", value)

    @property
    @pulumi.getter(name="pointInTimeRecoveryDetails")
    def point_in_time_recovery_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemPointInTimeRecoveryDetailArgs']]]]:
        """
        Point-in-time Recovery details like earliest and latest recovery time point for the DB System.
        """
        return pulumi.get(self, "point_in_time_recovery_details")

    @point_in_time_recovery_details.setter
    def point_in_time_recovery_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDbSystemPointInTimeRecoveryDetailArgs']]]]):
        pulumi.set(self, "point_in_time_recovery_details", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port for primary endpoint of the DB System to listen on.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portX")
    def port_x(self) -> Optional[pulumi.Input[int]]:
        """
        The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @port_x.setter
    def port_x(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_x", value)

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the shape. The shape determines the resources allocated
        * CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape_name", value)

    @property
    @pulumi.getter(name="shutdownType")
    def shutdown_type(self) -> Optional[pulumi.Input[str]]:
        """
        It is applicable only for stopping a DB System. Could be set to `FAST`, `SLOW` or `IMMEDIATE`. Default value is `FAST`.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "shutdown_type")

    @shutdown_type.setter
    def shutdown_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shutdown_type", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['MysqlDbSystemSourceArgs']]:
        """
        Parameters detailing how to provision the initial data of the system.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['MysqlDbSystemSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the subnet the DB System is associated with.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the DB System was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the DB System was last updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class MysqlDbSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 backup_policy: Optional[pulumi.Input[pulumi.InputType['MysqlDbSystemBackupPolicyArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 crash_recovery: Optional[pulumi.Input[str]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deletion_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlDbSystemDeletionPolicyArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hostname_label: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 is_highly_available: Optional[pulumi.Input[bool]] = None,
                 maintenance: Optional[pulumi.Input[pulumi.InputType['MysqlDbSystemMaintenanceArgs']]] = None,
                 mysql_version: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_x: Optional[pulumi.Input[int]] = None,
                 shape_name: Optional[pulumi.Input[str]] = None,
                 shutdown_type: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[pulumi.InputType['MysqlDbSystemSourceArgs']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Mysql Db System resource in Oracle Cloud Infrastructure MySQL Database service.

        Creates and launches a DB System.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_mysql_db_system = oci.mysql.MysqlDbSystem("testMysqlDbSystem",
            availability_domain=var["mysql_db_system_availability_domain"],
            compartment_id=var["compartment_id"],
            shape_name=var["mysql_shape_name"],
            subnet_id=oci_core_subnet["test_subnet"]["id"],
            admin_password=var["mysql_db_system_admin_password"],
            admin_username=var["mysql_db_system_admin_username"],
            backup_policy=oci.mysql.MysqlDbSystemBackupPolicyArgs(
                defined_tags={
                    "foo-namespace.bar-key": "value",
                },
                freeform_tags={
                    "bar-key": "value",
                },
                is_enabled=var["mysql_db_system_backup_policy_is_enabled"],
                pitr_policy=oci.mysql.MysqlDbSystemBackupPolicyPitrPolicyArgs(
                    is_enabled=var["mysql_db_system_backup_policy_pitr_policy_is_enabled"],
                ),
                retention_in_days=var["mysql_db_system_backup_policy_retention_in_days"],
                window_start_time=var["mysql_db_system_backup_policy_window_start_time"],
            ),
            configuration_id=oci_audit_configuration["test_configuration"]["id"],
            crash_recovery=var["mysql_db_system_crash_recovery"],
            data_storage_size_in_gb=var["mysql_db_system_data_storage_size_in_gb"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            deletion_policies=[oci.mysql.MysqlDbSystemDeletionPolicyArgs(
                automatic_backup_retention=var["mysql_db_system_deletion_policy_automatic_backup_retention"],
                final_backup=var["mysql_db_system_deletion_policy_final_backup"],
                is_delete_protected=var["mysql_db_system_deletion_policy_is_delete_protected"],
            )],
            description=var["mysql_db_system_description"],
            display_name=var["mysql_db_system_display_name"],
            fault_domain=var["mysql_db_system_fault_domain"],
            freeform_tags={
                "bar-key": "value",
            },
            hostname_label=var["mysql_db_system_hostname_label"],
            ip_address=var["mysql_db_system_ip_address"],
            is_highly_available=var["mysql_db_system_is_highly_available"],
            maintenance=oci.mysql.MysqlDbSystemMaintenanceArgs(
                window_start_time=var["mysql_db_system_maintenance_window_start_time"],
            ),
            port=var["mysql_db_system_port"],
            port_x=var["mysql_db_system_port_x"],
            source=oci.mysql.MysqlDbSystemSourceArgs(
                source_type=var["mysql_db_system_source_source_type"],
                backup_id=oci_mysql_mysql_backup["test_backup"]["id"],
            ))
        ```

        ## Import

        MysqlDbSystems can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Mysql/mysqlDbSystem:MysqlDbSystem test_mysql_db_system "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_password: The password for the administrative user. The password must be between 8 and 32 characters long, and must contain at least 1 numeric character, 1 lowercase character, 1 uppercase character, and 1 special (nonalphanumeric) character.
        :param pulumi.Input[str] admin_username: The username for the administrative user.
        :param pulumi.Input[str] availability_domain: The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
               
               In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.
               
               For a standalone DB System, this defines the availability domain in which the DB System is placed.
        :param pulumi.Input[pulumi.InputType['MysqlDbSystemBackupPolicyArgs']] backup_policy: (Updatable) Backup policy as optionally used for DB System Creation.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[str] configuration_id: (Updatable) The OCID of the Configuration to be used for this DB System.
        :param pulumi.Input[str] crash_recovery: (Updatable) Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        :param pulumi.Input[int] data_storage_size_in_gb: (Updatable) Initial size of the data volume in GBs that will be created and attached. Keep in mind that this only specifies the size of the database data volume, the log volume for the database will be scaled appropriately with its shape. It is required if you are creating a new database. It cannot be set if you are creating a database from a backup.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlDbSystemDeletionPolicyArgs']]]] deletion_policies: (Updatable) Policy for how the DB System and related resources should be handled at the time of its deletion.
        :param pulumi.Input[str] description: (Updatable) User-provided data about the DB System.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the DB System. It does not have to be unique.
        :param pulumi.Input[str] fault_domain: The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
               
               In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.
               
               For a standalone DB System, this defines the fault domain in which the DB System is placed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] hostname_label: The hostname for the primary endpoint of the DB System. Used for DNS.
               
               The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com").
               
               Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        :param pulumi.Input[str] ip_address: The IP address the DB System is configured to listen on. A private IP address of your choice to assign to the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        :param pulumi.Input[bool] is_highly_available: (Updatable) Specifies if the DB System is highly available.
               
               When creating a DB System with High Availability, three instances are created and placed according to your region- and subnet-type. The secondaries are placed automatically in the other two availability or fault domains.  You can choose the preferred location of your primary instance, only.
        :param pulumi.Input[pulumi.InputType['MysqlDbSystemMaintenanceArgs']] maintenance: (Updatable) The Maintenance Policy for the DB System or Read Replica that this model is included in. `maintenance` and `backup_policy` cannot be updated in the same request.
        :param pulumi.Input[str] mysql_version: The specific MySQL version identifier.
        :param pulumi.Input[int] port: The port for primary endpoint of the DB System to listen on.
        :param pulumi.Input[int] port_x: The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        :param pulumi.Input[str] shape_name: (Updatable) The name of the shape. The shape determines the resources allocated
               * CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        :param pulumi.Input[str] shutdown_type: It is applicable only for stopping a DB System. Could be set to `FAST`, `SLOW` or `IMMEDIATE`. Default value is `FAST`.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[pulumi.InputType['MysqlDbSystemSourceArgs']] source: Parameters detailing how to provision the initial data of the system.
        :param pulumi.Input[str] state: (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        :param pulumi.Input[str] subnet_id: The OCID of the subnet the DB System is associated with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MysqlDbSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Mysql Db System resource in Oracle Cloud Infrastructure MySQL Database service.

        Creates and launches a DB System.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_mysql_db_system = oci.mysql.MysqlDbSystem("testMysqlDbSystem",
            availability_domain=var["mysql_db_system_availability_domain"],
            compartment_id=var["compartment_id"],
            shape_name=var["mysql_shape_name"],
            subnet_id=oci_core_subnet["test_subnet"]["id"],
            admin_password=var["mysql_db_system_admin_password"],
            admin_username=var["mysql_db_system_admin_username"],
            backup_policy=oci.mysql.MysqlDbSystemBackupPolicyArgs(
                defined_tags={
                    "foo-namespace.bar-key": "value",
                },
                freeform_tags={
                    "bar-key": "value",
                },
                is_enabled=var["mysql_db_system_backup_policy_is_enabled"],
                pitr_policy=oci.mysql.MysqlDbSystemBackupPolicyPitrPolicyArgs(
                    is_enabled=var["mysql_db_system_backup_policy_pitr_policy_is_enabled"],
                ),
                retention_in_days=var["mysql_db_system_backup_policy_retention_in_days"],
                window_start_time=var["mysql_db_system_backup_policy_window_start_time"],
            ),
            configuration_id=oci_audit_configuration["test_configuration"]["id"],
            crash_recovery=var["mysql_db_system_crash_recovery"],
            data_storage_size_in_gb=var["mysql_db_system_data_storage_size_in_gb"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            deletion_policies=[oci.mysql.MysqlDbSystemDeletionPolicyArgs(
                automatic_backup_retention=var["mysql_db_system_deletion_policy_automatic_backup_retention"],
                final_backup=var["mysql_db_system_deletion_policy_final_backup"],
                is_delete_protected=var["mysql_db_system_deletion_policy_is_delete_protected"],
            )],
            description=var["mysql_db_system_description"],
            display_name=var["mysql_db_system_display_name"],
            fault_domain=var["mysql_db_system_fault_domain"],
            freeform_tags={
                "bar-key": "value",
            },
            hostname_label=var["mysql_db_system_hostname_label"],
            ip_address=var["mysql_db_system_ip_address"],
            is_highly_available=var["mysql_db_system_is_highly_available"],
            maintenance=oci.mysql.MysqlDbSystemMaintenanceArgs(
                window_start_time=var["mysql_db_system_maintenance_window_start_time"],
            ),
            port=var["mysql_db_system_port"],
            port_x=var["mysql_db_system_port_x"],
            source=oci.mysql.MysqlDbSystemSourceArgs(
                source_type=var["mysql_db_system_source_source_type"],
                backup_id=oci_mysql_mysql_backup["test_backup"]["id"],
            ))
        ```

        ## Import

        MysqlDbSystems can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Mysql/mysqlDbSystem:MysqlDbSystem test_mysql_db_system "id"
        ```

        :param str resource_name: The name of the resource.
        :param MysqlDbSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MysqlDbSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 backup_policy: Optional[pulumi.Input[pulumi.InputType['MysqlDbSystemBackupPolicyArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 crash_recovery: Optional[pulumi.Input[str]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deletion_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlDbSystemDeletionPolicyArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hostname_label: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 is_highly_available: Optional[pulumi.Input[bool]] = None,
                 maintenance: Optional[pulumi.Input[pulumi.InputType['MysqlDbSystemMaintenanceArgs']]] = None,
                 mysql_version: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_x: Optional[pulumi.Input[int]] = None,
                 shape_name: Optional[pulumi.Input[str]] = None,
                 shutdown_type: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[pulumi.InputType['MysqlDbSystemSourceArgs']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MysqlDbSystemArgs.__new__(MysqlDbSystemArgs)

            __props__.__dict__["admin_password"] = None if admin_password is None else pulumi.Output.secret(admin_password)
            __props__.__dict__["admin_username"] = admin_username
            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            __props__.__dict__["backup_policy"] = backup_policy
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["configuration_id"] = configuration_id
            __props__.__dict__["crash_recovery"] = crash_recovery
            __props__.__dict__["data_storage_size_in_gb"] = data_storage_size_in_gb
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["deletion_policies"] = deletion_policies
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["fault_domain"] = fault_domain
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["hostname_label"] = hostname_label
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["is_highly_available"] = is_highly_available
            __props__.__dict__["maintenance"] = maintenance
            __props__.__dict__["mysql_version"] = mysql_version
            __props__.__dict__["port"] = port
            __props__.__dict__["port_x"] = port_x
            if shape_name is None and not opts.urn:
                raise TypeError("Missing required property 'shape_name'")
            __props__.__dict__["shape_name"] = shape_name
            __props__.__dict__["shutdown_type"] = shutdown_type
            __props__.__dict__["source"] = source
            __props__.__dict__["state"] = state
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["channels"] = None
            __props__.__dict__["current_placements"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["heat_wave_clusters"] = None
            __props__.__dict__["is_heat_wave_cluster_attached"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["point_in_time_recovery_details"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["adminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MysqlDbSystem, __self__).__init__(
            'oci:Mysql/mysqlDbSystem:MysqlDbSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_password: Optional[pulumi.Input[str]] = None,
            admin_username: Optional[pulumi.Input[str]] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            backup_policy: Optional[pulumi.Input[pulumi.InputType['MysqlDbSystemBackupPolicyArgs']]] = None,
            channels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlDbSystemChannelArgs']]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            configuration_id: Optional[pulumi.Input[str]] = None,
            crash_recovery: Optional[pulumi.Input[str]] = None,
            current_placements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlDbSystemCurrentPlacementArgs']]]]] = None,
            data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            deletion_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlDbSystemDeletionPolicyArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlDbSystemEndpointArgs']]]]] = None,
            fault_domain: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            heat_wave_clusters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlDbSystemHeatWaveClusterArgs']]]]] = None,
            hostname_label: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            is_heat_wave_cluster_attached: Optional[pulumi.Input[bool]] = None,
            is_highly_available: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            maintenance: Optional[pulumi.Input[pulumi.InputType['MysqlDbSystemMaintenanceArgs']]] = None,
            mysql_version: Optional[pulumi.Input[str]] = None,
            point_in_time_recovery_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlDbSystemPointInTimeRecoveryDetailArgs']]]]] = None,
            port: Optional[pulumi.Input[int]] = None,
            port_x: Optional[pulumi.Input[int]] = None,
            shape_name: Optional[pulumi.Input[str]] = None,
            shutdown_type: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[pulumi.InputType['MysqlDbSystemSourceArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'MysqlDbSystem':
        """
        Get an existing MysqlDbSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_password: The password for the administrative user. The password must be between 8 and 32 characters long, and must contain at least 1 numeric character, 1 lowercase character, 1 uppercase character, and 1 special (nonalphanumeric) character.
        :param pulumi.Input[str] admin_username: The username for the administrative user.
        :param pulumi.Input[str] availability_domain: The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
               
               In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.
               
               For a standalone DB System, this defines the availability domain in which the DB System is placed.
        :param pulumi.Input[pulumi.InputType['MysqlDbSystemBackupPolicyArgs']] backup_policy: (Updatable) Backup policy as optionally used for DB System Creation.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlDbSystemChannelArgs']]]] channels: A list with a summary of all the Channels attached to the DB System.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[str] configuration_id: (Updatable) The OCID of the Configuration to be used for this DB System.
        :param pulumi.Input[str] crash_recovery: (Updatable) Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlDbSystemCurrentPlacementArgs']]]] current_placements: The availability domain and fault domain a DB System is placed in.
        :param pulumi.Input[int] data_storage_size_in_gb: (Updatable) Initial size of the data volume in GBs that will be created and attached. Keep in mind that this only specifies the size of the database data volume, the log volume for the database will be scaled appropriately with its shape. It is required if you are creating a new database. It cannot be set if you are creating a database from a backup.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlDbSystemDeletionPolicyArgs']]]] deletion_policies: (Updatable) Policy for how the DB System and related resources should be handled at the time of its deletion.
        :param pulumi.Input[str] description: (Updatable) User-provided data about the DB System.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the DB System. It does not have to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlDbSystemEndpointArgs']]]] endpoints: The network endpoints available for this DB System.
        :param pulumi.Input[str] fault_domain: The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
               
               In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.
               
               For a standalone DB System, this defines the fault domain in which the DB System is placed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlDbSystemHeatWaveClusterArgs']]]] heat_wave_clusters: A summary of a HeatWave cluster.
        :param pulumi.Input[str] hostname_label: The hostname for the primary endpoint of the DB System. Used for DNS.
               
               The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com").
               
               Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        :param pulumi.Input[str] ip_address: The IP address the DB System is configured to listen on. A private IP address of your choice to assign to the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        :param pulumi.Input[bool] is_heat_wave_cluster_attached: If the DB System has a HeatWave Cluster attached.
        :param pulumi.Input[bool] is_highly_available: (Updatable) Specifies if the DB System is highly available.
               
               When creating a DB System with High Availability, three instances are created and placed according to your region- and subnet-type. The secondaries are placed automatically in the other two availability or fault domains.  You can choose the preferred location of your primary instance, only.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycleState.
        :param pulumi.Input[pulumi.InputType['MysqlDbSystemMaintenanceArgs']] maintenance: (Updatable) The Maintenance Policy for the DB System or Read Replica that this model is included in. `maintenance` and `backup_policy` cannot be updated in the same request.
        :param pulumi.Input[str] mysql_version: The specific MySQL version identifier.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlDbSystemPointInTimeRecoveryDetailArgs']]]] point_in_time_recovery_details: Point-in-time Recovery details like earliest and latest recovery time point for the DB System.
        :param pulumi.Input[int] port: The port for primary endpoint of the DB System to listen on.
        :param pulumi.Input[int] port_x: The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        :param pulumi.Input[str] shape_name: (Updatable) The name of the shape. The shape determines the resources allocated
               * CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        :param pulumi.Input[str] shutdown_type: It is applicable only for stopping a DB System. Could be set to `FAST`, `SLOW` or `IMMEDIATE`. Default value is `FAST`.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[pulumi.InputType['MysqlDbSystemSourceArgs']] source: Parameters detailing how to provision the initial data of the system.
        :param pulumi.Input[str] state: (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        :param pulumi.Input[str] subnet_id: The OCID of the subnet the DB System is associated with.
        :param pulumi.Input[str] time_created: The date and time the DB System was created.
        :param pulumi.Input[str] time_updated: The time the DB System was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MysqlDbSystemState.__new__(_MysqlDbSystemState)

        __props__.__dict__["admin_password"] = admin_password
        __props__.__dict__["admin_username"] = admin_username
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["backup_policy"] = backup_policy
        __props__.__dict__["channels"] = channels
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["configuration_id"] = configuration_id
        __props__.__dict__["crash_recovery"] = crash_recovery
        __props__.__dict__["current_placements"] = current_placements
        __props__.__dict__["data_storage_size_in_gb"] = data_storage_size_in_gb
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["deletion_policies"] = deletion_policies
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["fault_domain"] = fault_domain
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["heat_wave_clusters"] = heat_wave_clusters
        __props__.__dict__["hostname_label"] = hostname_label
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["is_heat_wave_cluster_attached"] = is_heat_wave_cluster_attached
        __props__.__dict__["is_highly_available"] = is_highly_available
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["maintenance"] = maintenance
        __props__.__dict__["mysql_version"] = mysql_version
        __props__.__dict__["point_in_time_recovery_details"] = point_in_time_recovery_details
        __props__.__dict__["port"] = port
        __props__.__dict__["port_x"] = port_x
        __props__.__dict__["shape_name"] = shape_name
        __props__.__dict__["shutdown_type"] = shutdown_type
        __props__.__dict__["source"] = source
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return MysqlDbSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Output[str]:
        """
        The password for the administrative user. The password must be between 8 and 32 characters long, and must contain at least 1 numeric character, 1 lowercase character, 1 uppercase character, and 1 special (nonalphanumeric) character.
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Output[str]:
        """
        The username for the administrative user.
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the availability domain in which the DB System is placed.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> pulumi.Output['outputs.MysqlDbSystemBackupPolicy']:
        """
        (Updatable) Backup policy as optionally used for DB System Creation.
        """
        return pulumi.get(self, "backup_policy")

    @property
    @pulumi.getter
    def channels(self) -> pulumi.Output[Sequence['outputs.MysqlDbSystemChannel']]:
        """
        A list with a summary of all the Channels attached to the DB System.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the Configuration to be used for this DB System.
        """
        return pulumi.get(self, "configuration_id")

    @property
    @pulumi.getter(name="crashRecovery")
    def crash_recovery(self) -> pulumi.Output[str]:
        """
        (Updatable) Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        """
        return pulumi.get(self, "crash_recovery")

    @property
    @pulumi.getter(name="currentPlacements")
    def current_placements(self) -> pulumi.Output[Sequence['outputs.MysqlDbSystemCurrentPlacement']]:
        """
        The availability domain and fault domain a DB System is placed in.
        """
        return pulumi.get(self, "current_placements")

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> pulumi.Output[int]:
        """
        (Updatable) Initial size of the data volume in GBs that will be created and attached. Keep in mind that this only specifies the size of the database data volume, the log volume for the database will be scaled appropriately with its shape. It is required if you are creating a new database. It cannot be set if you are creating a database from a backup.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deletionPolicies")
    def deletion_policies(self) -> pulumi.Output[Sequence['outputs.MysqlDbSystemDeletionPolicy']]:
        """
        (Updatable) Policy for how the DB System and related resources should be handled at the time of its deletion.
        """
        return pulumi.get(self, "deletion_policies")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) User-provided data about the DB System.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The user-friendly name for the DB System. It does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.MysqlDbSystemEndpoint']]:
        """
        The network endpoints available for this DB System.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> pulumi.Output[str]:
        """
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains and the MySQL instance in that domain is promoted to the primary instance. This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the fault domain in which the DB System is placed.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="heatWaveClusters")
    def heat_wave_clusters(self) -> pulumi.Output[Sequence['outputs.MysqlDbSystemHeatWaveCluster']]:
        """
        A summary of a HeatWave cluster.
        """
        return pulumi.get(self, "heat_wave_clusters")

    @property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> pulumi.Output[str]:
        """
        The hostname for the primary endpoint of the DB System. Used for DNS.

        The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com").

        Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        """
        return pulumi.get(self, "hostname_label")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The IP address the DB System is configured to listen on. A private IP address of your choice to assign to the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet. This should be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="isHeatWaveClusterAttached")
    def is_heat_wave_cluster_attached(self) -> pulumi.Output[bool]:
        """
        If the DB System has a HeatWave Cluster attached.
        """
        return pulumi.get(self, "is_heat_wave_cluster_attached")

    @property
    @pulumi.getter(name="isHighlyAvailable")
    def is_highly_available(self) -> pulumi.Output[bool]:
        """
        (Updatable) Specifies if the DB System is highly available.

        When creating a DB System with High Availability, three instances are created and placed according to your region- and subnet-type. The secondaries are placed automatically in the other two availability or fault domains.  You can choose the preferred location of your primary instance, only.
        """
        return pulumi.get(self, "is_highly_available")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def maintenance(self) -> pulumi.Output['outputs.MysqlDbSystemMaintenance']:
        """
        (Updatable) The Maintenance Policy for the DB System or Read Replica that this model is included in. `maintenance` and `backup_policy` cannot be updated in the same request.
        """
        return pulumi.get(self, "maintenance")

    @property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> pulumi.Output[str]:
        """
        The specific MySQL version identifier.
        """
        return pulumi.get(self, "mysql_version")

    @property
    @pulumi.getter(name="pointInTimeRecoveryDetails")
    def point_in_time_recovery_details(self) -> pulumi.Output[Sequence['outputs.MysqlDbSystemPointInTimeRecoveryDetail']]:
        """
        Point-in-time Recovery details like earliest and latest recovery time point for the DB System.
        """
        return pulumi.get(self, "point_in_time_recovery_details")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The port for primary endpoint of the DB System to listen on.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portX")
    def port_x(self) -> pulumi.Output[int]:
        """
        The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The name of the shape. The shape determines the resources allocated
        * CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20190415/ShapeSummary/ListShapes) operation.
        """
        return pulumi.get(self, "shape_name")

    @property
    @pulumi.getter(name="shutdownType")
    def shutdown_type(self) -> pulumi.Output[Optional[str]]:
        """
        It is applicable only for stopping a DB System. Could be set to `FAST`, `SLOW` or `IMMEDIATE`. Default value is `FAST`.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "shutdown_type")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.MysqlDbSystemSource']:
        """
        Parameters detailing how to provision the initial data of the system.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        (Updatable) The target state for the DB System. Could be set to `ACTIVE` or `INACTIVE`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The OCID of the subnet the DB System is associated with.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the DB System was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the DB System was last updated.
        """
        return pulumi.get(self, "time_updated")

