# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'NetworkFirewallPolicyApplicationList',
    'NetworkFirewallPolicyApplicationListApplicationValue',
    'NetworkFirewallPolicyDecryptionProfile',
    'NetworkFirewallPolicyDecryptionRule',
    'NetworkFirewallPolicyDecryptionRuleCondition',
    'NetworkFirewallPolicyIpAddressList',
    'NetworkFirewallPolicyMappedSecret',
    'NetworkFirewallPolicySecurityRule',
    'NetworkFirewallPolicySecurityRuleCondition',
    'NetworkFirewallPolicyUrlList',
    'NetworkFirewallPolicyUrlListUrlListValue',
    'GetNetworkFirewallPoliciesFilterResult',
    'GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionResult',
    'GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemResult',
    'GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemApplicationListResult',
    'GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemApplicationListApplicationValueResult',
    'GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemDecryptionProfileResult',
    'GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemDecryptionRuleResult',
    'GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemDecryptionRuleConditionResult',
    'GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemIpAddressListResult',
    'GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemMappedSecretResult',
    'GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemSecurityRuleResult',
    'GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemSecurityRuleConditionResult',
    'GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemUrlListResult',
    'GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemUrlListUrlListValueResult',
    'GetNetworkFirewallPolicyApplicationListResult',
    'GetNetworkFirewallPolicyApplicationListApplicationValueResult',
    'GetNetworkFirewallPolicyDecryptionProfileResult',
    'GetNetworkFirewallPolicyDecryptionRuleResult',
    'GetNetworkFirewallPolicyDecryptionRuleConditionResult',
    'GetNetworkFirewallPolicyIpAddressListResult',
    'GetNetworkFirewallPolicyMappedSecretResult',
    'GetNetworkFirewallPolicySecurityRuleResult',
    'GetNetworkFirewallPolicySecurityRuleConditionResult',
    'GetNetworkFirewallPolicyUrlListResult',
    'GetNetworkFirewallPolicyUrlListUrlListValueResult',
    'GetNetworkFirewallsFilterResult',
    'GetNetworkFirewallsNetworkFirewallCollectionResult',
    'GetNetworkFirewallsNetworkFirewallCollectionItemResult',
]

@pulumi.output_type
class NetworkFirewallPolicyApplicationList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationListName":
            suggest = "application_list_name"
        elif key == "applicationValues":
            suggest = "application_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFirewallPolicyApplicationList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFirewallPolicyApplicationList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFirewallPolicyApplicationList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_list_name: str,
                 application_values: Optional[Sequence['outputs.NetworkFirewallPolicyApplicationListApplicationValue']] = None):
        """
        :param str application_list_name: (Updatable) The key is the identifier by which the application list is referenced.
        :param Sequence['NetworkFirewallPolicyApplicationListApplicationValueArgs'] application_values: (Updatable) Details about the application
        """
        pulumi.set(__self__, "application_list_name", application_list_name)
        if application_values is not None:
            pulumi.set(__self__, "application_values", application_values)

    @property
    @pulumi.getter(name="applicationListName")
    def application_list_name(self) -> str:
        """
        (Updatable) The key is the identifier by which the application list is referenced.
        """
        return pulumi.get(self, "application_list_name")

    @property
    @pulumi.getter(name="applicationValues")
    def application_values(self) -> Optional[Sequence['outputs.NetworkFirewallPolicyApplicationListApplicationValue']]:
        """
        (Updatable) Details about the application
        """
        return pulumi.get(self, "application_values")


@pulumi.output_type
class NetworkFirewallPolicyApplicationListApplicationValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "icmpCode":
            suggest = "icmp_code"
        elif key == "icmpType":
            suggest = "icmp_type"
        elif key == "maximumPort":
            suggest = "maximum_port"
        elif key == "minimumPort":
            suggest = "minimum_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFirewallPolicyApplicationListApplicationValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFirewallPolicyApplicationListApplicationValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFirewallPolicyApplicationListApplicationValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 icmp_code: Optional[int] = None,
                 icmp_type: Optional[int] = None,
                 maximum_port: Optional[int] = None,
                 minimum_port: Optional[int] = None):
        """
        :param str type: (Updatable) Type of the url lists based on the policy
        :param int icmp_code: (Updatable) Used when you select ICMP. 0-Net unreachable, 1-Host unreachable, 2-Protocol unreachable, 3-Port unreachable
        :param int icmp_type: (Updatable)  Used when you select ICMP. 0-Echo reply, 3-Destination unreachable, 5-Redirect, 8-Echo
        :param int maximum_port: (Updatable) Used when you select TCP or UDP. Enter a port number.
        :param int minimum_port: (Updatable) Used when you select TCP or UDP. Enter a port number.
        """
        pulumi.set(__self__, "type", type)
        if icmp_code is not None:
            pulumi.set(__self__, "icmp_code", icmp_code)
        if icmp_type is not None:
            pulumi.set(__self__, "icmp_type", icmp_type)
        if maximum_port is not None:
            pulumi.set(__self__, "maximum_port", maximum_port)
        if minimum_port is not None:
            pulumi.set(__self__, "minimum_port", minimum_port)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (Updatable) Type of the url lists based on the policy
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> Optional[int]:
        """
        (Updatable) Used when you select ICMP. 0-Net unreachable, 1-Host unreachable, 2-Protocol unreachable, 3-Port unreachable
        """
        return pulumi.get(self, "icmp_code")

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> Optional[int]:
        """
        (Updatable)  Used when you select ICMP. 0-Echo reply, 3-Destination unreachable, 5-Redirect, 8-Echo
        """
        return pulumi.get(self, "icmp_type")

    @property
    @pulumi.getter(name="maximumPort")
    def maximum_port(self) -> Optional[int]:
        """
        (Updatable) Used when you select TCP or UDP. Enter a port number.
        """
        return pulumi.get(self, "maximum_port")

    @property
    @pulumi.getter(name="minimumPort")
    def minimum_port(self) -> Optional[int]:
        """
        (Updatable) Used when you select TCP or UDP. Enter a port number.
        """
        return pulumi.get(self, "minimum_port")


@pulumi.output_type
class NetworkFirewallPolicyDecryptionProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "areCertificateExtensionsRestricted":
            suggest = "are_certificate_extensions_restricted"
        elif key == "isAutoIncludeAltName":
            suggest = "is_auto_include_alt_name"
        elif key == "isExpiredCertificateBlocked":
            suggest = "is_expired_certificate_blocked"
        elif key == "isOutOfCapacityBlocked":
            suggest = "is_out_of_capacity_blocked"
        elif key == "isRevocationStatusTimeoutBlocked":
            suggest = "is_revocation_status_timeout_blocked"
        elif key == "isUnknownRevocationStatusBlocked":
            suggest = "is_unknown_revocation_status_blocked"
        elif key == "isUnsupportedCipherBlocked":
            suggest = "is_unsupported_cipher_blocked"
        elif key == "isUnsupportedVersionBlocked":
            suggest = "is_unsupported_version_blocked"
        elif key == "isUntrustedIssuerBlocked":
            suggest = "is_untrusted_issuer_blocked"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFirewallPolicyDecryptionProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFirewallPolicyDecryptionProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFirewallPolicyDecryptionProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 type: str,
                 are_certificate_extensions_restricted: Optional[bool] = None,
                 is_auto_include_alt_name: Optional[bool] = None,
                 is_expired_certificate_blocked: Optional[bool] = None,
                 is_out_of_capacity_blocked: Optional[bool] = None,
                 is_revocation_status_timeout_blocked: Optional[bool] = None,
                 is_unknown_revocation_status_blocked: Optional[bool] = None,
                 is_unsupported_cipher_blocked: Optional[bool] = None,
                 is_unsupported_version_blocked: Optional[bool] = None,
                 is_untrusted_issuer_blocked: Optional[bool] = None):
        """
        :param str key: Source of the secrets, where the secrets are stored.
        :param str type: (Updatable) Type of the url lists based on the policy
        :param bool are_certificate_extensions_restricted: (Updatable) Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.
        :param bool is_auto_include_alt_name: (Updatable) Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.
        :param bool is_expired_certificate_blocked: (Updatable) Whether to block sessions if server's certificate is expired.
        :param bool is_out_of_capacity_blocked: (Updatable) Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.
        :param bool is_revocation_status_timeout_blocked: (Updatable) Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).
        :param bool is_unknown_revocation_status_blocked: (Updatable) Whether to block sessions if the revocation status check for server's certificate results in "unknown".
        :param bool is_unsupported_cipher_blocked: (Updatable) Whether to block sessions if SSL cipher suite is not supported.
        :param bool is_unsupported_version_blocked: (Updatable) Whether to block sessions if SSL version is not supported.
        :param bool is_untrusted_issuer_blocked: (Updatable) Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        if are_certificate_extensions_restricted is not None:
            pulumi.set(__self__, "are_certificate_extensions_restricted", are_certificate_extensions_restricted)
        if is_auto_include_alt_name is not None:
            pulumi.set(__self__, "is_auto_include_alt_name", is_auto_include_alt_name)
        if is_expired_certificate_blocked is not None:
            pulumi.set(__self__, "is_expired_certificate_blocked", is_expired_certificate_blocked)
        if is_out_of_capacity_blocked is not None:
            pulumi.set(__self__, "is_out_of_capacity_blocked", is_out_of_capacity_blocked)
        if is_revocation_status_timeout_blocked is not None:
            pulumi.set(__self__, "is_revocation_status_timeout_blocked", is_revocation_status_timeout_blocked)
        if is_unknown_revocation_status_blocked is not None:
            pulumi.set(__self__, "is_unknown_revocation_status_blocked", is_unknown_revocation_status_blocked)
        if is_unsupported_cipher_blocked is not None:
            pulumi.set(__self__, "is_unsupported_cipher_blocked", is_unsupported_cipher_blocked)
        if is_unsupported_version_blocked is not None:
            pulumi.set(__self__, "is_unsupported_version_blocked", is_unsupported_version_blocked)
        if is_untrusted_issuer_blocked is not None:
            pulumi.set(__self__, "is_untrusted_issuer_blocked", is_untrusted_issuer_blocked)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Source of the secrets, where the secrets are stored.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (Updatable) Type of the url lists based on the policy
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="areCertificateExtensionsRestricted")
    def are_certificate_extensions_restricted(self) -> Optional[bool]:
        """
        (Updatable) Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.
        """
        return pulumi.get(self, "are_certificate_extensions_restricted")

    @property
    @pulumi.getter(name="isAutoIncludeAltName")
    def is_auto_include_alt_name(self) -> Optional[bool]:
        """
        (Updatable) Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.
        """
        return pulumi.get(self, "is_auto_include_alt_name")

    @property
    @pulumi.getter(name="isExpiredCertificateBlocked")
    def is_expired_certificate_blocked(self) -> Optional[bool]:
        """
        (Updatable) Whether to block sessions if server's certificate is expired.
        """
        return pulumi.get(self, "is_expired_certificate_blocked")

    @property
    @pulumi.getter(name="isOutOfCapacityBlocked")
    def is_out_of_capacity_blocked(self) -> Optional[bool]:
        """
        (Updatable) Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.
        """
        return pulumi.get(self, "is_out_of_capacity_blocked")

    @property
    @pulumi.getter(name="isRevocationStatusTimeoutBlocked")
    def is_revocation_status_timeout_blocked(self) -> Optional[bool]:
        """
        (Updatable) Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).
        """
        return pulumi.get(self, "is_revocation_status_timeout_blocked")

    @property
    @pulumi.getter(name="isUnknownRevocationStatusBlocked")
    def is_unknown_revocation_status_blocked(self) -> Optional[bool]:
        """
        (Updatable) Whether to block sessions if the revocation status check for server's certificate results in "unknown".
        """
        return pulumi.get(self, "is_unknown_revocation_status_blocked")

    @property
    @pulumi.getter(name="isUnsupportedCipherBlocked")
    def is_unsupported_cipher_blocked(self) -> Optional[bool]:
        """
        (Updatable) Whether to block sessions if SSL cipher suite is not supported.
        """
        return pulumi.get(self, "is_unsupported_cipher_blocked")

    @property
    @pulumi.getter(name="isUnsupportedVersionBlocked")
    def is_unsupported_version_blocked(self) -> Optional[bool]:
        """
        (Updatable) Whether to block sessions if SSL version is not supported.
        """
        return pulumi.get(self, "is_unsupported_version_blocked")

    @property
    @pulumi.getter(name="isUntrustedIssuerBlocked")
    def is_untrusted_issuer_blocked(self) -> Optional[bool]:
        """
        (Updatable) Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).
        """
        return pulumi.get(self, "is_untrusted_issuer_blocked")


@pulumi.output_type
class NetworkFirewallPolicyDecryptionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "decryptionProfile":
            suggest = "decryption_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFirewallPolicyDecryptionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFirewallPolicyDecryptionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFirewallPolicyDecryptionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 condition: 'outputs.NetworkFirewallPolicyDecryptionRuleCondition',
                 name: str,
                 decryption_profile: Optional[str] = None,
                 secret: Optional[str] = None):
        """
        :param str action: (Updatable) Types of Action on the Traffic flow.
               * ALLOW - Allows the traffic.
               * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
               * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
               * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.
        :param 'NetworkFirewallPolicyDecryptionRuleConditionArgs' condition: (Updatable) Criteria to evaluate against network traffic. A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
        :param str name: (Updatable) Name for the Security rule, must be unique within the policy.
        :param str decryption_profile: (Updatable) The name of the decryption profile to use.
        :param str secret: (Updatable) The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "name", name)
        if decryption_profile is not None:
            pulumi.set(__self__, "decryption_profile", decryption_profile)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        (Updatable) Types of Action on the Traffic flow.
        * ALLOW - Allows the traffic.
        * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
        * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
        * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.NetworkFirewallPolicyDecryptionRuleCondition':
        """
        (Updatable) Criteria to evaluate against network traffic. A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Updatable) Name for the Security rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="decryptionProfile")
    def decryption_profile(self) -> Optional[str]:
        """
        (Updatable) The name of the decryption profile to use.
        """
        return pulumi.get(self, "decryption_profile")

    @property
    @pulumi.getter
    def secret(self) -> Optional[str]:
        """
        (Updatable) The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class NetworkFirewallPolicyDecryptionRuleCondition(dict):
    def __init__(__self__, *,
                 destinations: Optional[Sequence[str]] = None,
                 sources: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] destinations: (Updatable) An array of IP address list names to be evaluated against the traffic destination address.
        :param Sequence[str] sources: (Updatable) An array of IP address list names to be evaluated against the traffic source address.
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence[str]]:
        """
        (Updatable) An array of IP address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence[str]]:
        """
        (Updatable) An array of IP address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class NetworkFirewallPolicyIpAddressList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddressListName":
            suggest = "ip_address_list_name"
        elif key == "ipAddressListValues":
            suggest = "ip_address_list_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFirewallPolicyIpAddressList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFirewallPolicyIpAddressList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFirewallPolicyIpAddressList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address_list_name: str,
                 ip_address_list_values: Optional[Sequence[str]] = None):
        """
        :param str ip_address_list_name: (Updatable) The identifier by which the IP address list is referenced.
        :param Sequence[str] ip_address_list_values: (Updatable) List of IP address lists of the policy.
        """
        pulumi.set(__self__, "ip_address_list_name", ip_address_list_name)
        if ip_address_list_values is not None:
            pulumi.set(__self__, "ip_address_list_values", ip_address_list_values)

    @property
    @pulumi.getter(name="ipAddressListName")
    def ip_address_list_name(self) -> str:
        """
        (Updatable) The identifier by which the IP address list is referenced.
        """
        return pulumi.get(self, "ip_address_list_name")

    @property
    @pulumi.getter(name="ipAddressListValues")
    def ip_address_list_values(self) -> Optional[Sequence[str]]:
        """
        (Updatable) List of IP address lists of the policy.
        """
        return pulumi.get(self, "ip_address_list_values")


@pulumi.output_type
class NetworkFirewallPolicyMappedSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vaultSecretId":
            suggest = "vault_secret_id"
        elif key == "versionNumber":
            suggest = "version_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFirewallPolicyMappedSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFirewallPolicyMappedSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFirewallPolicyMappedSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 type: str,
                 vault_secret_id: Optional[str] = None,
                 version_number: Optional[int] = None):
        """
        :param str key: Source of the secrets, where the secrets are stored.
        :param str type: (Updatable) Type of the url lists based on the policy
        :param str vault_secret_id: (Updatable) OCID for the Vault Secret to be used.
        :param int version_number: (Updatable) Version number of the secret to be used.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        if vault_secret_id is not None:
            pulumi.set(__self__, "vault_secret_id", vault_secret_id)
        if version_number is not None:
            pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Source of the secrets, where the secrets are stored.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (Updatable) Type of the url lists based on the policy
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vaultSecretId")
    def vault_secret_id(self) -> Optional[str]:
        """
        (Updatable) OCID for the Vault Secret to be used.
        """
        return pulumi.get(self, "vault_secret_id")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> Optional[int]:
        """
        (Updatable) Version number of the secret to be used.
        """
        return pulumi.get(self, "version_number")


@pulumi.output_type
class NetworkFirewallPolicySecurityRule(dict):
    def __init__(__self__, *,
                 action: str,
                 condition: 'outputs.NetworkFirewallPolicySecurityRuleCondition',
                 name: str,
                 inspection: Optional[str] = None):
        """
        :param str action: (Updatable) Types of Action on the Traffic flow.
               * ALLOW - Allows the traffic.
               * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
               * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
               * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.
        :param 'NetworkFirewallPolicySecurityRuleConditionArgs' condition: (Updatable) Criteria to evaluate against network traffic. A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
        :param str name: (Updatable) Name for the Security rule, must be unique within the policy.
        :param str inspection: (Updatable) Type of inspection to affect the Traffic flow. This is only applicable if action is INSPECT.
               * INTRUSION_DETECTION - Intrusion Detection.
               * INTRUSION_PREVENTION - Intrusion Detection and Prevention. Traffic classified as potentially malicious will be rejected as described in `type`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "name", name)
        if inspection is not None:
            pulumi.set(__self__, "inspection", inspection)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        (Updatable) Types of Action on the Traffic flow.
        * ALLOW - Allows the traffic.
        * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
        * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
        * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.NetworkFirewallPolicySecurityRuleCondition':
        """
        (Updatable) Criteria to evaluate against network traffic. A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Updatable) Name for the Security rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def inspection(self) -> Optional[str]:
        """
        (Updatable) Type of inspection to affect the Traffic flow. This is only applicable if action is INSPECT.
        * INTRUSION_DETECTION - Intrusion Detection.
        * INTRUSION_PREVENTION - Intrusion Detection and Prevention. Traffic classified as potentially malicious will be rejected as described in `type`.
        """
        return pulumi.get(self, "inspection")


@pulumi.output_type
class NetworkFirewallPolicySecurityRuleCondition(dict):
    def __init__(__self__, *,
                 applications: Optional[Sequence[str]] = None,
                 destinations: Optional[Sequence[str]] = None,
                 sources: Optional[Sequence[str]] = None,
                 urls: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] applications: (Updatable) An array of application list names to be evaluated against the traffic protocol and protocol-specific parameters.
        :param Sequence[str] destinations: (Updatable) An array of IP address list names to be evaluated against the traffic destination address.
        :param Sequence[str] sources: (Updatable) An array of IP address list names to be evaluated against the traffic source address.
        :param Sequence[str] urls: (Updatable) An array of URL pattern list names to be evaluated against the HTTP(S) request target.
        """
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if urls is not None:
            pulumi.set(__self__, "urls", urls)

    @property
    @pulumi.getter
    def applications(self) -> Optional[Sequence[str]]:
        """
        (Updatable) An array of application list names to be evaluated against the traffic protocol and protocol-specific parameters.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence[str]]:
        """
        (Updatable) An array of IP address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence[str]]:
        """
        (Updatable) An array of IP address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def urls(self) -> Optional[Sequence[str]]:
        """
        (Updatable) An array of URL pattern list names to be evaluated against the HTTP(S) request target.
        """
        return pulumi.get(self, "urls")


@pulumi.output_type
class NetworkFirewallPolicyUrlList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "urlListName":
            suggest = "url_list_name"
        elif key == "urlListValues":
            suggest = "url_list_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkFirewallPolicyUrlList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkFirewallPolicyUrlList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkFirewallPolicyUrlList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url_list_name: str,
                 url_list_values: Optional[Sequence['outputs.NetworkFirewallPolicyUrlListUrlListValue']] = None):
        """
        :param str url_list_name: (Updatable) The identifier for the url list
        :param Sequence['NetworkFirewallPolicyUrlListUrlListValueArgs'] url_list_values: (Updatable) The list of Url Patterns.
        """
        pulumi.set(__self__, "url_list_name", url_list_name)
        if url_list_values is not None:
            pulumi.set(__self__, "url_list_values", url_list_values)

    @property
    @pulumi.getter(name="urlListName")
    def url_list_name(self) -> str:
        """
        (Updatable) The identifier for the url list
        """
        return pulumi.get(self, "url_list_name")

    @property
    @pulumi.getter(name="urlListValues")
    def url_list_values(self) -> Optional[Sequence['outputs.NetworkFirewallPolicyUrlListUrlListValue']]:
        """
        (Updatable) The list of Url Patterns.
        """
        return pulumi.get(self, "url_list_values")


@pulumi.output_type
class NetworkFirewallPolicyUrlListUrlListValue(dict):
    def __init__(__self__, *,
                 type: str,
                 pattern: Optional[str] = None):
        """
        :param str type: (Updatable) Type of the url lists based on the policy
        :param str pattern: (Updatable) URL lists to allow or deny traffic to a group of URLs. You can include a maximum of 25 URLs in each list.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "type", type)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (Updatable) Type of the url lists based on the policy
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        """
        (Updatable) URL lists to allow or deny traffic to a group of URLs. You can include a maximum of 25 URLs in each list.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class GetNetworkFirewallPoliciesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name for the Security rule, must be unique within the policy.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for the Security rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 application_lists: Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemApplicationListResult'],
                 compartment_id: str,
                 decryption_profiles: Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemDecryptionProfileResult'],
                 decryption_rules: Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemDecryptionRuleResult'],
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 ip_address_lists: Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemIpAddressListResult'],
                 is_firewall_attached: bool,
                 lifecycle_details: str,
                 mapped_secrets: Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemMappedSecretResult'],
                 security_rules: Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemSecurityRuleResult'],
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str,
                 url_lists: Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemUrlListResult']):
        """
        :param Sequence['GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemApplicationListArgs'] application_lists: Map defining application lists of the policy. The value of an entry is a list of "applications", each consisting of a protocol identifier (such as TCP, UDP, or ICMP) and protocol-specific parameters (such as a port range). The associated key is the identifier by which the application list is referenced.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence['GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemDecryptionProfileArgs'] decryption_profiles: Map defining decryption profiles of the policy. The value of an entry is a decryption profile. The associated key is the identifier by which the decryption profile is referenced.
        :param Sequence['GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemDecryptionRuleArgs'] decryption_rules: List of Decryption Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: Unique Network Firewall Policy identifier
        :param Sequence['GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemIpAddressListArgs'] ip_address_lists: Map defining IP address lists of the policy. The value of an entry is a list of IP addresses or prefixes in CIDR notation. The associated key is the identifier by which the IP address list is referenced.
        :param bool is_firewall_attached: To determine if any Network Firewall is associated with this Network Firewall Policy.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Sequence['GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemMappedSecretArgs'] mapped_secrets: Map defining secrets of the policy. The value of an entry is a "mapped secret" consisting of a purpose and source. The associated key is the identifier by which the mapped secret is referenced.
        :param Sequence['GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemSecurityRuleArgs'] security_rules: List of Security Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        :param str state: A filter to return only resources with a lifecycleState matching the given value.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time instant at which the Network Firewall Policy was created in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param str time_updated: The time instant at which the Network Firewall Policy was updated in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param Sequence['GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemUrlListArgs'] url_lists: Map defining URL pattern lists of the policy. The value of an entry is a list of URL patterns. The associated key is the identifier by which the URL pattern list is referenced.
        """
        pulumi.set(__self__, "application_lists", application_lists)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "decryption_profiles", decryption_profiles)
        pulumi.set(__self__, "decryption_rules", decryption_rules)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address_lists", ip_address_lists)
        pulumi.set(__self__, "is_firewall_attached", is_firewall_attached)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "mapped_secrets", mapped_secrets)
        pulumi.set(__self__, "security_rules", security_rules)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "url_lists", url_lists)

    @property
    @pulumi.getter(name="applicationLists")
    def application_lists(self) -> Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemApplicationListResult']:
        """
        Map defining application lists of the policy. The value of an entry is a list of "applications", each consisting of a protocol identifier (such as TCP, UDP, or ICMP) and protocol-specific parameters (such as a port range). The associated key is the identifier by which the application list is referenced.
        """
        return pulumi.get(self, "application_lists")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="decryptionProfiles")
    def decryption_profiles(self) -> Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemDecryptionProfileResult']:
        """
        Map defining decryption profiles of the policy. The value of an entry is a decryption profile. The associated key is the identifier by which the decryption profile is referenced.
        """
        return pulumi.get(self, "decryption_profiles")

    @property
    @pulumi.getter(name="decryptionRules")
    def decryption_rules(self) -> Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemDecryptionRuleResult']:
        """
        List of Decryption Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        """
        return pulumi.get(self, "decryption_rules")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddressLists")
    def ip_address_lists(self) -> Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemIpAddressListResult']:
        """
        Map defining IP address lists of the policy. The value of an entry is a list of IP addresses or prefixes in CIDR notation. The associated key is the identifier by which the IP address list is referenced.
        """
        return pulumi.get(self, "ip_address_lists")

    @property
    @pulumi.getter(name="isFirewallAttached")
    def is_firewall_attached(self) -> bool:
        """
        To determine if any Network Firewall is associated with this Network Firewall Policy.
        """
        return pulumi.get(self, "is_firewall_attached")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="mappedSecrets")
    def mapped_secrets(self) -> Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemMappedSecretResult']:
        """
        Map defining secrets of the policy. The value of an entry is a "mapped secret" consisting of a purpose and source. The associated key is the identifier by which the mapped secret is referenced.
        """
        return pulumi.get(self, "mapped_secrets")

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemSecurityRuleResult']:
        """
        List of Security Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        """
        return pulumi.get(self, "security_rules")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources with a lifecycleState matching the given value.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time instant at which the Network Firewall Policy was created in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time instant at which the Network Firewall Policy was updated in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="urlLists")
    def url_lists(self) -> Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemUrlListResult']:
        """
        Map defining URL pattern lists of the policy. The value of an entry is a list of URL patterns. The associated key is the identifier by which the URL pattern list is referenced.
        """
        return pulumi.get(self, "url_lists")


@pulumi.output_type
class GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemApplicationListResult(dict):
    def __init__(__self__, *,
                 application_list_name: str,
                 application_values: Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemApplicationListApplicationValueResult']):
        pulumi.set(__self__, "application_list_name", application_list_name)
        pulumi.set(__self__, "application_values", application_values)

    @property
    @pulumi.getter(name="applicationListName")
    def application_list_name(self) -> str:
        return pulumi.get(self, "application_list_name")

    @property
    @pulumi.getter(name="applicationValues")
    def application_values(self) -> Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemApplicationListApplicationValueResult']:
        return pulumi.get(self, "application_values")


@pulumi.output_type
class GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemApplicationListApplicationValueResult(dict):
    def __init__(__self__, *,
                 icmp_code: int,
                 icmp_type: int,
                 maximum_port: int,
                 minimum_port: int,
                 type: str):
        """
        :param str type: Type of the secrets mapped based on the policy.
        """
        pulumi.set(__self__, "icmp_code", icmp_code)
        pulumi.set(__self__, "icmp_type", icmp_type)
        pulumi.set(__self__, "maximum_port", maximum_port)
        pulumi.set(__self__, "minimum_port", minimum_port)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> int:
        return pulumi.get(self, "icmp_code")

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> int:
        return pulumi.get(self, "icmp_type")

    @property
    @pulumi.getter(name="maximumPort")
    def maximum_port(self) -> int:
        return pulumi.get(self, "maximum_port")

    @property
    @pulumi.getter(name="minimumPort")
    def minimum_port(self) -> int:
        return pulumi.get(self, "minimum_port")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the secrets mapped based on the policy.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemDecryptionProfileResult(dict):
    def __init__(__self__, *,
                 are_certificate_extensions_restricted: bool,
                 is_auto_include_alt_name: bool,
                 is_expired_certificate_blocked: bool,
                 is_out_of_capacity_blocked: bool,
                 is_revocation_status_timeout_blocked: bool,
                 is_unknown_revocation_status_blocked: bool,
                 is_unsupported_cipher_blocked: bool,
                 is_unsupported_version_blocked: bool,
                 is_untrusted_issuer_blocked: bool,
                 key: str,
                 type: str):
        """
        :param bool are_certificate_extensions_restricted: Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.
        :param bool is_auto_include_alt_name: Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.
        :param bool is_expired_certificate_blocked: Whether to block sessions if server's certificate is expired.
        :param bool is_out_of_capacity_blocked: Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.
        :param bool is_revocation_status_timeout_blocked: Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).
        :param bool is_unknown_revocation_status_blocked: Whether to block sessions if the revocation status check for server's certificate results in "unknown".
        :param bool is_unsupported_cipher_blocked: Whether to block sessions if SSL cipher suite is not supported.
        :param bool is_unsupported_version_blocked: Whether to block sessions if SSL version is not supported.
        :param bool is_untrusted_issuer_blocked: Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).
        :param str type: Type of the secrets mapped based on the policy.
        """
        pulumi.set(__self__, "are_certificate_extensions_restricted", are_certificate_extensions_restricted)
        pulumi.set(__self__, "is_auto_include_alt_name", is_auto_include_alt_name)
        pulumi.set(__self__, "is_expired_certificate_blocked", is_expired_certificate_blocked)
        pulumi.set(__self__, "is_out_of_capacity_blocked", is_out_of_capacity_blocked)
        pulumi.set(__self__, "is_revocation_status_timeout_blocked", is_revocation_status_timeout_blocked)
        pulumi.set(__self__, "is_unknown_revocation_status_blocked", is_unknown_revocation_status_blocked)
        pulumi.set(__self__, "is_unsupported_cipher_blocked", is_unsupported_cipher_blocked)
        pulumi.set(__self__, "is_unsupported_version_blocked", is_unsupported_version_blocked)
        pulumi.set(__self__, "is_untrusted_issuer_blocked", is_untrusted_issuer_blocked)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="areCertificateExtensionsRestricted")
    def are_certificate_extensions_restricted(self) -> bool:
        """
        Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.
        """
        return pulumi.get(self, "are_certificate_extensions_restricted")

    @property
    @pulumi.getter(name="isAutoIncludeAltName")
    def is_auto_include_alt_name(self) -> bool:
        """
        Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.
        """
        return pulumi.get(self, "is_auto_include_alt_name")

    @property
    @pulumi.getter(name="isExpiredCertificateBlocked")
    def is_expired_certificate_blocked(self) -> bool:
        """
        Whether to block sessions if server's certificate is expired.
        """
        return pulumi.get(self, "is_expired_certificate_blocked")

    @property
    @pulumi.getter(name="isOutOfCapacityBlocked")
    def is_out_of_capacity_blocked(self) -> bool:
        """
        Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.
        """
        return pulumi.get(self, "is_out_of_capacity_blocked")

    @property
    @pulumi.getter(name="isRevocationStatusTimeoutBlocked")
    def is_revocation_status_timeout_blocked(self) -> bool:
        """
        Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).
        """
        return pulumi.get(self, "is_revocation_status_timeout_blocked")

    @property
    @pulumi.getter(name="isUnknownRevocationStatusBlocked")
    def is_unknown_revocation_status_blocked(self) -> bool:
        """
        Whether to block sessions if the revocation status check for server's certificate results in "unknown".
        """
        return pulumi.get(self, "is_unknown_revocation_status_blocked")

    @property
    @pulumi.getter(name="isUnsupportedCipherBlocked")
    def is_unsupported_cipher_blocked(self) -> bool:
        """
        Whether to block sessions if SSL cipher suite is not supported.
        """
        return pulumi.get(self, "is_unsupported_cipher_blocked")

    @property
    @pulumi.getter(name="isUnsupportedVersionBlocked")
    def is_unsupported_version_blocked(self) -> bool:
        """
        Whether to block sessions if SSL version is not supported.
        """
        return pulumi.get(self, "is_unsupported_version_blocked")

    @property
    @pulumi.getter(name="isUntrustedIssuerBlocked")
    def is_untrusted_issuer_blocked(self) -> bool:
        """
        Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).
        """
        return pulumi.get(self, "is_untrusted_issuer_blocked")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the secrets mapped based on the policy.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemDecryptionRuleResult(dict):
    def __init__(__self__, *,
                 action: str,
                 conditions: Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemDecryptionRuleConditionResult'],
                 decryption_profile: str,
                 name: str,
                 secret: str):
        """
        :param str action: Types of Action on the Traffic flow.
               * ALLOW - Allows the traffic.
               * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
               * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
               * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.
        :param Sequence['GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemDecryptionRuleConditionArgs'] conditions: Criteria to evaluate against network traffic. A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
        :param str decryption_profile: The name of the decryption profile to use.
        :param str name: Name for the Security rule, must be unique within the policy.
        :param str secret: The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "decryption_profile", decryption_profile)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Types of Action on the Traffic flow.
        * ALLOW - Allows the traffic.
        * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
        * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
        * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemDecryptionRuleConditionResult']:
        """
        Criteria to evaluate against network traffic. A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="decryptionProfile")
    def decryption_profile(self) -> str:
        """
        The name of the decryption profile to use.
        """
        return pulumi.get(self, "decryption_profile")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for the Security rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemDecryptionRuleConditionResult(dict):
    def __init__(__self__, *,
                 destinations: Sequence[str],
                 sources: Sequence[str]):
        """
        :param Sequence[str] destinations: An array of IP address list names to be evaluated against the traffic destination address.
        :param Sequence[str] sources: An array of IP address list names to be evaluated against the traffic source address.
        """
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def destinations(self) -> Sequence[str]:
        """
        An array of IP address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def sources(self) -> Sequence[str]:
        """
        An array of IP address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemIpAddressListResult(dict):
    def __init__(__self__, *,
                 ip_address_list_name: str,
                 ip_address_list_values: Sequence[str]):
        pulumi.set(__self__, "ip_address_list_name", ip_address_list_name)
        pulumi.set(__self__, "ip_address_list_values", ip_address_list_values)

    @property
    @pulumi.getter(name="ipAddressListName")
    def ip_address_list_name(self) -> str:
        return pulumi.get(self, "ip_address_list_name")

    @property
    @pulumi.getter(name="ipAddressListValues")
    def ip_address_list_values(self) -> Sequence[str]:
        return pulumi.get(self, "ip_address_list_values")


@pulumi.output_type
class GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemMappedSecretResult(dict):
    def __init__(__self__, *,
                 key: str,
                 type: str,
                 vault_secret_id: str,
                 version_number: int):
        """
        :param str type: Type of the secrets mapped based on the policy.
        :param str vault_secret_id: OCID for the Vault Secret to be used.
        :param int version_number: Version number of the secret to be used.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vault_secret_id", vault_secret_id)
        pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the secrets mapped based on the policy.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vaultSecretId")
    def vault_secret_id(self) -> str:
        """
        OCID for the Vault Secret to be used.
        """
        return pulumi.get(self, "vault_secret_id")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> int:
        """
        Version number of the secret to be used.
        """
        return pulumi.get(self, "version_number")


@pulumi.output_type
class GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemSecurityRuleResult(dict):
    def __init__(__self__, *,
                 action: str,
                 conditions: Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemSecurityRuleConditionResult'],
                 inspection: str,
                 name: str):
        """
        :param str action: Types of Action on the Traffic flow.
               * ALLOW - Allows the traffic.
               * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
               * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
               * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.
        :param Sequence['GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemSecurityRuleConditionArgs'] conditions: Criteria to evaluate against network traffic. A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
        :param str inspection: Type of inspection to affect the Traffic flow. This is only applicable if action is INSPECT.
               * INTRUSION_DETECTION - Intrusion Detection.
               * INTRUSION_PREVENTION - Intrusion Detection and Prevention. Traffic classified as potentially malicious will be rejected as described in `type`.
        :param str name: Name for the Security rule, must be unique within the policy.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "inspection", inspection)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Types of Action on the Traffic flow.
        * ALLOW - Allows the traffic.
        * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
        * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
        * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemSecurityRuleConditionResult']:
        """
        Criteria to evaluate against network traffic. A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def inspection(self) -> str:
        """
        Type of inspection to affect the Traffic flow. This is only applicable if action is INSPECT.
        * INTRUSION_DETECTION - Intrusion Detection.
        * INTRUSION_PREVENTION - Intrusion Detection and Prevention. Traffic classified as potentially malicious will be rejected as described in `type`.
        """
        return pulumi.get(self, "inspection")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for the Security rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemSecurityRuleConditionResult(dict):
    def __init__(__self__, *,
                 applications: Sequence[str],
                 destinations: Sequence[str],
                 sources: Sequence[str],
                 urls: Sequence[str]):
        """
        :param Sequence[str] applications: An array of application list names to be evaluated against the traffic protocol and protocol-specific parameters.
        :param Sequence[str] destinations: An array of IP address list names to be evaluated against the traffic destination address.
        :param Sequence[str] sources: An array of IP address list names to be evaluated against the traffic source address.
        :param Sequence[str] urls: An array of URL pattern list names to be evaluated against the HTTP(S) request target.
        """
        pulumi.set(__self__, "applications", applications)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "urls", urls)

    @property
    @pulumi.getter
    def applications(self) -> Sequence[str]:
        """
        An array of application list names to be evaluated against the traffic protocol and protocol-specific parameters.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter
    def destinations(self) -> Sequence[str]:
        """
        An array of IP address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def sources(self) -> Sequence[str]:
        """
        An array of IP address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def urls(self) -> Sequence[str]:
        """
        An array of URL pattern list names to be evaluated against the HTTP(S) request target.
        """
        return pulumi.get(self, "urls")


@pulumi.output_type
class GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemUrlListResult(dict):
    def __init__(__self__, *,
                 url_list_name: str,
                 url_list_values: Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemUrlListUrlListValueResult']):
        pulumi.set(__self__, "url_list_name", url_list_name)
        pulumi.set(__self__, "url_list_values", url_list_values)

    @property
    @pulumi.getter(name="urlListName")
    def url_list_name(self) -> str:
        return pulumi.get(self, "url_list_name")

    @property
    @pulumi.getter(name="urlListValues")
    def url_list_values(self) -> Sequence['outputs.GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemUrlListUrlListValueResult']:
        return pulumi.get(self, "url_list_values")


@pulumi.output_type
class GetNetworkFirewallPoliciesNetworkFirewallPolicySummaryCollectionItemUrlListUrlListValueResult(dict):
    def __init__(__self__, *,
                 pattern: str,
                 type: str):
        """
        :param str type: Type of the secrets mapped based on the policy.
        """
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def pattern(self) -> str:
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the secrets mapped based on the policy.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkFirewallPolicyApplicationListResult(dict):
    def __init__(__self__, *,
                 application_list_name: str,
                 application_values: Sequence['outputs.GetNetworkFirewallPolicyApplicationListApplicationValueResult']):
        pulumi.set(__self__, "application_list_name", application_list_name)
        pulumi.set(__self__, "application_values", application_values)

    @property
    @pulumi.getter(name="applicationListName")
    def application_list_name(self) -> str:
        return pulumi.get(self, "application_list_name")

    @property
    @pulumi.getter(name="applicationValues")
    def application_values(self) -> Sequence['outputs.GetNetworkFirewallPolicyApplicationListApplicationValueResult']:
        return pulumi.get(self, "application_values")


@pulumi.output_type
class GetNetworkFirewallPolicyApplicationListApplicationValueResult(dict):
    def __init__(__self__, *,
                 icmp_code: int,
                 icmp_type: int,
                 maximum_port: int,
                 minimum_port: int,
                 type: str):
        """
        :param str type: Type of the secrets mapped based on the policy.
        """
        pulumi.set(__self__, "icmp_code", icmp_code)
        pulumi.set(__self__, "icmp_type", icmp_type)
        pulumi.set(__self__, "maximum_port", maximum_port)
        pulumi.set(__self__, "minimum_port", minimum_port)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> int:
        return pulumi.get(self, "icmp_code")

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> int:
        return pulumi.get(self, "icmp_type")

    @property
    @pulumi.getter(name="maximumPort")
    def maximum_port(self) -> int:
        return pulumi.get(self, "maximum_port")

    @property
    @pulumi.getter(name="minimumPort")
    def minimum_port(self) -> int:
        return pulumi.get(self, "minimum_port")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the secrets mapped based on the policy.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkFirewallPolicyDecryptionProfileResult(dict):
    def __init__(__self__, *,
                 are_certificate_extensions_restricted: bool,
                 is_auto_include_alt_name: bool,
                 is_expired_certificate_blocked: bool,
                 is_out_of_capacity_blocked: bool,
                 is_revocation_status_timeout_blocked: bool,
                 is_unknown_revocation_status_blocked: bool,
                 is_unsupported_cipher_blocked: bool,
                 is_unsupported_version_blocked: bool,
                 is_untrusted_issuer_blocked: bool,
                 key: str,
                 type: str):
        """
        :param bool are_certificate_extensions_restricted: Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.
        :param bool is_auto_include_alt_name: Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.
        :param bool is_expired_certificate_blocked: Whether to block sessions if server's certificate is expired.
        :param bool is_out_of_capacity_blocked: Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.
        :param bool is_revocation_status_timeout_blocked: Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).
        :param bool is_unknown_revocation_status_blocked: Whether to block sessions if the revocation status check for server's certificate results in "unknown".
        :param bool is_unsupported_cipher_blocked: Whether to block sessions if SSL cipher suite is not supported.
        :param bool is_unsupported_version_blocked: Whether to block sessions if SSL version is not supported.
        :param bool is_untrusted_issuer_blocked: Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).
        :param str type: Type of the secrets mapped based on the policy.
        """
        pulumi.set(__self__, "are_certificate_extensions_restricted", are_certificate_extensions_restricted)
        pulumi.set(__self__, "is_auto_include_alt_name", is_auto_include_alt_name)
        pulumi.set(__self__, "is_expired_certificate_blocked", is_expired_certificate_blocked)
        pulumi.set(__self__, "is_out_of_capacity_blocked", is_out_of_capacity_blocked)
        pulumi.set(__self__, "is_revocation_status_timeout_blocked", is_revocation_status_timeout_blocked)
        pulumi.set(__self__, "is_unknown_revocation_status_blocked", is_unknown_revocation_status_blocked)
        pulumi.set(__self__, "is_unsupported_cipher_blocked", is_unsupported_cipher_blocked)
        pulumi.set(__self__, "is_unsupported_version_blocked", is_unsupported_version_blocked)
        pulumi.set(__self__, "is_untrusted_issuer_blocked", is_untrusted_issuer_blocked)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="areCertificateExtensionsRestricted")
    def are_certificate_extensions_restricted(self) -> bool:
        """
        Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.
        """
        return pulumi.get(self, "are_certificate_extensions_restricted")

    @property
    @pulumi.getter(name="isAutoIncludeAltName")
    def is_auto_include_alt_name(self) -> bool:
        """
        Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.
        """
        return pulumi.get(self, "is_auto_include_alt_name")

    @property
    @pulumi.getter(name="isExpiredCertificateBlocked")
    def is_expired_certificate_blocked(self) -> bool:
        """
        Whether to block sessions if server's certificate is expired.
        """
        return pulumi.get(self, "is_expired_certificate_blocked")

    @property
    @pulumi.getter(name="isOutOfCapacityBlocked")
    def is_out_of_capacity_blocked(self) -> bool:
        """
        Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.
        """
        return pulumi.get(self, "is_out_of_capacity_blocked")

    @property
    @pulumi.getter(name="isRevocationStatusTimeoutBlocked")
    def is_revocation_status_timeout_blocked(self) -> bool:
        """
        Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).
        """
        return pulumi.get(self, "is_revocation_status_timeout_blocked")

    @property
    @pulumi.getter(name="isUnknownRevocationStatusBlocked")
    def is_unknown_revocation_status_blocked(self) -> bool:
        """
        Whether to block sessions if the revocation status check for server's certificate results in "unknown".
        """
        return pulumi.get(self, "is_unknown_revocation_status_blocked")

    @property
    @pulumi.getter(name="isUnsupportedCipherBlocked")
    def is_unsupported_cipher_blocked(self) -> bool:
        """
        Whether to block sessions if SSL cipher suite is not supported.
        """
        return pulumi.get(self, "is_unsupported_cipher_blocked")

    @property
    @pulumi.getter(name="isUnsupportedVersionBlocked")
    def is_unsupported_version_blocked(self) -> bool:
        """
        Whether to block sessions if SSL version is not supported.
        """
        return pulumi.get(self, "is_unsupported_version_blocked")

    @property
    @pulumi.getter(name="isUntrustedIssuerBlocked")
    def is_untrusted_issuer_blocked(self) -> bool:
        """
        Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).
        """
        return pulumi.get(self, "is_untrusted_issuer_blocked")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the secrets mapped based on the policy.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkFirewallPolicyDecryptionRuleResult(dict):
    def __init__(__self__, *,
                 action: str,
                 conditions: Sequence['outputs.GetNetworkFirewallPolicyDecryptionRuleConditionResult'],
                 decryption_profile: str,
                 name: str,
                 secret: str):
        """
        :param str action: Types of Action on the Traffic flow.
               * ALLOW - Allows the traffic.
               * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
               * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
               * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.
        :param Sequence['GetNetworkFirewallPolicyDecryptionRuleConditionArgs'] conditions: Criteria to evaluate against network traffic. A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
        :param str decryption_profile: The name of the decryption profile to use.
        :param str name: Name for the Security rule, must be unique within the policy.
        :param str secret: The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "decryption_profile", decryption_profile)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Types of Action on the Traffic flow.
        * ALLOW - Allows the traffic.
        * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
        * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
        * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetNetworkFirewallPolicyDecryptionRuleConditionResult']:
        """
        Criteria to evaluate against network traffic. A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="decryptionProfile")
    def decryption_profile(self) -> str:
        """
        The name of the decryption profile to use.
        """
        return pulumi.get(self, "decryption_profile")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for the Security rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class GetNetworkFirewallPolicyDecryptionRuleConditionResult(dict):
    def __init__(__self__, *,
                 destinations: Sequence[str],
                 sources: Sequence[str]):
        """
        :param Sequence[str] destinations: An array of IP address list names to be evaluated against the traffic destination address.
        :param Sequence[str] sources: An array of IP address list names to be evaluated against the traffic source address.
        """
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def destinations(self) -> Sequence[str]:
        """
        An array of IP address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def sources(self) -> Sequence[str]:
        """
        An array of IP address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class GetNetworkFirewallPolicyIpAddressListResult(dict):
    def __init__(__self__, *,
                 ip_address_list_name: str,
                 ip_address_list_values: Sequence[str]):
        pulumi.set(__self__, "ip_address_list_name", ip_address_list_name)
        pulumi.set(__self__, "ip_address_list_values", ip_address_list_values)

    @property
    @pulumi.getter(name="ipAddressListName")
    def ip_address_list_name(self) -> str:
        return pulumi.get(self, "ip_address_list_name")

    @property
    @pulumi.getter(name="ipAddressListValues")
    def ip_address_list_values(self) -> Sequence[str]:
        return pulumi.get(self, "ip_address_list_values")


@pulumi.output_type
class GetNetworkFirewallPolicyMappedSecretResult(dict):
    def __init__(__self__, *,
                 key: str,
                 type: str,
                 vault_secret_id: str,
                 version_number: int):
        """
        :param str type: Type of the secrets mapped based on the policy.
        :param str vault_secret_id: OCID for the Vault Secret to be used.
        :param int version_number: Version number of the secret to be used.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vault_secret_id", vault_secret_id)
        pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the secrets mapped based on the policy.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vaultSecretId")
    def vault_secret_id(self) -> str:
        """
        OCID for the Vault Secret to be used.
        """
        return pulumi.get(self, "vault_secret_id")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> int:
        """
        Version number of the secret to be used.
        """
        return pulumi.get(self, "version_number")


@pulumi.output_type
class GetNetworkFirewallPolicySecurityRuleResult(dict):
    def __init__(__self__, *,
                 action: str,
                 conditions: Sequence['outputs.GetNetworkFirewallPolicySecurityRuleConditionResult'],
                 inspection: str,
                 name: str):
        """
        :param str action: Types of Action on the Traffic flow.
               * ALLOW - Allows the traffic.
               * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
               * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
               * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.
        :param Sequence['GetNetworkFirewallPolicySecurityRuleConditionArgs'] conditions: Criteria to evaluate against network traffic. A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
        :param str inspection: Type of inspection to affect the Traffic flow. This is only applicable if action is INSPECT.
               * INTRUSION_DETECTION - Intrusion Detection.
               * INTRUSION_PREVENTION - Intrusion Detection and Prevention. Traffic classified as potentially malicious will be rejected as described in `type`.
        :param str name: Name for the Security rule, must be unique within the policy.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "inspection", inspection)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Types of Action on the Traffic flow.
        * ALLOW - Allows the traffic.
        * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
        * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
        * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetNetworkFirewallPolicySecurityRuleConditionResult']:
        """
        Criteria to evaluate against network traffic. A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def inspection(self) -> str:
        """
        Type of inspection to affect the Traffic flow. This is only applicable if action is INSPECT.
        * INTRUSION_DETECTION - Intrusion Detection.
        * INTRUSION_PREVENTION - Intrusion Detection and Prevention. Traffic classified as potentially malicious will be rejected as described in `type`.
        """
        return pulumi.get(self, "inspection")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for the Security rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetNetworkFirewallPolicySecurityRuleConditionResult(dict):
    def __init__(__self__, *,
                 applications: Sequence[str],
                 destinations: Sequence[str],
                 sources: Sequence[str],
                 urls: Sequence[str]):
        """
        :param Sequence[str] applications: An array of application list names to be evaluated against the traffic protocol and protocol-specific parameters.
        :param Sequence[str] destinations: An array of IP address list names to be evaluated against the traffic destination address.
        :param Sequence[str] sources: An array of IP address list names to be evaluated against the traffic source address.
        :param Sequence[str] urls: An array of URL pattern list names to be evaluated against the HTTP(S) request target.
        """
        pulumi.set(__self__, "applications", applications)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "urls", urls)

    @property
    @pulumi.getter
    def applications(self) -> Sequence[str]:
        """
        An array of application list names to be evaluated against the traffic protocol and protocol-specific parameters.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter
    def destinations(self) -> Sequence[str]:
        """
        An array of IP address list names to be evaluated against the traffic destination address.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def sources(self) -> Sequence[str]:
        """
        An array of IP address list names to be evaluated against the traffic source address.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def urls(self) -> Sequence[str]:
        """
        An array of URL pattern list names to be evaluated against the HTTP(S) request target.
        """
        return pulumi.get(self, "urls")


@pulumi.output_type
class GetNetworkFirewallPolicyUrlListResult(dict):
    def __init__(__self__, *,
                 url_list_name: str,
                 url_list_values: Sequence['outputs.GetNetworkFirewallPolicyUrlListUrlListValueResult']):
        pulumi.set(__self__, "url_list_name", url_list_name)
        pulumi.set(__self__, "url_list_values", url_list_values)

    @property
    @pulumi.getter(name="urlListName")
    def url_list_name(self) -> str:
        return pulumi.get(self, "url_list_name")

    @property
    @pulumi.getter(name="urlListValues")
    def url_list_values(self) -> Sequence['outputs.GetNetworkFirewallPolicyUrlListUrlListValueResult']:
        return pulumi.get(self, "url_list_values")


@pulumi.output_type
class GetNetworkFirewallPolicyUrlListUrlListValueResult(dict):
    def __init__(__self__, *,
                 pattern: str,
                 type: str):
        """
        :param str type: Type of the secrets mapped based on the policy.
        """
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def pattern(self) -> str:
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the secrets mapped based on the policy.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNetworkFirewallsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNetworkFirewallsNetworkFirewallCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetNetworkFirewallsNetworkFirewallCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworkFirewallsNetworkFirewallCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetNetworkFirewallsNetworkFirewallCollectionItemResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 ipv4address: str,
                 ipv6address: str,
                 lifecycle_details: str,
                 network_firewall_policy_id: str,
                 network_security_group_ids: Sequence[str],
                 state: str,
                 subnet_id: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param str availability_domain: A filter to return only resources that are present within the specified availability domain. To get a list of availability domains for a tenancy, use [ListAvailabilityDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/AvailabilityDomain/ListAvailabilityDomains) operation. Example: `kIdk:PHX-AD-1`
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Network Firewall resource.
        :param str ipv4address: IPv4 address for the Network Firewall.
        :param str ipv6address: IPv6 address for the Network Firewall.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str network_firewall_policy_id: A filter to return only resources that match the entire networkFirewallPolicyId given.
        :param Sequence[str] network_security_group_ids: An array of network security groups [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the Network Firewall.
        :param str state: A filter to return only resources with a lifecycleState matching the given value.
        :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the Network Firewall.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time instant at which the Network Firewall was created in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param str time_updated: The time instant at which the Network Firewall was updated in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipv4address", ipv4address)
        pulumi.set(__self__, "ipv6address", ipv6address)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        A filter to return only resources that are present within the specified availability domain. To get a list of availability domains for a tenancy, use [ListAvailabilityDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/AvailabilityDomain/ListAvailabilityDomains) operation. Example: `kIdk:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Network Firewall resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ipv4address(self) -> str:
        """
        IPv4 address for the Network Firewall.
        """
        return pulumi.get(self, "ipv4address")

    @property
    @pulumi.getter
    def ipv6address(self) -> str:
        """
        IPv6 address for the Network Firewall.
        """
        return pulumi.get(self, "ipv6address")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> str:
        """
        A filter to return only resources that match the entire networkFirewallPolicyId given.
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Sequence[str]:
        """
        An array of network security groups [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the Network Firewall.
        """
        return pulumi.get(self, "network_security_group_ids")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources with a lifecycleState matching the given value.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the Network Firewall.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time instant at which the Network Firewall was created in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time instant at which the Network Firewall was updated in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


