import numpy as np
from flopy.mbase import Package
from flopy.utils import Util2d,Util3d
class Mt3dRct(Package):
    '''
    Chemical reaction package class
    '''
    unitnumber = 36
    def __init__(self, model, isothm=0, ireact=0, igetsc=1, rhob=1.8e3, 
                 prsity2=0.1, srconc=0.0, sp1=0.0, sp2=0.0, rc1=0.0, rc2=0.0, 
                 extension='rct', unitnumber=None):
        #Call ancestor's init to set self.parent, extension, name and 
        #unit number
        if unitnumber is None:
            unitnumber = self.unitnumber
        Package.__init__(self, model, extension, 'RCT', unitnumber)
        nrow = model.nrow
        ncol = model.ncol
        nlay = model.nlay
        self.heading1 = '# RCT for MT3DMS, generated by Flopy.'
        self.isothm = isothm
        self.ireact = ireact
        self.irctop = 2 #All RCT vars are specified as 3D arrays
        self.igetsc = igetsc
        # Set values of all parameters
        #self.rhob = self.assignarray((nlay, nrow, ncol), np.float, rhob, 
        #                             name='rhob')
        self.rhob = Util3d(model,(nlay,nrow,ncol),np.float32,rhob,name='rhob',
                            locat=self.unit_number[0])
        #self.prsity2 = self.assignarray((nlay, nrow, ncol), np.float, prsity2, 
        #                                name='prsity2')
        self.prsity2 = Util3d(model,(nlay,nrow,ncol),np.float32,prsity2,
                               name='prsity2',locat=self.unit_number[0])
        #self.srconc = self.assignarray((nlay, nrow, ncol), np.float, srconc, 
        #                               name='srconc')
        self.srconc = Util3d(model,(nlay,nrow,ncol),np.float32,srconc,
                              name='srconc',locat=self.unit_number[0])
        #self.sp1 = self.assignarray((nlay, nrow, ncol), np.float, sp1, 
        #                            name='sp1')
        self.sp1 = Util3d(model,(nlay,nrow,ncol),np.float32,sp1,name='sp1',
                           locat=self.unit_number[0])
        #self.sp2 = self.assignarray((nlay, nrow, ncol), np.float, sp2, 
        #                            name='sp2')
        self.sp2 = Util3d(model,(nlay,nrow,ncol),np.float32,sp2,name='sp2',
                           locat=self.unit_number[0])
        #self.rc1 = self.assignarray((nlay, nrow, ncol), np.float, rc1, 
        #                            name='rc1')
        self.rc1 = Util3d(model,(nlay,nrow,ncol),np.float32,rc1,name='rc1',
                           locat=self.unit_number[0])
        #self.rc2 = self.assignarray((nlay, nrow, ncol), np.float, rc2,
        #                             name='rc2')
        self.rc2 = Util3d(model,(nlay,nrow,ncol),np.float32,rc2,name='rc2',
                           locat=self.unit_number[0])
        self.parent.add_package(self)
        return

    def __repr__( self ):
        return 'Chemical reaction package class'

    def write_file(self):
        """
        Write the package file

        Returns
        -------
        None

        """
        # Open file for writing
        f_rct = open(self.fn_path, 'w')
        f_rct.write('%10i%10i%10i%10i\n' % (self.isothm, self.ireact, 
                                            self.irctop, self.igetsc))
        if (self.isothm in [1, 2, 3, 4, 6]):
            #self.parent.write_array(f_rct, self.rhob, self.unit_number[0], 
            #                        True, 13, -ncol, 'Bulk density for Layer',
            #                        ext_base='rhob')
            f_rct.write(self.rhob.get_file_entry())
        if (self.isothm in [5, 6]):
            #self.parent.write_array(f_rct, self.prsity2, self.unit_number[0], 
            #                       True, 13, -ncol, 
            #                       'Immobile porosity for Layer',
            #                       ext_base='prsity2')
            f_rct.write(self.prsity2.get_file_entry())
        if (self.igetsc > 0):
            #self.parent.write_array(f_rct, self.srconc, self.unit_number[0], 
            #                        True, 13, -ncol, 'Sorbed/immobile '
            #                        'starting concentration for Layer',
            #                        ext_base='srconc')
            f_rct.write(self.srconc.get_file_entry())
        if (self.isothm > 0):
            #self.parent.write_array(f_rct, self.sp1, self.unit_number[0], 
            #                        True, 13, -ncol, 
            #                        'First sorption parameter for Layer',
            #                        ext_base='sp1')
            f_rct.write(self.sp1.get_file_entry())
        if (self.isothm > 0):
            #self.parent.write_array(f_rct, self.sp2, self.unit_number[0], 
            #                        True, 13, -ncol, 
            #                        'Second sorption parameter for Layer',
            #                        ext_base='sp2')
            f_rct.write(self.sp2.get_file_entry())
        if (self.ireact > 0):
            #self.parent.write_array(f_rct, self.rc1, self.unit_number[0], 
            #                        True, 13, -ncol, 'First order reaction '
            #                        'rate for liquid phase for Layer',
            #                        ext_base='rc1')
            f_rct.write(self.rc1.get_file_entry())
        if (self.ireact > 0):
            #self.parent.write_array(f_rct, self.rc2, self.unit_number[0], 
            #                        True, 13, -ncol, 'First order reaction '
            #                        'rate for sorbed phase for Layer',
            #                        ext_base='rc2')
            f_rct.write(self.rc2.get_file_entry())
        f_rct.close()
        return
