import { IRepository } from '@aws-cdk/aws-codecommit';
import { OnEventOptions, Rule } from '@aws-cdk/aws-events';
import { Construct } from '@aws-cdk/core';
export interface ApprovalRuleTemplateRepositoryAssociationProps {
    /**
     * The name of the template you want to associate with one or more repositories.
     */
    readonly approvalRuleTemplateName: string;
    /**
     * The repository you want to associate with the template.
     */
    readonly repository: IRepository;
}
export declare class ApprovalRuleTemplateRepositoryAssociation extends Construct {
    private repository;
    constructor(scope: Construct, id: string, props: ApprovalRuleTemplateRepositoryAssociationProps);
    onOverridden(id: string, options: OnEventOptions): Rule;
}
