from typing import Optional

from aiogram.types import ContentType
from cachetools import LRUCache

from ..manager.protocols import MediaIdStorageProtocol, MediaId


class MediaIdStorage(MediaIdStorageProtocol):
    def __init__(self, maxsize=10240):
        self.cache = LRUCache(maxsize=maxsize)

    async def get_media_id(
            self,
            path: Optional[str],
            url: Optional[str],
            type: ContentType,
    ) -> Optional[MediaId]:
        if not path:
            return None
        return self.cache.get((path, url, type))

    async def save_media_id(
            self,
            path: Optional[str],
            url: Optional[str],
            type: ContentType,
            media_id: MediaId,
    ) -> None:
        if not path and not url:
            return None
        self.cache[(path, url, type)] = media_id
