"""
Consolidated codon definitions for the nature genetic programming framework.

This package contains all codon classes (genetic programming primitives) organized by category.
For backward compatibility, all codons are re-exported from this __init__.py.

Organization:
- primitives.py: Core arithmetic, logical, type operations
- series.py: General-purpose pandas/series operations
"""

# Import base classes for backward compatibility (some code imports from nature.codons)
from nature.codon import Codon, Inp, Out  # noqa: F401

# Import everything from both modules for backward compatibility
from nature.codons.primitives import *  # noqa: F401, F403
from nature.codons.series import *  # noqa: F401, F403

# Explicitly list all exported symbols for clarity
__all__ = [
    "AbsDiffRollingMedianVolatility",
    "Add",
    "And",
    "ApplyLowerThreshold",
    "ApplyRecencyFilter",
    "ApplyUpperThreshold",
    "BbandsChan",
    "Between",
    "Boolean",
    "Btw",
    "BuildDf",
    "Cast",
    "CastSeries",
    "CastValue",
    "Choice",
    "ComparativeResidual",
    "DeriveWindow",
    "DfCol",
    "DfConcat",
    "DfExtend",
    "DfHStack",
    "DfMean",
    "Diff",
    "Div",
    "DynBbandsChan",
    "DynILoc",
    "DynRoll",
    "Eq",
    "EwmDiffAbsVolatility",
    "Flatten",
    "Float",
    "Fstr",
    "Gather",
    "Gaussian",
    "GaussianBetween",
    "GaussianInt",
    "Gt",
    "ILoc",
    "IfElse",
    "InRange",
    "IndexSequence",
    "IndexSeries",
    "Int",
    "IntBetween",
    "KalmanSmoothV2",
    "LagResidual",
    "Locator",
    "Log",
    "LogUniformFloat",
    "LowerDynBband",
    "Lt",
    "MTFMaCrossUpEvents",
    "MTFMomentumSignChangeEvents",
    "MTFPastHighCrossUpEvents",
    "Mean",
    "MedianDeviationVolatility",
    "Mul",
    "NDiff",
    "NPctChange",
    "NormBbands",
    "NormMinMax",
    "NormZScore",
    "Not",
    "OneOf",
    "Or",
    "PctChangeRelativeToMean",
    "PosInChan",
    "Pow",
    "Pow2",
    "Pow3",
    "ProbablisticBoolean",
    "RSI",
    "RandomCol",
    "Reduce",
    "RollBband",
    "RollCmp",
    "RollDom",
    "RollEntropy",
    "RollLinReg",
    "RollMad",
    "RollMode",
    "RollVol",
    "RollZScore",
    "Rolling",
    "RollingAutoCorr",
    "RollingCorr",
    "RollingCov",
    "RollingKurt",
    "RollingMax",
    "RollingMean",
    "RollingMed",
    "RollingMin",
    "RollingSkew",
    "RollingStd",
    "RollingSum",
    "RollingVar",
    "Round",
    "SAbs",
    "SAdd",
    "SAll",
    "SAnd",
    "SAny",
    "SBtw",
    "SCmpGate",
    "SCos",
    "SDiff",
    "SDiscretize",
    "SDiv",
    "SExp",
    "SILocIdx",
    "SIfElse",
    "SLoc",
    "SLocMask",
    "SLog",
    "SLog1p",
    "SLogicGate",
    "SMax",
    "SMean",
    "SMin",
    "SMul",
    "SNeg",
    "SNot",
    "SOr",
    "SPctChange",
    "SPow",
    "SSigmoid",
    "SSin",
    "SSin2pi",
    "SSqrt",
    "SSub",
    "STanh",
    "SWMean",
    "SeriesEq",
    "SeriesGeq",
    "SeriesGt",
    "SeriesLeq",
    "SeriesLt",
    "Shift",
    "Sigmoid",
    "SSing",
    "Sin",
    "Sqrt",
    "Step",
    "Str",
    "Sub",
    "Lexicon",
    "ToDict",
    "ToFloat",
    "ToInt",
    "ToTuple",
    "STrue",
    "UpperDynBband",
    "VolatilityWindows",
    "WMean",
    "WaveletTransform",
    "Zip",
    "Lexicon",
    "symbol",
    "NIL",
    "CodonHierarchy",
    # Base classes re-exported for backward compatibility
    "Codon",
    "Inp",
    "Out",
]
