# -*- coding: utf-8 -*-
from ..models import FBUserProfile
import gettext
import logging
from django.conf import settings


logger = logging.getLogger(__name__)


def install_user_locale(psid):
    try:
        user = FBUserProfile.objects.get(pk=psid)
        lang = user.locale[:2]
        logger.debug('locale dirs: %s' % settings.LOCALE_PATHS)
        for locale_dir in settings.LOCALE_PATHS:
            zh = gettext.translation('django',
                                     localedir=locale_dir,
                                     languages=[lang])
            zh.install()
            logger.debug('Successfully installed language %s for user %s'
                         % (lang, psid))
    except:
        logger.debug('Installing locale for user %s failed, resetting...' % psid)
        reset_locale()


def reset_locale():
    logger.debug('Resetting locale...')
    _ = lambda s: s
