# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DataAssetDataSourceDetailsArgs',
    'DataAssetDataSourceDetailsVersionSpecificDetailsArgs',
    'DetectAnomalyJobInputDetailsArgs',
    'DetectAnomalyJobInputDetailsDataArgs',
    'DetectAnomalyJobInputDetailsObjectLocationArgs',
    'DetectAnomalyJobOutputDetailsArgs',
    'ModelModelTrainingDetailsArgs',
    'ModelModelTrainingResultArgs',
    'ModelModelTrainingResultRowReductionDetailArgs',
    'ModelModelTrainingResultSignalDetailArgs',
    'GetAiPrivateEndpointsFilterArgs',
    'GetDetectAnomalyJobsFilterArgs',
    'GetDetectionDataAssetsFilterArgs',
    'GetDetectionModelsFilterArgs',
    'GetDetectionProjectsFilterArgs',
]

@pulumi.input_type
class DataAssetDataSourceDetailsArgs:
    def __init__(__self__, *,
                 data_source_type: pulumi.Input[str],
                 atp_password_secret_id: Optional[pulumi.Input[str]] = None,
                 atp_user_name: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 cwallet_file_secret_id: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 ewallet_file_secret_id: Optional[pulumi.Input[str]] = None,
                 key_store_file_secret_id: Optional[pulumi.Input[str]] = None,
                 measurement_name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 ojdbc_file_secret_id: Optional[pulumi.Input[str]] = None,
                 password_secret_id: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 tnsnames_file_secret_id: Optional[pulumi.Input[str]] = None,
                 truststore_file_secret_id: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 version_specific_details: Optional[pulumi.Input['DataAssetDataSourceDetailsVersionSpecificDetailsArgs']] = None,
                 wallet_password_secret_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] data_source_type: Data source type where actually data asset is being stored
        :param pulumi.Input[str] atp_password_secret_id: atp db password Secret Id
        :param pulumi.Input[str] atp_user_name: atp db user name
        :param pulumi.Input[str] bucket: Bucket Name for influx connection
        :param pulumi.Input[str] cwallet_file_secret_id: OCID of the secret containing the containers certificates of ATP wallet
        :param pulumi.Input[str] database_name: DB Name for influx connection
        :param pulumi.Input[str] ewallet_file_secret_id: OCID of the secret containing the PDB'S certificates of ATP wallet
        :param pulumi.Input[str] key_store_file_secret_id: OCID of the secret containing Keystore.jks file of the ATP wallet
        :param pulumi.Input[str] measurement_name: Measurement name for influx
        :param pulumi.Input[str] namespace: Object storage namespace
        :param pulumi.Input[str] object: File name
        :param pulumi.Input[str] ojdbc_file_secret_id: OCID of the secret that contains jdbc properties file of ATP wallet
        :param pulumi.Input[str] password_secret_id: Password Secret Id for the influx connection
        :param pulumi.Input[str] table_name: atp database table name
        :param pulumi.Input[str] tnsnames_file_secret_id: OCID of the secret that contains the tnsnames file of ATP wallet
        :param pulumi.Input[str] truststore_file_secret_id: OCID of the secret containing truststore.jks file of the ATP wallet
        :param pulumi.Input[str] url: public IP address and port to influx DB
        :param pulumi.Input[str] user_name: Username for connection to Influx
        :param pulumi.Input['DataAssetDataSourceDetailsVersionSpecificDetailsArgs'] version_specific_details: Possible data sources
        :param pulumi.Input[str] wallet_password_secret_id: wallet password Secret ID in String format
        """
        DataAssetDataSourceDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            data_source_type=data_source_type,
            atp_password_secret_id=atp_password_secret_id,
            atp_user_name=atp_user_name,
            bucket=bucket,
            cwallet_file_secret_id=cwallet_file_secret_id,
            database_name=database_name,
            ewallet_file_secret_id=ewallet_file_secret_id,
            key_store_file_secret_id=key_store_file_secret_id,
            measurement_name=measurement_name,
            namespace=namespace,
            object=object,
            ojdbc_file_secret_id=ojdbc_file_secret_id,
            password_secret_id=password_secret_id,
            table_name=table_name,
            tnsnames_file_secret_id=tnsnames_file_secret_id,
            truststore_file_secret_id=truststore_file_secret_id,
            url=url,
            user_name=user_name,
            version_specific_details=version_specific_details,
            wallet_password_secret_id=wallet_password_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             data_source_type: pulumi.Input[str],
             atp_password_secret_id: Optional[pulumi.Input[str]] = None,
             atp_user_name: Optional[pulumi.Input[str]] = None,
             bucket: Optional[pulumi.Input[str]] = None,
             cwallet_file_secret_id: Optional[pulumi.Input[str]] = None,
             database_name: Optional[pulumi.Input[str]] = None,
             ewallet_file_secret_id: Optional[pulumi.Input[str]] = None,
             key_store_file_secret_id: Optional[pulumi.Input[str]] = None,
             measurement_name: Optional[pulumi.Input[str]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             object: Optional[pulumi.Input[str]] = None,
             ojdbc_file_secret_id: Optional[pulumi.Input[str]] = None,
             password_secret_id: Optional[pulumi.Input[str]] = None,
             table_name: Optional[pulumi.Input[str]] = None,
             tnsnames_file_secret_id: Optional[pulumi.Input[str]] = None,
             truststore_file_secret_id: Optional[pulumi.Input[str]] = None,
             url: Optional[pulumi.Input[str]] = None,
             user_name: Optional[pulumi.Input[str]] = None,
             version_specific_details: Optional[pulumi.Input['DataAssetDataSourceDetailsVersionSpecificDetailsArgs']] = None,
             wallet_password_secret_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("data_source_type", data_source_type)
        if atp_password_secret_id is not None:
            _setter("atp_password_secret_id", atp_password_secret_id)
        if atp_user_name is not None:
            _setter("atp_user_name", atp_user_name)
        if bucket is not None:
            _setter("bucket", bucket)
        if cwallet_file_secret_id is not None:
            _setter("cwallet_file_secret_id", cwallet_file_secret_id)
        if database_name is not None:
            _setter("database_name", database_name)
        if ewallet_file_secret_id is not None:
            _setter("ewallet_file_secret_id", ewallet_file_secret_id)
        if key_store_file_secret_id is not None:
            _setter("key_store_file_secret_id", key_store_file_secret_id)
        if measurement_name is not None:
            _setter("measurement_name", measurement_name)
        if namespace is not None:
            _setter("namespace", namespace)
        if object is not None:
            _setter("object", object)
        if ojdbc_file_secret_id is not None:
            _setter("ojdbc_file_secret_id", ojdbc_file_secret_id)
        if password_secret_id is not None:
            _setter("password_secret_id", password_secret_id)
        if table_name is not None:
            _setter("table_name", table_name)
        if tnsnames_file_secret_id is not None:
            _setter("tnsnames_file_secret_id", tnsnames_file_secret_id)
        if truststore_file_secret_id is not None:
            _setter("truststore_file_secret_id", truststore_file_secret_id)
        if url is not None:
            _setter("url", url)
        if user_name is not None:
            _setter("user_name", user_name)
        if version_specific_details is not None:
            _setter("version_specific_details", version_specific_details)
        if wallet_password_secret_id is not None:
            _setter("wallet_password_secret_id", wallet_password_secret_id)

    @property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> pulumi.Input[str]:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "data_source_type")

    @data_source_type.setter
    def data_source_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_source_type", value)

    @property
    @pulumi.getter(name="atpPasswordSecretId")
    def atp_password_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        atp db password Secret Id
        """
        return pulumi.get(self, "atp_password_secret_id")

    @atp_password_secret_id.setter
    def atp_password_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "atp_password_secret_id", value)

    @property
    @pulumi.getter(name="atpUserName")
    def atp_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        atp db user name
        """
        return pulumi.get(self, "atp_user_name")

    @atp_user_name.setter
    def atp_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "atp_user_name", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Bucket Name for influx connection
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="cwalletFileSecretId")
    def cwallet_file_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the secret containing the containers certificates of ATP wallet
        """
        return pulumi.get(self, "cwallet_file_secret_id")

    @cwallet_file_secret_id.setter
    def cwallet_file_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cwallet_file_secret_id", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        DB Name for influx connection
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="ewalletFileSecretId")
    def ewallet_file_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the secret containing the PDB'S certificates of ATP wallet
        """
        return pulumi.get(self, "ewallet_file_secret_id")

    @ewallet_file_secret_id.setter
    def ewallet_file_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ewallet_file_secret_id", value)

    @property
    @pulumi.getter(name="keyStoreFileSecretId")
    def key_store_file_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the secret containing Keystore.jks file of the ATP wallet
        """
        return pulumi.get(self, "key_store_file_secret_id")

    @key_store_file_secret_id.setter
    def key_store_file_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_store_file_secret_id", value)

    @property
    @pulumi.getter(name="measurementName")
    def measurement_name(self) -> Optional[pulumi.Input[str]]:
        """
        Measurement name for influx
        """
        return pulumi.get(self, "measurement_name")

    @measurement_name.setter
    def measurement_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "measurement_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        File name
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter(name="ojdbcFileSecretId")
    def ojdbc_file_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the secret that contains jdbc properties file of ATP wallet
        """
        return pulumi.get(self, "ojdbc_file_secret_id")

    @ojdbc_file_secret_id.setter
    def ojdbc_file_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ojdbc_file_secret_id", value)

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        Password Secret Id for the influx connection
        """
        return pulumi.get(self, "password_secret_id")

    @password_secret_id.setter
    def password_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_secret_id", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[str]]:
        """
        atp database table name
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="tnsnamesFileSecretId")
    def tnsnames_file_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the secret that contains the tnsnames file of ATP wallet
        """
        return pulumi.get(self, "tnsnames_file_secret_id")

    @tnsnames_file_secret_id.setter
    def tnsnames_file_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tnsnames_file_secret_id", value)

    @property
    @pulumi.getter(name="truststoreFileSecretId")
    def truststore_file_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the secret containing truststore.jks file of the ATP wallet
        """
        return pulumi.get(self, "truststore_file_secret_id")

    @truststore_file_secret_id.setter
    def truststore_file_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "truststore_file_secret_id", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        public IP address and port to influx DB
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Username for connection to Influx
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="versionSpecificDetails")
    def version_specific_details(self) -> Optional[pulumi.Input['DataAssetDataSourceDetailsVersionSpecificDetailsArgs']]:
        """
        Possible data sources
        """
        return pulumi.get(self, "version_specific_details")

    @version_specific_details.setter
    def version_specific_details(self, value: Optional[pulumi.Input['DataAssetDataSourceDetailsVersionSpecificDetailsArgs']]):
        pulumi.set(self, "version_specific_details", value)

    @property
    @pulumi.getter(name="walletPasswordSecretId")
    def wallet_password_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        wallet password Secret ID in String format
        """
        return pulumi.get(self, "wallet_password_secret_id")

    @wallet_password_secret_id.setter
    def wallet_password_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wallet_password_secret_id", value)


@pulumi.input_type
class DataAssetDataSourceDetailsVersionSpecificDetailsArgs:
    def __init__(__self__, *,
                 influx_version: pulumi.Input[str],
                 bucket: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 organization_name: Optional[pulumi.Input[str]] = None,
                 retention_policy_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] influx_version: Data source type where actually data asset is being stored
        :param pulumi.Input[str] bucket: Bucket Name for influx connection
        :param pulumi.Input[str] database_name: DB Name for influx connection
        :param pulumi.Input[str] organization_name: Org name for the influx db
        :param pulumi.Input[str] retention_policy_name: retention policy is how long the bucket would last
        """
        DataAssetDataSourceDetailsVersionSpecificDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            influx_version=influx_version,
            bucket=bucket,
            database_name=database_name,
            organization_name=organization_name,
            retention_policy_name=retention_policy_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             influx_version: pulumi.Input[str],
             bucket: Optional[pulumi.Input[str]] = None,
             database_name: Optional[pulumi.Input[str]] = None,
             organization_name: Optional[pulumi.Input[str]] = None,
             retention_policy_name: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("influx_version", influx_version)
        if bucket is not None:
            _setter("bucket", bucket)
        if database_name is not None:
            _setter("database_name", database_name)
        if organization_name is not None:
            _setter("organization_name", organization_name)
        if retention_policy_name is not None:
            _setter("retention_policy_name", retention_policy_name)

    @property
    @pulumi.getter(name="influxVersion")
    def influx_version(self) -> pulumi.Input[str]:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "influx_version")

    @influx_version.setter
    def influx_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "influx_version", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Bucket Name for influx connection
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        DB Name for influx connection
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[pulumi.Input[str]]:
        """
        Org name for the influx db
        """
        return pulumi.get(self, "organization_name")

    @organization_name.setter
    def organization_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_name", value)

    @property
    @pulumi.getter(name="retentionPolicyName")
    def retention_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        retention policy is how long the bucket would last
        """
        return pulumi.get(self, "retention_policy_name")

    @retention_policy_name.setter
    def retention_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_policy_name", value)


@pulumi.input_type
class DetectAnomalyJobInputDetailsArgs:
    def __init__(__self__, *,
                 input_type: pulumi.Input[str],
                 content: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 datas: Optional[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsDataArgs']]]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 object_locations: Optional[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsObjectLocationArgs']]]] = None,
                 signal_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] input_type: Type of request. This parameter is automatically populated by classes generated by the SDK. For raw curl requests, you must provide this field.
        :param pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsDataArgs']]] datas: Array containing data.
        :param pulumi.Input[str] message: Inline input details.
        :param pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsObjectLocationArgs']]] object_locations: List of ObjectLocations.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] signal_names: List of signal names.
        """
        DetectAnomalyJobInputDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            input_type=input_type,
            content=content,
            content_type=content_type,
            datas=datas,
            message=message,
            object_locations=object_locations,
            signal_names=signal_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             input_type: pulumi.Input[str],
             content: Optional[pulumi.Input[str]] = None,
             content_type: Optional[pulumi.Input[str]] = None,
             datas: Optional[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsDataArgs']]]] = None,
             message: Optional[pulumi.Input[str]] = None,
             object_locations: Optional[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsObjectLocationArgs']]]] = None,
             signal_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("input_type", input_type)
        if content is not None:
            _setter("content", content)
        if content_type is not None:
            _setter("content_type", content_type)
        if datas is not None:
            _setter("datas", datas)
        if message is not None:
            _setter("message", message)
        if object_locations is not None:
            _setter("object_locations", object_locations)
        if signal_names is not None:
            _setter("signal_names", signal_names)

    @property
    @pulumi.getter(name="inputType")
    def input_type(self) -> pulumi.Input[str]:
        """
        Type of request. This parameter is automatically populated by classes generated by the SDK. For raw curl requests, you must provide this field.
        """
        return pulumi.get(self, "input_type")

    @input_type.setter
    def input_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_type", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsDataArgs']]]]:
        """
        Array containing data.
        """
        return pulumi.get(self, "datas")

    @datas.setter
    def datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsDataArgs']]]]):
        pulumi.set(self, "datas", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Inline input details.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsObjectLocationArgs']]]]:
        """
        List of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")

    @object_locations.setter
    def object_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectAnomalyJobInputDetailsObjectLocationArgs']]]]):
        pulumi.set(self, "object_locations", value)

    @property
    @pulumi.getter(name="signalNames")
    def signal_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of signal names.
        """
        return pulumi.get(self, "signal_names")

    @signal_names.setter
    def signal_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "signal_names", value)


@pulumi.input_type
class DetectAnomalyJobInputDetailsDataArgs:
    def __init__(__self__, *,
                 timestamp: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]] = None):
        """
        :param pulumi.Input[str] timestamp: Nullable string representing timestamp.
        :param pulumi.Input[Sequence[pulumi.Input[float]]] values: Array of double precision values.
        """
        DetectAnomalyJobInputDetailsDataArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            timestamp=timestamp,
            values=values,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             timestamp: Optional[pulumi.Input[str]] = None,
             values: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if timestamp is not None:
            _setter("timestamp", timestamp)
        if values is not None:
            _setter("values", values)

    @property
    @pulumi.getter
    def timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Nullable string representing timestamp.
        """
        return pulumi.get(self, "timestamp")

    @timestamp.setter
    def timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[float]]]]:
        """
        Array of double precision values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class DetectAnomalyJobInputDetailsObjectLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Object Storage bucket name.
        :param pulumi.Input[str] namespace: Object Storage namespace.
        :param pulumi.Input[str] object: Object Storage object name.
        """
        DetectAnomalyJobInputDetailsObjectLocationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            object=object,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: Optional[pulumi.Input[str]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             object: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if bucket is not None:
            _setter("bucket", bucket)
        if namespace is not None:
            _setter("namespace", namespace)
        if object is not None:
            _setter("object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Object Storage object name.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class DetectAnomalyJobOutputDetailsArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 output_type: pulumi.Input[str],
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Object Storage bucket name.
        :param pulumi.Input[str] namespace: Object Storage namespace.
        :param pulumi.Input[str] output_type: The type of output location. Allowed values are:
        :param pulumi.Input[str] prefix: Object Storage folder name.
        """
        DetectAnomalyJobOutputDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            output_type=output_type,
            prefix=prefix,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: pulumi.Input[str],
             namespace: pulumi.Input[str],
             output_type: pulumi.Input[str],
             prefix: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)
        _setter("output_type", output_type)
        if prefix is not None:
            _setter("prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> pulumi.Input[str]:
        """
        The type of output location. Allowed values are:
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "output_type", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Object Storage folder name.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class ModelModelTrainingDetailsArgs:
    def __init__(__self__, *,
                 data_asset_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 algorithm_hint: Optional[pulumi.Input[str]] = None,
                 target_fap: Optional[pulumi.Input[float]] = None,
                 training_fraction: Optional[pulumi.Input[float]] = None,
                 window_size: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] data_asset_ids: The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        :param pulumi.Input[str] algorithm_hint: User can choose specific algorithm for training.
        :param pulumi.Input[float] target_fap: A target model accuracy metric user provides as their requirement
        :param pulumi.Input[float] training_fraction: Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        :param pulumi.Input[int] window_size: This value would determine the window size of the training algorithm.
        """
        ModelModelTrainingDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            data_asset_ids=data_asset_ids,
            algorithm_hint=algorithm_hint,
            target_fap=target_fap,
            training_fraction=training_fraction,
            window_size=window_size,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             data_asset_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
             algorithm_hint: Optional[pulumi.Input[str]] = None,
             target_fap: Optional[pulumi.Input[float]] = None,
             training_fraction: Optional[pulumi.Input[float]] = None,
             window_size: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("data_asset_ids", data_asset_ids)
        if algorithm_hint is not None:
            _setter("algorithm_hint", algorithm_hint)
        if target_fap is not None:
            _setter("target_fap", target_fap)
        if training_fraction is not None:
            _setter("training_fraction", training_fraction)
        if window_size is not None:
            _setter("window_size", window_size)

    @property
    @pulumi.getter(name="dataAssetIds")
    def data_asset_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        """
        return pulumi.get(self, "data_asset_ids")

    @data_asset_ids.setter
    def data_asset_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "data_asset_ids", value)

    @property
    @pulumi.getter(name="algorithmHint")
    def algorithm_hint(self) -> Optional[pulumi.Input[str]]:
        """
        User can choose specific algorithm for training.
        """
        return pulumi.get(self, "algorithm_hint")

    @algorithm_hint.setter
    def algorithm_hint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "algorithm_hint", value)

    @property
    @pulumi.getter(name="targetFap")
    def target_fap(self) -> Optional[pulumi.Input[float]]:
        """
        A target model accuracy metric user provides as their requirement
        """
        return pulumi.get(self, "target_fap")

    @target_fap.setter
    def target_fap(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "target_fap", value)

    @property
    @pulumi.getter(name="trainingFraction")
    def training_fraction(self) -> Optional[pulumi.Input[float]]:
        """
        Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        """
        return pulumi.get(self, "training_fraction")

    @training_fraction.setter
    def training_fraction(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "training_fraction", value)

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[pulumi.Input[int]]:
        """
        This value would determine the window size of the training algorithm.
        """
        return pulumi.get(self, "window_size")

    @window_size.setter
    def window_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "window_size", value)


@pulumi.input_type
class ModelModelTrainingResultArgs:
    def __init__(__self__, *,
                 fap: Optional[pulumi.Input[float]] = None,
                 is_training_goal_achieved: Optional[pulumi.Input[bool]] = None,
                 mae: Optional[pulumi.Input[float]] = None,
                 max_inference_sync_rows: Optional[pulumi.Input[int]] = None,
                 multivariate_fap: Optional[pulumi.Input[float]] = None,
                 rmse: Optional[pulumi.Input[float]] = None,
                 row_reduction_details: Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultRowReductionDetailArgs']]]] = None,
                 signal_details: Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultSignalDetailArgs']]]] = None,
                 warning: Optional[pulumi.Input[str]] = None,
                 window_size: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[float] fap: Accuracy metric for a signal.
        :param pulumi.Input[bool] is_training_goal_achieved: A boolean value to indicate if train goal/targetFap is achieved for trained model
        :param pulumi.Input[float] multivariate_fap: The model accuracy metric on timestamp level.
        :param pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultRowReductionDetailArgs']]] row_reduction_details: Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        :param pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultSignalDetailArgs']]] signal_details: The list of signal details.
        :param pulumi.Input[str] warning: A warning message to explain the reason when targetFap cannot be achieved for trained model
        :param pulumi.Input[int] window_size: This value would determine the window size of the training algorithm.
        """
        ModelModelTrainingResultArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            fap=fap,
            is_training_goal_achieved=is_training_goal_achieved,
            mae=mae,
            max_inference_sync_rows=max_inference_sync_rows,
            multivariate_fap=multivariate_fap,
            rmse=rmse,
            row_reduction_details=row_reduction_details,
            signal_details=signal_details,
            warning=warning,
            window_size=window_size,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             fap: Optional[pulumi.Input[float]] = None,
             is_training_goal_achieved: Optional[pulumi.Input[bool]] = None,
             mae: Optional[pulumi.Input[float]] = None,
             max_inference_sync_rows: Optional[pulumi.Input[int]] = None,
             multivariate_fap: Optional[pulumi.Input[float]] = None,
             rmse: Optional[pulumi.Input[float]] = None,
             row_reduction_details: Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultRowReductionDetailArgs']]]] = None,
             signal_details: Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultSignalDetailArgs']]]] = None,
             warning: Optional[pulumi.Input[str]] = None,
             window_size: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if fap is not None:
            _setter("fap", fap)
        if is_training_goal_achieved is not None:
            _setter("is_training_goal_achieved", is_training_goal_achieved)
        if mae is not None:
            _setter("mae", mae)
        if max_inference_sync_rows is not None:
            _setter("max_inference_sync_rows", max_inference_sync_rows)
        if multivariate_fap is not None:
            _setter("multivariate_fap", multivariate_fap)
        if rmse is not None:
            _setter("rmse", rmse)
        if row_reduction_details is not None:
            _setter("row_reduction_details", row_reduction_details)
        if signal_details is not None:
            _setter("signal_details", signal_details)
        if warning is not None:
            _setter("warning", warning)
        if window_size is not None:
            _setter("window_size", window_size)

    @property
    @pulumi.getter
    def fap(self) -> Optional[pulumi.Input[float]]:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @fap.setter
    def fap(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "fap", value)

    @property
    @pulumi.getter(name="isTrainingGoalAchieved")
    def is_training_goal_achieved(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value to indicate if train goal/targetFap is achieved for trained model
        """
        return pulumi.get(self, "is_training_goal_achieved")

    @is_training_goal_achieved.setter
    def is_training_goal_achieved(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_training_goal_achieved", value)

    @property
    @pulumi.getter
    def mae(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "mae")

    @mae.setter
    def mae(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "mae", value)

    @property
    @pulumi.getter(name="maxInferenceSyncRows")
    def max_inference_sync_rows(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_inference_sync_rows")

    @max_inference_sync_rows.setter
    def max_inference_sync_rows(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_inference_sync_rows", value)

    @property
    @pulumi.getter(name="multivariateFap")
    def multivariate_fap(self) -> Optional[pulumi.Input[float]]:
        """
        The model accuracy metric on timestamp level.
        """
        return pulumi.get(self, "multivariate_fap")

    @multivariate_fap.setter
    def multivariate_fap(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "multivariate_fap", value)

    @property
    @pulumi.getter
    def rmse(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "rmse")

    @rmse.setter
    def rmse(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "rmse", value)

    @property
    @pulumi.getter(name="rowReductionDetails")
    def row_reduction_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultRowReductionDetailArgs']]]]:
        """
        Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        """
        return pulumi.get(self, "row_reduction_details")

    @row_reduction_details.setter
    def row_reduction_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultRowReductionDetailArgs']]]]):
        pulumi.set(self, "row_reduction_details", value)

    @property
    @pulumi.getter(name="signalDetails")
    def signal_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultSignalDetailArgs']]]]:
        """
        The list of signal details.
        """
        return pulumi.get(self, "signal_details")

    @signal_details.setter
    def signal_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelModelTrainingResultSignalDetailArgs']]]]):
        pulumi.set(self, "signal_details", value)

    @property
    @pulumi.getter
    def warning(self) -> Optional[pulumi.Input[str]]:
        """
        A warning message to explain the reason when targetFap cannot be achieved for trained model
        """
        return pulumi.get(self, "warning")

    @warning.setter
    def warning(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warning", value)

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[pulumi.Input[int]]:
        """
        This value would determine the window size of the training algorithm.
        """
        return pulumi.get(self, "window_size")

    @window_size.setter
    def window_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "window_size", value)


@pulumi.input_type
class ModelModelTrainingResultRowReductionDetailArgs:
    def __init__(__self__, *,
                 is_reduction_enabled: Optional[pulumi.Input[bool]] = None,
                 reduction_method: Optional[pulumi.Input[str]] = None,
                 reduction_percentage: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[bool] is_reduction_enabled: A boolean value to indicate if row reduction is applied
        :param pulumi.Input[str] reduction_method: Method for row reduction:
               * DELETE_ROW - delete rows with equal intervals
               * AVERAGE_ROW - average multiple rows to one row
        :param pulumi.Input[float] reduction_percentage: A percentage to reduce data size down to on top of original data
        """
        ModelModelTrainingResultRowReductionDetailArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_reduction_enabled=is_reduction_enabled,
            reduction_method=reduction_method,
            reduction_percentage=reduction_percentage,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_reduction_enabled: Optional[pulumi.Input[bool]] = None,
             reduction_method: Optional[pulumi.Input[str]] = None,
             reduction_percentage: Optional[pulumi.Input[float]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if is_reduction_enabled is not None:
            _setter("is_reduction_enabled", is_reduction_enabled)
        if reduction_method is not None:
            _setter("reduction_method", reduction_method)
        if reduction_percentage is not None:
            _setter("reduction_percentage", reduction_percentage)

    @property
    @pulumi.getter(name="isReductionEnabled")
    def is_reduction_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value to indicate if row reduction is applied
        """
        return pulumi.get(self, "is_reduction_enabled")

    @is_reduction_enabled.setter
    def is_reduction_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_reduction_enabled", value)

    @property
    @pulumi.getter(name="reductionMethod")
    def reduction_method(self) -> Optional[pulumi.Input[str]]:
        """
        Method for row reduction:
        * DELETE_ROW - delete rows with equal intervals
        * AVERAGE_ROW - average multiple rows to one row
        """
        return pulumi.get(self, "reduction_method")

    @reduction_method.setter
    def reduction_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reduction_method", value)

    @property
    @pulumi.getter(name="reductionPercentage")
    def reduction_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        A percentage to reduce data size down to on top of original data
        """
        return pulumi.get(self, "reduction_percentage")

    @reduction_percentage.setter
    def reduction_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "reduction_percentage", value)


@pulumi.input_type
class ModelModelTrainingResultSignalDetailArgs:
    def __init__(__self__, *,
                 details: Optional[pulumi.Input[str]] = None,
                 fap: Optional[pulumi.Input[float]] = None,
                 is_quantized: Optional[pulumi.Input[bool]] = None,
                 max: Optional[pulumi.Input[float]] = None,
                 min: Optional[pulumi.Input[float]] = None,
                 mvi_ratio: Optional[pulumi.Input[float]] = None,
                 signal_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 std: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] details: detailed information for a signal.
        :param pulumi.Input[float] fap: Accuracy metric for a signal.
        :param pulumi.Input[bool] is_quantized: A boolean value to indicate if a signal is quantized or not.
        :param pulumi.Input[float] max: Max value within a signal.
        :param pulumi.Input[float] min: Min value within a signal.
        :param pulumi.Input[float] mvi_ratio: The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        :param pulumi.Input[str] signal_name: The name of a signal.
        :param pulumi.Input[str] status: Status of the signal:
               * ACCEPTED - the signal is used for training the model
               * DROPPED - the signal does not meet requirement, and is dropped before training the model.
               * OTHER - placeholder for other status
        :param pulumi.Input[float] std: Standard deviation of values within a signal.
        """
        ModelModelTrainingResultSignalDetailArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            details=details,
            fap=fap,
            is_quantized=is_quantized,
            max=max,
            min=min,
            mvi_ratio=mvi_ratio,
            signal_name=signal_name,
            status=status,
            std=std,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             details: Optional[pulumi.Input[str]] = None,
             fap: Optional[pulumi.Input[float]] = None,
             is_quantized: Optional[pulumi.Input[bool]] = None,
             max: Optional[pulumi.Input[float]] = None,
             min: Optional[pulumi.Input[float]] = None,
             mvi_ratio: Optional[pulumi.Input[float]] = None,
             signal_name: Optional[pulumi.Input[str]] = None,
             status: Optional[pulumi.Input[str]] = None,
             std: Optional[pulumi.Input[float]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if details is not None:
            _setter("details", details)
        if fap is not None:
            _setter("fap", fap)
        if is_quantized is not None:
            _setter("is_quantized", is_quantized)
        if max is not None:
            _setter("max", max)
        if min is not None:
            _setter("min", min)
        if mvi_ratio is not None:
            _setter("mvi_ratio", mvi_ratio)
        if signal_name is not None:
            _setter("signal_name", signal_name)
        if status is not None:
            _setter("status", status)
        if std is not None:
            _setter("std", std)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[str]]:
        """
        detailed information for a signal.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def fap(self) -> Optional[pulumi.Input[float]]:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @fap.setter
    def fap(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "fap", value)

    @property
    @pulumi.getter(name="isQuantized")
    def is_quantized(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value to indicate if a signal is quantized or not.
        """
        return pulumi.get(self, "is_quantized")

    @is_quantized.setter
    def is_quantized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_quantized", value)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[float]]:
        """
        Max value within a signal.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[float]]:
        """
        Min value within a signal.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "min", value)

    @property
    @pulumi.getter(name="mviRatio")
    def mvi_ratio(self) -> Optional[pulumi.Input[float]]:
        """
        The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        """
        return pulumi.get(self, "mvi_ratio")

    @mvi_ratio.setter
    def mvi_ratio(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "mvi_ratio", value)

    @property
    @pulumi.getter(name="signalName")
    def signal_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a signal.
        """
        return pulumi.get(self, "signal_name")

    @signal_name.setter
    def signal_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signal_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the signal:
        * ACCEPTED - the signal is used for training the model
        * DROPPED - the signal does not meet requirement, and is dropped before training the model.
        * OTHER - placeholder for other status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def std(self) -> Optional[pulumi.Input[float]]:
        """
        Standard deviation of values within a signal.
        """
        return pulumi.get(self, "std")

    @std.setter
    def std(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "std", value)


@pulumi.input_type
class GetAiPrivateEndpointsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetAiPrivateEndpointsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetDetectAnomalyJobsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDetectAnomalyJobsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetDetectionDataAssetsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDetectionDataAssetsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetDetectionModelsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDetectionModelsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetDetectionProjectsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDetectionProjectsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


