# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DataAssetDataSourceDetails',
    'DataAssetDataSourceDetailsVersionSpecificDetails',
    'DetectAnomalyJobInputDetails',
    'DetectAnomalyJobInputDetailsData',
    'DetectAnomalyJobInputDetailsObjectLocation',
    'DetectAnomalyJobOutputDetails',
    'ModelModelTrainingDetails',
    'ModelModelTrainingResult',
    'ModelModelTrainingResultRowReductionDetail',
    'ModelModelTrainingResultSignalDetail',
    'GetAiPrivateEndpointsAiPrivateEndpointCollectionResult',
    'GetAiPrivateEndpointsAiPrivateEndpointCollectionItemResult',
    'GetAiPrivateEndpointsFilterResult',
    'GetDetectAnomalyJobInputDetailResult',
    'GetDetectAnomalyJobInputDetailDataResult',
    'GetDetectAnomalyJobInputDetailObjectLocationResult',
    'GetDetectAnomalyJobOutputDetailResult',
    'GetDetectAnomalyJobsDetectAnomalyJobCollectionResult',
    'GetDetectAnomalyJobsDetectAnomalyJobCollectionItemResult',
    'GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailResult',
    'GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailDataResult',
    'GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailObjectLocationResult',
    'GetDetectAnomalyJobsDetectAnomalyJobCollectionItemOutputDetailResult',
    'GetDetectAnomalyJobsFilterResult',
    'GetDetectionDataAssetDataSourceDetailResult',
    'GetDetectionDataAssetDataSourceDetailVersionSpecificDetailResult',
    'GetDetectionDataAssetsDataAssetCollectionResult',
    'GetDetectionDataAssetsDataAssetCollectionItemResult',
    'GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailResult',
    'GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailVersionSpecificDetailResult',
    'GetDetectionDataAssetsFilterResult',
    'GetDetectionModelModelTrainingDetailResult',
    'GetDetectionModelModelTrainingResultResult',
    'GetDetectionModelModelTrainingResultRowReductionDetailResult',
    'GetDetectionModelModelTrainingResultSignalDetailResult',
    'GetDetectionModelsFilterResult',
    'GetDetectionModelsModelCollectionResult',
    'GetDetectionModelsModelCollectionItemResult',
    'GetDetectionModelsModelCollectionItemModelTrainingDetailResult',
    'GetDetectionModelsModelCollectionItemModelTrainingResultResult',
    'GetDetectionModelsModelCollectionItemModelTrainingResultRowReductionDetailResult',
    'GetDetectionModelsModelCollectionItemModelTrainingResultSignalDetailResult',
    'GetDetectionProjectsFilterResult',
    'GetDetectionProjectsProjectCollectionResult',
    'GetDetectionProjectsProjectCollectionItemResult',
]

@pulumi.output_type
class DataAssetDataSourceDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSourceType":
            suggest = "data_source_type"
        elif key == "atpPasswordSecretId":
            suggest = "atp_password_secret_id"
        elif key == "atpUserName":
            suggest = "atp_user_name"
        elif key == "cwalletFileSecretId":
            suggest = "cwallet_file_secret_id"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "ewalletFileSecretId":
            suggest = "ewallet_file_secret_id"
        elif key == "keyStoreFileSecretId":
            suggest = "key_store_file_secret_id"
        elif key == "measurementName":
            suggest = "measurement_name"
        elif key == "ojdbcFileSecretId":
            suggest = "ojdbc_file_secret_id"
        elif key == "passwordSecretId":
            suggest = "password_secret_id"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "tnsnamesFileSecretId":
            suggest = "tnsnames_file_secret_id"
        elif key == "truststoreFileSecretId":
            suggest = "truststore_file_secret_id"
        elif key == "userName":
            suggest = "user_name"
        elif key == "versionSpecificDetails":
            suggest = "version_specific_details"
        elif key == "walletPasswordSecretId":
            suggest = "wallet_password_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataAssetDataSourceDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataAssetDataSourceDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataAssetDataSourceDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source_type: str,
                 atp_password_secret_id: Optional[str] = None,
                 atp_user_name: Optional[str] = None,
                 bucket: Optional[str] = None,
                 cwallet_file_secret_id: Optional[str] = None,
                 database_name: Optional[str] = None,
                 ewallet_file_secret_id: Optional[str] = None,
                 key_store_file_secret_id: Optional[str] = None,
                 measurement_name: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None,
                 ojdbc_file_secret_id: Optional[str] = None,
                 password_secret_id: Optional[str] = None,
                 table_name: Optional[str] = None,
                 tnsnames_file_secret_id: Optional[str] = None,
                 truststore_file_secret_id: Optional[str] = None,
                 url: Optional[str] = None,
                 user_name: Optional[str] = None,
                 version_specific_details: Optional['outputs.DataAssetDataSourceDetailsVersionSpecificDetails'] = None,
                 wallet_password_secret_id: Optional[str] = None):
        """
        :param str data_source_type: Data source type where actually data asset is being stored
        :param str atp_password_secret_id: atp db password Secret Id
        :param str atp_user_name: atp db user name
        :param str bucket: Bucket Name for influx connection
        :param str cwallet_file_secret_id: OCID of the secret containing the containers certificates of ATP wallet
        :param str database_name: DB Name for influx connection
        :param str ewallet_file_secret_id: OCID of the secret containing the PDB'S certificates of ATP wallet
        :param str key_store_file_secret_id: OCID of the secret containing Keystore.jks file of the ATP wallet
        :param str measurement_name: Measurement name for influx
        :param str namespace: Object storage namespace
        :param str object: File name
        :param str ojdbc_file_secret_id: OCID of the secret that contains jdbc properties file of ATP wallet
        :param str password_secret_id: Password Secret Id for the influx connection
        :param str table_name: atp database table name
        :param str tnsnames_file_secret_id: OCID of the secret that contains the tnsnames file of ATP wallet
        :param str truststore_file_secret_id: OCID of the secret containing truststore.jks file of the ATP wallet
        :param str url: public IP address and port to influx DB
        :param str user_name: Username for connection to Influx
        :param 'DataAssetDataSourceDetailsVersionSpecificDetailsArgs' version_specific_details: Possible data sources
        :param str wallet_password_secret_id: wallet password Secret ID in String format
        """
        DataAssetDataSourceDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            data_source_type=data_source_type,
            atp_password_secret_id=atp_password_secret_id,
            atp_user_name=atp_user_name,
            bucket=bucket,
            cwallet_file_secret_id=cwallet_file_secret_id,
            database_name=database_name,
            ewallet_file_secret_id=ewallet_file_secret_id,
            key_store_file_secret_id=key_store_file_secret_id,
            measurement_name=measurement_name,
            namespace=namespace,
            object=object,
            ojdbc_file_secret_id=ojdbc_file_secret_id,
            password_secret_id=password_secret_id,
            table_name=table_name,
            tnsnames_file_secret_id=tnsnames_file_secret_id,
            truststore_file_secret_id=truststore_file_secret_id,
            url=url,
            user_name=user_name,
            version_specific_details=version_specific_details,
            wallet_password_secret_id=wallet_password_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             data_source_type: str,
             atp_password_secret_id: Optional[str] = None,
             atp_user_name: Optional[str] = None,
             bucket: Optional[str] = None,
             cwallet_file_secret_id: Optional[str] = None,
             database_name: Optional[str] = None,
             ewallet_file_secret_id: Optional[str] = None,
             key_store_file_secret_id: Optional[str] = None,
             measurement_name: Optional[str] = None,
             namespace: Optional[str] = None,
             object: Optional[str] = None,
             ojdbc_file_secret_id: Optional[str] = None,
             password_secret_id: Optional[str] = None,
             table_name: Optional[str] = None,
             tnsnames_file_secret_id: Optional[str] = None,
             truststore_file_secret_id: Optional[str] = None,
             url: Optional[str] = None,
             user_name: Optional[str] = None,
             version_specific_details: Optional['outputs.DataAssetDataSourceDetailsVersionSpecificDetails'] = None,
             wallet_password_secret_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("data_source_type", data_source_type)
        if atp_password_secret_id is not None:
            _setter("atp_password_secret_id", atp_password_secret_id)
        if atp_user_name is not None:
            _setter("atp_user_name", atp_user_name)
        if bucket is not None:
            _setter("bucket", bucket)
        if cwallet_file_secret_id is not None:
            _setter("cwallet_file_secret_id", cwallet_file_secret_id)
        if database_name is not None:
            _setter("database_name", database_name)
        if ewallet_file_secret_id is not None:
            _setter("ewallet_file_secret_id", ewallet_file_secret_id)
        if key_store_file_secret_id is not None:
            _setter("key_store_file_secret_id", key_store_file_secret_id)
        if measurement_name is not None:
            _setter("measurement_name", measurement_name)
        if namespace is not None:
            _setter("namespace", namespace)
        if object is not None:
            _setter("object", object)
        if ojdbc_file_secret_id is not None:
            _setter("ojdbc_file_secret_id", ojdbc_file_secret_id)
        if password_secret_id is not None:
            _setter("password_secret_id", password_secret_id)
        if table_name is not None:
            _setter("table_name", table_name)
        if tnsnames_file_secret_id is not None:
            _setter("tnsnames_file_secret_id", tnsnames_file_secret_id)
        if truststore_file_secret_id is not None:
            _setter("truststore_file_secret_id", truststore_file_secret_id)
        if url is not None:
            _setter("url", url)
        if user_name is not None:
            _setter("user_name", user_name)
        if version_specific_details is not None:
            _setter("version_specific_details", version_specific_details)
        if wallet_password_secret_id is not None:
            _setter("wallet_password_secret_id", wallet_password_secret_id)

    @property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> str:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "data_source_type")

    @property
    @pulumi.getter(name="atpPasswordSecretId")
    def atp_password_secret_id(self) -> Optional[str]:
        """
        atp db password Secret Id
        """
        return pulumi.get(self, "atp_password_secret_id")

    @property
    @pulumi.getter(name="atpUserName")
    def atp_user_name(self) -> Optional[str]:
        """
        atp db user name
        """
        return pulumi.get(self, "atp_user_name")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Bucket Name for influx connection
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="cwalletFileSecretId")
    def cwallet_file_secret_id(self) -> Optional[str]:
        """
        OCID of the secret containing the containers certificates of ATP wallet
        """
        return pulumi.get(self, "cwallet_file_secret_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        DB Name for influx connection
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="ewalletFileSecretId")
    def ewallet_file_secret_id(self) -> Optional[str]:
        """
        OCID of the secret containing the PDB'S certificates of ATP wallet
        """
        return pulumi.get(self, "ewallet_file_secret_id")

    @property
    @pulumi.getter(name="keyStoreFileSecretId")
    def key_store_file_secret_id(self) -> Optional[str]:
        """
        OCID of the secret containing Keystore.jks file of the ATP wallet
        """
        return pulumi.get(self, "key_store_file_secret_id")

    @property
    @pulumi.getter(name="measurementName")
    def measurement_name(self) -> Optional[str]:
        """
        Measurement name for influx
        """
        return pulumi.get(self, "measurement_name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        File name
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="ojdbcFileSecretId")
    def ojdbc_file_secret_id(self) -> Optional[str]:
        """
        OCID of the secret that contains jdbc properties file of ATP wallet
        """
        return pulumi.get(self, "ojdbc_file_secret_id")

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> Optional[str]:
        """
        Password Secret Id for the influx connection
        """
        return pulumi.get(self, "password_secret_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[str]:
        """
        atp database table name
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="tnsnamesFileSecretId")
    def tnsnames_file_secret_id(self) -> Optional[str]:
        """
        OCID of the secret that contains the tnsnames file of ATP wallet
        """
        return pulumi.get(self, "tnsnames_file_secret_id")

    @property
    @pulumi.getter(name="truststoreFileSecretId")
    def truststore_file_secret_id(self) -> Optional[str]:
        """
        OCID of the secret containing truststore.jks file of the ATP wallet
        """
        return pulumi.get(self, "truststore_file_secret_id")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        public IP address and port to influx DB
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        Username for connection to Influx
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="versionSpecificDetails")
    def version_specific_details(self) -> Optional['outputs.DataAssetDataSourceDetailsVersionSpecificDetails']:
        """
        Possible data sources
        """
        return pulumi.get(self, "version_specific_details")

    @property
    @pulumi.getter(name="walletPasswordSecretId")
    def wallet_password_secret_id(self) -> Optional[str]:
        """
        wallet password Secret ID in String format
        """
        return pulumi.get(self, "wallet_password_secret_id")


@pulumi.output_type
class DataAssetDataSourceDetailsVersionSpecificDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "influxVersion":
            suggest = "influx_version"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "organizationName":
            suggest = "organization_name"
        elif key == "retentionPolicyName":
            suggest = "retention_policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataAssetDataSourceDetailsVersionSpecificDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataAssetDataSourceDetailsVersionSpecificDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataAssetDataSourceDetailsVersionSpecificDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 influx_version: str,
                 bucket: Optional[str] = None,
                 database_name: Optional[str] = None,
                 organization_name: Optional[str] = None,
                 retention_policy_name: Optional[str] = None):
        """
        :param str influx_version: Data source type where actually data asset is being stored
        :param str bucket: Bucket Name for influx connection
        :param str database_name: DB Name for influx connection
        :param str organization_name: Org name for the influx db
        :param str retention_policy_name: retention policy is how long the bucket would last
        """
        DataAssetDataSourceDetailsVersionSpecificDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            influx_version=influx_version,
            bucket=bucket,
            database_name=database_name,
            organization_name=organization_name,
            retention_policy_name=retention_policy_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             influx_version: str,
             bucket: Optional[str] = None,
             database_name: Optional[str] = None,
             organization_name: Optional[str] = None,
             retention_policy_name: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("influx_version", influx_version)
        if bucket is not None:
            _setter("bucket", bucket)
        if database_name is not None:
            _setter("database_name", database_name)
        if organization_name is not None:
            _setter("organization_name", organization_name)
        if retention_policy_name is not None:
            _setter("retention_policy_name", retention_policy_name)

    @property
    @pulumi.getter(name="influxVersion")
    def influx_version(self) -> str:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "influx_version")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Bucket Name for influx connection
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        DB Name for influx connection
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[str]:
        """
        Org name for the influx db
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="retentionPolicyName")
    def retention_policy_name(self) -> Optional[str]:
        """
        retention policy is how long the bucket would last
        """
        return pulumi.get(self, "retention_policy_name")


@pulumi.output_type
class DetectAnomalyJobInputDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputType":
            suggest = "input_type"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "objectLocations":
            suggest = "object_locations"
        elif key == "signalNames":
            suggest = "signal_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectAnomalyJobInputDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectAnomalyJobInputDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectAnomalyJobInputDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_type: str,
                 content: Optional[str] = None,
                 content_type: Optional[str] = None,
                 datas: Optional[Sequence['outputs.DetectAnomalyJobInputDetailsData']] = None,
                 message: Optional[str] = None,
                 object_locations: Optional[Sequence['outputs.DetectAnomalyJobInputDetailsObjectLocation']] = None,
                 signal_names: Optional[Sequence[str]] = None):
        """
        :param str input_type: Type of request. This parameter is automatically populated by classes generated by the SDK. For raw curl requests, you must provide this field.
        :param Sequence['DetectAnomalyJobInputDetailsDataArgs'] datas: Array containing data.
        :param str message: Inline input details.
        :param Sequence['DetectAnomalyJobInputDetailsObjectLocationArgs'] object_locations: List of ObjectLocations.
        :param Sequence[str] signal_names: List of signal names.
        """
        DetectAnomalyJobInputDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            input_type=input_type,
            content=content,
            content_type=content_type,
            datas=datas,
            message=message,
            object_locations=object_locations,
            signal_names=signal_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             input_type: str,
             content: Optional[str] = None,
             content_type: Optional[str] = None,
             datas: Optional[Sequence['outputs.DetectAnomalyJobInputDetailsData']] = None,
             message: Optional[str] = None,
             object_locations: Optional[Sequence['outputs.DetectAnomalyJobInputDetailsObjectLocation']] = None,
             signal_names: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("input_type", input_type)
        if content is not None:
            _setter("content", content)
        if content_type is not None:
            _setter("content_type", content_type)
        if datas is not None:
            _setter("datas", datas)
        if message is not None:
            _setter("message", message)
        if object_locations is not None:
            _setter("object_locations", object_locations)
        if signal_names is not None:
            _setter("signal_names", signal_names)

    @property
    @pulumi.getter(name="inputType")
    def input_type(self) -> str:
        """
        Type of request. This parameter is automatically populated by classes generated by the SDK. For raw curl requests, you must provide this field.
        """
        return pulumi.get(self, "input_type")

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def datas(self) -> Optional[Sequence['outputs.DetectAnomalyJobInputDetailsData']]:
        """
        Array containing data.
        """
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Inline input details.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Optional[Sequence['outputs.DetectAnomalyJobInputDetailsObjectLocation']]:
        """
        List of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")

    @property
    @pulumi.getter(name="signalNames")
    def signal_names(self) -> Optional[Sequence[str]]:
        """
        List of signal names.
        """
        return pulumi.get(self, "signal_names")


@pulumi.output_type
class DetectAnomalyJobInputDetailsData(dict):
    def __init__(__self__, *,
                 timestamp: Optional[str] = None,
                 values: Optional[Sequence[float]] = None):
        """
        :param str timestamp: Nullable string representing timestamp.
        :param Sequence[float] values: Array of double precision values.
        """
        DetectAnomalyJobInputDetailsData._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            timestamp=timestamp,
            values=values,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             timestamp: Optional[str] = None,
             values: Optional[Sequence[float]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if timestamp is not None:
            _setter("timestamp", timestamp)
        if values is not None:
            _setter("values", values)

    @property
    @pulumi.getter
    def timestamp(self) -> Optional[str]:
        """
        Nullable string representing timestamp.
        """
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[float]]:
        """
        Array of double precision values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class DetectAnomalyJobInputDetailsObjectLocation(dict):
    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None):
        """
        :param str bucket: Object Storage bucket name.
        :param str namespace: Object Storage namespace.
        :param str object: Object Storage object name.
        """
        DetectAnomalyJobInputDetailsObjectLocation._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            object=object,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: Optional[str] = None,
             namespace: Optional[str] = None,
             object: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if bucket is not None:
            _setter("bucket", bucket)
        if namespace is not None:
            _setter("namespace", namespace)
        if object is not None:
            _setter("object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        Object Storage object name.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class DetectAnomalyJobOutputDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputType":
            suggest = "output_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectAnomalyJobOutputDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectAnomalyJobOutputDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectAnomalyJobOutputDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 output_type: str,
                 prefix: Optional[str] = None):
        """
        :param str bucket: Object Storage bucket name.
        :param str namespace: Object Storage namespace.
        :param str output_type: The type of output location. Allowed values are:
        :param str prefix: Object Storage folder name.
        """
        DetectAnomalyJobOutputDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            output_type=output_type,
            prefix=prefix,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             namespace: str,
             output_type: str,
             prefix: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)
        _setter("output_type", output_type)
        if prefix is not None:
            _setter("prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> str:
        """
        The type of output location. Allowed values are:
        """
        return pulumi.get(self, "output_type")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object Storage folder name.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class ModelModelTrainingDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataAssetIds":
            suggest = "data_asset_ids"
        elif key == "algorithmHint":
            suggest = "algorithm_hint"
        elif key == "targetFap":
            suggest = "target_fap"
        elif key == "trainingFraction":
            suggest = "training_fraction"
        elif key == "windowSize":
            suggest = "window_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelModelTrainingDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelModelTrainingDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelModelTrainingDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_asset_ids: Sequence[str],
                 algorithm_hint: Optional[str] = None,
                 target_fap: Optional[float] = None,
                 training_fraction: Optional[float] = None,
                 window_size: Optional[int] = None):
        """
        :param Sequence[str] data_asset_ids: The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        :param str algorithm_hint: User can choose specific algorithm for training.
        :param float target_fap: A target model accuracy metric user provides as their requirement
        :param float training_fraction: Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        :param int window_size: This value would determine the window size of the training algorithm.
        """
        ModelModelTrainingDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            data_asset_ids=data_asset_ids,
            algorithm_hint=algorithm_hint,
            target_fap=target_fap,
            training_fraction=training_fraction,
            window_size=window_size,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             data_asset_ids: Sequence[str],
             algorithm_hint: Optional[str] = None,
             target_fap: Optional[float] = None,
             training_fraction: Optional[float] = None,
             window_size: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("data_asset_ids", data_asset_ids)
        if algorithm_hint is not None:
            _setter("algorithm_hint", algorithm_hint)
        if target_fap is not None:
            _setter("target_fap", target_fap)
        if training_fraction is not None:
            _setter("training_fraction", training_fraction)
        if window_size is not None:
            _setter("window_size", window_size)

    @property
    @pulumi.getter(name="dataAssetIds")
    def data_asset_ids(self) -> Sequence[str]:
        """
        The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        """
        return pulumi.get(self, "data_asset_ids")

    @property
    @pulumi.getter(name="algorithmHint")
    def algorithm_hint(self) -> Optional[str]:
        """
        User can choose specific algorithm for training.
        """
        return pulumi.get(self, "algorithm_hint")

    @property
    @pulumi.getter(name="targetFap")
    def target_fap(self) -> Optional[float]:
        """
        A target model accuracy metric user provides as their requirement
        """
        return pulumi.get(self, "target_fap")

    @property
    @pulumi.getter(name="trainingFraction")
    def training_fraction(self) -> Optional[float]:
        """
        Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        """
        return pulumi.get(self, "training_fraction")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[int]:
        """
        This value would determine the window size of the training algorithm.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class ModelModelTrainingResult(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isTrainingGoalAchieved":
            suggest = "is_training_goal_achieved"
        elif key == "maxInferenceSyncRows":
            suggest = "max_inference_sync_rows"
        elif key == "multivariateFap":
            suggest = "multivariate_fap"
        elif key == "rowReductionDetails":
            suggest = "row_reduction_details"
        elif key == "signalDetails":
            suggest = "signal_details"
        elif key == "windowSize":
            suggest = "window_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelModelTrainingResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelModelTrainingResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelModelTrainingResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fap: Optional[float] = None,
                 is_training_goal_achieved: Optional[bool] = None,
                 mae: Optional[float] = None,
                 max_inference_sync_rows: Optional[int] = None,
                 multivariate_fap: Optional[float] = None,
                 rmse: Optional[float] = None,
                 row_reduction_details: Optional[Sequence['outputs.ModelModelTrainingResultRowReductionDetail']] = None,
                 signal_details: Optional[Sequence['outputs.ModelModelTrainingResultSignalDetail']] = None,
                 warning: Optional[str] = None,
                 window_size: Optional[int] = None):
        """
        :param float fap: Accuracy metric for a signal.
        :param bool is_training_goal_achieved: A boolean value to indicate if train goal/targetFap is achieved for trained model
        :param float multivariate_fap: The model accuracy metric on timestamp level.
        :param Sequence['ModelModelTrainingResultRowReductionDetailArgs'] row_reduction_details: Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        :param Sequence['ModelModelTrainingResultSignalDetailArgs'] signal_details: The list of signal details.
        :param str warning: A warning message to explain the reason when targetFap cannot be achieved for trained model
        :param int window_size: This value would determine the window size of the training algorithm.
        """
        ModelModelTrainingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            fap=fap,
            is_training_goal_achieved=is_training_goal_achieved,
            mae=mae,
            max_inference_sync_rows=max_inference_sync_rows,
            multivariate_fap=multivariate_fap,
            rmse=rmse,
            row_reduction_details=row_reduction_details,
            signal_details=signal_details,
            warning=warning,
            window_size=window_size,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             fap: Optional[float] = None,
             is_training_goal_achieved: Optional[bool] = None,
             mae: Optional[float] = None,
             max_inference_sync_rows: Optional[int] = None,
             multivariate_fap: Optional[float] = None,
             rmse: Optional[float] = None,
             row_reduction_details: Optional[Sequence['outputs.ModelModelTrainingResultRowReductionDetail']] = None,
             signal_details: Optional[Sequence['outputs.ModelModelTrainingResultSignalDetail']] = None,
             warning: Optional[str] = None,
             window_size: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if fap is not None:
            _setter("fap", fap)
        if is_training_goal_achieved is not None:
            _setter("is_training_goal_achieved", is_training_goal_achieved)
        if mae is not None:
            _setter("mae", mae)
        if max_inference_sync_rows is not None:
            _setter("max_inference_sync_rows", max_inference_sync_rows)
        if multivariate_fap is not None:
            _setter("multivariate_fap", multivariate_fap)
        if rmse is not None:
            _setter("rmse", rmse)
        if row_reduction_details is not None:
            _setter("row_reduction_details", row_reduction_details)
        if signal_details is not None:
            _setter("signal_details", signal_details)
        if warning is not None:
            _setter("warning", warning)
        if window_size is not None:
            _setter("window_size", window_size)

    @property
    @pulumi.getter
    def fap(self) -> Optional[float]:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @property
    @pulumi.getter(name="isTrainingGoalAchieved")
    def is_training_goal_achieved(self) -> Optional[bool]:
        """
        A boolean value to indicate if train goal/targetFap is achieved for trained model
        """
        return pulumi.get(self, "is_training_goal_achieved")

    @property
    @pulumi.getter
    def mae(self) -> Optional[float]:
        return pulumi.get(self, "mae")

    @property
    @pulumi.getter(name="maxInferenceSyncRows")
    def max_inference_sync_rows(self) -> Optional[int]:
        return pulumi.get(self, "max_inference_sync_rows")

    @property
    @pulumi.getter(name="multivariateFap")
    def multivariate_fap(self) -> Optional[float]:
        """
        The model accuracy metric on timestamp level.
        """
        return pulumi.get(self, "multivariate_fap")

    @property
    @pulumi.getter
    def rmse(self) -> Optional[float]:
        return pulumi.get(self, "rmse")

    @property
    @pulumi.getter(name="rowReductionDetails")
    def row_reduction_details(self) -> Optional[Sequence['outputs.ModelModelTrainingResultRowReductionDetail']]:
        """
        Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        """
        return pulumi.get(self, "row_reduction_details")

    @property
    @pulumi.getter(name="signalDetails")
    def signal_details(self) -> Optional[Sequence['outputs.ModelModelTrainingResultSignalDetail']]:
        """
        The list of signal details.
        """
        return pulumi.get(self, "signal_details")

    @property
    @pulumi.getter
    def warning(self) -> Optional[str]:
        """
        A warning message to explain the reason when targetFap cannot be achieved for trained model
        """
        return pulumi.get(self, "warning")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[int]:
        """
        This value would determine the window size of the training algorithm.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class ModelModelTrainingResultRowReductionDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isReductionEnabled":
            suggest = "is_reduction_enabled"
        elif key == "reductionMethod":
            suggest = "reduction_method"
        elif key == "reductionPercentage":
            suggest = "reduction_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelModelTrainingResultRowReductionDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelModelTrainingResultRowReductionDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelModelTrainingResultRowReductionDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_reduction_enabled: Optional[bool] = None,
                 reduction_method: Optional[str] = None,
                 reduction_percentage: Optional[float] = None):
        """
        :param bool is_reduction_enabled: A boolean value to indicate if row reduction is applied
        :param str reduction_method: Method for row reduction:
               * DELETE_ROW - delete rows with equal intervals
               * AVERAGE_ROW - average multiple rows to one row
        :param float reduction_percentage: A percentage to reduce data size down to on top of original data
        """
        ModelModelTrainingResultRowReductionDetail._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_reduction_enabled=is_reduction_enabled,
            reduction_method=reduction_method,
            reduction_percentage=reduction_percentage,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_reduction_enabled: Optional[bool] = None,
             reduction_method: Optional[str] = None,
             reduction_percentage: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if is_reduction_enabled is not None:
            _setter("is_reduction_enabled", is_reduction_enabled)
        if reduction_method is not None:
            _setter("reduction_method", reduction_method)
        if reduction_percentage is not None:
            _setter("reduction_percentage", reduction_percentage)

    @property
    @pulumi.getter(name="isReductionEnabled")
    def is_reduction_enabled(self) -> Optional[bool]:
        """
        A boolean value to indicate if row reduction is applied
        """
        return pulumi.get(self, "is_reduction_enabled")

    @property
    @pulumi.getter(name="reductionMethod")
    def reduction_method(self) -> Optional[str]:
        """
        Method for row reduction:
        * DELETE_ROW - delete rows with equal intervals
        * AVERAGE_ROW - average multiple rows to one row
        """
        return pulumi.get(self, "reduction_method")

    @property
    @pulumi.getter(name="reductionPercentage")
    def reduction_percentage(self) -> Optional[float]:
        """
        A percentage to reduce data size down to on top of original data
        """
        return pulumi.get(self, "reduction_percentage")


@pulumi.output_type
class ModelModelTrainingResultSignalDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isQuantized":
            suggest = "is_quantized"
        elif key == "mviRatio":
            suggest = "mvi_ratio"
        elif key == "signalName":
            suggest = "signal_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelModelTrainingResultSignalDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelModelTrainingResultSignalDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelModelTrainingResultSignalDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 details: Optional[str] = None,
                 fap: Optional[float] = None,
                 is_quantized: Optional[bool] = None,
                 max: Optional[float] = None,
                 min: Optional[float] = None,
                 mvi_ratio: Optional[float] = None,
                 signal_name: Optional[str] = None,
                 status: Optional[str] = None,
                 std: Optional[float] = None):
        """
        :param str details: detailed information for a signal.
        :param float fap: Accuracy metric for a signal.
        :param bool is_quantized: A boolean value to indicate if a signal is quantized or not.
        :param float max: Max value within a signal.
        :param float min: Min value within a signal.
        :param float mvi_ratio: The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        :param str signal_name: The name of a signal.
        :param str status: Status of the signal:
               * ACCEPTED - the signal is used for training the model
               * DROPPED - the signal does not meet requirement, and is dropped before training the model.
               * OTHER - placeholder for other status
        :param float std: Standard deviation of values within a signal.
        """
        ModelModelTrainingResultSignalDetail._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            details=details,
            fap=fap,
            is_quantized=is_quantized,
            max=max,
            min=min,
            mvi_ratio=mvi_ratio,
            signal_name=signal_name,
            status=status,
            std=std,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             details: Optional[str] = None,
             fap: Optional[float] = None,
             is_quantized: Optional[bool] = None,
             max: Optional[float] = None,
             min: Optional[float] = None,
             mvi_ratio: Optional[float] = None,
             signal_name: Optional[str] = None,
             status: Optional[str] = None,
             std: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if details is not None:
            _setter("details", details)
        if fap is not None:
            _setter("fap", fap)
        if is_quantized is not None:
            _setter("is_quantized", is_quantized)
        if max is not None:
            _setter("max", max)
        if min is not None:
            _setter("min", min)
        if mvi_ratio is not None:
            _setter("mvi_ratio", mvi_ratio)
        if signal_name is not None:
            _setter("signal_name", signal_name)
        if status is not None:
            _setter("status", status)
        if std is not None:
            _setter("std", std)

    @property
    @pulumi.getter
    def details(self) -> Optional[str]:
        """
        detailed information for a signal.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def fap(self) -> Optional[float]:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @property
    @pulumi.getter(name="isQuantized")
    def is_quantized(self) -> Optional[bool]:
        """
        A boolean value to indicate if a signal is quantized or not.
        """
        return pulumi.get(self, "is_quantized")

    @property
    @pulumi.getter
    def max(self) -> Optional[float]:
        """
        Max value within a signal.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[float]:
        """
        Min value within a signal.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter(name="mviRatio")
    def mvi_ratio(self) -> Optional[float]:
        """
        The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        """
        return pulumi.get(self, "mvi_ratio")

    @property
    @pulumi.getter(name="signalName")
    def signal_name(self) -> Optional[str]:
        """
        The name of a signal.
        """
        return pulumi.get(self, "signal_name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of the signal:
        * ACCEPTED - the signal is used for training the model
        * DROPPED - the signal does not meet requirement, and is dropped before training the model.
        * OTHER - placeholder for other status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def std(self) -> Optional[float]:
        """
        Standard deviation of values within a signal.
        """
        return pulumi.get(self, "std")


@pulumi.output_type
class GetAiPrivateEndpointsAiPrivateEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetAiPrivateEndpointsAiPrivateEndpointCollectionItemResult']):
        GetAiPrivateEndpointsAiPrivateEndpointCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetAiPrivateEndpointsAiPrivateEndpointCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAiPrivateEndpointsAiPrivateEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetAiPrivateEndpointsAiPrivateEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 attached_data_assets: Sequence[str],
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 dns_zones: Sequence[str],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_details: str,
                 state: str,
                 subnet_id: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param Sequence[str] attached_data_assets: The list of dataAssets using the private reverse connection endpoint.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Sequence[str] dns_zones: List of DNS zones to be used by the data assets. Example: custpvtsubnet.oraclevcn.com for data asset: db.custpvtsubnet.oraclevcn.com
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: unique AiPrivateEndpoint identifier
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        :param str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param str subnet_id: Subnet Identifier
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time the private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param str time_updated: The time the private endpoint was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        GetAiPrivateEndpointsAiPrivateEndpointCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            attached_data_assets=attached_data_assets,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            dns_zones=dns_zones,
            freeform_tags=freeform_tags,
            id=id,
            lifecycle_details=lifecycle_details,
            state=state,
            subnet_id=subnet_id,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             attached_data_assets: Sequence[str],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             dns_zones: Sequence[str],
             freeform_tags: Mapping[str, Any],
             id: str,
             lifecycle_details: str,
             state: str,
             subnet_id: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("attached_data_assets", attached_data_assets)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("dns_zones", dns_zones)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("lifecycle_details", lifecycle_details)
        _setter("state", state)
        _setter("subnet_id", subnet_id)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="attachedDataAssets")
    def attached_data_assets(self) -> Sequence[str]:
        """
        The list of dataAssets using the private reverse connection endpoint.
        """
        return pulumi.get(self, "attached_data_assets")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsZones")
    def dns_zones(self) -> Sequence[str]:
        """
        List of DNS zones to be used by the data assets. Example: custpvtsubnet.oraclevcn.com for data asset: db.custpvtsubnet.oraclevcn.com
        """
        return pulumi.get(self, "dns_zones")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        unique AiPrivateEndpoint identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Subnet Identifier
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the private endpoint was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetAiPrivateEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetAiPrivateEndpointsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDetectAnomalyJobInputDetailResult(dict):
    def __init__(__self__, *,
                 content: str,
                 content_type: str,
                 datas: Sequence['outputs.GetDetectAnomalyJobInputDetailDataResult'],
                 input_type: str,
                 message: str,
                 object_locations: Sequence['outputs.GetDetectAnomalyJobInputDetailObjectLocationResult'],
                 signal_names: Sequence[str]):
        """
        :param str input_type: The type of input location Allowed values are:
        :param str message: Inline input details.
        :param Sequence['GetDetectAnomalyJobInputDetailObjectLocationArgs'] object_locations: List of ObjectLocations.
        """
        GetDetectAnomalyJobInputDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            content_type=content_type,
            datas=datas,
            input_type=input_type,
            message=message,
            object_locations=object_locations,
            signal_names=signal_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: str,
             content_type: str,
             datas: Sequence['outputs.GetDetectAnomalyJobInputDetailDataResult'],
             input_type: str,
             message: str,
             object_locations: Sequence['outputs.GetDetectAnomalyJobInputDetailObjectLocationResult'],
             signal_names: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("content", content)
        _setter("content_type", content_type)
        _setter("datas", datas)
        _setter("input_type", input_type)
        _setter("message", message)
        _setter("object_locations", object_locations)
        _setter("signal_names", signal_names)

    @property
    @pulumi.getter
    def content(self) -> str:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.GetDetectAnomalyJobInputDetailDataResult']:
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter(name="inputType")
    def input_type(self) -> str:
        """
        The type of input location Allowed values are:
        """
        return pulumi.get(self, "input_type")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Inline input details.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Sequence['outputs.GetDetectAnomalyJobInputDetailObjectLocationResult']:
        """
        List of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")

    @property
    @pulumi.getter(name="signalNames")
    def signal_names(self) -> Sequence[str]:
        return pulumi.get(self, "signal_names")


@pulumi.output_type
class GetDetectAnomalyJobInputDetailDataResult(dict):
    def __init__(__self__, *,
                 timestamp: str,
                 values: Sequence[float]):
        GetDetectAnomalyJobInputDetailDataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            timestamp=timestamp,
            values=values,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             timestamp: str,
             values: Sequence[float],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("timestamp", timestamp)
        _setter("values", values)

    @property
    @pulumi.getter
    def timestamp(self) -> str:
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter
    def values(self) -> Sequence[float]:
        return pulumi.get(self, "values")


@pulumi.output_type
class GetDetectAnomalyJobInputDetailObjectLocationResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: Object Storage bucket name.
        :param str namespace: Object Storage namespace.
        :param str object: Object Storage object name.
        """
        GetDetectAnomalyJobInputDetailObjectLocationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            object=object,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             namespace: str,
             object: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)
        _setter("object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Object Storage object name.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetDetectAnomalyJobOutputDetailResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 output_type: str,
                 prefix: str):
        """
        :param str bucket: Object Storage bucket name.
        :param str namespace: Object Storage namespace.
        :param str output_type: The type of output location Allowed values are:
        :param str prefix: Object Storage folder name.
        """
        GetDetectAnomalyJobOutputDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            output_type=output_type,
            prefix=prefix,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             namespace: str,
             output_type: str,
             prefix: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)
        _setter("output_type", output_type)
        _setter("prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> str:
        """
        The type of output location Allowed values are:
        """
        return pulumi.get(self, "output_type")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        Object Storage folder name.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetDetectAnomalyJobsDetectAnomalyJobCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemResult']):
        GetDetectAnomalyJobsDetectAnomalyJobCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDetectAnomalyJobsDetectAnomalyJobCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 input_details: Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailResult'],
                 lifecycle_state_details: str,
                 model_id: str,
                 output_details: Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemOutputDetailResult'],
                 project_id: str,
                 sensitivity: float,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_accepted: str,
                 time_finished: str,
                 time_started: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: Detect anomaly job description.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: Id of the job.
        :param Sequence['GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailArgs'] input_details: Input details for detect anomaly job.
        :param str lifecycle_state_details: The current state details of the batch document job.
        :param str model_id: The ID of the trained model for which to list the resources.
        :param Sequence['GetDetectAnomalyJobsDetectAnomalyJobCollectionItemOutputDetailArgs'] output_details: Output details for detect anomaly job.
        :param str project_id: The ID of the project for which to list the objects.
        :param float sensitivity: The value that customer can adjust to control the sensitivity of anomaly detection
        :param str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_accepted: Job accepted time
        :param str time_finished: Job finished time
        :param str time_started: Job started time
        """
        GetDetectAnomalyJobsDetectAnomalyJobCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            input_details=input_details,
            lifecycle_state_details=lifecycle_state_details,
            model_id=model_id,
            output_details=output_details,
            project_id=project_id,
            sensitivity=sensitivity,
            state=state,
            system_tags=system_tags,
            time_accepted=time_accepted,
            time_finished=time_finished,
            time_started=time_started,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             input_details: Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailResult'],
             lifecycle_state_details: str,
             model_id: str,
             output_details: Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemOutputDetailResult'],
             project_id: str,
             sensitivity: float,
             state: str,
             system_tags: Mapping[str, Any],
             time_accepted: str,
             time_finished: str,
             time_started: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("input_details", input_details)
        _setter("lifecycle_state_details", lifecycle_state_details)
        _setter("model_id", model_id)
        _setter("output_details", output_details)
        _setter("project_id", project_id)
        _setter("sensitivity", sensitivity)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_accepted", time_accepted)
        _setter("time_finished", time_finished)
        _setter("time_started", time_started)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Detect anomaly job description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Id of the job.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inputDetails")
    def input_details(self) -> Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailResult']:
        """
        Input details for detect anomaly job.
        """
        return pulumi.get(self, "input_details")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> str:
        """
        The current state details of the batch document job.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> str:
        """
        The ID of the trained model for which to list the resources.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="outputDetails")
    def output_details(self) -> Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemOutputDetailResult']:
        """
        Output details for detect anomaly job.
        """
        return pulumi.get(self, "output_details")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project for which to list the objects.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def sensitivity(self) -> float:
        """
        The value that customer can adjust to control the sensitivity of anomaly detection
        """
        return pulumi.get(self, "sensitivity")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> str:
        """
        Job accepted time
        """
        return pulumi.get(self, "time_accepted")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> str:
        """
        Job finished time
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        Job started time
        """
        return pulumi.get(self, "time_started")


@pulumi.output_type
class GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailResult(dict):
    def __init__(__self__, *,
                 content: str,
                 content_type: str,
                 datas: Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailDataResult'],
                 input_type: str,
                 message: str,
                 object_locations: Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailObjectLocationResult'],
                 signal_names: Sequence[str]):
        """
        :param str input_type: The type of input location Allowed values are:
        :param str message: Inline input details.
        :param Sequence['GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailObjectLocationArgs'] object_locations: List of ObjectLocations.
        """
        GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            content_type=content_type,
            datas=datas,
            input_type=input_type,
            message=message,
            object_locations=object_locations,
            signal_names=signal_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: str,
             content_type: str,
             datas: Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailDataResult'],
             input_type: str,
             message: str,
             object_locations: Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailObjectLocationResult'],
             signal_names: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("content", content)
        _setter("content_type", content_type)
        _setter("datas", datas)
        _setter("input_type", input_type)
        _setter("message", message)
        _setter("object_locations", object_locations)
        _setter("signal_names", signal_names)

    @property
    @pulumi.getter
    def content(self) -> str:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailDataResult']:
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter(name="inputType")
    def input_type(self) -> str:
        """
        The type of input location Allowed values are:
        """
        return pulumi.get(self, "input_type")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Inline input details.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Sequence['outputs.GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailObjectLocationResult']:
        """
        List of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")

    @property
    @pulumi.getter(name="signalNames")
    def signal_names(self) -> Sequence[str]:
        return pulumi.get(self, "signal_names")


@pulumi.output_type
class GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailDataResult(dict):
    def __init__(__self__, *,
                 timestamp: str,
                 values: Sequence[float]):
        GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailDataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            timestamp=timestamp,
            values=values,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             timestamp: str,
             values: Sequence[float],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("timestamp", timestamp)
        _setter("values", values)

    @property
    @pulumi.getter
    def timestamp(self) -> str:
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter
    def values(self) -> Sequence[float]:
        return pulumi.get(self, "values")


@pulumi.output_type
class GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailObjectLocationResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: Object Storage bucket name.
        :param str namespace: Object Storage namespace.
        :param str object: Object Storage object name.
        """
        GetDetectAnomalyJobsDetectAnomalyJobCollectionItemInputDetailObjectLocationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            object=object,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             namespace: str,
             object: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)
        _setter("object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Object Storage object name.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetDetectAnomalyJobsDetectAnomalyJobCollectionItemOutputDetailResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 output_type: str,
                 prefix: str):
        """
        :param str bucket: Object Storage bucket name.
        :param str namespace: Object Storage namespace.
        :param str output_type: The type of output location Allowed values are:
        :param str prefix: Object Storage folder name.
        """
        GetDetectAnomalyJobsDetectAnomalyJobCollectionItemOutputDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            output_type=output_type,
            prefix=prefix,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             namespace: str,
             output_type: str,
             prefix: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)
        _setter("output_type", output_type)
        _setter("prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> str:
        """
        The type of output location Allowed values are:
        """
        return pulumi.get(self, "output_type")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        Object Storage folder name.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetDetectAnomalyJobsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDetectAnomalyJobsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDetectionDataAssetDataSourceDetailResult(dict):
    def __init__(__self__, *,
                 atp_password_secret_id: str,
                 atp_user_name: str,
                 bucket: str,
                 cwallet_file_secret_id: str,
                 data_source_type: str,
                 database_name: str,
                 ewallet_file_secret_id: str,
                 key_store_file_secret_id: str,
                 measurement_name: str,
                 namespace: str,
                 object: str,
                 ojdbc_file_secret_id: str,
                 password_secret_id: str,
                 table_name: str,
                 tnsnames_file_secret_id: str,
                 truststore_file_secret_id: str,
                 url: str,
                 user_name: str,
                 version_specific_details: Sequence['outputs.GetDetectionDataAssetDataSourceDetailVersionSpecificDetailResult'],
                 wallet_password_secret_id: str):
        """
        :param str atp_password_secret_id: atp db password Secret Id
        :param str atp_user_name: atp db user name
        :param str bucket: Bucket Name for influx connection
        :param str cwallet_file_secret_id: OCID of the secret containing the containers certificates of ATP wallet
        :param str data_source_type: Data source type where actually data asset is being stored
        :param str database_name: DB Name for influx connection
        :param str ewallet_file_secret_id: OCID of the secret containing the PDB'S certificates of ATP wallet
        :param str key_store_file_secret_id: OCID of the secret containing Keystore.jks file of the ATP wallet
        :param str measurement_name: Measurement name for influx
        :param str namespace: Object storage namespace
        :param str object: File name
        :param str ojdbc_file_secret_id: OCID of the secret that contains jdbc properties file of ATP wallet
        :param str password_secret_id: Password Secret Id for the influx connection
        :param str table_name: atp database table name
        :param str tnsnames_file_secret_id: OCID of the secret that contains the tnsnames file of ATP wallet
        :param str truststore_file_secret_id: OCID of the secret containing truststore.jks file of the ATP wallet
        :param str url: public IP address and port to influx DB
        :param str user_name: Username for connection to Influx
        :param Sequence['GetDetectionDataAssetDataSourceDetailVersionSpecificDetailArgs'] version_specific_details: Possible data sources
        :param str wallet_password_secret_id: wallet password Secret ID in String format
        """
        GetDetectionDataAssetDataSourceDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            atp_password_secret_id=atp_password_secret_id,
            atp_user_name=atp_user_name,
            bucket=bucket,
            cwallet_file_secret_id=cwallet_file_secret_id,
            data_source_type=data_source_type,
            database_name=database_name,
            ewallet_file_secret_id=ewallet_file_secret_id,
            key_store_file_secret_id=key_store_file_secret_id,
            measurement_name=measurement_name,
            namespace=namespace,
            object=object,
            ojdbc_file_secret_id=ojdbc_file_secret_id,
            password_secret_id=password_secret_id,
            table_name=table_name,
            tnsnames_file_secret_id=tnsnames_file_secret_id,
            truststore_file_secret_id=truststore_file_secret_id,
            url=url,
            user_name=user_name,
            version_specific_details=version_specific_details,
            wallet_password_secret_id=wallet_password_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             atp_password_secret_id: str,
             atp_user_name: str,
             bucket: str,
             cwallet_file_secret_id: str,
             data_source_type: str,
             database_name: str,
             ewallet_file_secret_id: str,
             key_store_file_secret_id: str,
             measurement_name: str,
             namespace: str,
             object: str,
             ojdbc_file_secret_id: str,
             password_secret_id: str,
             table_name: str,
             tnsnames_file_secret_id: str,
             truststore_file_secret_id: str,
             url: str,
             user_name: str,
             version_specific_details: Sequence['outputs.GetDetectionDataAssetDataSourceDetailVersionSpecificDetailResult'],
             wallet_password_secret_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("atp_password_secret_id", atp_password_secret_id)
        _setter("atp_user_name", atp_user_name)
        _setter("bucket", bucket)
        _setter("cwallet_file_secret_id", cwallet_file_secret_id)
        _setter("data_source_type", data_source_type)
        _setter("database_name", database_name)
        _setter("ewallet_file_secret_id", ewallet_file_secret_id)
        _setter("key_store_file_secret_id", key_store_file_secret_id)
        _setter("measurement_name", measurement_name)
        _setter("namespace", namespace)
        _setter("object", object)
        _setter("ojdbc_file_secret_id", ojdbc_file_secret_id)
        _setter("password_secret_id", password_secret_id)
        _setter("table_name", table_name)
        _setter("tnsnames_file_secret_id", tnsnames_file_secret_id)
        _setter("truststore_file_secret_id", truststore_file_secret_id)
        _setter("url", url)
        _setter("user_name", user_name)
        _setter("version_specific_details", version_specific_details)
        _setter("wallet_password_secret_id", wallet_password_secret_id)

    @property
    @pulumi.getter(name="atpPasswordSecretId")
    def atp_password_secret_id(self) -> str:
        """
        atp db password Secret Id
        """
        return pulumi.get(self, "atp_password_secret_id")

    @property
    @pulumi.getter(name="atpUserName")
    def atp_user_name(self) -> str:
        """
        atp db user name
        """
        return pulumi.get(self, "atp_user_name")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket Name for influx connection
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="cwalletFileSecretId")
    def cwallet_file_secret_id(self) -> str:
        """
        OCID of the secret containing the containers certificates of ATP wallet
        """
        return pulumi.get(self, "cwallet_file_secret_id")

    @property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> str:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "data_source_type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        DB Name for influx connection
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="ewalletFileSecretId")
    def ewallet_file_secret_id(self) -> str:
        """
        OCID of the secret containing the PDB'S certificates of ATP wallet
        """
        return pulumi.get(self, "ewallet_file_secret_id")

    @property
    @pulumi.getter(name="keyStoreFileSecretId")
    def key_store_file_secret_id(self) -> str:
        """
        OCID of the secret containing Keystore.jks file of the ATP wallet
        """
        return pulumi.get(self, "key_store_file_secret_id")

    @property
    @pulumi.getter(name="measurementName")
    def measurement_name(self) -> str:
        """
        Measurement name for influx
        """
        return pulumi.get(self, "measurement_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        File name
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="ojdbcFileSecretId")
    def ojdbc_file_secret_id(self) -> str:
        """
        OCID of the secret that contains jdbc properties file of ATP wallet
        """
        return pulumi.get(self, "ojdbc_file_secret_id")

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> str:
        """
        Password Secret Id for the influx connection
        """
        return pulumi.get(self, "password_secret_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        atp database table name
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="tnsnamesFileSecretId")
    def tnsnames_file_secret_id(self) -> str:
        """
        OCID of the secret that contains the tnsnames file of ATP wallet
        """
        return pulumi.get(self, "tnsnames_file_secret_id")

    @property
    @pulumi.getter(name="truststoreFileSecretId")
    def truststore_file_secret_id(self) -> str:
        """
        OCID of the secret containing truststore.jks file of the ATP wallet
        """
        return pulumi.get(self, "truststore_file_secret_id")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        public IP address and port to influx DB
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        Username for connection to Influx
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="versionSpecificDetails")
    def version_specific_details(self) -> Sequence['outputs.GetDetectionDataAssetDataSourceDetailVersionSpecificDetailResult']:
        """
        Possible data sources
        """
        return pulumi.get(self, "version_specific_details")

    @property
    @pulumi.getter(name="walletPasswordSecretId")
    def wallet_password_secret_id(self) -> str:
        """
        wallet password Secret ID in String format
        """
        return pulumi.get(self, "wallet_password_secret_id")


@pulumi.output_type
class GetDetectionDataAssetDataSourceDetailVersionSpecificDetailResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 database_name: str,
                 influx_version: str,
                 organization_name: str,
                 retention_policy_name: str):
        """
        :param str bucket: Bucket Name for influx connection
        :param str database_name: DB Name for influx connection
        :param str influx_version: Data source type where actually data asset is being stored
        :param str organization_name: Org name for the influx db
        :param str retention_policy_name: retention policy is how long the bucket would last
        """
        GetDetectionDataAssetDataSourceDetailVersionSpecificDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            database_name=database_name,
            influx_version=influx_version,
            organization_name=organization_name,
            retention_policy_name=retention_policy_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             database_name: str,
             influx_version: str,
             organization_name: str,
             retention_policy_name: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("database_name", database_name)
        _setter("influx_version", influx_version)
        _setter("organization_name", organization_name)
        _setter("retention_policy_name", retention_policy_name)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket Name for influx connection
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        DB Name for influx connection
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="influxVersion")
    def influx_version(self) -> str:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "influx_version")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> str:
        """
        Org name for the influx db
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="retentionPolicyName")
    def retention_policy_name(self) -> str:
        """
        retention policy is how long the bucket would last
        """
        return pulumi.get(self, "retention_policy_name")


@pulumi.output_type
class GetDetectionDataAssetsDataAssetCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionItemResult']):
        GetDetectionDataAssetsDataAssetCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDetectionDataAssetsDataAssetCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 data_source_details: Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailResult'],
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 private_endpoint_id: str,
                 project_id: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence['GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailArgs'] data_source_details: Possible data sources
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: A short description of the data asset.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The Unique Oracle ID (OCID) that is immutable on creation.
        :param str private_endpoint_id: OCID of Private Endpoint.
        :param str project_id: The ID of the project for which to list the objects.
        :param str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time the the DataAsset was created. An RFC3339 formatted datetime string
        :param str time_updated: The time the the DataAsset was updated. An RFC3339 formatted datetime string
        """
        GetDetectionDataAssetsDataAssetCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            data_source_details=data_source_details,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            private_endpoint_id=private_endpoint_id,
            project_id=project_id,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             data_source_details: Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailResult'],
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             private_endpoint_id: str,
             project_id: str,
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("data_source_details", data_source_details)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("private_endpoint_id", private_endpoint_id)
        _setter("project_id", project_id)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataSourceDetails")
    def data_source_details(self) -> Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailResult']:
        """
        Possible data sources
        """
        return pulumi.get(self, "data_source_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A short description of the data asset.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Unique Oracle ID (OCID) that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> str:
        """
        OCID of Private Endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project for which to list the objects.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the DataAsset was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the the DataAsset was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailResult(dict):
    def __init__(__self__, *,
                 atp_password_secret_id: str,
                 atp_user_name: str,
                 bucket: str,
                 cwallet_file_secret_id: str,
                 data_source_type: str,
                 database_name: str,
                 ewallet_file_secret_id: str,
                 key_store_file_secret_id: str,
                 measurement_name: str,
                 namespace: str,
                 object: str,
                 ojdbc_file_secret_id: str,
                 password_secret_id: str,
                 table_name: str,
                 tnsnames_file_secret_id: str,
                 truststore_file_secret_id: str,
                 url: str,
                 user_name: str,
                 version_specific_details: Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailVersionSpecificDetailResult'],
                 wallet_password_secret_id: str):
        """
        :param str atp_password_secret_id: atp db password Secret Id
        :param str atp_user_name: atp db user name
        :param str bucket: Bucket Name for influx connection
        :param str cwallet_file_secret_id: OCID of the secret containing the containers certificates of ATP wallet
        :param str data_source_type: Data source type where actually data asset is being stored
        :param str database_name: DB Name for influx connection
        :param str ewallet_file_secret_id: OCID of the secret containing the PDB'S certificates of ATP wallet
        :param str key_store_file_secret_id: OCID of the secret containing Keystore.jks file of the ATP wallet
        :param str measurement_name: Measurement name for influx
        :param str namespace: Object storage namespace
        :param str object: File name
        :param str ojdbc_file_secret_id: OCID of the secret that contains jdbc properties file of ATP wallet
        :param str password_secret_id: Password Secret Id for the influx connection
        :param str table_name: atp database table name
        :param str tnsnames_file_secret_id: OCID of the secret that contains the tnsnames file of ATP wallet
        :param str truststore_file_secret_id: OCID of the secret containing truststore.jks file of the ATP wallet
        :param str url: public IP address and port to influx DB
        :param str user_name: Username for connection to Influx
        :param Sequence['GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailVersionSpecificDetailArgs'] version_specific_details: Possible data sources
        :param str wallet_password_secret_id: wallet password Secret ID in String format
        """
        GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            atp_password_secret_id=atp_password_secret_id,
            atp_user_name=atp_user_name,
            bucket=bucket,
            cwallet_file_secret_id=cwallet_file_secret_id,
            data_source_type=data_source_type,
            database_name=database_name,
            ewallet_file_secret_id=ewallet_file_secret_id,
            key_store_file_secret_id=key_store_file_secret_id,
            measurement_name=measurement_name,
            namespace=namespace,
            object=object,
            ojdbc_file_secret_id=ojdbc_file_secret_id,
            password_secret_id=password_secret_id,
            table_name=table_name,
            tnsnames_file_secret_id=tnsnames_file_secret_id,
            truststore_file_secret_id=truststore_file_secret_id,
            url=url,
            user_name=user_name,
            version_specific_details=version_specific_details,
            wallet_password_secret_id=wallet_password_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             atp_password_secret_id: str,
             atp_user_name: str,
             bucket: str,
             cwallet_file_secret_id: str,
             data_source_type: str,
             database_name: str,
             ewallet_file_secret_id: str,
             key_store_file_secret_id: str,
             measurement_name: str,
             namespace: str,
             object: str,
             ojdbc_file_secret_id: str,
             password_secret_id: str,
             table_name: str,
             tnsnames_file_secret_id: str,
             truststore_file_secret_id: str,
             url: str,
             user_name: str,
             version_specific_details: Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailVersionSpecificDetailResult'],
             wallet_password_secret_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("atp_password_secret_id", atp_password_secret_id)
        _setter("atp_user_name", atp_user_name)
        _setter("bucket", bucket)
        _setter("cwallet_file_secret_id", cwallet_file_secret_id)
        _setter("data_source_type", data_source_type)
        _setter("database_name", database_name)
        _setter("ewallet_file_secret_id", ewallet_file_secret_id)
        _setter("key_store_file_secret_id", key_store_file_secret_id)
        _setter("measurement_name", measurement_name)
        _setter("namespace", namespace)
        _setter("object", object)
        _setter("ojdbc_file_secret_id", ojdbc_file_secret_id)
        _setter("password_secret_id", password_secret_id)
        _setter("table_name", table_name)
        _setter("tnsnames_file_secret_id", tnsnames_file_secret_id)
        _setter("truststore_file_secret_id", truststore_file_secret_id)
        _setter("url", url)
        _setter("user_name", user_name)
        _setter("version_specific_details", version_specific_details)
        _setter("wallet_password_secret_id", wallet_password_secret_id)

    @property
    @pulumi.getter(name="atpPasswordSecretId")
    def atp_password_secret_id(self) -> str:
        """
        atp db password Secret Id
        """
        return pulumi.get(self, "atp_password_secret_id")

    @property
    @pulumi.getter(name="atpUserName")
    def atp_user_name(self) -> str:
        """
        atp db user name
        """
        return pulumi.get(self, "atp_user_name")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket Name for influx connection
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="cwalletFileSecretId")
    def cwallet_file_secret_id(self) -> str:
        """
        OCID of the secret containing the containers certificates of ATP wallet
        """
        return pulumi.get(self, "cwallet_file_secret_id")

    @property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> str:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "data_source_type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        DB Name for influx connection
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="ewalletFileSecretId")
    def ewallet_file_secret_id(self) -> str:
        """
        OCID of the secret containing the PDB'S certificates of ATP wallet
        """
        return pulumi.get(self, "ewallet_file_secret_id")

    @property
    @pulumi.getter(name="keyStoreFileSecretId")
    def key_store_file_secret_id(self) -> str:
        """
        OCID of the secret containing Keystore.jks file of the ATP wallet
        """
        return pulumi.get(self, "key_store_file_secret_id")

    @property
    @pulumi.getter(name="measurementName")
    def measurement_name(self) -> str:
        """
        Measurement name for influx
        """
        return pulumi.get(self, "measurement_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        File name
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="ojdbcFileSecretId")
    def ojdbc_file_secret_id(self) -> str:
        """
        OCID of the secret that contains jdbc properties file of ATP wallet
        """
        return pulumi.get(self, "ojdbc_file_secret_id")

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> str:
        """
        Password Secret Id for the influx connection
        """
        return pulumi.get(self, "password_secret_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        atp database table name
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="tnsnamesFileSecretId")
    def tnsnames_file_secret_id(self) -> str:
        """
        OCID of the secret that contains the tnsnames file of ATP wallet
        """
        return pulumi.get(self, "tnsnames_file_secret_id")

    @property
    @pulumi.getter(name="truststoreFileSecretId")
    def truststore_file_secret_id(self) -> str:
        """
        OCID of the secret containing truststore.jks file of the ATP wallet
        """
        return pulumi.get(self, "truststore_file_secret_id")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        public IP address and port to influx DB
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        Username for connection to Influx
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="versionSpecificDetails")
    def version_specific_details(self) -> Sequence['outputs.GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailVersionSpecificDetailResult']:
        """
        Possible data sources
        """
        return pulumi.get(self, "version_specific_details")

    @property
    @pulumi.getter(name="walletPasswordSecretId")
    def wallet_password_secret_id(self) -> str:
        """
        wallet password Secret ID in String format
        """
        return pulumi.get(self, "wallet_password_secret_id")


@pulumi.output_type
class GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailVersionSpecificDetailResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 database_name: str,
                 influx_version: str,
                 organization_name: str,
                 retention_policy_name: str):
        """
        :param str bucket: Bucket Name for influx connection
        :param str database_name: DB Name for influx connection
        :param str influx_version: Data source type where actually data asset is being stored
        :param str organization_name: Org name for the influx db
        :param str retention_policy_name: retention policy is how long the bucket would last
        """
        GetDetectionDataAssetsDataAssetCollectionItemDataSourceDetailVersionSpecificDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            database_name=database_name,
            influx_version=influx_version,
            organization_name=organization_name,
            retention_policy_name=retention_policy_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             database_name: str,
             influx_version: str,
             organization_name: str,
             retention_policy_name: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("database_name", database_name)
        _setter("influx_version", influx_version)
        _setter("organization_name", organization_name)
        _setter("retention_policy_name", retention_policy_name)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket Name for influx connection
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        DB Name for influx connection
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="influxVersion")
    def influx_version(self) -> str:
        """
        Data source type where actually data asset is being stored
        """
        return pulumi.get(self, "influx_version")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> str:
        """
        Org name for the influx db
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="retentionPolicyName")
    def retention_policy_name(self) -> str:
        """
        retention policy is how long the bucket would last
        """
        return pulumi.get(self, "retention_policy_name")


@pulumi.output_type
class GetDetectionDataAssetsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDetectionDataAssetsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDetectionModelModelTrainingDetailResult(dict):
    def __init__(__self__, *,
                 algorithm_hint: str,
                 data_asset_ids: Sequence[str],
                 target_fap: float,
                 training_fraction: float,
                 window_size: int):
        """
        :param str algorithm_hint: User can choose specific algorithm for training.
        :param Sequence[str] data_asset_ids: The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        :param float target_fap: A target model accuracy metric user provides as their requirement
        :param float training_fraction: Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        :param int window_size: Window size defined during training or deduced by the algorithm.
        """
        GetDetectionModelModelTrainingDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            algorithm_hint=algorithm_hint,
            data_asset_ids=data_asset_ids,
            target_fap=target_fap,
            training_fraction=training_fraction,
            window_size=window_size,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             algorithm_hint: str,
             data_asset_ids: Sequence[str],
             target_fap: float,
             training_fraction: float,
             window_size: int,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("algorithm_hint", algorithm_hint)
        _setter("data_asset_ids", data_asset_ids)
        _setter("target_fap", target_fap)
        _setter("training_fraction", training_fraction)
        _setter("window_size", window_size)

    @property
    @pulumi.getter(name="algorithmHint")
    def algorithm_hint(self) -> str:
        """
        User can choose specific algorithm for training.
        """
        return pulumi.get(self, "algorithm_hint")

    @property
    @pulumi.getter(name="dataAssetIds")
    def data_asset_ids(self) -> Sequence[str]:
        """
        The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        """
        return pulumi.get(self, "data_asset_ids")

    @property
    @pulumi.getter(name="targetFap")
    def target_fap(self) -> float:
        """
        A target model accuracy metric user provides as their requirement
        """
        return pulumi.get(self, "target_fap")

    @property
    @pulumi.getter(name="trainingFraction")
    def training_fraction(self) -> float:
        """
        Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        """
        return pulumi.get(self, "training_fraction")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> int:
        """
        Window size defined during training or deduced by the algorithm.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class GetDetectionModelModelTrainingResultResult(dict):
    def __init__(__self__, *,
                 fap: float,
                 is_training_goal_achieved: bool,
                 mae: float,
                 max_inference_sync_rows: int,
                 multivariate_fap: float,
                 rmse: float,
                 row_reduction_details: Sequence['outputs.GetDetectionModelModelTrainingResultRowReductionDetailResult'],
                 signal_details: Sequence['outputs.GetDetectionModelModelTrainingResultSignalDetailResult'],
                 warning: str,
                 window_size: int):
        """
        :param float fap: Accuracy metric for a signal.
        :param bool is_training_goal_achieved: A boolean value to indicate if train goal/targetFap is achieved for trained model
        :param float multivariate_fap: The model accuracy metric on timestamp level.
        :param Sequence['GetDetectionModelModelTrainingResultRowReductionDetailArgs'] row_reduction_details: Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        :param Sequence['GetDetectionModelModelTrainingResultSignalDetailArgs'] signal_details: The list of signal details.
        :param str warning: A warning message to explain the reason when targetFap cannot be achieved for trained model
        :param int window_size: Window size defined during training or deduced by the algorithm.
        """
        GetDetectionModelModelTrainingResultResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            fap=fap,
            is_training_goal_achieved=is_training_goal_achieved,
            mae=mae,
            max_inference_sync_rows=max_inference_sync_rows,
            multivariate_fap=multivariate_fap,
            rmse=rmse,
            row_reduction_details=row_reduction_details,
            signal_details=signal_details,
            warning=warning,
            window_size=window_size,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             fap: float,
             is_training_goal_achieved: bool,
             mae: float,
             max_inference_sync_rows: int,
             multivariate_fap: float,
             rmse: float,
             row_reduction_details: Sequence['outputs.GetDetectionModelModelTrainingResultRowReductionDetailResult'],
             signal_details: Sequence['outputs.GetDetectionModelModelTrainingResultSignalDetailResult'],
             warning: str,
             window_size: int,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("fap", fap)
        _setter("is_training_goal_achieved", is_training_goal_achieved)
        _setter("mae", mae)
        _setter("max_inference_sync_rows", max_inference_sync_rows)
        _setter("multivariate_fap", multivariate_fap)
        _setter("rmse", rmse)
        _setter("row_reduction_details", row_reduction_details)
        _setter("signal_details", signal_details)
        _setter("warning", warning)
        _setter("window_size", window_size)

    @property
    @pulumi.getter
    def fap(self) -> float:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @property
    @pulumi.getter(name="isTrainingGoalAchieved")
    def is_training_goal_achieved(self) -> bool:
        """
        A boolean value to indicate if train goal/targetFap is achieved for trained model
        """
        return pulumi.get(self, "is_training_goal_achieved")

    @property
    @pulumi.getter
    def mae(self) -> float:
        return pulumi.get(self, "mae")

    @property
    @pulumi.getter(name="maxInferenceSyncRows")
    def max_inference_sync_rows(self) -> int:
        return pulumi.get(self, "max_inference_sync_rows")

    @property
    @pulumi.getter(name="multivariateFap")
    def multivariate_fap(self) -> float:
        """
        The model accuracy metric on timestamp level.
        """
        return pulumi.get(self, "multivariate_fap")

    @property
    @pulumi.getter
    def rmse(self) -> float:
        return pulumi.get(self, "rmse")

    @property
    @pulumi.getter(name="rowReductionDetails")
    def row_reduction_details(self) -> Sequence['outputs.GetDetectionModelModelTrainingResultRowReductionDetailResult']:
        """
        Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        """
        return pulumi.get(self, "row_reduction_details")

    @property
    @pulumi.getter(name="signalDetails")
    def signal_details(self) -> Sequence['outputs.GetDetectionModelModelTrainingResultSignalDetailResult']:
        """
        The list of signal details.
        """
        return pulumi.get(self, "signal_details")

    @property
    @pulumi.getter
    def warning(self) -> str:
        """
        A warning message to explain the reason when targetFap cannot be achieved for trained model
        """
        return pulumi.get(self, "warning")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> int:
        """
        Window size defined during training or deduced by the algorithm.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class GetDetectionModelModelTrainingResultRowReductionDetailResult(dict):
    def __init__(__self__, *,
                 is_reduction_enabled: bool,
                 reduction_method: str,
                 reduction_percentage: float):
        """
        :param bool is_reduction_enabled: A boolean value to indicate if row reduction is applied
        :param str reduction_method: Method for row reduction:
               * DELETE_ROW - delete rows with equal intervals
               * AVERAGE_ROW - average multiple rows to one row
        :param float reduction_percentage: A percentage to reduce data size down to on top of original data
        """
        GetDetectionModelModelTrainingResultRowReductionDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_reduction_enabled=is_reduction_enabled,
            reduction_method=reduction_method,
            reduction_percentage=reduction_percentage,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_reduction_enabled: bool,
             reduction_method: str,
             reduction_percentage: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("is_reduction_enabled", is_reduction_enabled)
        _setter("reduction_method", reduction_method)
        _setter("reduction_percentage", reduction_percentage)

    @property
    @pulumi.getter(name="isReductionEnabled")
    def is_reduction_enabled(self) -> bool:
        """
        A boolean value to indicate if row reduction is applied
        """
        return pulumi.get(self, "is_reduction_enabled")

    @property
    @pulumi.getter(name="reductionMethod")
    def reduction_method(self) -> str:
        """
        Method for row reduction:
        * DELETE_ROW - delete rows with equal intervals
        * AVERAGE_ROW - average multiple rows to one row
        """
        return pulumi.get(self, "reduction_method")

    @property
    @pulumi.getter(name="reductionPercentage")
    def reduction_percentage(self) -> float:
        """
        A percentage to reduce data size down to on top of original data
        """
        return pulumi.get(self, "reduction_percentage")


@pulumi.output_type
class GetDetectionModelModelTrainingResultSignalDetailResult(dict):
    def __init__(__self__, *,
                 details: str,
                 fap: float,
                 is_quantized: bool,
                 max: float,
                 min: float,
                 mvi_ratio: float,
                 signal_name: str,
                 status: str,
                 std: float):
        """
        :param str details: detailed information for a signal.
        :param float fap: Accuracy metric for a signal.
        :param bool is_quantized: A boolean value to indicate if a signal is quantized or not.
        :param float max: Max value within a signal.
        :param float min: Min value within a signal.
        :param float mvi_ratio: The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        :param str signal_name: The name of a signal.
        :param str status: Status of the signal:
               * ACCEPTED - the signal is used for training the model
               * DROPPED - the signal does not meet requirement, and is dropped before training the model.
               * OTHER - placeholder for other status
        :param float std: Standard deviation of values within a signal.
        """
        GetDetectionModelModelTrainingResultSignalDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            details=details,
            fap=fap,
            is_quantized=is_quantized,
            max=max,
            min=min,
            mvi_ratio=mvi_ratio,
            signal_name=signal_name,
            status=status,
            std=std,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             details: str,
             fap: float,
             is_quantized: bool,
             max: float,
             min: float,
             mvi_ratio: float,
             signal_name: str,
             status: str,
             std: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("details", details)
        _setter("fap", fap)
        _setter("is_quantized", is_quantized)
        _setter("max", max)
        _setter("min", min)
        _setter("mvi_ratio", mvi_ratio)
        _setter("signal_name", signal_name)
        _setter("status", status)
        _setter("std", std)

    @property
    @pulumi.getter
    def details(self) -> str:
        """
        detailed information for a signal.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def fap(self) -> float:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @property
    @pulumi.getter(name="isQuantized")
    def is_quantized(self) -> bool:
        """
        A boolean value to indicate if a signal is quantized or not.
        """
        return pulumi.get(self, "is_quantized")

    @property
    @pulumi.getter
    def max(self) -> float:
        """
        Max value within a signal.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> float:
        """
        Min value within a signal.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter(name="mviRatio")
    def mvi_ratio(self) -> float:
        """
        The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        """
        return pulumi.get(self, "mvi_ratio")

    @property
    @pulumi.getter(name="signalName")
    def signal_name(self) -> str:
        """
        The name of a signal.
        """
        return pulumi.get(self, "signal_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the signal:
        * ACCEPTED - the signal is used for training the model
        * DROPPED - the signal does not meet requirement, and is dropped before training the model.
        * OTHER - placeholder for other status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def std(self) -> float:
        """
        Standard deviation of values within a signal.
        """
        return pulumi.get(self, "std")


@pulumi.output_type
class GetDetectionModelsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDetectionModelsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDetectionModelsModelCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDetectionModelsModelCollectionItemResult']):
        GetDetectionModelsModelCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetDetectionModelsModelCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDetectionModelsModelCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDetectionModelsModelCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_details: str,
                 model_training_details: Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingDetailResult'],
                 model_training_results: Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingResultResult'],
                 project_id: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: A short description of the Model.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The OCID of the model that is immutable on creation.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Sequence['GetDetectionModelsModelCollectionItemModelTrainingDetailArgs'] model_training_details: Specifies the details of the MSET model during the create call.
        :param Sequence['GetDetectionModelsModelCollectionItemModelTrainingResultArgs'] model_training_results: Specifies the details for an Anomaly Detection model trained with MSET.
        :param str project_id: The ID of the project for which to list the objects.
        :param str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time the the Model was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time the Model was updated. An RFC3339 formatted datetime string.
        """
        GetDetectionModelsModelCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            lifecycle_details=lifecycle_details,
            model_training_details=model_training_details,
            model_training_results=model_training_results,
            project_id=project_id,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             lifecycle_details: str,
             model_training_details: Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingDetailResult'],
             model_training_results: Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingResultResult'],
             project_id: str,
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("lifecycle_details", lifecycle_details)
        _setter("model_training_details", model_training_details)
        _setter("model_training_results", model_training_results)
        _setter("project_id", project_id)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A short description of the Model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the model that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="modelTrainingDetails")
    def model_training_details(self) -> Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingDetailResult']:
        """
        Specifies the details of the MSET model during the create call.
        """
        return pulumi.get(self, "model_training_details")

    @property
    @pulumi.getter(name="modelTrainingResults")
    def model_training_results(self) -> Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingResultResult']:
        """
        Specifies the details for an Anomaly Detection model trained with MSET.
        """
        return pulumi.get(self, "model_training_results")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project for which to list the objects.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the Model was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the Model was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDetectionModelsModelCollectionItemModelTrainingDetailResult(dict):
    def __init__(__self__, *,
                 algorithm_hint: str,
                 data_asset_ids: Sequence[str],
                 target_fap: float,
                 training_fraction: float,
                 window_size: int):
        """
        :param str algorithm_hint: User can choose specific algorithm for training.
        :param Sequence[str] data_asset_ids: The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        :param float target_fap: A target model accuracy metric user provides as their requirement
        :param float training_fraction: Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        :param int window_size: Window size defined during training or deduced by the algorithm.
        """
        GetDetectionModelsModelCollectionItemModelTrainingDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            algorithm_hint=algorithm_hint,
            data_asset_ids=data_asset_ids,
            target_fap=target_fap,
            training_fraction=training_fraction,
            window_size=window_size,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             algorithm_hint: str,
             data_asset_ids: Sequence[str],
             target_fap: float,
             training_fraction: float,
             window_size: int,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("algorithm_hint", algorithm_hint)
        _setter("data_asset_ids", data_asset_ids)
        _setter("target_fap", target_fap)
        _setter("training_fraction", training_fraction)
        _setter("window_size", window_size)

    @property
    @pulumi.getter(name="algorithmHint")
    def algorithm_hint(self) -> str:
        """
        User can choose specific algorithm for training.
        """
        return pulumi.get(self, "algorithm_hint")

    @property
    @pulumi.getter(name="dataAssetIds")
    def data_asset_ids(self) -> Sequence[str]:
        """
        The list of OCIDs of the data assets to train the model. The dataAssets have to be in the same project where the ai model would reside.
        """
        return pulumi.get(self, "data_asset_ids")

    @property
    @pulumi.getter(name="targetFap")
    def target_fap(self) -> float:
        """
        A target model accuracy metric user provides as their requirement
        """
        return pulumi.get(self, "target_fap")

    @property
    @pulumi.getter(name="trainingFraction")
    def training_fraction(self) -> float:
        """
        Fraction of total data that is used for training the model. The remaining is used for validation of the model.
        """
        return pulumi.get(self, "training_fraction")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> int:
        """
        Window size defined during training or deduced by the algorithm.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class GetDetectionModelsModelCollectionItemModelTrainingResultResult(dict):
    def __init__(__self__, *,
                 fap: float,
                 is_training_goal_achieved: bool,
                 mae: float,
                 max_inference_sync_rows: int,
                 multivariate_fap: float,
                 rmse: float,
                 row_reduction_details: Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingResultRowReductionDetailResult'],
                 signal_details: Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingResultSignalDetailResult'],
                 warning: str,
                 window_size: int):
        """
        :param float fap: Accuracy metric for a signal.
        :param bool is_training_goal_achieved: A boolean value to indicate if train goal/targetFap is achieved for trained model
        :param float multivariate_fap: The model accuracy metric on timestamp level.
        :param Sequence['GetDetectionModelsModelCollectionItemModelTrainingResultRowReductionDetailArgs'] row_reduction_details: Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        :param Sequence['GetDetectionModelsModelCollectionItemModelTrainingResultSignalDetailArgs'] signal_details: The list of signal details.
        :param str warning: A warning message to explain the reason when targetFap cannot be achieved for trained model
        :param int window_size: Window size defined during training or deduced by the algorithm.
        """
        GetDetectionModelsModelCollectionItemModelTrainingResultResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            fap=fap,
            is_training_goal_achieved=is_training_goal_achieved,
            mae=mae,
            max_inference_sync_rows=max_inference_sync_rows,
            multivariate_fap=multivariate_fap,
            rmse=rmse,
            row_reduction_details=row_reduction_details,
            signal_details=signal_details,
            warning=warning,
            window_size=window_size,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             fap: float,
             is_training_goal_achieved: bool,
             mae: float,
             max_inference_sync_rows: int,
             multivariate_fap: float,
             rmse: float,
             row_reduction_details: Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingResultRowReductionDetailResult'],
             signal_details: Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingResultSignalDetailResult'],
             warning: str,
             window_size: int,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("fap", fap)
        _setter("is_training_goal_achieved", is_training_goal_achieved)
        _setter("mae", mae)
        _setter("max_inference_sync_rows", max_inference_sync_rows)
        _setter("multivariate_fap", multivariate_fap)
        _setter("rmse", rmse)
        _setter("row_reduction_details", row_reduction_details)
        _setter("signal_details", signal_details)
        _setter("warning", warning)
        _setter("window_size", window_size)

    @property
    @pulumi.getter
    def fap(self) -> float:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @property
    @pulumi.getter(name="isTrainingGoalAchieved")
    def is_training_goal_achieved(self) -> bool:
        """
        A boolean value to indicate if train goal/targetFap is achieved for trained model
        """
        return pulumi.get(self, "is_training_goal_achieved")

    @property
    @pulumi.getter
    def mae(self) -> float:
        return pulumi.get(self, "mae")

    @property
    @pulumi.getter(name="maxInferenceSyncRows")
    def max_inference_sync_rows(self) -> int:
        return pulumi.get(self, "max_inference_sync_rows")

    @property
    @pulumi.getter(name="multivariateFap")
    def multivariate_fap(self) -> float:
        """
        The model accuracy metric on timestamp level.
        """
        return pulumi.get(self, "multivariate_fap")

    @property
    @pulumi.getter
    def rmse(self) -> float:
        return pulumi.get(self, "rmse")

    @property
    @pulumi.getter(name="rowReductionDetails")
    def row_reduction_details(self) -> Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingResultRowReductionDetailResult']:
        """
        Information regarding how/what row reduction methods will be applied. If this property is not present or is null, then it means row reduction is not applied.
        """
        return pulumi.get(self, "row_reduction_details")

    @property
    @pulumi.getter(name="signalDetails")
    def signal_details(self) -> Sequence['outputs.GetDetectionModelsModelCollectionItemModelTrainingResultSignalDetailResult']:
        """
        The list of signal details.
        """
        return pulumi.get(self, "signal_details")

    @property
    @pulumi.getter
    def warning(self) -> str:
        """
        A warning message to explain the reason when targetFap cannot be achieved for trained model
        """
        return pulumi.get(self, "warning")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> int:
        """
        Window size defined during training or deduced by the algorithm.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class GetDetectionModelsModelCollectionItemModelTrainingResultRowReductionDetailResult(dict):
    def __init__(__self__, *,
                 is_reduction_enabled: bool,
                 reduction_method: str,
                 reduction_percentage: float):
        """
        :param bool is_reduction_enabled: A boolean value to indicate if row reduction is applied
        :param str reduction_method: Method for row reduction:
               * DELETE_ROW - delete rows with equal intervals
               * AVERAGE_ROW - average multiple rows to one row
        :param float reduction_percentage: A percentage to reduce data size down to on top of original data
        """
        GetDetectionModelsModelCollectionItemModelTrainingResultRowReductionDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_reduction_enabled=is_reduction_enabled,
            reduction_method=reduction_method,
            reduction_percentage=reduction_percentage,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_reduction_enabled: bool,
             reduction_method: str,
             reduction_percentage: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("is_reduction_enabled", is_reduction_enabled)
        _setter("reduction_method", reduction_method)
        _setter("reduction_percentage", reduction_percentage)

    @property
    @pulumi.getter(name="isReductionEnabled")
    def is_reduction_enabled(self) -> bool:
        """
        A boolean value to indicate if row reduction is applied
        """
        return pulumi.get(self, "is_reduction_enabled")

    @property
    @pulumi.getter(name="reductionMethod")
    def reduction_method(self) -> str:
        """
        Method for row reduction:
        * DELETE_ROW - delete rows with equal intervals
        * AVERAGE_ROW - average multiple rows to one row
        """
        return pulumi.get(self, "reduction_method")

    @property
    @pulumi.getter(name="reductionPercentage")
    def reduction_percentage(self) -> float:
        """
        A percentage to reduce data size down to on top of original data
        """
        return pulumi.get(self, "reduction_percentage")


@pulumi.output_type
class GetDetectionModelsModelCollectionItemModelTrainingResultSignalDetailResult(dict):
    def __init__(__self__, *,
                 details: str,
                 fap: float,
                 is_quantized: bool,
                 max: float,
                 min: float,
                 mvi_ratio: float,
                 signal_name: str,
                 status: str,
                 std: float):
        """
        :param str details: detailed information for a signal.
        :param float fap: Accuracy metric for a signal.
        :param bool is_quantized: A boolean value to indicate if a signal is quantized or not.
        :param float max: Max value within a signal.
        :param float min: Min value within a signal.
        :param float mvi_ratio: The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        :param str signal_name: The name of a signal.
        :param str status: Status of the signal:
               * ACCEPTED - the signal is used for training the model
               * DROPPED - the signal does not meet requirement, and is dropped before training the model.
               * OTHER - placeholder for other status
        :param float std: Standard deviation of values within a signal.
        """
        GetDetectionModelsModelCollectionItemModelTrainingResultSignalDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            details=details,
            fap=fap,
            is_quantized=is_quantized,
            max=max,
            min=min,
            mvi_ratio=mvi_ratio,
            signal_name=signal_name,
            status=status,
            std=std,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             details: str,
             fap: float,
             is_quantized: bool,
             max: float,
             min: float,
             mvi_ratio: float,
             signal_name: str,
             status: str,
             std: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("details", details)
        _setter("fap", fap)
        _setter("is_quantized", is_quantized)
        _setter("max", max)
        _setter("min", min)
        _setter("mvi_ratio", mvi_ratio)
        _setter("signal_name", signal_name)
        _setter("status", status)
        _setter("std", std)

    @property
    @pulumi.getter
    def details(self) -> str:
        """
        detailed information for a signal.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def fap(self) -> float:
        """
        Accuracy metric for a signal.
        """
        return pulumi.get(self, "fap")

    @property
    @pulumi.getter(name="isQuantized")
    def is_quantized(self) -> bool:
        """
        A boolean value to indicate if a signal is quantized or not.
        """
        return pulumi.get(self, "is_quantized")

    @property
    @pulumi.getter
    def max(self) -> float:
        """
        Max value within a signal.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> float:
        """
        Min value within a signal.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter(name="mviRatio")
    def mvi_ratio(self) -> float:
        """
        The ratio of missing values in a signal filled/imputed by the IDP algorithm.
        """
        return pulumi.get(self, "mvi_ratio")

    @property
    @pulumi.getter(name="signalName")
    def signal_name(self) -> str:
        """
        The name of a signal.
        """
        return pulumi.get(self, "signal_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the signal:
        * ACCEPTED - the signal is used for training the model
        * DROPPED - the signal does not meet requirement, and is dropped before training the model.
        * OTHER - placeholder for other status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def std(self) -> float:
        """
        Standard deviation of values within a signal.
        """
        return pulumi.get(self, "std")


@pulumi.output_type
class GetDetectionProjectsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDetectionProjectsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDetectionProjectsProjectCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDetectionProjectsProjectCollectionItemResult']):
        GetDetectionProjectsProjectCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetDetectionProjectsProjectCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDetectionProjectsProjectCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDetectionProjectsProjectCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: A short description of the project.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The OCID of the project that is immutable on creation.
        :param str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param str time_updated: The date and time the resource was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        GetDetectionProjectsProjectCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A short description of the project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the project that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")


