# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ConfigDimension',
    'ConfigInUseBy',
    'ConfigMetric',
    'ConfigRule',
    'GetConfigDimensionResult',
    'GetConfigInUseByResult',
    'GetConfigMetricResult',
    'GetConfigRuleResult',
    'GetConfigsConfigCollectionResult',
    'GetConfigsConfigCollectionItemResult',
    'GetConfigsConfigCollectionItemDimensionResult',
    'GetConfigsConfigCollectionItemInUseByResult',
    'GetConfigsConfigCollectionItemMetricResult',
    'GetConfigsConfigCollectionItemRuleResult',
    'GetConfigsFilterResult',
]

@pulumi.output_type
class ConfigDimension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueSource":
            suggest = "value_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigDimension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigDimension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigDimension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value_source: Optional[str] = None):
        """
        :param str name: (Updatable) The name of the metric. This must be a known metric name.
        :param str value_source: (Updatable) This must not be set.
        """
        ConfigDimension._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value_source=value_source,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             value_source: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if name is not None:
            _setter("name", name)
        if value_source is not None:
            _setter("value_source", value_source)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) The name of the metric. This must be a known metric name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> Optional[str]:
        """
        (Updatable) This must not be set.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class ConfigInUseBy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configType":
            suggest = "config_type"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "optionsGroup":
            suggest = "options_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigInUseBy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigInUseBy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigInUseBy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_type: Optional[str] = None,
                 display_name: Optional[str] = None,
                 id: Optional[str] = None,
                 options_group: Optional[str] = None):
        """
        :param str config_type: (Updatable) The type of configuration item.
        :param str display_name: (Updatable) The name by which a configuration entity is displayed to the end user.
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        :param str options_group: A string that specifies the group that an OPTIONS item belongs to.
        """
        ConfigInUseBy._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            config_type=config_type,
            display_name=display_name,
            id=id,
            options_group=options_group,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             config_type: Optional[str] = None,
             display_name: Optional[str] = None,
             id: Optional[str] = None,
             options_group: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if config_type is not None:
            _setter("config_type", config_type)
        if display_name is not None:
            _setter("display_name", display_name)
        if id is not None:
            _setter("id", id)
        if options_group is not None:
            _setter("options_group", options_group)

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> Optional[str]:
        """
        (Updatable) The type of configuration item.
        """
        return pulumi.get(self, "config_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        (Updatable) The name by which a configuration entity is displayed to the end user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="optionsGroup")
    def options_group(self) -> Optional[str]:
        """
        A string that specifies the group that an OPTIONS item belongs to.
        """
        return pulumi.get(self, "options_group")


@pulumi.output_type
class ConfigMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueSource":
            suggest = "value_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 name: Optional[str] = None,
                 unit: Optional[str] = None,
                 value_source: Optional[str] = None):
        """
        :param str description: (Updatable) A description of the metric.
        :param str name: (Updatable) The name of the metric. This must be a known metric name.
        :param str unit: (Updatable) The unit of the metric.
        :param str value_source: (Updatable) This must not be set.
        """
        ConfigMetric._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            name=name,
            unit=unit,
            value_source=value_source,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: Optional[str] = None,
             name: Optional[str] = None,
             unit: Optional[str] = None,
             value_source: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if description is not None:
            _setter("description", description)
        if name is not None:
            _setter("name", name)
        if unit is not None:
            _setter("unit", unit)
        if value_source is not None:
            _setter("value_source", value_source)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        (Updatable) A description of the metric.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) The name of the metric. This must be a known metric name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        (Updatable) The unit of the metric.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> Optional[str]:
        """
        (Updatable) This must not be set.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class ConfigRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "filterText":
            suggest = "filter_text"
        elif key == "isApplyToErrorSpans":
            suggest = "is_apply_to_error_spans"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "satisfiedResponseTime":
            suggest = "satisfied_response_time"
        elif key == "toleratingResponseTime":
            suggest = "tolerating_response_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 filter_text: Optional[str] = None,
                 is_apply_to_error_spans: Optional[bool] = None,
                 is_enabled: Optional[bool] = None,
                 priority: Optional[int] = None,
                 satisfied_response_time: Optional[int] = None,
                 tolerating_response_time: Optional[int] = None):
        """
        :param str display_name: (Updatable) The name by which a configuration entity is displayed to the end user.
        :param str filter_text: (Updatable) The string that defines the Span Filter expression.
        :param bool is_apply_to_error_spans: (Updatable) Specifies whether an Apdex score should be computed for error spans. Setting it to "true" means that the Apdex score is computed in the usual way. Setting it to "false" skips the Apdex computation and sets the Apdex score to "frustrating" regardless of the configured thresholds. The default is "false".
        :param bool is_enabled: (Updatable) Specifies whether the Apdex score should be computed for spans matching the rule. This can be used to disable Apdex score for spans that do not need or require it. The default is "true".
        :param int priority: (Updatable) The priority controls the order in which multiple rules in a rule set are applied. Lower values indicate higher priorities. Rules with higher priority are applied first, and once a match is found, the rest of the rules are ignored. Rules within the same rule set cannot have the same priority.
        :param int satisfied_response_time: (Updatable) The maximum response time in milliseconds that is considered "satisfactory" for the end user.
        :param int tolerating_response_time: (Updatable) The maximum response time in milliseconds that is considered "tolerable" for the end user. A response time beyond this threshold is considered "frustrating". This value cannot be lower than "satisfiedResponseTime". 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ConfigRule._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            filter_text=filter_text,
            is_apply_to_error_spans=is_apply_to_error_spans,
            is_enabled=is_enabled,
            priority=priority,
            satisfied_response_time=satisfied_response_time,
            tolerating_response_time=tolerating_response_time,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: Optional[str] = None,
             filter_text: Optional[str] = None,
             is_apply_to_error_spans: Optional[bool] = None,
             is_enabled: Optional[bool] = None,
             priority: Optional[int] = None,
             satisfied_response_time: Optional[int] = None,
             tolerating_response_time: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if display_name is not None:
            _setter("display_name", display_name)
        if filter_text is not None:
            _setter("filter_text", filter_text)
        if is_apply_to_error_spans is not None:
            _setter("is_apply_to_error_spans", is_apply_to_error_spans)
        if is_enabled is not None:
            _setter("is_enabled", is_enabled)
        if priority is not None:
            _setter("priority", priority)
        if satisfied_response_time is not None:
            _setter("satisfied_response_time", satisfied_response_time)
        if tolerating_response_time is not None:
            _setter("tolerating_response_time", tolerating_response_time)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        (Updatable) The name by which a configuration entity is displayed to the end user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="filterText")
    def filter_text(self) -> Optional[str]:
        """
        (Updatable) The string that defines the Span Filter expression.
        """
        return pulumi.get(self, "filter_text")

    @property
    @pulumi.getter(name="isApplyToErrorSpans")
    def is_apply_to_error_spans(self) -> Optional[bool]:
        """
        (Updatable) Specifies whether an Apdex score should be computed for error spans. Setting it to "true" means that the Apdex score is computed in the usual way. Setting it to "false" skips the Apdex computation and sets the Apdex score to "frustrating" regardless of the configured thresholds. The default is "false".
        """
        return pulumi.get(self, "is_apply_to_error_spans")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        (Updatable) Specifies whether the Apdex score should be computed for spans matching the rule. This can be used to disable Apdex score for spans that do not need or require it. The default is "true".
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        (Updatable) The priority controls the order in which multiple rules in a rule set are applied. Lower values indicate higher priorities. Rules with higher priority are applied first, and once a match is found, the rest of the rules are ignored. Rules within the same rule set cannot have the same priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="satisfiedResponseTime")
    def satisfied_response_time(self) -> Optional[int]:
        """
        (Updatable) The maximum response time in milliseconds that is considered "satisfactory" for the end user.
        """
        return pulumi.get(self, "satisfied_response_time")

    @property
    @pulumi.getter(name="toleratingResponseTime")
    def tolerating_response_time(self) -> Optional[int]:
        """
        (Updatable) The maximum response time in milliseconds that is considered "tolerable" for the end user. A response time beyond this threshold is considered "frustrating". This value cannot be lower than "satisfiedResponseTime". 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tolerating_response_time")


@pulumi.output_type
class GetConfigDimensionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value_source: str):
        """
        :param str name: The name of the metric. This must be a known metric name.
        :param str value_source: This must not be set.
        """
        GetConfigDimensionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value_source=value_source,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             value_source: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("value_source", value_source)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the metric. This must be a known metric name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> str:
        """
        This must not be set.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class GetConfigInUseByResult(dict):
    def __init__(__self__, *,
                 config_type: str,
                 display_name: str,
                 id: str,
                 options_group: str):
        """
        :param str config_type: The type of configuration item.
        :param str display_name: The name by which a configuration entity is displayed to the end user.
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        :param str options_group: A string that specifies the group that an OPTIONS item belongs to.
        """
        GetConfigInUseByResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            config_type=config_type,
            display_name=display_name,
            id=id,
            options_group=options_group,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             config_type: str,
             display_name: str,
             id: str,
             options_group: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("config_type", config_type)
        _setter("display_name", display_name)
        _setter("id", id)
        _setter("options_group", options_group)

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> str:
        """
        The type of configuration item.
        """
        return pulumi.get(self, "config_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The name by which a configuration entity is displayed to the end user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="optionsGroup")
    def options_group(self) -> str:
        """
        A string that specifies the group that an OPTIONS item belongs to.
        """
        return pulumi.get(self, "options_group")


@pulumi.output_type
class GetConfigMetricResult(dict):
    def __init__(__self__, *,
                 description: str,
                 name: str,
                 unit: str,
                 value_source: str):
        """
        :param str description: A description of the metric.
        :param str name: The name of the metric. This must be a known metric name.
        :param str unit: The unit of the metric.
        :param str value_source: This must not be set.
        """
        GetConfigMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            name=name,
            unit=unit,
            value_source=value_source,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: str,
             name: str,
             unit: str,
             value_source: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("description", description)
        _setter("name", name)
        _setter("unit", unit)
        _setter("value_source", value_source)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the metric.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the metric. This must be a known metric name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def unit(self) -> str:
        """
        The unit of the metric.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> str:
        """
        This must not be set.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class GetConfigRuleResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 filter_text: str,
                 is_apply_to_error_spans: bool,
                 is_enabled: bool,
                 priority: int,
                 satisfied_response_time: int,
                 tolerating_response_time: int):
        """
        :param str display_name: The name by which a configuration entity is displayed to the end user.
        :param str filter_text: The string that defines the Span Filter expression.
        :param bool is_apply_to_error_spans: Specifies whether an Apdex score should be computed for error spans. Setting it to "true" means that the Apdex score is computed in the usual way. Setting it to "false" skips the Apdex computation and sets the Apdex score to "frustrating" regardless of the configured thresholds. The default is "false".
        :param bool is_enabled: Specifies whether the Apdex score should be computed for spans matching the rule. This can be used to disable Apdex score for spans that do not need or require it. The default is "true".
        :param int priority: The priority controls the order in which multiple rules in a rule set are applied. Lower values indicate higher priorities. Rules with higher priority are applied first, and once a match is found, the rest of the rules are ignored. Rules within the same rule set cannot have the same priority.
        :param int satisfied_response_time: The maximum response time in milliseconds that is considered "satisfactory" for the end user.
        :param int tolerating_response_time: The maximum response time in milliseconds that is considered "tolerable" for the end user. A response time beyond this threshold is considered "frustrating". This value cannot be lower than "satisfiedResponseTime".
        """
        GetConfigRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            filter_text=filter_text,
            is_apply_to_error_spans=is_apply_to_error_spans,
            is_enabled=is_enabled,
            priority=priority,
            satisfied_response_time=satisfied_response_time,
            tolerating_response_time=tolerating_response_time,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: str,
             filter_text: str,
             is_apply_to_error_spans: bool,
             is_enabled: bool,
             priority: int,
             satisfied_response_time: int,
             tolerating_response_time: int,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("display_name", display_name)
        _setter("filter_text", filter_text)
        _setter("is_apply_to_error_spans", is_apply_to_error_spans)
        _setter("is_enabled", is_enabled)
        _setter("priority", priority)
        _setter("satisfied_response_time", satisfied_response_time)
        _setter("tolerating_response_time", tolerating_response_time)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The name by which a configuration entity is displayed to the end user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="filterText")
    def filter_text(self) -> str:
        """
        The string that defines the Span Filter expression.
        """
        return pulumi.get(self, "filter_text")

    @property
    @pulumi.getter(name="isApplyToErrorSpans")
    def is_apply_to_error_spans(self) -> bool:
        """
        Specifies whether an Apdex score should be computed for error spans. Setting it to "true" means that the Apdex score is computed in the usual way. Setting it to "false" skips the Apdex computation and sets the Apdex score to "frustrating" regardless of the configured thresholds. The default is "false".
        """
        return pulumi.get(self, "is_apply_to_error_spans")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Specifies whether the Apdex score should be computed for spans matching the rule. This can be used to disable Apdex score for spans that do not need or require it. The default is "true".
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The priority controls the order in which multiple rules in a rule set are applied. Lower values indicate higher priorities. Rules with higher priority are applied first, and once a match is found, the rest of the rules are ignored. Rules within the same rule set cannot have the same priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="satisfiedResponseTime")
    def satisfied_response_time(self) -> int:
        """
        The maximum response time in milliseconds that is considered "satisfactory" for the end user.
        """
        return pulumi.get(self, "satisfied_response_time")

    @property
    @pulumi.getter(name="toleratingResponseTime")
    def tolerating_response_time(self) -> int:
        """
        The maximum response time in milliseconds that is considered "tolerable" for the end user. A response time beyond this threshold is considered "frustrating". This value cannot be lower than "satisfiedResponseTime".
        """
        return pulumi.get(self, "tolerating_response_time")


@pulumi.output_type
class GetConfigsConfigCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConfigsConfigCollectionItemResult']):
        GetConfigsConfigCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetConfigsConfigCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConfigsConfigCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConfigsConfigCollectionItemResult(dict):
    def __init__(__self__, *,
                 apm_domain_id: str,
                 config_type: str,
                 created_by: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 dimensions: Sequence['outputs.GetConfigsConfigCollectionItemDimensionResult'],
                 display_name: str,
                 etag: str,
                 filter_id: str,
                 filter_text: str,
                 freeform_tags: Mapping[str, Any],
                 group: str,
                 id: str,
                 in_use_bies: Sequence['outputs.GetConfigsConfigCollectionItemInUseByResult'],
                 metrics: Sequence['outputs.GetConfigsConfigCollectionItemMetricResult'],
                 namespace: str,
                 opc_dry_run: str,
                 options: str,
                 rules: Sequence['outputs.GetConfigsConfigCollectionItemRuleResult'],
                 time_created: str,
                 time_updated: str,
                 updated_by: str):
        """
        :param str apm_domain_id: The APM Domain ID the request is intended for.
        :param str config_type: A filter to match configuration items of a given type. Supported values are SPAN_FILTER, METRIC_GROUP, and APDEX.
        :param str created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: A description of the metric.
        :param Sequence['GetConfigsConfigCollectionItemDimensionArgs'] dimensions: A list of dimensions for the metric. This variable should not be used.
        :param str display_name: A filter to return resources that match the given display name.
        :param str etag: For optimistic concurrency control. See `if-match`.
        :param str filter_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        :param str filter_text: The string that defines the Span Filter expression.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str group: A string that specifies the group that an OPTIONS item belongs to.
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        :param Sequence['GetConfigsConfigCollectionItemInUseByArgs'] in_use_bies: The list of configuration items that reference the span filter.
        :param Sequence['GetConfigsConfigCollectionItemMetricArgs'] metrics: The list of metrics in this group.
        :param str namespace: The namespace to which the metrics are published. It must be one of several predefined namespaces.
        :param str options: The options are stored here as JSON.
        :param str time_created: The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param str time_updated: The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        :param str updated_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        GetConfigsConfigCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            apm_domain_id=apm_domain_id,
            config_type=config_type,
            created_by=created_by,
            defined_tags=defined_tags,
            description=description,
            dimensions=dimensions,
            display_name=display_name,
            etag=etag,
            filter_id=filter_id,
            filter_text=filter_text,
            freeform_tags=freeform_tags,
            group=group,
            id=id,
            in_use_bies=in_use_bies,
            metrics=metrics,
            namespace=namespace,
            opc_dry_run=opc_dry_run,
            options=options,
            rules=rules,
            time_created=time_created,
            time_updated=time_updated,
            updated_by=updated_by,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             apm_domain_id: str,
             config_type: str,
             created_by: str,
             defined_tags: Mapping[str, Any],
             description: str,
             dimensions: Sequence['outputs.GetConfigsConfigCollectionItemDimensionResult'],
             display_name: str,
             etag: str,
             filter_id: str,
             filter_text: str,
             freeform_tags: Mapping[str, Any],
             group: str,
             id: str,
             in_use_bies: Sequence['outputs.GetConfigsConfigCollectionItemInUseByResult'],
             metrics: Sequence['outputs.GetConfigsConfigCollectionItemMetricResult'],
             namespace: str,
             opc_dry_run: str,
             options: str,
             rules: Sequence['outputs.GetConfigsConfigCollectionItemRuleResult'],
             time_created: str,
             time_updated: str,
             updated_by: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("apm_domain_id", apm_domain_id)
        _setter("config_type", config_type)
        _setter("created_by", created_by)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("dimensions", dimensions)
        _setter("display_name", display_name)
        _setter("etag", etag)
        _setter("filter_id", filter_id)
        _setter("filter_text", filter_text)
        _setter("freeform_tags", freeform_tags)
        _setter("group", group)
        _setter("id", id)
        _setter("in_use_bies", in_use_bies)
        _setter("metrics", metrics)
        _setter("namespace", namespace)
        _setter("opc_dry_run", opc_dry_run)
        _setter("options", options)
        _setter("rules", rules)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("updated_by", updated_by)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> str:
        """
        The APM Domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> str:
        """
        A filter to match configuration items of a given type. Supported values are SPAN_FILTER, METRIC_GROUP, and APDEX.
        """
        return pulumi.get(self, "config_type")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the metric.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetConfigsConfigCollectionItemDimensionResult']:
        """
        A list of dimensions for the metric. This variable should not be used.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return resources that match the given display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        For optimistic concurrency control. See `if-match`.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="filterId")
    def filter_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Span Filter. The filterId is mandatory for the creation of MetricGroups. A filterId is generated when a Span Filter is created.
        """
        return pulumi.get(self, "filter_id")

    @property
    @pulumi.getter(name="filterText")
    def filter_text(self) -> str:
        """
        The string that defines the Span Filter expression.
        """
        return pulumi.get(self, "filter_text")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def group(self) -> str:
        """
        A string that specifies the group that an OPTIONS item belongs to.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inUseBies")
    def in_use_bies(self) -> Sequence['outputs.GetConfigsConfigCollectionItemInUseByResult']:
        """
        The list of configuration items that reference the span filter.
        """
        return pulumi.get(self, "in_use_bies")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetConfigsConfigCollectionItemMetricResult']:
        """
        The list of metrics in this group.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace to which the metrics are published. It must be one of several predefined namespaces.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> str:
        return pulumi.get(self, "opc_dry_run")

    @property
    @pulumi.getter
    def options(self) -> str:
        """
        The options are stored here as JSON.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetConfigsConfigCollectionItemRuleResult']:
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a user.
        """
        return pulumi.get(self, "updated_by")


@pulumi.output_type
class GetConfigsConfigCollectionItemDimensionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value_source: str):
        """
        :param str name: The name of the metric. This must be a known metric name.
        :param str value_source: This must not be set.
        """
        GetConfigsConfigCollectionItemDimensionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value_source=value_source,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             value_source: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("value_source", value_source)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the metric. This must be a known metric name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> str:
        """
        This must not be set.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class GetConfigsConfigCollectionItemInUseByResult(dict):
    def __init__(__self__, *,
                 config_type: str,
                 display_name: str,
                 id: str,
                 options_group: str):
        """
        :param str config_type: A filter to match configuration items of a given type. Supported values are SPAN_FILTER, METRIC_GROUP, and APDEX.
        :param str display_name: A filter to return resources that match the given display name.
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        :param str options_group: A filter to return OPTIONS resources that match the given group.
        """
        GetConfigsConfigCollectionItemInUseByResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            config_type=config_type,
            display_name=display_name,
            id=id,
            options_group=options_group,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             config_type: str,
             display_name: str,
             id: str,
             options_group: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("config_type", config_type)
        _setter("display_name", display_name)
        _setter("id", id)
        _setter("options_group", options_group)

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> str:
        """
        A filter to match configuration items of a given type. Supported values are SPAN_FILTER, METRIC_GROUP, and APDEX.
        """
        return pulumi.get(self, "config_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return resources that match the given display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the configuration item. An OCID is generated when the item is created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="optionsGroup")
    def options_group(self) -> str:
        """
        A filter to return OPTIONS resources that match the given group.
        """
        return pulumi.get(self, "options_group")


@pulumi.output_type
class GetConfigsConfigCollectionItemMetricResult(dict):
    def __init__(__self__, *,
                 description: str,
                 name: str,
                 unit: str,
                 value_source: str):
        """
        :param str description: A description of the metric.
        :param str name: The name of the metric. This must be a known metric name.
        :param str unit: The unit of the metric.
        :param str value_source: This must not be set.
        """
        GetConfigsConfigCollectionItemMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            name=name,
            unit=unit,
            value_source=value_source,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: str,
             name: str,
             unit: str,
             value_source: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("description", description)
        _setter("name", name)
        _setter("unit", unit)
        _setter("value_source", value_source)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the metric.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the metric. This must be a known metric name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def unit(self) -> str:
        """
        The unit of the metric.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> str:
        """
        This must not be set.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class GetConfigsConfigCollectionItemRuleResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 filter_text: str,
                 is_apply_to_error_spans: bool,
                 is_enabled: bool,
                 priority: int,
                 satisfied_response_time: int,
                 tolerating_response_time: int):
        """
        :param str display_name: A filter to return resources that match the given display name.
        :param str filter_text: The string that defines the Span Filter expression.
        :param bool is_apply_to_error_spans: Specifies whether an Apdex score should be computed for error spans. Setting it to "true" means that the Apdex score is computed in the usual way. Setting it to "false" skips the Apdex computation and sets the Apdex score to "frustrating" regardless of the configured thresholds. The default is "false".
        :param bool is_enabled: Specifies whether the Apdex score should be computed for spans matching the rule. This can be used to disable Apdex score for spans that do not need or require it. The default is "true".
        :param int priority: The priority controls the order in which multiple rules in a rule set are applied. Lower values indicate higher priorities. Rules with higher priority are applied first, and once a match is found, the rest of the rules are ignored. Rules within the same rule set cannot have the same priority.
        :param int satisfied_response_time: The maximum response time in milliseconds that is considered "satisfactory" for the end user.
        :param int tolerating_response_time: The maximum response time in milliseconds that is considered "tolerable" for the end user. A response time beyond this threshold is considered "frustrating". This value cannot be lower than "satisfiedResponseTime".
        """
        GetConfigsConfigCollectionItemRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            filter_text=filter_text,
            is_apply_to_error_spans=is_apply_to_error_spans,
            is_enabled=is_enabled,
            priority=priority,
            satisfied_response_time=satisfied_response_time,
            tolerating_response_time=tolerating_response_time,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: str,
             filter_text: str,
             is_apply_to_error_spans: bool,
             is_enabled: bool,
             priority: int,
             satisfied_response_time: int,
             tolerating_response_time: int,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("display_name", display_name)
        _setter("filter_text", filter_text)
        _setter("is_apply_to_error_spans", is_apply_to_error_spans)
        _setter("is_enabled", is_enabled)
        _setter("priority", priority)
        _setter("satisfied_response_time", satisfied_response_time)
        _setter("tolerating_response_time", tolerating_response_time)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return resources that match the given display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="filterText")
    def filter_text(self) -> str:
        """
        The string that defines the Span Filter expression.
        """
        return pulumi.get(self, "filter_text")

    @property
    @pulumi.getter(name="isApplyToErrorSpans")
    def is_apply_to_error_spans(self) -> bool:
        """
        Specifies whether an Apdex score should be computed for error spans. Setting it to "true" means that the Apdex score is computed in the usual way. Setting it to "false" skips the Apdex computation and sets the Apdex score to "frustrating" regardless of the configured thresholds. The default is "false".
        """
        return pulumi.get(self, "is_apply_to_error_spans")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Specifies whether the Apdex score should be computed for spans matching the rule. This can be used to disable Apdex score for spans that do not need or require it. The default is "true".
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The priority controls the order in which multiple rules in a rule set are applied. Lower values indicate higher priorities. Rules with higher priority are applied first, and once a match is found, the rest of the rules are ignored. Rules within the same rule set cannot have the same priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="satisfiedResponseTime")
    def satisfied_response_time(self) -> int:
        """
        The maximum response time in milliseconds that is considered "satisfactory" for the end user.
        """
        return pulumi.get(self, "satisfied_response_time")

    @property
    @pulumi.getter(name="toleratingResponseTime")
    def tolerating_response_time(self) -> int:
        """
        The maximum response time in milliseconds that is considered "tolerable" for the end user. A response time beyond this threshold is considered "frustrating". This value cannot be lower than "satisfiedResponseTime".
        """
        return pulumi.get(self, "tolerating_response_time")


@pulumi.output_type
class GetConfigsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the metric. This must be a known metric name.
        """
        GetConfigsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the metric. This must be a known metric name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


