# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetVantagePointResult',
    'AwaitableGetVantagePointResult',
    'get_vantage_point',
    'get_vantage_point_output',
]

@pulumi.output_type
class GetVantagePointResult:
    """
    A collection of values returned by getVantagePoint.
    """
    def __init__(__self__, apm_domain_id=None, display_name=None, id=None, items=None, name=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> str:
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetVantagePointItemResult']:
        """
        List of PublicVantagePointSummary items.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Unique permanent name of the vantage point.
        """
        return pulumi.get(self, "name")


class AwaitableGetVantagePointResult(GetVantagePointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVantagePointResult(
            apm_domain_id=self.apm_domain_id,
            display_name=self.display_name,
            id=self.id,
            items=self.items,
            name=self.name)


def get_vantage_point(apm_domain_id: Optional[str] = None,
                      display_name: Optional[str] = None,
                      name: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVantagePointResult:
    """
    This data source provides details about a specific Public Vantage Point resource in Oracle Cloud Infrastructure Apm Synthetics service.

    Returns a list of public vantage points.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_public_vantage_point = oci.ApmSynthetics.get_vantage_point(apm_domain_id=oci_apm_synthetics_apm_domain["test_apm_domain"]["id"],
        display_name=var["public_vantage_point_display_name"],
        name=var["public_vantage_point_name"])
    ```


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str display_name: A filter to return only the resources that match the entire display name.
    :param str name: A filter to return only the resources that match the entire name.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['displayName'] = display_name
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmSynthetics/getVantagePoint:getVantagePoint', __args__, opts=opts, typ=GetVantagePointResult).value

    return AwaitableGetVantagePointResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        name=pulumi.get(__ret__, 'name'))


@_utilities.lift_output_func(get_vantage_point)
def get_vantage_point_output(apm_domain_id: Optional[pulumi.Input[str]] = None,
                             display_name: Optional[pulumi.Input[Optional[str]]] = None,
                             name: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVantagePointResult]:
    """
    This data source provides details about a specific Public Vantage Point resource in Oracle Cloud Infrastructure Apm Synthetics service.

    Returns a list of public vantage points.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_public_vantage_point = oci.ApmSynthetics.get_vantage_point(apm_domain_id=oci_apm_synthetics_apm_domain["test_apm_domain"]["id"],
        display_name=var["public_vantage_point_display_name"],
        name=var["public_vantage_point_name"])
    ```


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str display_name: A filter to return only the resources that match the entire display name.
    :param str name: A filter to return only the resources that match the entire name.
    """
    ...
