# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVantagePointsResult',
    'AwaitableGetVantagePointsResult',
    'get_vantage_points',
    'get_vantage_points_output',
]

@pulumi.output_type
class GetVantagePointsResult:
    """
    A collection of values returned by getVantagePoints.
    """
    def __init__(__self__, apm_domain_id=None, display_name=None, filters=None, id=None, name=None, public_vantage_point_collections=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_vantage_point_collections and not isinstance(public_vantage_point_collections, list):
            raise TypeError("Expected argument 'public_vantage_point_collections' to be a list")
        pulumi.set(__self__, "public_vantage_point_collections", public_vantage_point_collections)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> str:
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVantagePointsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Unique permanent name of the vantage point.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicVantagePointCollections")
    def public_vantage_point_collections(self) -> Sequence['outputs.GetVantagePointsPublicVantagePointCollectionResult']:
        """
        The list of public_vantage_point_collection.
        """
        return pulumi.get(self, "public_vantage_point_collections")


class AwaitableGetVantagePointsResult(GetVantagePointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVantagePointsResult(
            apm_domain_id=self.apm_domain_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            name=self.name,
            public_vantage_point_collections=self.public_vantage_point_collections)


def get_vantage_points(apm_domain_id: Optional[str] = None,
                       display_name: Optional[str] = None,
                       filters: Optional[Sequence[pulumi.InputType['GetVantagePointsFilterArgs']]] = None,
                       name: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVantagePointsResult:
    """
    This data source provides the list of Public Vantage Points in Oracle Cloud Infrastructure Apm Synthetics service.

    Returns a list of public vantage points.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_public_vantage_points = oci.ApmSynthetics.get_vantage_points(apm_domain_id=oci_apm_synthetics_apm_domain["test_apm_domain"]["id"],
        display_name=var["public_vantage_point_display_name"],
        name=var["public_vantage_point_name"])
    ```


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str display_name: A filter to return only the resources that match the entire display name.
    :param str name: A filter to return only the resources that match the entire name.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmSynthetics/getVantagePoints:getVantagePoints', __args__, opts=opts, typ=GetVantagePointsResult).value

    return AwaitableGetVantagePointsResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        public_vantage_point_collections=pulumi.get(__ret__, 'public_vantage_point_collections'))


@_utilities.lift_output_func(get_vantage_points)
def get_vantage_points_output(apm_domain_id: Optional[pulumi.Input[str]] = None,
                              display_name: Optional[pulumi.Input[Optional[str]]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetVantagePointsFilterArgs']]]]] = None,
                              name: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVantagePointsResult]:
    """
    This data source provides the list of Public Vantage Points in Oracle Cloud Infrastructure Apm Synthetics service.

    Returns a list of public vantage points.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_public_vantage_points = oci.ApmSynthetics.get_vantage_points(apm_domain_id=oci_apm_synthetics_apm_domain["test_apm_domain"]["id"],
        display_name=var["public_vantage_point_display_name"],
        name=var["public_vantage_point_name"])
    ```


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str display_name: A filter to return only the resources that match the entire display name.
    :param str name: A filter to return only the resources that match the entire name.
    """
    ...
