# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataMaskRuleArgs', 'DataMaskRule']

@pulumi.input_type
class DataMaskRuleArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 data_mask_categories: pulumi.Input[Sequence[pulumi.Input[str]]],
                 display_name: pulumi.Input[str],
                 iam_group_id: pulumi.Input[str],
                 target_selected: pulumi.Input['DataMaskRuleTargetSelectedArgs'],
                 data_mask_rule_status: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DataMaskRule resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier where the resource is created
        :param pulumi.Input[Sequence[pulumi.Input[str]]] data_mask_categories: (Updatable) Data Mask Categories
        :param pulumi.Input[str] display_name: (Updatable) Data mask rule name.
               
               Avoid entering confidential information.
        :param pulumi.Input[str] iam_group_id: (Updatable) IAM Group id associated with the data mask rule
        :param pulumi.Input['DataMaskRuleTargetSelectedArgs'] target_selected: (Updatable) Target Selection eg select ALL or select on basis of TargetResourceTypes or TargetIds.
        :param pulumi.Input[str] data_mask_rule_status: (Updatable) The status of the dataMaskRule.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: The data mask rule description. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[str] state: The current state of the DataMaskRule.
        """
        DataMaskRuleArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            data_mask_categories=data_mask_categories,
            display_name=display_name,
            iam_group_id=iam_group_id,
            target_selected=target_selected,
            data_mask_rule_status=data_mask_rule_status,
            defined_tags=defined_tags,
            description=description,
            freeform_tags=freeform_tags,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             data_mask_categories: pulumi.Input[Sequence[pulumi.Input[str]]],
             display_name: pulumi.Input[str],
             iam_group_id: pulumi.Input[str],
             target_selected: pulumi.Input['DataMaskRuleTargetSelectedArgs'],
             data_mask_rule_status: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             state: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("data_mask_categories", data_mask_categories)
        _setter("display_name", display_name)
        _setter("iam_group_id", iam_group_id)
        _setter("target_selected", target_selected)
        if data_mask_rule_status is not None:
            _setter("data_mask_rule_status", data_mask_rule_status)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if state is not None:
            _setter("state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment Identifier where the resource is created
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dataMaskCategories")
    def data_mask_categories(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) Data Mask Categories
        """
        return pulumi.get(self, "data_mask_categories")

    @data_mask_categories.setter
    def data_mask_categories(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "data_mask_categories", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Data mask rule name.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="iamGroupId")
    def iam_group_id(self) -> pulumi.Input[str]:
        """
        (Updatable) IAM Group id associated with the data mask rule
        """
        return pulumi.get(self, "iam_group_id")

    @iam_group_id.setter
    def iam_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "iam_group_id", value)

    @property
    @pulumi.getter(name="targetSelected")
    def target_selected(self) -> pulumi.Input['DataMaskRuleTargetSelectedArgs']:
        """
        (Updatable) Target Selection eg select ALL or select on basis of TargetResourceTypes or TargetIds.
        """
        return pulumi.get(self, "target_selected")

    @target_selected.setter
    def target_selected(self, value: pulumi.Input['DataMaskRuleTargetSelectedArgs']):
        pulumi.set(self, "target_selected", value)

    @property
    @pulumi.getter(name="dataMaskRuleStatus")
    def data_mask_rule_status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The status of the dataMaskRule.
        """
        return pulumi.get(self, "data_mask_rule_status")

    @data_mask_rule_status.setter
    def data_mask_rule_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_mask_rule_status", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The data mask rule description. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the DataMaskRule.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _DataMaskRuleState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_mask_categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_mask_rule_status: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 iam_group_id: Optional[pulumi.Input[str]] = None,
                 lifecyle_details: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_selected: Optional[pulumi.Input['DataMaskRuleTargetSelectedArgs']] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DataMaskRule resources.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier where the resource is created
        :param pulumi.Input[Sequence[pulumi.Input[str]]] data_mask_categories: (Updatable) Data Mask Categories
        :param pulumi.Input[str] data_mask_rule_status: (Updatable) The status of the dataMaskRule.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: The data mask rule description. Avoid entering confidential information.
        :param pulumi.Input[str] display_name: (Updatable) Data mask rule name.
               
               Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[str] iam_group_id: (Updatable) IAM Group id associated with the data mask rule
        :param pulumi.Input[str] lifecyle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] state: The current state of the DataMaskRule.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input['DataMaskRuleTargetSelectedArgs'] target_selected: (Updatable) Target Selection eg select ALL or select on basis of TargetResourceTypes or TargetIds.
        :param pulumi.Input[str] time_created: The date and time the target was created. Format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the target was updated. Format defined by RFC3339.
        """
        _DataMaskRuleState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            data_mask_categories=data_mask_categories,
            data_mask_rule_status=data_mask_rule_status,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            iam_group_id=iam_group_id,
            lifecyle_details=lifecyle_details,
            state=state,
            system_tags=system_tags,
            target_selected=target_selected,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             data_mask_categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             data_mask_rule_status: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             iam_group_id: Optional[pulumi.Input[str]] = None,
             lifecyle_details: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             target_selected: Optional[pulumi.Input['DataMaskRuleTargetSelectedArgs']] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if data_mask_categories is not None:
            _setter("data_mask_categories", data_mask_categories)
        if data_mask_rule_status is not None:
            _setter("data_mask_rule_status", data_mask_rule_status)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if iam_group_id is not None:
            _setter("iam_group_id", iam_group_id)
        if lifecyle_details is not None:
            _setter("lifecyle_details", lifecyle_details)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if target_selected is not None:
            _setter("target_selected", target_selected)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment Identifier where the resource is created
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dataMaskCategories")
    def data_mask_categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Data Mask Categories
        """
        return pulumi.get(self, "data_mask_categories")

    @data_mask_categories.setter
    def data_mask_categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "data_mask_categories", value)

    @property
    @pulumi.getter(name="dataMaskRuleStatus")
    def data_mask_rule_status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The status of the dataMaskRule.
        """
        return pulumi.get(self, "data_mask_rule_status")

    @data_mask_rule_status.setter
    def data_mask_rule_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_mask_rule_status", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The data mask rule description. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Data mask rule name.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="iamGroupId")
    def iam_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) IAM Group id associated with the data mask rule
        """
        return pulumi.get(self, "iam_group_id")

    @iam_group_id.setter
    def iam_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_group_id", value)

    @property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecyle_details")

    @lifecyle_details.setter
    def lifecyle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecyle_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the DataMaskRule.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetSelected")
    def target_selected(self) -> Optional[pulumi.Input['DataMaskRuleTargetSelectedArgs']]:
        """
        (Updatable) Target Selection eg select ALL or select on basis of TargetResourceTypes or TargetIds.
        """
        return pulumi.get(self, "target_selected")

    @target_selected.setter
    def target_selected(self, value: Optional[pulumi.Input['DataMaskRuleTargetSelectedArgs']]):
        pulumi.set(self, "target_selected", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the target was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the target was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class DataMaskRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_mask_categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_mask_rule_status: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 iam_group_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 target_selected: Optional[pulumi.Input[pulumi.InputType['DataMaskRuleTargetSelectedArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Data Mask Rule resource in Oracle Cloud Infrastructure Cloud Guard service.

        Creates a new Data Mask Rule Definition

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_data_mask_rule = oci.cloud_guard.DataMaskRule("testDataMaskRule",
            compartment_id=var["compartment_id"],
            data_mask_categories=var["data_mask_rule_data_mask_categories"],
            display_name=var["data_mask_rule_display_name"],
            iam_group_id=oci_identity_group["test_group"]["id"],
            target_selected=oci.cloud_guard.DataMaskRuleTargetSelectedArgs(
                kind=var["data_mask_rule_target_selected_kind"],
                values=var["data_mask_rule_target_selected_values"],
            ),
            data_mask_rule_status=var["data_mask_rule_data_mask_rule_status"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["data_mask_rule_description"],
            freeform_tags={
                "bar-key": "value",
            },
            state=var["data_mask_rule_state"])
        ```

        ## Import

        DataMaskRules can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:CloudGuard/dataMaskRule:DataMaskRule test_data_mask_rule "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier where the resource is created
        :param pulumi.Input[Sequence[pulumi.Input[str]]] data_mask_categories: (Updatable) Data Mask Categories
        :param pulumi.Input[str] data_mask_rule_status: (Updatable) The status of the dataMaskRule.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: The data mask rule description. Avoid entering confidential information.
        :param pulumi.Input[str] display_name: (Updatable) Data mask rule name.
               
               Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[str] iam_group_id: (Updatable) IAM Group id associated with the data mask rule
        :param pulumi.Input[str] state: The current state of the DataMaskRule.
        :param pulumi.Input[pulumi.InputType['DataMaskRuleTargetSelectedArgs']] target_selected: (Updatable) Target Selection eg select ALL or select on basis of TargetResourceTypes or TargetIds.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataMaskRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Data Mask Rule resource in Oracle Cloud Infrastructure Cloud Guard service.

        Creates a new Data Mask Rule Definition

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_data_mask_rule = oci.cloud_guard.DataMaskRule("testDataMaskRule",
            compartment_id=var["compartment_id"],
            data_mask_categories=var["data_mask_rule_data_mask_categories"],
            display_name=var["data_mask_rule_display_name"],
            iam_group_id=oci_identity_group["test_group"]["id"],
            target_selected=oci.cloud_guard.DataMaskRuleTargetSelectedArgs(
                kind=var["data_mask_rule_target_selected_kind"],
                values=var["data_mask_rule_target_selected_values"],
            ),
            data_mask_rule_status=var["data_mask_rule_data_mask_rule_status"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["data_mask_rule_description"],
            freeform_tags={
                "bar-key": "value",
            },
            state=var["data_mask_rule_state"])
        ```

        ## Import

        DataMaskRules can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:CloudGuard/dataMaskRule:DataMaskRule test_data_mask_rule "id"
        ```

        :param str resource_name: The name of the resource.
        :param DataMaskRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataMaskRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            DataMaskRuleArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_mask_categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_mask_rule_status: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 iam_group_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 target_selected: Optional[pulumi.Input[pulumi.InputType['DataMaskRuleTargetSelectedArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataMaskRuleArgs.__new__(DataMaskRuleArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if data_mask_categories is None and not opts.urn:
                raise TypeError("Missing required property 'data_mask_categories'")
            __props__.__dict__["data_mask_categories"] = data_mask_categories
            __props__.__dict__["data_mask_rule_status"] = data_mask_rule_status
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if iam_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'iam_group_id'")
            __props__.__dict__["iam_group_id"] = iam_group_id
            __props__.__dict__["state"] = state
            if target_selected is not None and not isinstance(target_selected, DataMaskRuleTargetSelectedArgs):
                target_selected = target_selected or {}
                def _setter(key, value):
                    target_selected[key] = value
                DataMaskRuleTargetSelectedArgs._configure(_setter, **target_selected)
            if target_selected is None and not opts.urn:
                raise TypeError("Missing required property 'target_selected'")
            __props__.__dict__["target_selected"] = target_selected
            __props__.__dict__["lifecyle_details"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DataMaskRule, __self__).__init__(
            'oci:CloudGuard/dataMaskRule:DataMaskRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            data_mask_categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            data_mask_rule_status: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            iam_group_id: Optional[pulumi.Input[str]] = None,
            lifecyle_details: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            target_selected: Optional[pulumi.Input[pulumi.InputType['DataMaskRuleTargetSelectedArgs']]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'DataMaskRule':
        """
        Get an existing DataMaskRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier where the resource is created
        :param pulumi.Input[Sequence[pulumi.Input[str]]] data_mask_categories: (Updatable) Data Mask Categories
        :param pulumi.Input[str] data_mask_rule_status: (Updatable) The status of the dataMaskRule.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: The data mask rule description. Avoid entering confidential information.
        :param pulumi.Input[str] display_name: (Updatable) Data mask rule name.
               
               Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
        :param pulumi.Input[str] iam_group_id: (Updatable) IAM Group id associated with the data mask rule
        :param pulumi.Input[str] lifecyle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] state: The current state of the DataMaskRule.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[pulumi.InputType['DataMaskRuleTargetSelectedArgs']] target_selected: (Updatable) Target Selection eg select ALL or select on basis of TargetResourceTypes or TargetIds.
        :param pulumi.Input[str] time_created: The date and time the target was created. Format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the target was updated. Format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataMaskRuleState.__new__(_DataMaskRuleState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["data_mask_categories"] = data_mask_categories
        __props__.__dict__["data_mask_rule_status"] = data_mask_rule_status
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["iam_group_id"] = iam_group_id
        __props__.__dict__["lifecyle_details"] = lifecyle_details
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_selected"] = target_selected
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return DataMaskRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment Identifier where the resource is created
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataMaskCategories")
    def data_mask_categories(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Data Mask Categories
        """
        return pulumi.get(self, "data_mask_categories")

    @property
    @pulumi.getter(name="dataMaskRuleStatus")
    def data_mask_rule_status(self) -> pulumi.Output[str]:
        """
        (Updatable) The status of the dataMaskRule.
        """
        return pulumi.get(self, "data_mask_rule_status")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The data mask rule description. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Data mask rule name.

        Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="iamGroupId")
    def iam_group_id(self) -> pulumi.Output[str]:
        """
        (Updatable) IAM Group id associated with the data mask rule
        """
        return pulumi.get(self, "iam_group_id")

    @property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecyle_details")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the DataMaskRule.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetSelected")
    def target_selected(self) -> pulumi.Output['outputs.DataMaskRuleTargetSelected']:
        """
        (Updatable) Target Selection eg select ALL or select on basis of TargetResourceTypes or TargetIds.
        """
        return pulumi.get(self, "target_selected")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the target was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the target was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

