# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MigrationAssetArgs', 'MigrationAsset']

@pulumi.input_type
class MigrationAssetArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[str],
                 inventory_asset_id: pulumi.Input[str],
                 migration_id: pulumi.Input[str],
                 replication_compartment_id: pulumi.Input[str],
                 snap_shot_bucket_name: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 migration_asset_depends_ons: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 replication_schedule_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MigrationAsset resource.
        :param pulumi.Input[str] availability_domain: Availability domain
        :param pulumi.Input[str] inventory_asset_id: OCID of an asset for an inventory.
        :param pulumi.Input[str] migration_id: OCID of the associated migration.
        :param pulumi.Input[str] replication_compartment_id: Replication compartment identifier
        :param pulumi.Input[str] snap_shot_bucket_name: Name of snapshot bucket
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. If empty, then source asset name will be used. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] replication_schedule_id: (Updatable) Replication schedule identifier
        """
        MigrationAssetArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            inventory_asset_id=inventory_asset_id,
            migration_id=migration_id,
            replication_compartment_id=replication_compartment_id,
            snap_shot_bucket_name=snap_shot_bucket_name,
            display_name=display_name,
            migration_asset_depends_ons=migration_asset_depends_ons,
            replication_schedule_id=replication_schedule_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: pulumi.Input[str],
             inventory_asset_id: pulumi.Input[str],
             migration_id: pulumi.Input[str],
             replication_compartment_id: pulumi.Input[str],
             snap_shot_bucket_name: pulumi.Input[str],
             display_name: Optional[pulumi.Input[str]] = None,
             migration_asset_depends_ons: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             replication_schedule_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("availability_domain", availability_domain)
        _setter("inventory_asset_id", inventory_asset_id)
        _setter("migration_id", migration_id)
        _setter("replication_compartment_id", replication_compartment_id)
        _setter("snap_shot_bucket_name", snap_shot_bucket_name)
        if display_name is not None:
            _setter("display_name", display_name)
        if migration_asset_depends_ons is not None:
            _setter("migration_asset_depends_ons", migration_asset_depends_ons)
        if replication_schedule_id is not None:
            _setter("replication_schedule_id", replication_schedule_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[str]:
        """
        Availability domain
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="inventoryAssetId")
    def inventory_asset_id(self) -> pulumi.Input[str]:
        """
        OCID of an asset for an inventory.
        """
        return pulumi.get(self, "inventory_asset_id")

    @inventory_asset_id.setter
    def inventory_asset_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "inventory_asset_id", value)

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> pulumi.Input[str]:
        """
        OCID of the associated migration.
        """
        return pulumi.get(self, "migration_id")

    @migration_id.setter
    def migration_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "migration_id", value)

    @property
    @pulumi.getter(name="replicationCompartmentId")
    def replication_compartment_id(self) -> pulumi.Input[str]:
        """
        Replication compartment identifier
        """
        return pulumi.get(self, "replication_compartment_id")

    @replication_compartment_id.setter
    def replication_compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "replication_compartment_id", value)

    @property
    @pulumi.getter(name="snapShotBucketName")
    def snap_shot_bucket_name(self) -> pulumi.Input[str]:
        """
        Name of snapshot bucket


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "snap_shot_bucket_name")

    @snap_shot_bucket_name.setter
    def snap_shot_bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "snap_shot_bucket_name", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. If empty, then source asset name will be used. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="migrationAssetDependsOns")
    def migration_asset_depends_ons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "migration_asset_depends_ons")

    @migration_asset_depends_ons.setter
    def migration_asset_depends_ons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "migration_asset_depends_ons", value)

    @property
    @pulumi.getter(name="replicationScheduleId")
    def replication_schedule_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Replication schedule identifier
        """
        return pulumi.get(self, "replication_schedule_id")

    @replication_schedule_id.setter
    def replication_schedule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_schedule_id", value)


@pulumi.input_type
class _MigrationAssetState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 depended_on_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 inventory_asset_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 migration_asset_depends_ons: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 migration_id: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 parent_snapshot: Optional[pulumi.Input[str]] = None,
                 replication_compartment_id: Optional[pulumi.Input[str]] = None,
                 replication_schedule_id: Optional[pulumi.Input[str]] = None,
                 snap_shot_bucket_name: Optional[pulumi.Input[str]] = None,
                 snapshots: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 source_asset_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tenancy_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MigrationAsset resources.
        :param pulumi.Input[str] availability_domain: Availability domain
        :param pulumi.Input[str] compartment_id: Compartment Identifier
        :param pulumi.Input[Sequence[pulumi.Input[str]]] depended_on_bies: List of migration assets that depend on the asset.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. If empty, then source asset name will be used. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] inventory_asset_id: OCID of an asset for an inventory.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] migration_id: OCID of the associated migration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notifications: List of notifications
        :param pulumi.Input[str] parent_snapshot: The parent snapshot of the migration asset to be used by the replication task.
        :param pulumi.Input[str] replication_compartment_id: Replication compartment identifier
        :param pulumi.Input[str] replication_schedule_id: (Updatable) Replication schedule identifier
        :param pulumi.Input[str] snap_shot_bucket_name: Name of snapshot bucket
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] snapshots: Key-value pair representing disks ID mapped to the OCIDs of replicated or hydration server volume snapshots. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] source_asset_id: OCID that is referenced to an asset for an inventory.
        :param pulumi.Input[str] state: The current state of the migration asset.
        :param pulumi.Input[str] tenancy_id: Tenancy identifier
        :param pulumi.Input[str] time_created: The time when the migration asset was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when the migration asset was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] type: The type of asset referenced for inventory.
        """
        _MigrationAssetState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            compartment_id=compartment_id,
            depended_on_bies=depended_on_bies,
            display_name=display_name,
            inventory_asset_id=inventory_asset_id,
            lifecycle_details=lifecycle_details,
            migration_asset_depends_ons=migration_asset_depends_ons,
            migration_id=migration_id,
            notifications=notifications,
            parent_snapshot=parent_snapshot,
            replication_compartment_id=replication_compartment_id,
            replication_schedule_id=replication_schedule_id,
            snap_shot_bucket_name=snap_shot_bucket_name,
            snapshots=snapshots,
            source_asset_id=source_asset_id,
            state=state,
            tenancy_id=tenancy_id,
            time_created=time_created,
            time_updated=time_updated,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: Optional[pulumi.Input[str]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             depended_on_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             inventory_asset_id: Optional[pulumi.Input[str]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             migration_asset_depends_ons: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             migration_id: Optional[pulumi.Input[str]] = None,
             notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             parent_snapshot: Optional[pulumi.Input[str]] = None,
             replication_compartment_id: Optional[pulumi.Input[str]] = None,
             replication_schedule_id: Optional[pulumi.Input[str]] = None,
             snap_shot_bucket_name: Optional[pulumi.Input[str]] = None,
             snapshots: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             source_asset_id: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             tenancy_id: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if availability_domain is not None:
            _setter("availability_domain", availability_domain)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if depended_on_bies is not None:
            _setter("depended_on_bies", depended_on_bies)
        if display_name is not None:
            _setter("display_name", display_name)
        if inventory_asset_id is not None:
            _setter("inventory_asset_id", inventory_asset_id)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if migration_asset_depends_ons is not None:
            _setter("migration_asset_depends_ons", migration_asset_depends_ons)
        if migration_id is not None:
            _setter("migration_id", migration_id)
        if notifications is not None:
            _setter("notifications", notifications)
        if parent_snapshot is not None:
            _setter("parent_snapshot", parent_snapshot)
        if replication_compartment_id is not None:
            _setter("replication_compartment_id", replication_compartment_id)
        if replication_schedule_id is not None:
            _setter("replication_schedule_id", replication_schedule_id)
        if snap_shot_bucket_name is not None:
            _setter("snap_shot_bucket_name", snap_shot_bucket_name)
        if snapshots is not None:
            _setter("snapshots", snapshots)
        if source_asset_id is not None:
            _setter("source_asset_id", source_asset_id)
        if state is not None:
            _setter("state", state)
        if tenancy_id is not None:
            _setter("tenancy_id", tenancy_id)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Availability domain
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dependedOnBies")
    def depended_on_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of migration assets that depend on the asset.
        """
        return pulumi.get(self, "depended_on_bies")

    @depended_on_bies.setter
    def depended_on_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "depended_on_bies", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. If empty, then source asset name will be used. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="inventoryAssetId")
    def inventory_asset_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of an asset for an inventory.
        """
        return pulumi.get(self, "inventory_asset_id")

    @inventory_asset_id.setter
    def inventory_asset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inventory_asset_id", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="migrationAssetDependsOns")
    def migration_asset_depends_ons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "migration_asset_depends_ons")

    @migration_asset_depends_ons.setter
    def migration_asset_depends_ons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "migration_asset_depends_ons", value)

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the associated migration.
        """
        return pulumi.get(self, "migration_id")

    @migration_id.setter
    def migration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migration_id", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of notifications
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter(name="parentSnapshot")
    def parent_snapshot(self) -> Optional[pulumi.Input[str]]:
        """
        The parent snapshot of the migration asset to be used by the replication task.
        """
        return pulumi.get(self, "parent_snapshot")

    @parent_snapshot.setter
    def parent_snapshot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_snapshot", value)

    @property
    @pulumi.getter(name="replicationCompartmentId")
    def replication_compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Replication compartment identifier
        """
        return pulumi.get(self, "replication_compartment_id")

    @replication_compartment_id.setter
    def replication_compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_compartment_id", value)

    @property
    @pulumi.getter(name="replicationScheduleId")
    def replication_schedule_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Replication schedule identifier
        """
        return pulumi.get(self, "replication_schedule_id")

    @replication_schedule_id.setter
    def replication_schedule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_schedule_id", value)

    @property
    @pulumi.getter(name="snapShotBucketName")
    def snap_shot_bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of snapshot bucket


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "snap_shot_bucket_name")

    @snap_shot_bucket_name.setter
    def snap_shot_bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snap_shot_bucket_name", value)

    @property
    @pulumi.getter
    def snapshots(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Key-value pair representing disks ID mapped to the OCIDs of replicated or hydration server volume snapshots. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "snapshots")

    @snapshots.setter
    def snapshots(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "snapshots", value)

    @property
    @pulumi.getter(name="sourceAssetId")
    def source_asset_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID that is referenced to an asset for an inventory.
        """
        return pulumi.get(self, "source_asset_id")

    @source_asset_id.setter
    def source_asset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_asset_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the migration asset.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenancy identifier
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the migration asset was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the migration asset was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of asset referenced for inventory.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class MigrationAsset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 inventory_asset_id: Optional[pulumi.Input[str]] = None,
                 migration_asset_depends_ons: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 migration_id: Optional[pulumi.Input[str]] = None,
                 replication_compartment_id: Optional[pulumi.Input[str]] = None,
                 replication_schedule_id: Optional[pulumi.Input[str]] = None,
                 snap_shot_bucket_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Migration Asset resource in Oracle Cloud Infrastructure Cloud Migrations service.

        Creates a migration asset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_migration_asset = oci.cloud_migrations.MigrationAsset("testMigrationAsset",
            availability_domain=var["migration_asset_availability_domain"],
            inventory_asset_id=oci_cloud_migrations_inventory_asset["test_inventory_asset"]["id"],
            migration_id=oci_cloud_migrations_migration["test_migration"]["id"],
            replication_compartment_id=oci_identity_compartment["test_compartment"]["id"],
            snap_shot_bucket_name=oci_objectstorage_bucket["test_bucket"]["name"],
            display_name=var["migration_asset_display_name"],
            replication_schedule_id=oci_cloud_migrations_replication_schedule["test_replication_schedule"]["id"],
            opts=pulumi.ResourceOptions(depends_on=var["migration_asset_depends_on"]))
        ```

        ## Import

        MigrationAssets can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:CloudMigrations/migrationAsset:MigrationAsset test_migration_asset "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: Availability domain
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. If empty, then source asset name will be used. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] inventory_asset_id: OCID of an asset for an inventory.
        :param pulumi.Input[str] migration_id: OCID of the associated migration.
        :param pulumi.Input[str] replication_compartment_id: Replication compartment identifier
        :param pulumi.Input[str] replication_schedule_id: (Updatable) Replication schedule identifier
        :param pulumi.Input[str] snap_shot_bucket_name: Name of snapshot bucket
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MigrationAssetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Migration Asset resource in Oracle Cloud Infrastructure Cloud Migrations service.

        Creates a migration asset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_migration_asset = oci.cloud_migrations.MigrationAsset("testMigrationAsset",
            availability_domain=var["migration_asset_availability_domain"],
            inventory_asset_id=oci_cloud_migrations_inventory_asset["test_inventory_asset"]["id"],
            migration_id=oci_cloud_migrations_migration["test_migration"]["id"],
            replication_compartment_id=oci_identity_compartment["test_compartment"]["id"],
            snap_shot_bucket_name=oci_objectstorage_bucket["test_bucket"]["name"],
            display_name=var["migration_asset_display_name"],
            replication_schedule_id=oci_cloud_migrations_replication_schedule["test_replication_schedule"]["id"],
            opts=pulumi.ResourceOptions(depends_on=var["migration_asset_depends_on"]))
        ```

        ## Import

        MigrationAssets can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:CloudMigrations/migrationAsset:MigrationAsset test_migration_asset "id"
        ```

        :param str resource_name: The name of the resource.
        :param MigrationAssetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MigrationAssetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            MigrationAssetArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 inventory_asset_id: Optional[pulumi.Input[str]] = None,
                 migration_asset_depends_ons: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 migration_id: Optional[pulumi.Input[str]] = None,
                 replication_compartment_id: Optional[pulumi.Input[str]] = None,
                 replication_schedule_id: Optional[pulumi.Input[str]] = None,
                 snap_shot_bucket_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MigrationAssetArgs.__new__(MigrationAssetArgs)

            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            __props__.__dict__["display_name"] = display_name
            if inventory_asset_id is None and not opts.urn:
                raise TypeError("Missing required property 'inventory_asset_id'")
            __props__.__dict__["inventory_asset_id"] = inventory_asset_id
            __props__.__dict__["migration_asset_depends_ons"] = migration_asset_depends_ons
            if migration_id is None and not opts.urn:
                raise TypeError("Missing required property 'migration_id'")
            __props__.__dict__["migration_id"] = migration_id
            if replication_compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'replication_compartment_id'")
            __props__.__dict__["replication_compartment_id"] = replication_compartment_id
            __props__.__dict__["replication_schedule_id"] = replication_schedule_id
            if snap_shot_bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'snap_shot_bucket_name'")
            __props__.__dict__["snap_shot_bucket_name"] = snap_shot_bucket_name
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["depended_on_bies"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["notifications"] = None
            __props__.__dict__["parent_snapshot"] = None
            __props__.__dict__["snapshots"] = None
            __props__.__dict__["source_asset_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["tenancy_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["type"] = None
        super(MigrationAsset, __self__).__init__(
            'oci:CloudMigrations/migrationAsset:MigrationAsset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            depended_on_bies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            inventory_asset_id: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            migration_asset_depends_ons: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            migration_id: Optional[pulumi.Input[str]] = None,
            notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            parent_snapshot: Optional[pulumi.Input[str]] = None,
            replication_compartment_id: Optional[pulumi.Input[str]] = None,
            replication_schedule_id: Optional[pulumi.Input[str]] = None,
            snap_shot_bucket_name: Optional[pulumi.Input[str]] = None,
            snapshots: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            source_asset_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            tenancy_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'MigrationAsset':
        """
        Get an existing MigrationAsset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: Availability domain
        :param pulumi.Input[str] compartment_id: Compartment Identifier
        :param pulumi.Input[Sequence[pulumi.Input[str]]] depended_on_bies: List of migration assets that depend on the asset.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. If empty, then source asset name will be used. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] inventory_asset_id: OCID of an asset for an inventory.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] migration_id: OCID of the associated migration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notifications: List of notifications
        :param pulumi.Input[str] parent_snapshot: The parent snapshot of the migration asset to be used by the replication task.
        :param pulumi.Input[str] replication_compartment_id: Replication compartment identifier
        :param pulumi.Input[str] replication_schedule_id: (Updatable) Replication schedule identifier
        :param pulumi.Input[str] snap_shot_bucket_name: Name of snapshot bucket
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] snapshots: Key-value pair representing disks ID mapped to the OCIDs of replicated or hydration server volume snapshots. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] source_asset_id: OCID that is referenced to an asset for an inventory.
        :param pulumi.Input[str] state: The current state of the migration asset.
        :param pulumi.Input[str] tenancy_id: Tenancy identifier
        :param pulumi.Input[str] time_created: The time when the migration asset was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when the migration asset was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] type: The type of asset referenced for inventory.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MigrationAssetState.__new__(_MigrationAssetState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["depended_on_bies"] = depended_on_bies
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["inventory_asset_id"] = inventory_asset_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["migration_asset_depends_ons"] = migration_asset_depends_ons
        __props__.__dict__["migration_id"] = migration_id
        __props__.__dict__["notifications"] = notifications
        __props__.__dict__["parent_snapshot"] = parent_snapshot
        __props__.__dict__["replication_compartment_id"] = replication_compartment_id
        __props__.__dict__["replication_schedule_id"] = replication_schedule_id
        __props__.__dict__["snap_shot_bucket_name"] = snap_shot_bucket_name
        __props__.__dict__["snapshots"] = snapshots
        __props__.__dict__["source_asset_id"] = source_asset_id
        __props__.__dict__["state"] = state
        __props__.__dict__["tenancy_id"] = tenancy_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        return MigrationAsset(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        Availability domain
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dependedOnBies")
    def depended_on_bies(self) -> pulumi.Output[Sequence[str]]:
        """
        List of migration assets that depend on the asset.
        """
        return pulumi.get(self, "depended_on_bies")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. If empty, then source asset name will be used. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="inventoryAssetId")
    def inventory_asset_id(self) -> pulumi.Output[str]:
        """
        OCID of an asset for an inventory.
        """
        return pulumi.get(self, "inventory_asset_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="migrationAssetDependsOns")
    def migration_asset_depends_ons(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "migration_asset_depends_ons")

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> pulumi.Output[str]:
        """
        OCID of the associated migration.
        """
        return pulumi.get(self, "migration_id")

    @property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Sequence[str]]:
        """
        List of notifications
        """
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter(name="parentSnapshot")
    def parent_snapshot(self) -> pulumi.Output[str]:
        """
        The parent snapshot of the migration asset to be used by the replication task.
        """
        return pulumi.get(self, "parent_snapshot")

    @property
    @pulumi.getter(name="replicationCompartmentId")
    def replication_compartment_id(self) -> pulumi.Output[str]:
        """
        Replication compartment identifier
        """
        return pulumi.get(self, "replication_compartment_id")

    @property
    @pulumi.getter(name="replicationScheduleId")
    def replication_schedule_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Replication schedule identifier
        """
        return pulumi.get(self, "replication_schedule_id")

    @property
    @pulumi.getter(name="snapShotBucketName")
    def snap_shot_bucket_name(self) -> pulumi.Output[str]:
        """
        Name of snapshot bucket


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "snap_shot_bucket_name")

    @property
    @pulumi.getter
    def snapshots(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Key-value pair representing disks ID mapped to the OCIDs of replicated or hydration server volume snapshots. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "snapshots")

    @property
    @pulumi.getter(name="sourceAssetId")
    def source_asset_id(self) -> pulumi.Output[str]:
        """
        OCID that is referenced to an asset for an inventory.
        """
        return pulumi.get(self, "source_asset_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the migration asset.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> pulumi.Output[str]:
        """
        Tenancy identifier
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time when the migration asset was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time when the migration asset was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of asset referenced for inventory.
        """
        return pulumi.get(self, "type")

