# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualNodePoolArgs', 'VirtualNodePool']

@pulumi.input_type
class VirtualNodePoolArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 placement_configurations: pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolPlacementConfigurationArgs']]],
                 pod_configuration: pulumi.Input['VirtualNodePoolPodConfigurationArgs'],
                 size: pulumi.Input[int],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 initial_virtual_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolInitialVirtualNodeLabelArgs']]]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolTaintArgs']]]] = None,
                 virtual_node_tags: Optional[pulumi.Input['VirtualNodePoolVirtualNodeTagsArgs']] = None):
        """
        The set of arguments for constructing a VirtualNodePool resource.
        :param pulumi.Input[str] cluster_id: The cluster the virtual node pool is associated with. A virtual node pool can only be associated with one cluster.
        :param pulumi.Input[str] compartment_id: Compartment of the virtual node pool.
        :param pulumi.Input[str] display_name: (Updatable) Display name of the virtual node pool. This is a non-unique value.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolPlacementConfigurationArgs']]] placement_configurations: (Updatable) The list of placement configurations which determines where Virtual Nodes will be provisioned across as it relates to the subnet and availability domains. The size attribute determines how many we evenly spread across these placement configurations
        :param pulumi.Input['VirtualNodePoolPodConfigurationArgs'] pod_configuration: (Updatable) The pod configuration for pods run on virtual nodes of this virtual node pool.
        :param pulumi.Input[int] size: (Updatable) The number of Virtual Nodes that should be in the Virtual Node Pool. The placement configurations determine where these virtual nodes are placed.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolInitialVirtualNodeLabelArgs']]] initial_virtual_node_labels: (Updatable) Initial labels that will be added to the Kubernetes Virtual Node object when it registers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) List of network security group IDs applied to the Pod VNIC.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolTaintArgs']]] taints: (Updatable) A taint is a collection of <key, value, effect>. These taints will be applied to the Virtual Nodes of this Virtual Node Pool for Kubernetes scheduling.
        :param pulumi.Input['VirtualNodePoolVirtualNodeTagsArgs'] virtual_node_tags: (Updatable) The tags associated to the virtual nodes in this virtual node pool.
        """
        VirtualNodePoolArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cluster_id=cluster_id,
            compartment_id=compartment_id,
            display_name=display_name,
            placement_configurations=placement_configurations,
            pod_configuration=pod_configuration,
            size=size,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            initial_virtual_node_labels=initial_virtual_node_labels,
            nsg_ids=nsg_ids,
            taints=taints,
            virtual_node_tags=virtual_node_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cluster_id: pulumi.Input[str],
             compartment_id: pulumi.Input[str],
             display_name: pulumi.Input[str],
             placement_configurations: pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolPlacementConfigurationArgs']]],
             pod_configuration: pulumi.Input['VirtualNodePoolPodConfigurationArgs'],
             size: pulumi.Input[int],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             initial_virtual_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolInitialVirtualNodeLabelArgs']]]] = None,
             nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             taints: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolTaintArgs']]]] = None,
             virtual_node_tags: Optional[pulumi.Input['VirtualNodePoolVirtualNodeTagsArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("cluster_id", cluster_id)
        _setter("compartment_id", compartment_id)
        _setter("display_name", display_name)
        _setter("placement_configurations", placement_configurations)
        _setter("pod_configuration", pod_configuration)
        _setter("size", size)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if initial_virtual_node_labels is not None:
            _setter("initial_virtual_node_labels", initial_virtual_node_labels)
        if nsg_ids is not None:
            _setter("nsg_ids", nsg_ids)
        if taints is not None:
            _setter("taints", taints)
        if virtual_node_tags is not None:
            _setter("virtual_node_tags", virtual_node_tags)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The cluster the virtual node pool is associated with. A virtual node pool can only be associated with one cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        Compartment of the virtual node pool.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Display name of the virtual node pool. This is a non-unique value.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="placementConfigurations")
    def placement_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolPlacementConfigurationArgs']]]:
        """
        (Updatable) The list of placement configurations which determines where Virtual Nodes will be provisioned across as it relates to the subnet and availability domains. The size attribute determines how many we evenly spread across these placement configurations
        """
        return pulumi.get(self, "placement_configurations")

    @placement_configurations.setter
    def placement_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolPlacementConfigurationArgs']]]):
        pulumi.set(self, "placement_configurations", value)

    @property
    @pulumi.getter(name="podConfiguration")
    def pod_configuration(self) -> pulumi.Input['VirtualNodePoolPodConfigurationArgs']:
        """
        (Updatable) The pod configuration for pods run on virtual nodes of this virtual node pool.
        """
        return pulumi.get(self, "pod_configuration")

    @pod_configuration.setter
    def pod_configuration(self, value: pulumi.Input['VirtualNodePoolPodConfigurationArgs']):
        pulumi.set(self, "pod_configuration", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        (Updatable) The number of Virtual Nodes that should be in the Virtual Node Pool. The placement configurations determine where these virtual nodes are placed.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="initialVirtualNodeLabels")
    def initial_virtual_node_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolInitialVirtualNodeLabelArgs']]]]:
        """
        (Updatable) Initial labels that will be added to the Kubernetes Virtual Node object when it registers.
        """
        return pulumi.get(self, "initial_virtual_node_labels")

    @initial_virtual_node_labels.setter
    def initial_virtual_node_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolInitialVirtualNodeLabelArgs']]]]):
        pulumi.set(self, "initial_virtual_node_labels", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of network security group IDs applied to the Pod VNIC.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolTaintArgs']]]]:
        """
        (Updatable) A taint is a collection of <key, value, effect>. These taints will be applied to the Virtual Nodes of this Virtual Node Pool for Kubernetes scheduling.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="virtualNodeTags")
    def virtual_node_tags(self) -> Optional[pulumi.Input['VirtualNodePoolVirtualNodeTagsArgs']]:
        """
        (Updatable) The tags associated to the virtual nodes in this virtual node pool.
        """
        return pulumi.get(self, "virtual_node_tags")

    @virtual_node_tags.setter
    def virtual_node_tags(self, value: Optional[pulumi.Input['VirtualNodePoolVirtualNodeTagsArgs']]):
        pulumi.set(self, "virtual_node_tags", value)


@pulumi.input_type
class _VirtualNodePoolState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 initial_virtual_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolInitialVirtualNodeLabelArgs']]]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 placement_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolPlacementConfigurationArgs']]]] = None,
                 pod_configuration: Optional[pulumi.Input['VirtualNodePoolPodConfigurationArgs']] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolTaintArgs']]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 virtual_node_tags: Optional[pulumi.Input['VirtualNodePoolVirtualNodeTagsArgs']] = None):
        """
        Input properties used for looking up and filtering VirtualNodePool resources.
        :param pulumi.Input[str] cluster_id: The cluster the virtual node pool is associated with. A virtual node pool can only be associated with one cluster.
        :param pulumi.Input[str] compartment_id: Compartment of the virtual node pool.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) Display name of the virtual node pool. This is a non-unique value.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolInitialVirtualNodeLabelArgs']]] initial_virtual_node_labels: (Updatable) Initial labels that will be added to the Kubernetes Virtual Node object when it registers.
        :param pulumi.Input[str] kubernetes_version: The version of Kubernetes running on the nodes in the node pool.
        :param pulumi.Input[str] lifecycle_details: Details about the state of the Virtual Node Pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) List of network security group IDs applied to the Pod VNIC.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolPlacementConfigurationArgs']]] placement_configurations: (Updatable) The list of placement configurations which determines where Virtual Nodes will be provisioned across as it relates to the subnet and availability domains. The size attribute determines how many we evenly spread across these placement configurations
        :param pulumi.Input['VirtualNodePoolPodConfigurationArgs'] pod_configuration: (Updatable) The pod configuration for pods run on virtual nodes of this virtual node pool.
        :param pulumi.Input[int] size: (Updatable) The number of Virtual Nodes that should be in the Virtual Node Pool. The placement configurations determine where these virtual nodes are placed.
        :param pulumi.Input[str] state: The state of the Virtual Node Pool.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolTaintArgs']]] taints: (Updatable) A taint is a collection of <key, value, effect>. These taints will be applied to the Virtual Nodes of this Virtual Node Pool for Kubernetes scheduling.
        :param pulumi.Input[str] time_created: The time the virtual node pool was created.
        :param pulumi.Input[str] time_updated: The time the virtual node pool was updated.
        :param pulumi.Input['VirtualNodePoolVirtualNodeTagsArgs'] virtual_node_tags: (Updatable) The tags associated to the virtual nodes in this virtual node pool.
        """
        _VirtualNodePoolState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cluster_id=cluster_id,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            initial_virtual_node_labels=initial_virtual_node_labels,
            kubernetes_version=kubernetes_version,
            lifecycle_details=lifecycle_details,
            nsg_ids=nsg_ids,
            placement_configurations=placement_configurations,
            pod_configuration=pod_configuration,
            size=size,
            state=state,
            system_tags=system_tags,
            taints=taints,
            time_created=time_created,
            time_updated=time_updated,
            virtual_node_tags=virtual_node_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cluster_id: Optional[pulumi.Input[str]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             initial_virtual_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolInitialVirtualNodeLabelArgs']]]] = None,
             kubernetes_version: Optional[pulumi.Input[str]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             placement_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolPlacementConfigurationArgs']]]] = None,
             pod_configuration: Optional[pulumi.Input['VirtualNodePoolPodConfigurationArgs']] = None,
             size: Optional[pulumi.Input[int]] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             taints: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolTaintArgs']]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             virtual_node_tags: Optional[pulumi.Input['VirtualNodePoolVirtualNodeTagsArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if cluster_id is not None:
            _setter("cluster_id", cluster_id)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if initial_virtual_node_labels is not None:
            _setter("initial_virtual_node_labels", initial_virtual_node_labels)
        if kubernetes_version is not None:
            _setter("kubernetes_version", kubernetes_version)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if nsg_ids is not None:
            _setter("nsg_ids", nsg_ids)
        if placement_configurations is not None:
            _setter("placement_configurations", placement_configurations)
        if pod_configuration is not None:
            _setter("pod_configuration", pod_configuration)
        if size is not None:
            _setter("size", size)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if taints is not None:
            _setter("taints", taints)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)
        if virtual_node_tags is not None:
            _setter("virtual_node_tags", virtual_node_tags)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster the virtual node pool is associated with. A virtual node pool can only be associated with one cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Compartment of the virtual node pool.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Display name of the virtual node pool. This is a non-unique value.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="initialVirtualNodeLabels")
    def initial_virtual_node_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolInitialVirtualNodeLabelArgs']]]]:
        """
        (Updatable) Initial labels that will be added to the Kubernetes Virtual Node object when it registers.
        """
        return pulumi.get(self, "initial_virtual_node_labels")

    @initial_virtual_node_labels.setter
    def initial_virtual_node_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolInitialVirtualNodeLabelArgs']]]]):
        pulumi.set(self, "initial_virtual_node_labels", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of Kubernetes running on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the state of the Virtual Node Pool.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of network security group IDs applied to the Pod VNIC.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="placementConfigurations")
    def placement_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolPlacementConfigurationArgs']]]]:
        """
        (Updatable) The list of placement configurations which determines where Virtual Nodes will be provisioned across as it relates to the subnet and availability domains. The size attribute determines how many we evenly spread across these placement configurations
        """
        return pulumi.get(self, "placement_configurations")

    @placement_configurations.setter
    def placement_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolPlacementConfigurationArgs']]]]):
        pulumi.set(self, "placement_configurations", value)

    @property
    @pulumi.getter(name="podConfiguration")
    def pod_configuration(self) -> Optional[pulumi.Input['VirtualNodePoolPodConfigurationArgs']]:
        """
        (Updatable) The pod configuration for pods run on virtual nodes of this virtual node pool.
        """
        return pulumi.get(self, "pod_configuration")

    @pod_configuration.setter
    def pod_configuration(self, value: Optional[pulumi.Input['VirtualNodePoolPodConfigurationArgs']]):
        pulumi.set(self, "pod_configuration", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of Virtual Nodes that should be in the Virtual Node Pool. The placement configurations determine where these virtual nodes are placed.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the Virtual Node Pool.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolTaintArgs']]]]:
        """
        (Updatable) A taint is a collection of <key, value, effect>. These taints will be applied to the Virtual Nodes of this Virtual Node Pool for Kubernetes scheduling.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the virtual node pool was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the virtual node pool was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="virtualNodeTags")
    def virtual_node_tags(self) -> Optional[pulumi.Input['VirtualNodePoolVirtualNodeTagsArgs']]:
        """
        (Updatable) The tags associated to the virtual nodes in this virtual node pool.
        """
        return pulumi.get(self, "virtual_node_tags")

    @virtual_node_tags.setter
    def virtual_node_tags(self, value: Optional[pulumi.Input['VirtualNodePoolVirtualNodeTagsArgs']]):
        pulumi.set(self, "virtual_node_tags", value)


class VirtualNodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 initial_virtual_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNodePoolInitialVirtualNodeLabelArgs']]]]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 placement_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNodePoolPlacementConfigurationArgs']]]]] = None,
                 pod_configuration: Optional[pulumi.Input[pulumi.InputType['VirtualNodePoolPodConfigurationArgs']]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNodePoolTaintArgs']]]]] = None,
                 virtual_node_tags: Optional[pulumi.Input[pulumi.InputType['VirtualNodePoolVirtualNodeTagsArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Virtual Node Pool resource in Oracle Cloud Infrastructure Container Engine service.

        Create a new virtual node pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_virtual_node_pool = oci.container_engine.VirtualNodePool("testVirtualNodePool",
            cluster_id=oci_containerengine_cluster["test_cluster"]["id"],
            compartment_id=var["compartment_id"],
            display_name=var["virtual_node_pool_display_name"],
            placement_configurations=[oci.container_engine.VirtualNodePoolPlacementConfigurationArgs(
                availability_domain=var["virtual_node_pool_placement_configurations_availability_domain"],
                fault_domains=var["virtual_node_pool_placement_configurations_fault_domain"],
                subnet_id=oci_core_subnet["test_subnet"]["id"],
            )],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            initial_virtual_node_labels=[oci.container_engine.VirtualNodePoolInitialVirtualNodeLabelArgs(
                key=var["virtual_node_pool_initial_virtual_node_labels_key"],
                value=var["virtual_node_pool_initial_virtual_node_labels_value"],
            )],
            nsg_ids=var["virtual_node_pool_nsg_ids"],
            pod_configuration=oci.container_engine.VirtualNodePoolPodConfigurationArgs(
                shape=var["virtual_node_pool_pod_configuration_shape"],
                subnet_id=oci_core_subnet["test_subnet"]["id"],
                nsg_ids=var["virtual_node_pool_pod_configuration_nsg_ids"],
            ),
            size=var["virtual_node_pool_size"],
            taints=[oci.container_engine.VirtualNodePoolTaintArgs(
                effect=var["virtual_node_pool_taints_effect"],
                key=var["virtual_node_pool_taints_key"],
                value=var["virtual_node_pool_taints_value"],
            )],
            virtual_node_tags=oci.container_engine.VirtualNodePoolVirtualNodeTagsArgs(
                defined_tags={
                    "Operations.CostCenter": "42",
                },
                freeform_tags={
                    "Department": "Finance",
                },
            ))
        ```

        ## Import

        VirtualNodePools can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:ContainerEngine/virtualNodePool:VirtualNodePool test_virtual_node_pool "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The cluster the virtual node pool is associated with. A virtual node pool can only be associated with one cluster.
        :param pulumi.Input[str] compartment_id: Compartment of the virtual node pool.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) Display name of the virtual node pool. This is a non-unique value.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNodePoolInitialVirtualNodeLabelArgs']]]] initial_virtual_node_labels: (Updatable) Initial labels that will be added to the Kubernetes Virtual Node object when it registers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) List of network security group IDs applied to the Pod VNIC.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNodePoolPlacementConfigurationArgs']]]] placement_configurations: (Updatable) The list of placement configurations which determines where Virtual Nodes will be provisioned across as it relates to the subnet and availability domains. The size attribute determines how many we evenly spread across these placement configurations
        :param pulumi.Input[pulumi.InputType['VirtualNodePoolPodConfigurationArgs']] pod_configuration: (Updatable) The pod configuration for pods run on virtual nodes of this virtual node pool.
        :param pulumi.Input[int] size: (Updatable) The number of Virtual Nodes that should be in the Virtual Node Pool. The placement configurations determine where these virtual nodes are placed.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNodePoolTaintArgs']]]] taints: (Updatable) A taint is a collection of <key, value, effect>. These taints will be applied to the Virtual Nodes of this Virtual Node Pool for Kubernetes scheduling.
        :param pulumi.Input[pulumi.InputType['VirtualNodePoolVirtualNodeTagsArgs']] virtual_node_tags: (Updatable) The tags associated to the virtual nodes in this virtual node pool.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualNodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Virtual Node Pool resource in Oracle Cloud Infrastructure Container Engine service.

        Create a new virtual node pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_virtual_node_pool = oci.container_engine.VirtualNodePool("testVirtualNodePool",
            cluster_id=oci_containerengine_cluster["test_cluster"]["id"],
            compartment_id=var["compartment_id"],
            display_name=var["virtual_node_pool_display_name"],
            placement_configurations=[oci.container_engine.VirtualNodePoolPlacementConfigurationArgs(
                availability_domain=var["virtual_node_pool_placement_configurations_availability_domain"],
                fault_domains=var["virtual_node_pool_placement_configurations_fault_domain"],
                subnet_id=oci_core_subnet["test_subnet"]["id"],
            )],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            initial_virtual_node_labels=[oci.container_engine.VirtualNodePoolInitialVirtualNodeLabelArgs(
                key=var["virtual_node_pool_initial_virtual_node_labels_key"],
                value=var["virtual_node_pool_initial_virtual_node_labels_value"],
            )],
            nsg_ids=var["virtual_node_pool_nsg_ids"],
            pod_configuration=oci.container_engine.VirtualNodePoolPodConfigurationArgs(
                shape=var["virtual_node_pool_pod_configuration_shape"],
                subnet_id=oci_core_subnet["test_subnet"]["id"],
                nsg_ids=var["virtual_node_pool_pod_configuration_nsg_ids"],
            ),
            size=var["virtual_node_pool_size"],
            taints=[oci.container_engine.VirtualNodePoolTaintArgs(
                effect=var["virtual_node_pool_taints_effect"],
                key=var["virtual_node_pool_taints_key"],
                value=var["virtual_node_pool_taints_value"],
            )],
            virtual_node_tags=oci.container_engine.VirtualNodePoolVirtualNodeTagsArgs(
                defined_tags={
                    "Operations.CostCenter": "42",
                },
                freeform_tags={
                    "Department": "Finance",
                },
            ))
        ```

        ## Import

        VirtualNodePools can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:ContainerEngine/virtualNodePool:VirtualNodePool test_virtual_node_pool "id"
        ```

        :param str resource_name: The name of the resource.
        :param VirtualNodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualNodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            VirtualNodePoolArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 initial_virtual_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNodePoolInitialVirtualNodeLabelArgs']]]]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 placement_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNodePoolPlacementConfigurationArgs']]]]] = None,
                 pod_configuration: Optional[pulumi.Input[pulumi.InputType['VirtualNodePoolPodConfigurationArgs']]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNodePoolTaintArgs']]]]] = None,
                 virtual_node_tags: Optional[pulumi.Input[pulumi.InputType['VirtualNodePoolVirtualNodeTagsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualNodePoolArgs.__new__(VirtualNodePoolArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["initial_virtual_node_labels"] = initial_virtual_node_labels
            __props__.__dict__["nsg_ids"] = nsg_ids
            if placement_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'placement_configurations'")
            __props__.__dict__["placement_configurations"] = placement_configurations
            if pod_configuration is not None and not isinstance(pod_configuration, VirtualNodePoolPodConfigurationArgs):
                pod_configuration = pod_configuration or {}
                def _setter(key, value):
                    pod_configuration[key] = value
                VirtualNodePoolPodConfigurationArgs._configure(_setter, **pod_configuration)
            if pod_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'pod_configuration'")
            __props__.__dict__["pod_configuration"] = pod_configuration
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["taints"] = taints
            if virtual_node_tags is not None and not isinstance(virtual_node_tags, VirtualNodePoolVirtualNodeTagsArgs):
                virtual_node_tags = virtual_node_tags or {}
                def _setter(key, value):
                    virtual_node_tags[key] = value
                VirtualNodePoolVirtualNodeTagsArgs._configure(_setter, **virtual_node_tags)
            __props__.__dict__["virtual_node_tags"] = virtual_node_tags
            __props__.__dict__["kubernetes_version"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(VirtualNodePool, __self__).__init__(
            'oci:ContainerEngine/virtualNodePool:VirtualNodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            initial_virtual_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNodePoolInitialVirtualNodeLabelArgs']]]]] = None,
            kubernetes_version: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            placement_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNodePoolPlacementConfigurationArgs']]]]] = None,
            pod_configuration: Optional[pulumi.Input[pulumi.InputType['VirtualNodePoolPodConfigurationArgs']]] = None,
            size: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNodePoolTaintArgs']]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            virtual_node_tags: Optional[pulumi.Input[pulumi.InputType['VirtualNodePoolVirtualNodeTagsArgs']]] = None) -> 'VirtualNodePool':
        """
        Get an existing VirtualNodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The cluster the virtual node pool is associated with. A virtual node pool can only be associated with one cluster.
        :param pulumi.Input[str] compartment_id: Compartment of the virtual node pool.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) Display name of the virtual node pool. This is a non-unique value.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNodePoolInitialVirtualNodeLabelArgs']]]] initial_virtual_node_labels: (Updatable) Initial labels that will be added to the Kubernetes Virtual Node object when it registers.
        :param pulumi.Input[str] kubernetes_version: The version of Kubernetes running on the nodes in the node pool.
        :param pulumi.Input[str] lifecycle_details: Details about the state of the Virtual Node Pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) List of network security group IDs applied to the Pod VNIC.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNodePoolPlacementConfigurationArgs']]]] placement_configurations: (Updatable) The list of placement configurations which determines where Virtual Nodes will be provisioned across as it relates to the subnet and availability domains. The size attribute determines how many we evenly spread across these placement configurations
        :param pulumi.Input[pulumi.InputType['VirtualNodePoolPodConfigurationArgs']] pod_configuration: (Updatable) The pod configuration for pods run on virtual nodes of this virtual node pool.
        :param pulumi.Input[int] size: (Updatable) The number of Virtual Nodes that should be in the Virtual Node Pool. The placement configurations determine where these virtual nodes are placed.
        :param pulumi.Input[str] state: The state of the Virtual Node Pool.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNodePoolTaintArgs']]]] taints: (Updatable) A taint is a collection of <key, value, effect>. These taints will be applied to the Virtual Nodes of this Virtual Node Pool for Kubernetes scheduling.
        :param pulumi.Input[str] time_created: The time the virtual node pool was created.
        :param pulumi.Input[str] time_updated: The time the virtual node pool was updated.
        :param pulumi.Input[pulumi.InputType['VirtualNodePoolVirtualNodeTagsArgs']] virtual_node_tags: (Updatable) The tags associated to the virtual nodes in this virtual node pool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualNodePoolState.__new__(_VirtualNodePoolState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["initial_virtual_node_labels"] = initial_virtual_node_labels
        __props__.__dict__["kubernetes_version"] = kubernetes_version
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["placement_configurations"] = placement_configurations
        __props__.__dict__["pod_configuration"] = pod_configuration
        __props__.__dict__["size"] = size
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["taints"] = taints
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["virtual_node_tags"] = virtual_node_tags
        return VirtualNodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The cluster the virtual node pool is associated with. A virtual node pool can only be associated with one cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        Compartment of the virtual node pool.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Display name of the virtual node pool. This is a non-unique value.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="initialVirtualNodeLabels")
    def initial_virtual_node_labels(self) -> pulumi.Output[Sequence['outputs.VirtualNodePoolInitialVirtualNodeLabel']]:
        """
        (Updatable) Initial labels that will be added to the Kubernetes Virtual Node object when it registers.
        """
        return pulumi.get(self, "initial_virtual_node_labels")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Output[str]:
        """
        The version of Kubernetes running on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details about the state of the Virtual Node Pool.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) List of network security group IDs applied to the Pod VNIC.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="placementConfigurations")
    def placement_configurations(self) -> pulumi.Output[Sequence['outputs.VirtualNodePoolPlacementConfiguration']]:
        """
        (Updatable) The list of placement configurations which determines where Virtual Nodes will be provisioned across as it relates to the subnet and availability domains. The size attribute determines how many we evenly spread across these placement configurations
        """
        return pulumi.get(self, "placement_configurations")

    @property
    @pulumi.getter(name="podConfiguration")
    def pod_configuration(self) -> pulumi.Output['outputs.VirtualNodePoolPodConfiguration']:
        """
        (Updatable) The pod configuration for pods run on virtual nodes of this virtual node pool.
        """
        return pulumi.get(self, "pod_configuration")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of Virtual Nodes that should be in the Virtual Node Pool. The placement configurations determine where these virtual nodes are placed.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the Virtual Node Pool.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Sequence['outputs.VirtualNodePoolTaint']]:
        """
        (Updatable) A taint is a collection of <key, value, effect>. These taints will be applied to the Virtual Nodes of this Virtual Node Pool for Kubernetes scheduling.
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the virtual node pool was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the virtual node pool was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="virtualNodeTags")
    def virtual_node_tags(self) -> pulumi.Output['outputs.VirtualNodePoolVirtualNodeTags']:
        """
        (Updatable) The tags associated to the virtual nodes in this virtual node pool.
        """
        return pulumi.get(self, "virtual_node_tags")

