# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetImageResult',
    'AwaitableGetImageResult',
    'get_image',
    'get_image_output',
]

@pulumi.output_type
class GetImageResult:
    """
    A collection of values returned by getImage.
    """
    def __init__(__self__, agent_features=None, base_image_id=None, billable_size_in_gbs=None, compartment_id=None, create_image_allowed=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, image_id=None, image_source_details=None, instance_id=None, launch_mode=None, launch_options=None, listing_type=None, operating_system=None, operating_system_version=None, size_in_mbs=None, state=None, time_created=None):
        if agent_features and not isinstance(agent_features, list):
            raise TypeError("Expected argument 'agent_features' to be a list")
        pulumi.set(__self__, "agent_features", agent_features)
        if base_image_id and not isinstance(base_image_id, str):
            raise TypeError("Expected argument 'base_image_id' to be a str")
        pulumi.set(__self__, "base_image_id", base_image_id)
        if billable_size_in_gbs and not isinstance(billable_size_in_gbs, str):
            raise TypeError("Expected argument 'billable_size_in_gbs' to be a str")
        pulumi.set(__self__, "billable_size_in_gbs", billable_size_in_gbs)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if create_image_allowed and not isinstance(create_image_allowed, bool):
            raise TypeError("Expected argument 'create_image_allowed' to be a bool")
        pulumi.set(__self__, "create_image_allowed", create_image_allowed)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if image_source_details and not isinstance(image_source_details, list):
            raise TypeError("Expected argument 'image_source_details' to be a list")
        pulumi.set(__self__, "image_source_details", image_source_details)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if launch_mode and not isinstance(launch_mode, str):
            raise TypeError("Expected argument 'launch_mode' to be a str")
        pulumi.set(__self__, "launch_mode", launch_mode)
        if launch_options and not isinstance(launch_options, list):
            raise TypeError("Expected argument 'launch_options' to be a list")
        pulumi.set(__self__, "launch_options", launch_options)
        if listing_type and not isinstance(listing_type, str):
            raise TypeError("Expected argument 'listing_type' to be a str")
        pulumi.set(__self__, "listing_type", listing_type)
        if operating_system and not isinstance(operating_system, str):
            raise TypeError("Expected argument 'operating_system' to be a str")
        pulumi.set(__self__, "operating_system", operating_system)
        if operating_system_version and not isinstance(operating_system_version, str):
            raise TypeError("Expected argument 'operating_system_version' to be a str")
        pulumi.set(__self__, "operating_system_version", operating_system_version)
        if size_in_mbs and not isinstance(size_in_mbs, str):
            raise TypeError("Expected argument 'size_in_mbs' to be a str")
        pulumi.set(__self__, "size_in_mbs", size_in_mbs)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="agentFeatures")
    def agent_features(self) -> Sequence['outputs.GetImageAgentFeatureResult']:
        """
        Oracle Cloud Agent features supported on the image.
        """
        return pulumi.get(self, "agent_features")

    @property
    @pulumi.getter(name="baseImageId")
    def base_image_id(self) -> str:
        """
        The OCID of the image originally used to launch the instance.
        """
        return pulumi.get(self, "base_image_id")

    @property
    @pulumi.getter(name="billableSizeInGbs")
    def billable_size_in_gbs(self) -> str:
        """
        The size of the internal storage for this image that is subject to billing (1 GB = 1,073,741,824 bytes).  Example: `100`
        """
        return pulumi.get(self, "billable_size_in_gbs")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the instance you want to use as the basis for the image.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createImageAllowed")
    def create_image_allowed(self) -> bool:
        """
        Whether instances launched with this image can be used to create new images. For example, you cannot create an image of an Oracle Database instance.  Example: `true`
        """
        return pulumi.get(self, "create_image_allowed")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name for the image. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the image.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageSourceDetails")
    def image_source_details(self) -> Sequence['outputs.GetImageImageSourceDetailResult']:
        return pulumi.get(self, "image_source_details")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="launchMode")
    def launch_mode(self) -> str:
        """
        Specifies the configuration mode for launching virtual machine (VM) instances. The configuration modes are:
        """
        return pulumi.get(self, "launch_mode")

    @property
    @pulumi.getter(name="launchOptions")
    def launch_options(self) -> Sequence['outputs.GetImageLaunchOptionResult']:
        """
        Options for tuning the compatibility and performance of VM shapes. The values that you specify override any default values.
        """
        return pulumi.get(self, "launch_options")

    @property
    @pulumi.getter(name="listingType")
    def listing_type(self) -> str:
        """
        The listing type of the image. The default value is "NONE".
        """
        return pulumi.get(self, "listing_type")

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> str:
        """
        The image's operating system.  Example: `Oracle Linux`
        """
        return pulumi.get(self, "operating_system")

    @property
    @pulumi.getter(name="operatingSystemVersion")
    def operating_system_version(self) -> str:
        """
        The image's operating system version.  Example: `7.2`
        """
        return pulumi.get(self, "operating_system_version")

    @property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> str:
        """
        The boot volume size for an instance launched from this image (1 MB = 1,048,576 bytes). Note this is not the same as the size of the image when it was exported or the actual size of the image.  Example: `47694`
        """
        return pulumi.get(self, "size_in_mbs")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the image.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the image was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetImageResult(GetImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageResult(
            agent_features=self.agent_features,
            base_image_id=self.base_image_id,
            billable_size_in_gbs=self.billable_size_in_gbs,
            compartment_id=self.compartment_id,
            create_image_allowed=self.create_image_allowed,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            image_id=self.image_id,
            image_source_details=self.image_source_details,
            instance_id=self.instance_id,
            launch_mode=self.launch_mode,
            launch_options=self.launch_options,
            listing_type=self.listing_type,
            operating_system=self.operating_system,
            operating_system_version=self.operating_system_version,
            size_in_mbs=self.size_in_mbs,
            state=self.state,
            time_created=self.time_created)


def get_image(image_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageResult:
    """
    This data source provides details about a specific Image resource in Oracle Cloud Infrastructure Core service.

    Gets the specified image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_image = oci.Core.get_image(image_id=oci_core_image["test_image"]["id"])
    ```


    :param str image_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the image.
    """
    __args__ = dict()
    __args__['imageId'] = image_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getImage:getImage', __args__, opts=opts, typ=GetImageResult).value

    return AwaitableGetImageResult(
        agent_features=pulumi.get(__ret__, 'agent_features'),
        base_image_id=pulumi.get(__ret__, 'base_image_id'),
        billable_size_in_gbs=pulumi.get(__ret__, 'billable_size_in_gbs'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        create_image_allowed=pulumi.get(__ret__, 'create_image_allowed'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        image_source_details=pulumi.get(__ret__, 'image_source_details'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        launch_mode=pulumi.get(__ret__, 'launch_mode'),
        launch_options=pulumi.get(__ret__, 'launch_options'),
        listing_type=pulumi.get(__ret__, 'listing_type'),
        operating_system=pulumi.get(__ret__, 'operating_system'),
        operating_system_version=pulumi.get(__ret__, 'operating_system_version'),
        size_in_mbs=pulumi.get(__ret__, 'size_in_mbs'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_image)
def get_image_output(image_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetImageResult]:
    """
    This data source provides details about a specific Image resource in Oracle Cloud Infrastructure Core service.

    Gets the specified image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_image = oci.Core.get_image(image_id=oci_core_image["test_image"]["id"])
    ```


    :param str image_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the image.
    """
    ...
