# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExadataInfrastructureComputeArgs', 'ExadataInfrastructureCompute']

@pulumi.input_type
class ExadataInfrastructureComputeArgs:
    def __init__(__self__, *,
                 exadata_infrastructure_id: pulumi.Input[str],
                 activation_file: Optional[pulumi.Input[str]] = None,
                 additional_compute_count_compute_managed_resource: Optional[pulumi.Input[int]] = None,
                 additional_compute_system_model_compute_managed_resource: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ExadataInfrastructureCompute resource.
        :param pulumi.Input[str] exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        ExadataInfrastructureComputeArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            exadata_infrastructure_id=exadata_infrastructure_id,
            activation_file=activation_file,
            additional_compute_count_compute_managed_resource=additional_compute_count_compute_managed_resource,
            additional_compute_system_model_compute_managed_resource=additional_compute_system_model_compute_managed_resource,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             exadata_infrastructure_id: pulumi.Input[str],
             activation_file: Optional[pulumi.Input[str]] = None,
             additional_compute_count_compute_managed_resource: Optional[pulumi.Input[int]] = None,
             additional_compute_system_model_compute_managed_resource: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("exadata_infrastructure_id", exadata_infrastructure_id)
        if activation_file is not None:
            _setter("activation_file", activation_file)
        if additional_compute_count_compute_managed_resource is not None:
            _setter("additional_compute_count_compute_managed_resource", additional_compute_count_compute_managed_resource)
        if additional_compute_system_model_compute_managed_resource is not None:
            _setter("additional_compute_system_model_compute_managed_resource", additional_compute_system_model_compute_managed_resource)

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> pulumi.Input[str]:
        """
        The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="activationFile")
    def activation_file(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "activation_file")

    @activation_file.setter
    def activation_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_file", value)

    @property
    @pulumi.getter(name="additionalComputeCountComputeManagedResource")
    def additional_compute_count_compute_managed_resource(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "additional_compute_count_compute_managed_resource")

    @additional_compute_count_compute_managed_resource.setter
    def additional_compute_count_compute_managed_resource(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_compute_count_compute_managed_resource", value)

    @property
    @pulumi.getter(name="additionalComputeSystemModelComputeManagedResource")
    def additional_compute_system_model_compute_managed_resource(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "additional_compute_system_model_compute_managed_resource")

    @additional_compute_system_model_compute_managed_resource.setter
    def additional_compute_system_model_compute_managed_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_compute_system_model_compute_managed_resource", value)


@pulumi.input_type
class _ExadataInfrastructureComputeState:
    def __init__(__self__, *,
                 activated_storage_count: Optional[pulumi.Input[int]] = None,
                 activation_file: Optional[pulumi.Input[str]] = None,
                 additional_compute_count: Optional[pulumi.Input[int]] = None,
                 additional_compute_count_compute_managed_resource: Optional[pulumi.Input[int]] = None,
                 additional_compute_system_model: Optional[pulumi.Input[str]] = None,
                 additional_compute_system_model_compute_managed_resource: Optional[pulumi.Input[str]] = None,
                 additional_storage_count: Optional[pulumi.Input[int]] = None,
                 admin_network_cidr: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server1: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server2: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[int]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureComputeContactArgs']]]] = None,
                 corporate_proxy: Optional[pulumi.Input[str]] = None,
                 cpus_enabled: Optional[pulumi.Input[int]] = None,
                 create_async: Optional[pulumi.Input[bool]] = None,
                 csi_number: Optional[pulumi.Input[str]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 db_server_version: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 gateway: Optional[pulumi.Input[str]] = None,
                 infini_band_network_cidr: Optional[pulumi.Input[str]] = None,
                 is_cps_offline_report_enabled: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 maintenance_slo_status: Optional[pulumi.Input[str]] = None,
                 maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureComputeMaintenanceWindowArgs']]]] = None,
                 max_cpu_count: Optional[pulumi.Input[int]] = None,
                 max_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
                 max_db_node_storage_in_gbs: Optional[pulumi.Input[int]] = None,
                 max_memory_in_gbs: Optional[pulumi.Input[int]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 monthly_db_server_version: Optional[pulumi.Input[str]] = None,
                 netmask: Optional[pulumi.Input[str]] = None,
                 ntp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage_count: Optional[pulumi.Input[int]] = None,
                 storage_server_version: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExadataInfrastructureCompute resources.
        :param pulumi.Input[int] activated_storage_count: The requested number of additional storage servers activated for the Exadata infrastructure.
        :param pulumi.Input[int] additional_compute_count: The number of additional compute servers for the Exadata infrastructure.
        :param pulumi.Input[str] additional_compute_system_model: Oracle Exadata System Model specification. The system model determines the amount of compute or storage server resources available for use. For more information, please see [System and Shape Configuration Options] (https://docs.oracle.com/en/engineered-systems/exadata-cloud-at-customer/ecccm/ecc-system-config-options.html#GUID-9E090174-5C57-4EB1-9243-B470F9F10D6B)
        :param pulumi.Input[int] additional_storage_count: The requested number of additional storage servers for the Exadata infrastructure.
        :param pulumi.Input[str] admin_network_cidr: The CIDR block for the Exadata administration network.
        :param pulumi.Input[str] cloud_control_plane_server1: The IP address for the first control plane server.
        :param pulumi.Input[str] cloud_control_plane_server2: The IP address for the second control plane server.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] compute_count: The number of compute servers for the Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureComputeContactArgs']]] contacts: The list of contacts for the Exadata infrastructure.
        :param pulumi.Input[str] corporate_proxy: The corporate network proxy for access to the control plane network.
        :param pulumi.Input[int] cpus_enabled: The number of enabled CPU cores.
        :param pulumi.Input[str] csi_number: The CSI Number of the Exadata infrastructure.
        :param pulumi.Input[float] data_storage_size_in_tbs: Size, in terabytes, of the DATA disk group.
        :param pulumi.Input[int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[str] db_server_version: The software version of the database servers (dom0) in the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-friendly name for the Exadata Cloud@Customer infrastructure. The name does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: The list of DNS server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[str] exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gateway: The gateway for the control plane network.
        :param pulumi.Input[str] infini_band_network_cidr: The CIDR block for the Exadata InfiniBand interconnect.
        :param pulumi.Input[bool] is_cps_offline_report_enabled: Indicates whether cps offline diagnostic report is enabled for this Exadata infrastructure. This will allow a customer to quickly check status themselves and fix problems on their end, saving time and frustration for both Oracle and the customer when they find the CPS in a disconnected state.You can enable offline diagnostic report during Exadata infrastructure provisioning. You can also disable or enable it at any time using the UpdateExadatainfrastructure API.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] maintenance_slo_status: A field to capture ‘Maintenance SLO Status’ for the Exadata infrastructure with values ‘OK’, ‘DEGRADED’. Default is ‘OK’ when the infrastructure is provisioned.
        :param pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureComputeMaintenanceWindowArgs']]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] max_cpu_count: The total number of CPU cores available.
        :param pulumi.Input[float] max_data_storage_in_tbs: The total available DATA disk group size.
        :param pulumi.Input[int] max_db_node_storage_in_gbs: The total local node storage available in GBs.
        :param pulumi.Input[int] max_memory_in_gbs: The total memory available in GBs.
        :param pulumi.Input[int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[str] monthly_db_server_version: The monthly software version of the database servers (dom0) in the Exadata infrastructure.
        :param pulumi.Input[str] netmask: The netmask for the control plane network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ntp_servers: The list of NTP server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[str] shape: The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        :param pulumi.Input[str] state: The current lifecycle state of the Exadata infrastructure.
        :param pulumi.Input[int] storage_count: The number of Exadata storage servers for the Exadata infrastructure.
        :param pulumi.Input[str] storage_server_version: The software version of the storage servers (cells) in the Exadata infrastructure.
        :param pulumi.Input[str] time_created: The date and time the Exadata infrastructure was created.
        :param pulumi.Input[str] time_zone: The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        _ExadataInfrastructureComputeState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            activated_storage_count=activated_storage_count,
            activation_file=activation_file,
            additional_compute_count=additional_compute_count,
            additional_compute_count_compute_managed_resource=additional_compute_count_compute_managed_resource,
            additional_compute_system_model=additional_compute_system_model,
            additional_compute_system_model_compute_managed_resource=additional_compute_system_model_compute_managed_resource,
            additional_storage_count=additional_storage_count,
            admin_network_cidr=admin_network_cidr,
            cloud_control_plane_server1=cloud_control_plane_server1,
            cloud_control_plane_server2=cloud_control_plane_server2,
            compartment_id=compartment_id,
            compute_count=compute_count,
            contacts=contacts,
            corporate_proxy=corporate_proxy,
            cpus_enabled=cpus_enabled,
            create_async=create_async,
            csi_number=csi_number,
            data_storage_size_in_tbs=data_storage_size_in_tbs,
            db_node_storage_size_in_gbs=db_node_storage_size_in_gbs,
            db_server_version=db_server_version,
            defined_tags=defined_tags,
            display_name=display_name,
            dns_servers=dns_servers,
            exadata_infrastructure_id=exadata_infrastructure_id,
            freeform_tags=freeform_tags,
            gateway=gateway,
            infini_band_network_cidr=infini_band_network_cidr,
            is_cps_offline_report_enabled=is_cps_offline_report_enabled,
            lifecycle_details=lifecycle_details,
            maintenance_slo_status=maintenance_slo_status,
            maintenance_windows=maintenance_windows,
            max_cpu_count=max_cpu_count,
            max_data_storage_in_tbs=max_data_storage_in_tbs,
            max_db_node_storage_in_gbs=max_db_node_storage_in_gbs,
            max_memory_in_gbs=max_memory_in_gbs,
            memory_size_in_gbs=memory_size_in_gbs,
            monthly_db_server_version=monthly_db_server_version,
            netmask=netmask,
            ntp_servers=ntp_servers,
            shape=shape,
            state=state,
            storage_count=storage_count,
            storage_server_version=storage_server_version,
            time_created=time_created,
            time_zone=time_zone,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             activated_storage_count: Optional[pulumi.Input[int]] = None,
             activation_file: Optional[pulumi.Input[str]] = None,
             additional_compute_count: Optional[pulumi.Input[int]] = None,
             additional_compute_count_compute_managed_resource: Optional[pulumi.Input[int]] = None,
             additional_compute_system_model: Optional[pulumi.Input[str]] = None,
             additional_compute_system_model_compute_managed_resource: Optional[pulumi.Input[str]] = None,
             additional_storage_count: Optional[pulumi.Input[int]] = None,
             admin_network_cidr: Optional[pulumi.Input[str]] = None,
             cloud_control_plane_server1: Optional[pulumi.Input[str]] = None,
             cloud_control_plane_server2: Optional[pulumi.Input[str]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             compute_count: Optional[pulumi.Input[int]] = None,
             contacts: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureComputeContactArgs']]]] = None,
             corporate_proxy: Optional[pulumi.Input[str]] = None,
             cpus_enabled: Optional[pulumi.Input[int]] = None,
             create_async: Optional[pulumi.Input[bool]] = None,
             csi_number: Optional[pulumi.Input[str]] = None,
             data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
             db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
             db_server_version: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             gateway: Optional[pulumi.Input[str]] = None,
             infini_band_network_cidr: Optional[pulumi.Input[str]] = None,
             is_cps_offline_report_enabled: Optional[pulumi.Input[bool]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             maintenance_slo_status: Optional[pulumi.Input[str]] = None,
             maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureComputeMaintenanceWindowArgs']]]] = None,
             max_cpu_count: Optional[pulumi.Input[int]] = None,
             max_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
             max_db_node_storage_in_gbs: Optional[pulumi.Input[int]] = None,
             max_memory_in_gbs: Optional[pulumi.Input[int]] = None,
             memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
             monthly_db_server_version: Optional[pulumi.Input[str]] = None,
             netmask: Optional[pulumi.Input[str]] = None,
             ntp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             shape: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             storage_count: Optional[pulumi.Input[int]] = None,
             storage_server_version: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_zone: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if activated_storage_count is not None:
            _setter("activated_storage_count", activated_storage_count)
        if activation_file is not None:
            _setter("activation_file", activation_file)
        if additional_compute_count is not None:
            _setter("additional_compute_count", additional_compute_count)
        if additional_compute_count_compute_managed_resource is not None:
            _setter("additional_compute_count_compute_managed_resource", additional_compute_count_compute_managed_resource)
        if additional_compute_system_model is not None:
            _setter("additional_compute_system_model", additional_compute_system_model)
        if additional_compute_system_model_compute_managed_resource is not None:
            _setter("additional_compute_system_model_compute_managed_resource", additional_compute_system_model_compute_managed_resource)
        if additional_storage_count is not None:
            _setter("additional_storage_count", additional_storage_count)
        if admin_network_cidr is not None:
            _setter("admin_network_cidr", admin_network_cidr)
        if cloud_control_plane_server1 is not None:
            _setter("cloud_control_plane_server1", cloud_control_plane_server1)
        if cloud_control_plane_server2 is not None:
            _setter("cloud_control_plane_server2", cloud_control_plane_server2)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if compute_count is not None:
            _setter("compute_count", compute_count)
        if contacts is not None:
            _setter("contacts", contacts)
        if corporate_proxy is not None:
            _setter("corporate_proxy", corporate_proxy)
        if cpus_enabled is not None:
            _setter("cpus_enabled", cpus_enabled)
        if create_async is not None:
            _setter("create_async", create_async)
        if csi_number is not None:
            _setter("csi_number", csi_number)
        if data_storage_size_in_tbs is not None:
            _setter("data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            _setter("db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_server_version is not None:
            _setter("db_server_version", db_server_version)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if dns_servers is not None:
            _setter("dns_servers", dns_servers)
        if exadata_infrastructure_id is not None:
            _setter("exadata_infrastructure_id", exadata_infrastructure_id)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if gateway is not None:
            _setter("gateway", gateway)
        if infini_band_network_cidr is not None:
            _setter("infini_band_network_cidr", infini_band_network_cidr)
        if is_cps_offline_report_enabled is not None:
            _setter("is_cps_offline_report_enabled", is_cps_offline_report_enabled)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if maintenance_slo_status is not None:
            _setter("maintenance_slo_status", maintenance_slo_status)
        if maintenance_windows is not None:
            _setter("maintenance_windows", maintenance_windows)
        if max_cpu_count is not None:
            _setter("max_cpu_count", max_cpu_count)
        if max_data_storage_in_tbs is not None:
            _setter("max_data_storage_in_tbs", max_data_storage_in_tbs)
        if max_db_node_storage_in_gbs is not None:
            _setter("max_db_node_storage_in_gbs", max_db_node_storage_in_gbs)
        if max_memory_in_gbs is not None:
            _setter("max_memory_in_gbs", max_memory_in_gbs)
        if memory_size_in_gbs is not None:
            _setter("memory_size_in_gbs", memory_size_in_gbs)
        if monthly_db_server_version is not None:
            _setter("monthly_db_server_version", monthly_db_server_version)
        if netmask is not None:
            _setter("netmask", netmask)
        if ntp_servers is not None:
            _setter("ntp_servers", ntp_servers)
        if shape is not None:
            _setter("shape", shape)
        if state is not None:
            _setter("state", state)
        if storage_count is not None:
            _setter("storage_count", storage_count)
        if storage_server_version is not None:
            _setter("storage_server_version", storage_server_version)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_zone is not None:
            _setter("time_zone", time_zone)

    @property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> Optional[pulumi.Input[int]]:
        """
        The requested number of additional storage servers activated for the Exadata infrastructure.
        """
        return pulumi.get(self, "activated_storage_count")

    @activated_storage_count.setter
    def activated_storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "activated_storage_count", value)

    @property
    @pulumi.getter(name="activationFile")
    def activation_file(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "activation_file")

    @activation_file.setter
    def activation_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_file", value)

    @property
    @pulumi.getter(name="additionalComputeCount")
    def additional_compute_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of additional compute servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_compute_count")

    @additional_compute_count.setter
    def additional_compute_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_compute_count", value)

    @property
    @pulumi.getter(name="additionalComputeCountComputeManagedResource")
    def additional_compute_count_compute_managed_resource(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "additional_compute_count_compute_managed_resource")

    @additional_compute_count_compute_managed_resource.setter
    def additional_compute_count_compute_managed_resource(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_compute_count_compute_managed_resource", value)

    @property
    @pulumi.getter(name="additionalComputeSystemModel")
    def additional_compute_system_model(self) -> Optional[pulumi.Input[str]]:
        """
        Oracle Exadata System Model specification. The system model determines the amount of compute or storage server resources available for use. For more information, please see [System and Shape Configuration Options] (https://docs.oracle.com/en/engineered-systems/exadata-cloud-at-customer/ecccm/ecc-system-config-options.html#GUID-9E090174-5C57-4EB1-9243-B470F9F10D6B)
        """
        return pulumi.get(self, "additional_compute_system_model")

    @additional_compute_system_model.setter
    def additional_compute_system_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_compute_system_model", value)

    @property
    @pulumi.getter(name="additionalComputeSystemModelComputeManagedResource")
    def additional_compute_system_model_compute_managed_resource(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "additional_compute_system_model_compute_managed_resource")

    @additional_compute_system_model_compute_managed_resource.setter
    def additional_compute_system_model_compute_managed_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_compute_system_model_compute_managed_resource", value)

    @property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> Optional[pulumi.Input[int]]:
        """
        The requested number of additional storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_storage_count")

    @additional_storage_count.setter
    def additional_storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_storage_count", value)

    @property
    @pulumi.getter(name="adminNetworkCidr")
    def admin_network_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for the Exadata administration network.
        """
        return pulumi.get(self, "admin_network_cidr")

    @admin_network_cidr.setter
    def admin_network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_network_cidr", value)

    @property
    @pulumi.getter(name="cloudControlPlaneServer1")
    def cloud_control_plane_server1(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address for the first control plane server.
        """
        return pulumi.get(self, "cloud_control_plane_server1")

    @cloud_control_plane_server1.setter
    def cloud_control_plane_server1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_control_plane_server1", value)

    @property
    @pulumi.getter(name="cloudControlPlaneServer2")
    def cloud_control_plane_server2(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address for the second control plane server.
        """
        return pulumi.get(self, "cloud_control_plane_server2")

    @cloud_control_plane_server2.setter
    def cloud_control_plane_server2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_control_plane_server2", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of compute servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compute_count", value)

    @property
    @pulumi.getter
    def contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureComputeContactArgs']]]]:
        """
        The list of contacts for the Exadata infrastructure.
        """
        return pulumi.get(self, "contacts")

    @contacts.setter
    def contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureComputeContactArgs']]]]):
        pulumi.set(self, "contacts", value)

    @property
    @pulumi.getter(name="corporateProxy")
    def corporate_proxy(self) -> Optional[pulumi.Input[str]]:
        """
        The corporate network proxy for access to the control plane network.
        """
        return pulumi.get(self, "corporate_proxy")

    @corporate_proxy.setter
    def corporate_proxy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "corporate_proxy", value)

    @property
    @pulumi.getter(name="cpusEnabled")
    def cpus_enabled(self) -> Optional[pulumi.Input[int]]:
        """
        The number of enabled CPU cores.
        """
        return pulumi.get(self, "cpus_enabled")

    @cpus_enabled.setter
    def cpus_enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpus_enabled", value)

    @property
    @pulumi.getter(name="createAsync")
    def create_async(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "create_async")

    @create_async.setter
    def create_async(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_async", value)

    @property
    @pulumi.getter(name="csiNumber")
    def csi_number(self) -> Optional[pulumi.Input[str]]:
        """
        The CSI Number of the Exadata infrastructure.
        """
        return pulumi.get(self, "csi_number")

    @csi_number.setter
    def csi_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csi_number", value)

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        Size, in terabytes, of the DATA disk group.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="dbServerVersion")
    def db_server_version(self) -> Optional[pulumi.Input[str]]:
        """
        The software version of the database servers (dom0) in the Exadata infrastructure.
        """
        return pulumi.get(self, "db_server_version")

    @db_server_version.setter
    def db_server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_server_version", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name for the Exadata Cloud@Customer infrastructure. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of DNS server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The gateway for the control plane network.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="infiniBandNetworkCidr")
    def infini_band_network_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for the Exadata InfiniBand interconnect.
        """
        return pulumi.get(self, "infini_band_network_cidr")

    @infini_band_network_cidr.setter
    def infini_band_network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infini_band_network_cidr", value)

    @property
    @pulumi.getter(name="isCpsOfflineReportEnabled")
    def is_cps_offline_report_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether cps offline diagnostic report is enabled for this Exadata infrastructure. This will allow a customer to quickly check status themselves and fix problems on their end, saving time and frustration for both Oracle and the customer when they find the CPS in a disconnected state.You can enable offline diagnostic report during Exadata infrastructure provisioning. You can also disable or enable it at any time using the UpdateExadatainfrastructure API.
        """
        return pulumi.get(self, "is_cps_offline_report_enabled")

    @is_cps_offline_report_enabled.setter
    def is_cps_offline_report_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cps_offline_report_enabled", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="maintenanceSloStatus")
    def maintenance_slo_status(self) -> Optional[pulumi.Input[str]]:
        """
        A field to capture ‘Maintenance SLO Status’ for the Exadata infrastructure with values ‘OK’, ‘DEGRADED’. Default is ‘OK’ when the infrastructure is provisioned.
        """
        return pulumi.get(self, "maintenance_slo_status")

    @maintenance_slo_status.setter
    def maintenance_slo_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_slo_status", value)

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureComputeMaintenanceWindowArgs']]]]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @maintenance_windows.setter
    def maintenance_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureComputeMaintenanceWindowArgs']]]]):
        pulumi.set(self, "maintenance_windows", value)

    @property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of CPU cores available.
        """
        return pulumi.get(self, "max_cpu_count")

    @max_cpu_count.setter
    def max_cpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_cpu_count", value)

    @property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        The total available DATA disk group size.
        """
        return pulumi.get(self, "max_data_storage_in_tbs")

    @max_data_storage_in_tbs.setter
    def max_data_storage_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_data_storage_in_tbs", value)

    @property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The total local node storage available in GBs.
        """
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @max_db_node_storage_in_gbs.setter
    def max_db_node_storage_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_db_node_storage_in_gbs", value)

    @property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The total memory available in GBs.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @max_memory_in_gbs.setter
    def max_memory_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_memory_in_gbs", value)

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @property
    @pulumi.getter(name="monthlyDbServerVersion")
    def monthly_db_server_version(self) -> Optional[pulumi.Input[str]]:
        """
        The monthly software version of the database servers (dom0) in the Exadata infrastructure.
        """
        return pulumi.get(self, "monthly_db_server_version")

    @monthly_db_server_version.setter
    def monthly_db_server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monthly_db_server_version", value)

    @property
    @pulumi.getter
    def netmask(self) -> Optional[pulumi.Input[str]]:
        """
        The netmask for the control plane network.
        """
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netmask", value)

    @property
    @pulumi.getter(name="ntpServers")
    def ntp_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of NTP server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "ntp_servers")

    @ntp_servers.setter
    def ntp_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ntp_servers", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the Exadata infrastructure.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of Exadata storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_count")

    @storage_count.setter
    def storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_count", value)

    @property
    @pulumi.getter(name="storageServerVersion")
    def storage_server_version(self) -> Optional[pulumi.Input[str]]:
        """
        The software version of the storage servers (cells) in the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_server_version")

    @storage_server_version.setter
    def storage_server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_server_version", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the Exadata infrastructure was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


class ExadataInfrastructureCompute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_file: Optional[pulumi.Input[str]] = None,
                 additional_compute_count_compute_managed_resource: Optional[pulumi.Input[int]] = None,
                 additional_compute_system_model_compute_managed_resource: Optional[pulumi.Input[str]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This data source provides details about a specific Exadata Infrastructure compute managed resource in Oracle Cloud Infrastructure Database service.

        Gets information about the specified Exadata infrastructure. Applies to Exadata Cloud@Customer instances only.
        To get information on an Exadata Cloud Service infrastructure resource, use the  [GetCloudExadataInfrastructure](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudExadataInfrastructure/GetCloudExadataInfrastructure) operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_exadata_infrastructure = oci.Database.get_exadata_infrastructure(exadata_infrastructure_id=oci_database_exadata_infrastructure["test_exadata_infrastructure"]["id"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExadataInfrastructureComputeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This data source provides details about a specific Exadata Infrastructure compute managed resource in Oracle Cloud Infrastructure Database service.

        Gets information about the specified Exadata infrastructure. Applies to Exadata Cloud@Customer instances only.
        To get information on an Exadata Cloud Service infrastructure resource, use the  [GetCloudExadataInfrastructure](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudExadataInfrastructure/GetCloudExadataInfrastructure) operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_exadata_infrastructure = oci.Database.get_exadata_infrastructure(exadata_infrastructure_id=oci_database_exadata_infrastructure["test_exadata_infrastructure"]["id"])
        ```

        :param str resource_name: The name of the resource.
        :param ExadataInfrastructureComputeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExadataInfrastructureComputeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ExadataInfrastructureComputeArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_file: Optional[pulumi.Input[str]] = None,
                 additional_compute_count_compute_managed_resource: Optional[pulumi.Input[int]] = None,
                 additional_compute_system_model_compute_managed_resource: Optional[pulumi.Input[str]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExadataInfrastructureComputeArgs.__new__(ExadataInfrastructureComputeArgs)

            __props__.__dict__["activation_file"] = activation_file
            __props__.__dict__["additional_compute_count_compute_managed_resource"] = additional_compute_count_compute_managed_resource
            __props__.__dict__["additional_compute_system_model_compute_managed_resource"] = additional_compute_system_model_compute_managed_resource
            if exadata_infrastructure_id is None and not opts.urn:
                raise TypeError("Missing required property 'exadata_infrastructure_id'")
            __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
            __props__.__dict__["activated_storage_count"] = None
            __props__.__dict__["additional_compute_count"] = None
            __props__.__dict__["additional_compute_system_model"] = None
            __props__.__dict__["additional_storage_count"] = None
            __props__.__dict__["admin_network_cidr"] = None
            __props__.__dict__["cloud_control_plane_server1"] = None
            __props__.__dict__["cloud_control_plane_server2"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["compute_count"] = None
            __props__.__dict__["contacts"] = None
            __props__.__dict__["corporate_proxy"] = None
            __props__.__dict__["cpus_enabled"] = None
            __props__.__dict__["create_async"] = None
            __props__.__dict__["csi_number"] = None
            __props__.__dict__["data_storage_size_in_tbs"] = None
            __props__.__dict__["db_node_storage_size_in_gbs"] = None
            __props__.__dict__["db_server_version"] = None
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["dns_servers"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["gateway"] = None
            __props__.__dict__["infini_band_network_cidr"] = None
            __props__.__dict__["is_cps_offline_report_enabled"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["maintenance_slo_status"] = None
            __props__.__dict__["maintenance_windows"] = None
            __props__.__dict__["max_cpu_count"] = None
            __props__.__dict__["max_data_storage_in_tbs"] = None
            __props__.__dict__["max_db_node_storage_in_gbs"] = None
            __props__.__dict__["max_memory_in_gbs"] = None
            __props__.__dict__["memory_size_in_gbs"] = None
            __props__.__dict__["monthly_db_server_version"] = None
            __props__.__dict__["netmask"] = None
            __props__.__dict__["ntp_servers"] = None
            __props__.__dict__["shape"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["storage_count"] = None
            __props__.__dict__["storage_server_version"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_zone"] = None
        super(ExadataInfrastructureCompute, __self__).__init__(
            'oci:Database/exadataInfrastructureCompute:ExadataInfrastructureCompute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activated_storage_count: Optional[pulumi.Input[int]] = None,
            activation_file: Optional[pulumi.Input[str]] = None,
            additional_compute_count: Optional[pulumi.Input[int]] = None,
            additional_compute_count_compute_managed_resource: Optional[pulumi.Input[int]] = None,
            additional_compute_system_model: Optional[pulumi.Input[str]] = None,
            additional_compute_system_model_compute_managed_resource: Optional[pulumi.Input[str]] = None,
            additional_storage_count: Optional[pulumi.Input[int]] = None,
            admin_network_cidr: Optional[pulumi.Input[str]] = None,
            cloud_control_plane_server1: Optional[pulumi.Input[str]] = None,
            cloud_control_plane_server2: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            compute_count: Optional[pulumi.Input[int]] = None,
            contacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExadataInfrastructureComputeContactArgs']]]]] = None,
            corporate_proxy: Optional[pulumi.Input[str]] = None,
            cpus_enabled: Optional[pulumi.Input[int]] = None,
            create_async: Optional[pulumi.Input[bool]] = None,
            csi_number: Optional[pulumi.Input[str]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
            db_server_version: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            gateway: Optional[pulumi.Input[str]] = None,
            infini_band_network_cidr: Optional[pulumi.Input[str]] = None,
            is_cps_offline_report_enabled: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            maintenance_slo_status: Optional[pulumi.Input[str]] = None,
            maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExadataInfrastructureComputeMaintenanceWindowArgs']]]]] = None,
            max_cpu_count: Optional[pulumi.Input[int]] = None,
            max_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
            max_db_node_storage_in_gbs: Optional[pulumi.Input[int]] = None,
            max_memory_in_gbs: Optional[pulumi.Input[int]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
            monthly_db_server_version: Optional[pulumi.Input[str]] = None,
            netmask: Optional[pulumi.Input[str]] = None,
            ntp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            shape: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            storage_count: Optional[pulumi.Input[int]] = None,
            storage_server_version: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_zone: Optional[pulumi.Input[str]] = None) -> 'ExadataInfrastructureCompute':
        """
        Get an existing ExadataInfrastructureCompute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] activated_storage_count: The requested number of additional storage servers activated for the Exadata infrastructure.
        :param pulumi.Input[int] additional_compute_count: The number of additional compute servers for the Exadata infrastructure.
        :param pulumi.Input[str] additional_compute_system_model: Oracle Exadata System Model specification. The system model determines the amount of compute or storage server resources available for use. For more information, please see [System and Shape Configuration Options] (https://docs.oracle.com/en/engineered-systems/exadata-cloud-at-customer/ecccm/ecc-system-config-options.html#GUID-9E090174-5C57-4EB1-9243-B470F9F10D6B)
        :param pulumi.Input[int] additional_storage_count: The requested number of additional storage servers for the Exadata infrastructure.
        :param pulumi.Input[str] admin_network_cidr: The CIDR block for the Exadata administration network.
        :param pulumi.Input[str] cloud_control_plane_server1: The IP address for the first control plane server.
        :param pulumi.Input[str] cloud_control_plane_server2: The IP address for the second control plane server.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] compute_count: The number of compute servers for the Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExadataInfrastructureComputeContactArgs']]]] contacts: The list of contacts for the Exadata infrastructure.
        :param pulumi.Input[str] corporate_proxy: The corporate network proxy for access to the control plane network.
        :param pulumi.Input[int] cpus_enabled: The number of enabled CPU cores.
        :param pulumi.Input[str] csi_number: The CSI Number of the Exadata infrastructure.
        :param pulumi.Input[float] data_storage_size_in_tbs: Size, in terabytes, of the DATA disk group.
        :param pulumi.Input[int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[str] db_server_version: The software version of the database servers (dom0) in the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-friendly name for the Exadata Cloud@Customer infrastructure. The name does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: The list of DNS server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[str] exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gateway: The gateway for the control plane network.
        :param pulumi.Input[str] infini_band_network_cidr: The CIDR block for the Exadata InfiniBand interconnect.
        :param pulumi.Input[bool] is_cps_offline_report_enabled: Indicates whether cps offline diagnostic report is enabled for this Exadata infrastructure. This will allow a customer to quickly check status themselves and fix problems on their end, saving time and frustration for both Oracle and the customer when they find the CPS in a disconnected state.You can enable offline diagnostic report during Exadata infrastructure provisioning. You can also disable or enable it at any time using the UpdateExadatainfrastructure API.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] maintenance_slo_status: A field to capture ‘Maintenance SLO Status’ for the Exadata infrastructure with values ‘OK’, ‘DEGRADED’. Default is ‘OK’ when the infrastructure is provisioned.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExadataInfrastructureComputeMaintenanceWindowArgs']]]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] max_cpu_count: The total number of CPU cores available.
        :param pulumi.Input[float] max_data_storage_in_tbs: The total available DATA disk group size.
        :param pulumi.Input[int] max_db_node_storage_in_gbs: The total local node storage available in GBs.
        :param pulumi.Input[int] max_memory_in_gbs: The total memory available in GBs.
        :param pulumi.Input[int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[str] monthly_db_server_version: The monthly software version of the database servers (dom0) in the Exadata infrastructure.
        :param pulumi.Input[str] netmask: The netmask for the control plane network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ntp_servers: The list of NTP server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[str] shape: The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        :param pulumi.Input[str] state: The current lifecycle state of the Exadata infrastructure.
        :param pulumi.Input[int] storage_count: The number of Exadata storage servers for the Exadata infrastructure.
        :param pulumi.Input[str] storage_server_version: The software version of the storage servers (cells) in the Exadata infrastructure.
        :param pulumi.Input[str] time_created: The date and time the Exadata infrastructure was created.
        :param pulumi.Input[str] time_zone: The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExadataInfrastructureComputeState.__new__(_ExadataInfrastructureComputeState)

        __props__.__dict__["activated_storage_count"] = activated_storage_count
        __props__.__dict__["activation_file"] = activation_file
        __props__.__dict__["additional_compute_count"] = additional_compute_count
        __props__.__dict__["additional_compute_count_compute_managed_resource"] = additional_compute_count_compute_managed_resource
        __props__.__dict__["additional_compute_system_model"] = additional_compute_system_model
        __props__.__dict__["additional_compute_system_model_compute_managed_resource"] = additional_compute_system_model_compute_managed_resource
        __props__.__dict__["additional_storage_count"] = additional_storage_count
        __props__.__dict__["admin_network_cidr"] = admin_network_cidr
        __props__.__dict__["cloud_control_plane_server1"] = cloud_control_plane_server1
        __props__.__dict__["cloud_control_plane_server2"] = cloud_control_plane_server2
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_count"] = compute_count
        __props__.__dict__["contacts"] = contacts
        __props__.__dict__["corporate_proxy"] = corporate_proxy
        __props__.__dict__["cpus_enabled"] = cpus_enabled
        __props__.__dict__["create_async"] = create_async
        __props__.__dict__["csi_number"] = csi_number
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
        __props__.__dict__["db_server_version"] = db_server_version
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dns_servers"] = dns_servers
        __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["gateway"] = gateway
        __props__.__dict__["infini_band_network_cidr"] = infini_band_network_cidr
        __props__.__dict__["is_cps_offline_report_enabled"] = is_cps_offline_report_enabled
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["maintenance_slo_status"] = maintenance_slo_status
        __props__.__dict__["maintenance_windows"] = maintenance_windows
        __props__.__dict__["max_cpu_count"] = max_cpu_count
        __props__.__dict__["max_data_storage_in_tbs"] = max_data_storage_in_tbs
        __props__.__dict__["max_db_node_storage_in_gbs"] = max_db_node_storage_in_gbs
        __props__.__dict__["max_memory_in_gbs"] = max_memory_in_gbs
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["monthly_db_server_version"] = monthly_db_server_version
        __props__.__dict__["netmask"] = netmask
        __props__.__dict__["ntp_servers"] = ntp_servers
        __props__.__dict__["shape"] = shape
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_count"] = storage_count
        __props__.__dict__["storage_server_version"] = storage_server_version
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_zone"] = time_zone
        return ExadataInfrastructureCompute(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> pulumi.Output[int]:
        """
        The requested number of additional storage servers activated for the Exadata infrastructure.
        """
        return pulumi.get(self, "activated_storage_count")

    @property
    @pulumi.getter(name="activationFile")
    def activation_file(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "activation_file")

    @property
    @pulumi.getter(name="additionalComputeCount")
    def additional_compute_count(self) -> pulumi.Output[int]:
        """
        The number of additional compute servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_compute_count")

    @property
    @pulumi.getter(name="additionalComputeCountComputeManagedResource")
    def additional_compute_count_compute_managed_resource(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "additional_compute_count_compute_managed_resource")

    @property
    @pulumi.getter(name="additionalComputeSystemModel")
    def additional_compute_system_model(self) -> pulumi.Output[str]:
        """
        Oracle Exadata System Model specification. The system model determines the amount of compute or storage server resources available for use. For more information, please see [System and Shape Configuration Options] (https://docs.oracle.com/en/engineered-systems/exadata-cloud-at-customer/ecccm/ecc-system-config-options.html#GUID-9E090174-5C57-4EB1-9243-B470F9F10D6B)
        """
        return pulumi.get(self, "additional_compute_system_model")

    @property
    @pulumi.getter(name="additionalComputeSystemModelComputeManagedResource")
    def additional_compute_system_model_compute_managed_resource(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "additional_compute_system_model_compute_managed_resource")

    @property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> pulumi.Output[int]:
        """
        The requested number of additional storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_storage_count")

    @property
    @pulumi.getter(name="adminNetworkCidr")
    def admin_network_cidr(self) -> pulumi.Output[str]:
        """
        The CIDR block for the Exadata administration network.
        """
        return pulumi.get(self, "admin_network_cidr")

    @property
    @pulumi.getter(name="cloudControlPlaneServer1")
    def cloud_control_plane_server1(self) -> pulumi.Output[str]:
        """
        The IP address for the first control plane server.
        """
        return pulumi.get(self, "cloud_control_plane_server1")

    @property
    @pulumi.getter(name="cloudControlPlaneServer2")
    def cloud_control_plane_server2(self) -> pulumi.Output[str]:
        """
        The IP address for the second control plane server.
        """
        return pulumi.get(self, "cloud_control_plane_server2")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Output[int]:
        """
        The number of compute servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "compute_count")

    @property
    @pulumi.getter
    def contacts(self) -> pulumi.Output[Sequence['outputs.ExadataInfrastructureComputeContact']]:
        """
        The list of contacts for the Exadata infrastructure.
        """
        return pulumi.get(self, "contacts")

    @property
    @pulumi.getter(name="corporateProxy")
    def corporate_proxy(self) -> pulumi.Output[str]:
        """
        The corporate network proxy for access to the control plane network.
        """
        return pulumi.get(self, "corporate_proxy")

    @property
    @pulumi.getter(name="cpusEnabled")
    def cpus_enabled(self) -> pulumi.Output[int]:
        """
        The number of enabled CPU cores.
        """
        return pulumi.get(self, "cpus_enabled")

    @property
    @pulumi.getter(name="createAsync")
    def create_async(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "create_async")

    @property
    @pulumi.getter(name="csiNumber")
    def csi_number(self) -> pulumi.Output[str]:
        """
        The CSI Number of the Exadata infrastructure.
        """
        return pulumi.get(self, "csi_number")

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[float]:
        """
        Size, in terabytes, of the DATA disk group.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="dbServerVersion")
    def db_server_version(self) -> pulumi.Output[str]:
        """
        The software version of the database servers (dom0) in the Exadata infrastructure.
        """
        return pulumi.get(self, "db_server_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The user-friendly name for the Exadata Cloud@Customer infrastructure. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of DNS server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> pulumi.Output[str]:
        """
        The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Output[str]:
        """
        The gateway for the control plane network.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="infiniBandNetworkCidr")
    def infini_band_network_cidr(self) -> pulumi.Output[str]:
        """
        The CIDR block for the Exadata InfiniBand interconnect.
        """
        return pulumi.get(self, "infini_band_network_cidr")

    @property
    @pulumi.getter(name="isCpsOfflineReportEnabled")
    def is_cps_offline_report_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates whether cps offline diagnostic report is enabled for this Exadata infrastructure. This will allow a customer to quickly check status themselves and fix problems on their end, saving time and frustration for both Oracle and the customer when they find the CPS in a disconnected state.You can enable offline diagnostic report during Exadata infrastructure provisioning. You can also disable or enable it at any time using the UpdateExadatainfrastructure API.
        """
        return pulumi.get(self, "is_cps_offline_report_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceSloStatus")
    def maintenance_slo_status(self) -> pulumi.Output[str]:
        """
        A field to capture ‘Maintenance SLO Status’ for the Exadata infrastructure with values ‘OK’, ‘DEGRADED’. Default is ‘OK’ when the infrastructure is provisioned.
        """
        return pulumi.get(self, "maintenance_slo_status")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> pulumi.Output[Sequence['outputs.ExadataInfrastructureComputeMaintenanceWindow']]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> pulumi.Output[int]:
        """
        The total number of CPU cores available.
        """
        return pulumi.get(self, "max_cpu_count")

    @property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> pulumi.Output[float]:
        """
        The total available DATA disk group size.
        """
        return pulumi.get(self, "max_data_storage_in_tbs")

    @property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> pulumi.Output[int]:
        """
        The total local node storage available in GBs.
        """
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> pulumi.Output[int]:
        """
        The total memory available in GBs.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter(name="monthlyDbServerVersion")
    def monthly_db_server_version(self) -> pulumi.Output[str]:
        """
        The monthly software version of the database servers (dom0) in the Exadata infrastructure.
        """
        return pulumi.get(self, "monthly_db_server_version")

    @property
    @pulumi.getter
    def netmask(self) -> pulumi.Output[str]:
        """
        The netmask for the control plane network.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="ntpServers")
    def ntp_servers(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of NTP server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "ntp_servers")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[str]:
        """
        The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the Exadata infrastructure.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> pulumi.Output[int]:
        """
        The number of Exadata storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_count")

    @property
    @pulumi.getter(name="storageServerVersion")
    def storage_server_version(self) -> pulumi.Output[str]:
        """
        The software version of the storage servers (cells) in the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_server_version")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the Exadata infrastructure was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

