# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalExadataInfrastructureArgs', 'ExternalExadataInfrastructure']

@pulumi.input_type
class ExternalExadataInfrastructureArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 db_system_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 display_name: pulumi.Input[str],
                 discovery_key: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 storage_server_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ExternalExadataInfrastructure resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_system_ids: (Updatable) The list of DB systems in the Exadata infrastructure.
        :param pulumi.Input[str] display_name: (Updatable) The name of the Exadata infrastructure.
        :param pulumi.Input[str] discovery_key: (Updatable) The unique key of the discovery request.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the database management resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] storage_server_names: (Updatable) The list of all the Exadata storage server names to be included for monitoring purposes. If not specified, all the Exadata storage servers associated with the DB systems are included.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ExternalExadataInfrastructureArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            db_system_ids=db_system_ids,
            display_name=display_name,
            discovery_key=discovery_key,
            license_model=license_model,
            storage_server_names=storage_server_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             db_system_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
             display_name: pulumi.Input[str],
             discovery_key: Optional[pulumi.Input[str]] = None,
             license_model: Optional[pulumi.Input[str]] = None,
             storage_server_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("db_system_ids", db_system_ids)
        _setter("display_name", display_name)
        if discovery_key is not None:
            _setter("discovery_key", discovery_key)
        if license_model is not None:
            _setter("license_model", license_model)
        if storage_server_names is not None:
            _setter("storage_server_names", storage_server_names)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dbSystemIds")
    def db_system_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) The list of DB systems in the Exadata infrastructure.
        """
        return pulumi.get(self, "db_system_ids")

    @db_system_ids.setter
    def db_system_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "db_system_ids", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The name of the Exadata infrastructure.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="discoveryKey")
    def discovery_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The unique key of the discovery request.
        """
        return pulumi.get(self, "discovery_key")

    @discovery_key.setter
    def discovery_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_key", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle license model that applies to the database management resources.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="storageServerNames")
    def storage_server_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The list of all the Exadata storage server names to be included for monitoring purposes. If not specified, all the Exadata storage servers associated with the DB systems are included.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "storage_server_names")

    @storage_server_names.setter
    def storage_server_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "storage_server_names", value)


@pulumi.input_type
class _ExternalExadataInfrastructureState:
    def __init__(__self__, *,
                 additional_details: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 database_compartments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 database_systems: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalExadataInfrastructureDatabaseSystemArgs']]]] = None,
                 db_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 discovery_key: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 internal_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 rack_size: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_grids: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalExadataInfrastructureStorageGridArgs']]]] = None,
                 storage_server_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExternalExadataInfrastructure resources.
        :param pulumi.Input[Mapping[str, Any]] additional_details: The additional details of the resource defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] database_compartments: The list of [OCIDs] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartments.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalExadataInfrastructureDatabaseSystemArgs']]] database_systems: A list of DB systems.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_system_ids: (Updatable) The list of DB systems in the Exadata infrastructure.
        :param pulumi.Input[str] discovery_key: (Updatable) The unique key of the discovery request.
        :param pulumi.Input[str] display_name: (Updatable) The name of the Exadata infrastructure.
        :param pulumi.Input[str] internal_id: The internal ID of the Exadata resource.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the database management resources.
        :param pulumi.Input[str] lifecycle_details: The details of the lifecycle state of the Exadata resource.
        :param pulumi.Input[str] rack_size: The rack size of the Exadata infrastructure.
        :param pulumi.Input[str] state: The current lifecycle state of the database resource.
        :param pulumi.Input[str] status: The status of the Exadata resource.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalExadataInfrastructureStorageGridArgs']]] storage_grids: The Exadata storage server grid of the Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] storage_server_names: (Updatable) The list of all the Exadata storage server names to be included for monitoring purposes. If not specified, all the Exadata storage servers associated with the DB systems are included.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The timestamp of the creation of the Exadata resource.
        :param pulumi.Input[str] time_updated: The timestamp of the last update of the Exadata resource.
        :param pulumi.Input[str] version: The version of the Exadata resource.
        """
        _ExternalExadataInfrastructureState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            additional_details=additional_details,
            compartment_id=compartment_id,
            database_compartments=database_compartments,
            database_systems=database_systems,
            db_system_ids=db_system_ids,
            discovery_key=discovery_key,
            display_name=display_name,
            internal_id=internal_id,
            license_model=license_model,
            lifecycle_details=lifecycle_details,
            rack_size=rack_size,
            state=state,
            status=status,
            storage_grids=storage_grids,
            storage_server_names=storage_server_names,
            time_created=time_created,
            time_updated=time_updated,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             additional_details: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             database_compartments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             database_systems: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalExadataInfrastructureDatabaseSystemArgs']]]] = None,
             db_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             discovery_key: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             internal_id: Optional[pulumi.Input[str]] = None,
             license_model: Optional[pulumi.Input[str]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             rack_size: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             status: Optional[pulumi.Input[str]] = None,
             storage_grids: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalExadataInfrastructureStorageGridArgs']]]] = None,
             storage_server_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             version: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if additional_details is not None:
            _setter("additional_details", additional_details)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if database_compartments is not None:
            _setter("database_compartments", database_compartments)
        if database_systems is not None:
            _setter("database_systems", database_systems)
        if db_system_ids is not None:
            _setter("db_system_ids", db_system_ids)
        if discovery_key is not None:
            _setter("discovery_key", discovery_key)
        if display_name is not None:
            _setter("display_name", display_name)
        if internal_id is not None:
            _setter("internal_id", internal_id)
        if license_model is not None:
            _setter("license_model", license_model)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if rack_size is not None:
            _setter("rack_size", rack_size)
        if state is not None:
            _setter("state", state)
        if status is not None:
            _setter("status", status)
        if storage_grids is not None:
            _setter("storage_grids", storage_grids)
        if storage_server_names is not None:
            _setter("storage_server_names", storage_server_names)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)
        if version is not None:
            _setter("version", version)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The additional details of the resource defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @additional_details.setter
    def additional_details(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "additional_details", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="databaseCompartments")
    def database_compartments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of [OCIDs] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartments.
        """
        return pulumi.get(self, "database_compartments")

    @database_compartments.setter
    def database_compartments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "database_compartments", value)

    @property
    @pulumi.getter(name="databaseSystems")
    def database_systems(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalExadataInfrastructureDatabaseSystemArgs']]]]:
        """
        A list of DB systems.
        """
        return pulumi.get(self, "database_systems")

    @database_systems.setter
    def database_systems(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalExadataInfrastructureDatabaseSystemArgs']]]]):
        pulumi.set(self, "database_systems", value)

    @property
    @pulumi.getter(name="dbSystemIds")
    def db_system_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The list of DB systems in the Exadata infrastructure.
        """
        return pulumi.get(self, "db_system_ids")

    @db_system_ids.setter
    def db_system_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "db_system_ids", value)

    @property
    @pulumi.getter(name="discoveryKey")
    def discovery_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The unique key of the discovery request.
        """
        return pulumi.get(self, "discovery_key")

    @discovery_key.setter
    def discovery_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_key", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the Exadata infrastructure.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="internalId")
    def internal_id(self) -> Optional[pulumi.Input[str]]:
        """
        The internal ID of the Exadata resource.
        """
        return pulumi.get(self, "internal_id")

    @internal_id.setter
    def internal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internal_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle license model that applies to the database management resources.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        The details of the lifecycle state of the Exadata resource.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="rackSize")
    def rack_size(self) -> Optional[pulumi.Input[str]]:
        """
        The rack size of the Exadata infrastructure.
        """
        return pulumi.get(self, "rack_size")

    @rack_size.setter
    def rack_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rack_size", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the database resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Exadata resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storageGrids")
    def storage_grids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalExadataInfrastructureStorageGridArgs']]]]:
        """
        The Exadata storage server grid of the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_grids")

    @storage_grids.setter
    def storage_grids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalExadataInfrastructureStorageGridArgs']]]]):
        pulumi.set(self, "storage_grids", value)

    @property
    @pulumi.getter(name="storageServerNames")
    def storage_server_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The list of all the Exadata storage server names to be included for monitoring purposes. If not specified, all the Exadata storage servers associated with the DB systems are included.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "storage_server_names")

    @storage_server_names.setter
    def storage_server_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "storage_server_names", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of the creation of the Exadata resource.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of the last update of the Exadata resource.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the Exadata resource.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class ExternalExadataInfrastructure(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 db_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 discovery_key: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 storage_server_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource provides the External Exadata Infrastructure resource in Oracle Cloud Infrastructure Database Management service.

        Creates an Oracle Cloud Infrastructure resource for the Exadata infrastructure and enables the Monitoring service for the Exadata infrastructure.
        The following resource/subresources are created:
          Infrastructure
          Storage server connectors
          Storage servers
          Storage grids

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_exadata_infrastructure = oci.database_management.ExternalExadataInfrastructure("testExternalExadataInfrastructure",
            compartment_id=var["compartment_id"],
            db_system_ids=var["external_exadata_infrastructure_db_system_ids"],
            display_name=var["external_exadata_infrastructure_display_name"],
            discovery_key=var["external_exadata_infrastructure_discovery_key"],
            license_model=var["external_exadata_infrastructure_license_model"],
            storage_server_names=var["external_exadata_infrastructure_storage_server_names"])
        ```

        ## Import

        ExternalExadataInfrastructures can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DatabaseManagement/externalExadataInfrastructure:ExternalExadataInfrastructure test_external_exadata_infrastructure "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_system_ids: (Updatable) The list of DB systems in the Exadata infrastructure.
        :param pulumi.Input[str] discovery_key: (Updatable) The unique key of the discovery request.
        :param pulumi.Input[str] display_name: (Updatable) The name of the Exadata infrastructure.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the database management resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] storage_server_names: (Updatable) The list of all the Exadata storage server names to be included for monitoring purposes. If not specified, all the Exadata storage servers associated with the DB systems are included.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalExadataInfrastructureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the External Exadata Infrastructure resource in Oracle Cloud Infrastructure Database Management service.

        Creates an Oracle Cloud Infrastructure resource for the Exadata infrastructure and enables the Monitoring service for the Exadata infrastructure.
        The following resource/subresources are created:
          Infrastructure
          Storage server connectors
          Storage servers
          Storage grids

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_exadata_infrastructure = oci.database_management.ExternalExadataInfrastructure("testExternalExadataInfrastructure",
            compartment_id=var["compartment_id"],
            db_system_ids=var["external_exadata_infrastructure_db_system_ids"],
            display_name=var["external_exadata_infrastructure_display_name"],
            discovery_key=var["external_exadata_infrastructure_discovery_key"],
            license_model=var["external_exadata_infrastructure_license_model"],
            storage_server_names=var["external_exadata_infrastructure_storage_server_names"])
        ```

        ## Import

        ExternalExadataInfrastructures can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DatabaseManagement/externalExadataInfrastructure:ExternalExadataInfrastructure test_external_exadata_infrastructure "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExternalExadataInfrastructureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalExadataInfrastructureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ExternalExadataInfrastructureArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 db_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 discovery_key: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 storage_server_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalExadataInfrastructureArgs.__new__(ExternalExadataInfrastructureArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if db_system_ids is None and not opts.urn:
                raise TypeError("Missing required property 'db_system_ids'")
            __props__.__dict__["db_system_ids"] = db_system_ids
            __props__.__dict__["discovery_key"] = discovery_key
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["storage_server_names"] = storage_server_names
            __props__.__dict__["additional_details"] = None
            __props__.__dict__["database_compartments"] = None
            __props__.__dict__["database_systems"] = None
            __props__.__dict__["internal_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["rack_size"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["storage_grids"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["version"] = None
        super(ExternalExadataInfrastructure, __self__).__init__(
            'oci:DatabaseManagement/externalExadataInfrastructure:ExternalExadataInfrastructure',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_details: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            database_compartments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            database_systems: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalExadataInfrastructureDatabaseSystemArgs']]]]] = None,
            db_system_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            discovery_key: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            internal_id: Optional[pulumi.Input[str]] = None,
            license_model: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            rack_size: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            storage_grids: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalExadataInfrastructureStorageGridArgs']]]]] = None,
            storage_server_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'ExternalExadataInfrastructure':
        """
        Get an existing ExternalExadataInfrastructure resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] additional_details: The additional details of the resource defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] database_compartments: The list of [OCIDs] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartments.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalExadataInfrastructureDatabaseSystemArgs']]]] database_systems: A list of DB systems.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_system_ids: (Updatable) The list of DB systems in the Exadata infrastructure.
        :param pulumi.Input[str] discovery_key: (Updatable) The unique key of the discovery request.
        :param pulumi.Input[str] display_name: (Updatable) The name of the Exadata infrastructure.
        :param pulumi.Input[str] internal_id: The internal ID of the Exadata resource.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the database management resources.
        :param pulumi.Input[str] lifecycle_details: The details of the lifecycle state of the Exadata resource.
        :param pulumi.Input[str] rack_size: The rack size of the Exadata infrastructure.
        :param pulumi.Input[str] state: The current lifecycle state of the database resource.
        :param pulumi.Input[str] status: The status of the Exadata resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalExadataInfrastructureStorageGridArgs']]]] storage_grids: The Exadata storage server grid of the Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] storage_server_names: (Updatable) The list of all the Exadata storage server names to be included for monitoring purposes. If not specified, all the Exadata storage servers associated with the DB systems are included.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The timestamp of the creation of the Exadata resource.
        :param pulumi.Input[str] time_updated: The timestamp of the last update of the Exadata resource.
        :param pulumi.Input[str] version: The version of the Exadata resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalExadataInfrastructureState.__new__(_ExternalExadataInfrastructureState)

        __props__.__dict__["additional_details"] = additional_details
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["database_compartments"] = database_compartments
        __props__.__dict__["database_systems"] = database_systems
        __props__.__dict__["db_system_ids"] = db_system_ids
        __props__.__dict__["discovery_key"] = discovery_key
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["internal_id"] = internal_id
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["rack_size"] = rack_size
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_grids"] = storage_grids
        __props__.__dict__["storage_server_names"] = storage_server_names
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["version"] = version
        return ExternalExadataInfrastructure(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The additional details of the resource defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseCompartments")
    def database_compartments(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of [OCIDs] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartments.
        """
        return pulumi.get(self, "database_compartments")

    @property
    @pulumi.getter(name="databaseSystems")
    def database_systems(self) -> pulumi.Output[Sequence['outputs.ExternalExadataInfrastructureDatabaseSystem']]:
        """
        A list of DB systems.
        """
        return pulumi.get(self, "database_systems")

    @property
    @pulumi.getter(name="dbSystemIds")
    def db_system_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The list of DB systems in the Exadata infrastructure.
        """
        return pulumi.get(self, "db_system_ids")

    @property
    @pulumi.getter(name="discoveryKey")
    def discovery_key(self) -> pulumi.Output[str]:
        """
        (Updatable) The unique key of the discovery request.
        """
        return pulumi.get(self, "discovery_key")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The name of the Exadata infrastructure.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="internalId")
    def internal_id(self) -> pulumi.Output[str]:
        """
        The internal ID of the Exadata resource.
        """
        return pulumi.get(self, "internal_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[str]:
        """
        (Updatable) The Oracle license model that applies to the database management resources.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        The details of the lifecycle state of the Exadata resource.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="rackSize")
    def rack_size(self) -> pulumi.Output[str]:
        """
        The rack size of the Exadata infrastructure.
        """
        return pulumi.get(self, "rack_size")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the database resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Exadata resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageGrids")
    def storage_grids(self) -> pulumi.Output[Sequence['outputs.ExternalExadataInfrastructureStorageGrid']]:
        """
        The Exadata storage server grid of the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_grids")

    @property
    @pulumi.getter(name="storageServerNames")
    def storage_server_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) The list of all the Exadata storage server names to be included for monitoring purposes. If not specified, all the Exadata storage servers associated with the DB systems are included.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "storage_server_names")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The timestamp of the creation of the Exadata resource.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The timestamp of the last update of the Exadata resource.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The version of the Exadata resource.
        """
        return pulumi.get(self, "version")

