# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedDatabaseUserDataAccessContainersResult',
    'AwaitableGetManagedDatabaseUserDataAccessContainersResult',
    'get_managed_database_user_data_access_containers',
    'get_managed_database_user_data_access_containers_output',
]

@pulumi.output_type
class GetManagedDatabaseUserDataAccessContainersResult:
    """
    A collection of values returned by getManagedDatabaseUserDataAccessContainers.
    """
    def __init__(__self__, data_access_container_collections=None, filters=None, id=None, managed_database_id=None, name=None, user_name=None):
        if data_access_container_collections and not isinstance(data_access_container_collections, list):
            raise TypeError("Expected argument 'data_access_container_collections' to be a list")
        pulumi.set(__self__, "data_access_container_collections", data_access_container_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="dataAccessContainerCollections")
    def data_access_container_collections(self) -> Sequence['outputs.GetManagedDatabaseUserDataAccessContainersDataAccessContainerCollectionResult']:
        """
        The list of data_access_container_collection.
        """
        return pulumi.get(self, "data_access_container_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedDatabaseUserDataAccessContainersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the container included in the attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        return pulumi.get(self, "user_name")


class AwaitableGetManagedDatabaseUserDataAccessContainersResult(GetManagedDatabaseUserDataAccessContainersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseUserDataAccessContainersResult(
            data_access_container_collections=self.data_access_container_collections,
            filters=self.filters,
            id=self.id,
            managed_database_id=self.managed_database_id,
            name=self.name,
            user_name=self.user_name)


def get_managed_database_user_data_access_containers(filters: Optional[Sequence[pulumi.InputType['GetManagedDatabaseUserDataAccessContainersFilterArgs']]] = None,
                                                     managed_database_id: Optional[str] = None,
                                                     name: Optional[str] = None,
                                                     user_name: Optional[str] = None,
                                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseUserDataAccessContainersResult:
    """
    This data source provides the list of Managed Database User Data Access Containers in Oracle Cloud Infrastructure Database Management service.

    Gets the list of containers for a specific user. This is only applicable if ALL_CONTAINERS !='Y'.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_user_data_access_containers = oci.DatabaseManagement.get_managed_database_user_data_access_containers(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        user_name=oci_identity_user["test_user"]["name"],
        name=var["managed_database_user_data_access_container_name"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: A filter to return only resources that match the entire name.
    :param str user_name: The name of the user whose details are to be viewed.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['managedDatabaseId'] = managed_database_id
    __args__['name'] = name
    __args__['userName'] = user_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseUserDataAccessContainers:getManagedDatabaseUserDataAccessContainers', __args__, opts=opts, typ=GetManagedDatabaseUserDataAccessContainersResult).value

    return AwaitableGetManagedDatabaseUserDataAccessContainersResult(
        data_access_container_collections=pulumi.get(__ret__, 'data_access_container_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        name=pulumi.get(__ret__, 'name'),
        user_name=pulumi.get(__ret__, 'user_name'))


@_utilities.lift_output_func(get_managed_database_user_data_access_containers)
def get_managed_database_user_data_access_containers_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagedDatabaseUserDataAccessContainersFilterArgs']]]]] = None,
                                                            managed_database_id: Optional[pulumi.Input[str]] = None,
                                                            name: Optional[pulumi.Input[Optional[str]]] = None,
                                                            user_name: Optional[pulumi.Input[str]] = None,
                                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseUserDataAccessContainersResult]:
    """
    This data source provides the list of Managed Database User Data Access Containers in Oracle Cloud Infrastructure Database Management service.

    Gets the list of containers for a specific user. This is only applicable if ALL_CONTAINERS !='Y'.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_user_data_access_containers = oci.DatabaseManagement.get_managed_database_user_data_access_containers(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        user_name=oci_identity_user["test_user"]["name"],
        name=var["managed_database_user_data_access_container_name"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str name: A filter to return only resources that match the entire name.
    :param str user_name: The name of the user whose details are to be viewed.
    """
    ...
