# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RepositoryArgs', 'Repository']

@pulumi.input_type
class RepositoryArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[str],
                 repository_type: pulumi.Input[str],
                 default_branch: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 mirror_repository_config: Optional[pulumi.Input['RepositoryMirrorRepositoryConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Repository resource.
        :param pulumi.Input[str] project_id: The OCID of the DevOps project containing the repository.
        :param pulumi.Input[str] repository_type: (Updatable) Type of repository. Allowed values:  `MIRRORED`  `HOSTED` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] default_branch: (Updatable) The default branch of the repository.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Details of the repository. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input['RepositoryMirrorRepositoryConfigArgs'] mirror_repository_config: (Updatable) Configuration information for mirroring the repository.
        :param pulumi.Input[str] name: (Updatable) Unique name of a repository.
        """
        RepositoryArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            project_id=project_id,
            repository_type=repository_type,
            default_branch=default_branch,
            defined_tags=defined_tags,
            description=description,
            freeform_tags=freeform_tags,
            mirror_repository_config=mirror_repository_config,
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             project_id: pulumi.Input[str],
             repository_type: pulumi.Input[str],
             default_branch: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             mirror_repository_config: Optional[pulumi.Input['RepositoryMirrorRepositoryConfigArgs']] = None,
             name: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("project_id", project_id)
        _setter("repository_type", repository_type)
        if default_branch is not None:
            _setter("default_branch", default_branch)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if mirror_repository_config is not None:
            _setter("mirror_repository_config", mirror_repository_config)
        if name is not None:
            _setter("name", name)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The OCID of the DevOps project containing the repository.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="repositoryType")
    def repository_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of repository. Allowed values:  `MIRRORED`  `HOSTED` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repository_type")

    @repository_type.setter
    def repository_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_type", value)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The default branch of the repository.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_branch", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Details of the repository. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="mirrorRepositoryConfig")
    def mirror_repository_config(self) -> Optional[pulumi.Input['RepositoryMirrorRepositoryConfigArgs']]:
        """
        (Updatable) Configuration information for mirroring the repository.
        """
        return pulumi.get(self, "mirror_repository_config")

    @mirror_repository_config.setter
    def mirror_repository_config(self, value: Optional[pulumi.Input['RepositoryMirrorRepositoryConfigArgs']]):
        pulumi.set(self, "mirror_repository_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique name of a repository.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RepositoryState:
    def __init__(__self__, *,
                 branch_count: Optional[pulumi.Input[int]] = None,
                 commit_count: Optional[pulumi.Input[int]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 http_url: Optional[pulumi.Input[str]] = None,
                 lifecyle_details: Optional[pulumi.Input[str]] = None,
                 mirror_repository_config: Optional[pulumi.Input['RepositoryMirrorRepositoryConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 repository_type: Optional[pulumi.Input[str]] = None,
                 size_in_bytes: Optional[pulumi.Input[str]] = None,
                 ssh_url: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 trigger_build_events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Repository resources.
        :param pulumi.Input[int] branch_count: The count of the branches present in the repository.
        :param pulumi.Input[int] commit_count: The count of the commits present in the repository.
        :param pulumi.Input[str] compartment_id: The OCID of the repository's compartment.
        :param pulumi.Input[str] default_branch: (Updatable) The default branch of the repository.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Details of the repository. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] http_url: HTTP URL that you use to git clone, pull and push.
        :param pulumi.Input[str] lifecyle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input['RepositoryMirrorRepositoryConfigArgs'] mirror_repository_config: (Updatable) Configuration information for mirroring the repository.
        :param pulumi.Input[str] name: (Updatable) Unique name of a repository.
        :param pulumi.Input[str] namespace: Tenancy unique namespace.
        :param pulumi.Input[str] project_id: The OCID of the DevOps project containing the repository.
        :param pulumi.Input[str] project_name: Unique project name in a namespace.
        :param pulumi.Input[str] repository_type: (Updatable) Type of repository. Allowed values:  `MIRRORED`  `HOSTED` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] size_in_bytes: The size of the repository in bytes.
        :param pulumi.Input[str] ssh_url: SSH URL that you use to git clone, pull and push.
        :param pulumi.Input[str] state: The current state of the repository.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the repository was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[str] time_updated: The time the repository was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trigger_build_events: Trigger build events supported for this repository: PUSH - Build is triggered when a push event occurs. COMMIT_UPDATES - Build is triggered when new commits are mirrored into a repository.
        """
        _RepositoryState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            branch_count=branch_count,
            commit_count=commit_count,
            compartment_id=compartment_id,
            default_branch=default_branch,
            defined_tags=defined_tags,
            description=description,
            freeform_tags=freeform_tags,
            http_url=http_url,
            lifecyle_details=lifecyle_details,
            mirror_repository_config=mirror_repository_config,
            name=name,
            namespace=namespace,
            project_id=project_id,
            project_name=project_name,
            repository_type=repository_type,
            size_in_bytes=size_in_bytes,
            ssh_url=ssh_url,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
            trigger_build_events=trigger_build_events,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             branch_count: Optional[pulumi.Input[int]] = None,
             commit_count: Optional[pulumi.Input[int]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             default_branch: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             http_url: Optional[pulumi.Input[str]] = None,
             lifecyle_details: Optional[pulumi.Input[str]] = None,
             mirror_repository_config: Optional[pulumi.Input['RepositoryMirrorRepositoryConfigArgs']] = None,
             name: Optional[pulumi.Input[str]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             project_id: Optional[pulumi.Input[str]] = None,
             project_name: Optional[pulumi.Input[str]] = None,
             repository_type: Optional[pulumi.Input[str]] = None,
             size_in_bytes: Optional[pulumi.Input[str]] = None,
             ssh_url: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             trigger_build_events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if branch_count is not None:
            _setter("branch_count", branch_count)
        if commit_count is not None:
            _setter("commit_count", commit_count)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if default_branch is not None:
            _setter("default_branch", default_branch)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if http_url is not None:
            _setter("http_url", http_url)
        if lifecyle_details is not None:
            _setter("lifecyle_details", lifecyle_details)
        if mirror_repository_config is not None:
            _setter("mirror_repository_config", mirror_repository_config)
        if name is not None:
            _setter("name", name)
        if namespace is not None:
            _setter("namespace", namespace)
        if project_id is not None:
            _setter("project_id", project_id)
        if project_name is not None:
            _setter("project_name", project_name)
        if repository_type is not None:
            _setter("repository_type", repository_type)
        if size_in_bytes is not None:
            _setter("size_in_bytes", size_in_bytes)
        if ssh_url is not None:
            _setter("ssh_url", ssh_url)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)
        if trigger_build_events is not None:
            _setter("trigger_build_events", trigger_build_events)

    @property
    @pulumi.getter(name="branchCount")
    def branch_count(self) -> Optional[pulumi.Input[int]]:
        """
        The count of the branches present in the repository.
        """
        return pulumi.get(self, "branch_count")

    @branch_count.setter
    def branch_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "branch_count", value)

    @property
    @pulumi.getter(name="commitCount")
    def commit_count(self) -> Optional[pulumi.Input[int]]:
        """
        The count of the commits present in the repository.
        """
        return pulumi.get(self, "commit_count")

    @commit_count.setter
    def commit_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "commit_count", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the repository's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The default branch of the repository.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_branch", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Details of the repository. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="httpUrl")
    def http_url(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP URL that you use to git clone, pull and push.
        """
        return pulumi.get(self, "http_url")

    @http_url.setter
    def http_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_url", value)

    @property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecyle_details")

    @lifecyle_details.setter
    def lifecyle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecyle_details", value)

    @property
    @pulumi.getter(name="mirrorRepositoryConfig")
    def mirror_repository_config(self) -> Optional[pulumi.Input['RepositoryMirrorRepositoryConfigArgs']]:
        """
        (Updatable) Configuration information for mirroring the repository.
        """
        return pulumi.get(self, "mirror_repository_config")

    @mirror_repository_config.setter
    def mirror_repository_config(self, value: Optional[pulumi.Input['RepositoryMirrorRepositoryConfigArgs']]):
        pulumi.set(self, "mirror_repository_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique name of a repository.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Tenancy unique namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the DevOps project containing the repository.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique project name in a namespace.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="repositoryType")
    def repository_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of repository. Allowed values:  `MIRRORED`  `HOSTED` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repository_type")

    @repository_type.setter
    def repository_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_type", value)

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the repository in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @size_in_bytes.setter
    def size_in_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_in_bytes", value)

    @property
    @pulumi.getter(name="sshUrl")
    def ssh_url(self) -> Optional[pulumi.Input[str]]:
        """
        SSH URL that you use to git clone, pull and push.
        """
        return pulumi.get(self, "ssh_url")

    @ssh_url.setter
    def ssh_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_url", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the repository.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the repository was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the repository was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="triggerBuildEvents")
    def trigger_build_events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Trigger build events supported for this repository: PUSH - Build is triggered when a push event occurs. COMMIT_UPDATES - Build is triggered when new commits are mirrored into a repository.
        """
        return pulumi.get(self, "trigger_build_events")

    @trigger_build_events.setter
    def trigger_build_events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "trigger_build_events", value)


class Repository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 mirror_repository_config: Optional[pulumi.Input[pulumi.InputType['RepositoryMirrorRepositoryConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 repository_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Repository resource in Oracle Cloud Infrastructure Devops service.

        Creates a new repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_repository = oci.dev_ops.Repository("testRepository",
            project_id=oci_devops_project["test_project"]["id"],
            repository_type=var["repository_repository_type"],
            default_branch=var["repository_default_branch"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["repository_description"],
            freeform_tags={
                "bar-key": "value",
            },
            mirror_repository_config=oci.dev_ops.RepositoryMirrorRepositoryConfigArgs(
                connector_id=oci_devops_connector["test_connector"]["id"],
                repository_url=var["repository_mirror_repository_config_repository_url"],
                trigger_schedule=oci.dev_ops.RepositoryMirrorRepositoryConfigTriggerScheduleArgs(
                    schedule_type=var["repository_mirror_repository_config_trigger_schedule_schedule_type"],
                    custom_schedule=var["repository_mirror_repository_config_trigger_schedule_custom_schedule"],
                ),
            ))
        ```

        ## Import

        Repositories can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DevOps/repository:Repository test_repository "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_branch: (Updatable) The default branch of the repository.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Details of the repository. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[pulumi.InputType['RepositoryMirrorRepositoryConfigArgs']] mirror_repository_config: (Updatable) Configuration information for mirroring the repository.
        :param pulumi.Input[str] name: (Updatable) Unique name of a repository.
        :param pulumi.Input[str] project_id: The OCID of the DevOps project containing the repository.
        :param pulumi.Input[str] repository_type: (Updatable) Type of repository. Allowed values:  `MIRRORED`  `HOSTED` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Repository resource in Oracle Cloud Infrastructure Devops service.

        Creates a new repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_repository = oci.dev_ops.Repository("testRepository",
            project_id=oci_devops_project["test_project"]["id"],
            repository_type=var["repository_repository_type"],
            default_branch=var["repository_default_branch"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["repository_description"],
            freeform_tags={
                "bar-key": "value",
            },
            mirror_repository_config=oci.dev_ops.RepositoryMirrorRepositoryConfigArgs(
                connector_id=oci_devops_connector["test_connector"]["id"],
                repository_url=var["repository_mirror_repository_config_repository_url"],
                trigger_schedule=oci.dev_ops.RepositoryMirrorRepositoryConfigTriggerScheduleArgs(
                    schedule_type=var["repository_mirror_repository_config_trigger_schedule_schedule_type"],
                    custom_schedule=var["repository_mirror_repository_config_trigger_schedule_custom_schedule"],
                ),
            ))
        ```

        ## Import

        Repositories can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DevOps/repository:Repository test_repository "id"
        ```

        :param str resource_name: The name of the resource.
        :param RepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            RepositoryArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 mirror_repository_config: Optional[pulumi.Input[pulumi.InputType['RepositoryMirrorRepositoryConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 repository_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryArgs.__new__(RepositoryArgs)

            __props__.__dict__["default_branch"] = default_branch
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["freeform_tags"] = freeform_tags
            if mirror_repository_config is not None and not isinstance(mirror_repository_config, RepositoryMirrorRepositoryConfigArgs):
                mirror_repository_config = mirror_repository_config or {}
                def _setter(key, value):
                    mirror_repository_config[key] = value
                RepositoryMirrorRepositoryConfigArgs._configure(_setter, **mirror_repository_config)
            __props__.__dict__["mirror_repository_config"] = mirror_repository_config
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if repository_type is None and not opts.urn:
                raise TypeError("Missing required property 'repository_type'")
            __props__.__dict__["repository_type"] = repository_type
            __props__.__dict__["branch_count"] = None
            __props__.__dict__["commit_count"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["http_url"] = None
            __props__.__dict__["lifecyle_details"] = None
            __props__.__dict__["namespace"] = None
            __props__.__dict__["project_name"] = None
            __props__.__dict__["size_in_bytes"] = None
            __props__.__dict__["ssh_url"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["trigger_build_events"] = None
        super(Repository, __self__).__init__(
            'oci:DevOps/repository:Repository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            branch_count: Optional[pulumi.Input[int]] = None,
            commit_count: Optional[pulumi.Input[int]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            default_branch: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            http_url: Optional[pulumi.Input[str]] = None,
            lifecyle_details: Optional[pulumi.Input[str]] = None,
            mirror_repository_config: Optional[pulumi.Input[pulumi.InputType['RepositoryMirrorRepositoryConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            repository_type: Optional[pulumi.Input[str]] = None,
            size_in_bytes: Optional[pulumi.Input[str]] = None,
            ssh_url: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            trigger_build_events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Repository':
        """
        Get an existing Repository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] branch_count: The count of the branches present in the repository.
        :param pulumi.Input[int] commit_count: The count of the commits present in the repository.
        :param pulumi.Input[str] compartment_id: The OCID of the repository's compartment.
        :param pulumi.Input[str] default_branch: (Updatable) The default branch of the repository.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Details of the repository. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] http_url: HTTP URL that you use to git clone, pull and push.
        :param pulumi.Input[str] lifecyle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[pulumi.InputType['RepositoryMirrorRepositoryConfigArgs']] mirror_repository_config: (Updatable) Configuration information for mirroring the repository.
        :param pulumi.Input[str] name: (Updatable) Unique name of a repository.
        :param pulumi.Input[str] namespace: Tenancy unique namespace.
        :param pulumi.Input[str] project_id: The OCID of the DevOps project containing the repository.
        :param pulumi.Input[str] project_name: Unique project name in a namespace.
        :param pulumi.Input[str] repository_type: (Updatable) Type of repository. Allowed values:  `MIRRORED`  `HOSTED` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] size_in_bytes: The size of the repository in bytes.
        :param pulumi.Input[str] ssh_url: SSH URL that you use to git clone, pull and push.
        :param pulumi.Input[str] state: The current state of the repository.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the repository was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[str] time_updated: The time the repository was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trigger_build_events: Trigger build events supported for this repository: PUSH - Build is triggered when a push event occurs. COMMIT_UPDATES - Build is triggered when new commits are mirrored into a repository.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryState.__new__(_RepositoryState)

        __props__.__dict__["branch_count"] = branch_count
        __props__.__dict__["commit_count"] = commit_count
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["default_branch"] = default_branch
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["http_url"] = http_url
        __props__.__dict__["lifecyle_details"] = lifecyle_details
        __props__.__dict__["mirror_repository_config"] = mirror_repository_config
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["repository_type"] = repository_type
        __props__.__dict__["size_in_bytes"] = size_in_bytes
        __props__.__dict__["ssh_url"] = ssh_url
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["trigger_build_events"] = trigger_build_events
        return Repository(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="branchCount")
    def branch_count(self) -> pulumi.Output[int]:
        """
        The count of the branches present in the repository.
        """
        return pulumi.get(self, "branch_count")

    @property
    @pulumi.getter(name="commitCount")
    def commit_count(self) -> pulumi.Output[int]:
        """
        The count of the commits present in the repository.
        """
        return pulumi.get(self, "commit_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the repository's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> pulumi.Output[str]:
        """
        (Updatable) The default branch of the repository.
        """
        return pulumi.get(self, "default_branch")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Details of the repository. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="httpUrl")
    def http_url(self) -> pulumi.Output[str]:
        """
        HTTP URL that you use to git clone, pull and push.
        """
        return pulumi.get(self, "http_url")

    @property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecyle_details")

    @property
    @pulumi.getter(name="mirrorRepositoryConfig")
    def mirror_repository_config(self) -> pulumi.Output['outputs.RepositoryMirrorRepositoryConfig']:
        """
        (Updatable) Configuration information for mirroring the repository.
        """
        return pulumi.get(self, "mirror_repository_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        (Updatable) Unique name of a repository.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        Tenancy unique namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The OCID of the DevOps project containing the repository.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        Unique project name in a namespace.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="repositoryType")
    def repository_type(self) -> pulumi.Output[str]:
        """
        (Updatable) Type of repository. Allowed values:  `MIRRORED`  `HOSTED` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repository_type")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> pulumi.Output[str]:
        """
        The size of the repository in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter(name="sshUrl")
    def ssh_url(self) -> pulumi.Output[str]:
        """
        SSH URL that you use to git clone, pull and push.
        """
        return pulumi.get(self, "ssh_url")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the repository.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the repository was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the repository was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="triggerBuildEvents")
    def trigger_build_events(self) -> pulumi.Output[Sequence[str]]:
        """
        Trigger build events supported for this repository: PUSH - Build is triggered when a push event occurs. COMMIT_UPDATES - Build is triggered when new commits are mirrored into a repository.
        """
        return pulumi.get(self, "trigger_build_events")

