# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DrPlanExecutionExecutionOptionsArgs',
    'DrPlanExecutionGroupExecutionArgs',
    'DrPlanExecutionGroupExecutionStepExecutionArgs',
    'DrPlanExecutionGroupExecutionStepExecutionLogLocationArgs',
    'DrPlanExecutionLogLocationArgs',
    'DrPlanPlanGroupArgs',
    'DrPlanPlanGroupStepArgs',
    'DrPlanPlanGroupStepUserDefinedStepArgs',
    'DrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocationArgs',
    'DrProtectionGroupAssociationArgs',
    'DrProtectionGroupLogLocationArgs',
    'DrProtectionGroupMemberArgs',
    'DrProtectionGroupMemberVnicMappingArgs',
    'GetDrPlanExecutionsFilterArgs',
    'GetDrPlansFilterArgs',
    'GetDrProtectionGroupsFilterArgs',
]

@pulumi.input_type
class DrPlanExecutionExecutionOptionsArgs:
    def __init__(__self__, *,
                 plan_execution_type: pulumi.Input[str],
                 are_prechecks_enabled: Optional[pulumi.Input[bool]] = None,
                 are_warnings_ignored: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] plan_execution_type: The type of the plan execution.
        :param pulumi.Input[bool] are_prechecks_enabled: A flag indicating whether prechecks should be executed before the plan execution.  Example: `false`
        :param pulumi.Input[bool] are_warnings_ignored: A flag indicating whether warnings should be ignored during the switchover precheck.  Example: `true`
        """
        DrPlanExecutionExecutionOptionsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            plan_execution_type=plan_execution_type,
            are_prechecks_enabled=are_prechecks_enabled,
            are_warnings_ignored=are_warnings_ignored,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             plan_execution_type: pulumi.Input[str],
             are_prechecks_enabled: Optional[pulumi.Input[bool]] = None,
             are_warnings_ignored: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("plan_execution_type", plan_execution_type)
        if are_prechecks_enabled is not None:
            _setter("are_prechecks_enabled", are_prechecks_enabled)
        if are_warnings_ignored is not None:
            _setter("are_warnings_ignored", are_warnings_ignored)

    @property
    @pulumi.getter(name="planExecutionType")
    def plan_execution_type(self) -> pulumi.Input[str]:
        """
        The type of the plan execution.
        """
        return pulumi.get(self, "plan_execution_type")

    @plan_execution_type.setter
    def plan_execution_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_execution_type", value)

    @property
    @pulumi.getter(name="arePrechecksEnabled")
    def are_prechecks_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether prechecks should be executed before the plan execution.  Example: `false`
        """
        return pulumi.get(self, "are_prechecks_enabled")

    @are_prechecks_enabled.setter
    def are_prechecks_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "are_prechecks_enabled", value)

    @property
    @pulumi.getter(name="areWarningsIgnored")
    def are_warnings_ignored(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether warnings should be ignored during the switchover precheck.  Example: `true`
        """
        return pulumi.get(self, "are_warnings_ignored")

    @are_warnings_ignored.setter
    def are_warnings_ignored(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "are_warnings_ignored", value)


@pulumi.input_type
class DrPlanExecutionGroupExecutionArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 execution_duration_in_sec: Optional[pulumi.Input[int]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 status_details: Optional[pulumi.Input[str]] = None,
                 step_executions: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionStepExecutionArgs']]]] = None,
                 time_ended: Optional[pulumi.Input[str]] = None,
                 time_started: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] display_name: (Updatable) The display name of the DR Plan Execution.  Example: `Execution - EBS Switchover PHX to IAD`
        :param pulumi.Input[int] execution_duration_in_sec: The total duration in seconds taken to complete step execution.  Example: `35`
        :param pulumi.Input[str] group_id: The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        :param pulumi.Input[str] status: The status of the step execution.
        :param pulumi.Input[str] status_details: Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        :param pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionStepExecutionArgs']]] step_executions: A list of details of each step executed in this group.
        :param pulumi.Input[str] time_ended: The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[str] time_started: The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[str] type: The plan group type.
        """
        DrPlanExecutionGroupExecutionArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            execution_duration_in_sec=execution_duration_in_sec,
            group_id=group_id,
            status=status,
            status_details=status_details,
            step_executions=step_executions,
            time_ended=time_ended,
            time_started=time_started,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: Optional[pulumi.Input[str]] = None,
             execution_duration_in_sec: Optional[pulumi.Input[int]] = None,
             group_id: Optional[pulumi.Input[str]] = None,
             status: Optional[pulumi.Input[str]] = None,
             status_details: Optional[pulumi.Input[str]] = None,
             step_executions: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionStepExecutionArgs']]]] = None,
             time_ended: Optional[pulumi.Input[str]] = None,
             time_started: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if display_name is not None:
            _setter("display_name", display_name)
        if execution_duration_in_sec is not None:
            _setter("execution_duration_in_sec", execution_duration_in_sec)
        if group_id is not None:
            _setter("group_id", group_id)
        if status is not None:
            _setter("status", status)
        if status_details is not None:
            _setter("status_details", status_details)
        if step_executions is not None:
            _setter("step_executions", step_executions)
        if time_ended is not None:
            _setter("time_ended", time_ended)
        if time_started is not None:
            _setter("time_started", time_started)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the DR Plan Execution.  Example: `Execution - EBS Switchover PHX to IAD`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="executionDurationInSec")
    def execution_duration_in_sec(self) -> Optional[pulumi.Input[int]]:
        """
        The total duration in seconds taken to complete step execution.  Example: `35`
        """
        return pulumi.get(self, "execution_duration_in_sec")

    @execution_duration_in_sec.setter
    def execution_duration_in_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "execution_duration_in_sec", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the step execution.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        """
        return pulumi.get(self, "status_details")

    @status_details.setter
    def status_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_details", value)

    @property
    @pulumi.getter(name="stepExecutions")
    def step_executions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionStepExecutionArgs']]]]:
        """
        A list of details of each step executed in this group.
        """
        return pulumi.get(self, "step_executions")

    @step_executions.setter
    def step_executions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionStepExecutionArgs']]]]):
        pulumi.set(self, "step_executions", value)

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_ended")

    @time_ended.setter
    def time_ended(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_ended", value)

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_started", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The plan group type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DrPlanExecutionGroupExecutionStepExecutionArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 execution_duration_in_sec: Optional[pulumi.Input[int]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 log_locations: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionStepExecutionLogLocationArgs']]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 status_details: Optional[pulumi.Input[str]] = None,
                 step_id: Optional[pulumi.Input[str]] = None,
                 time_ended: Optional[pulumi.Input[str]] = None,
                 time_started: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] display_name: (Updatable) The display name of the DR Plan Execution.  Example: `Execution - EBS Switchover PHX to IAD`
        :param pulumi.Input[int] execution_duration_in_sec: The total duration in seconds taken to complete step execution.  Example: `35`
        :param pulumi.Input[str] group_id: The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        :param pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionStepExecutionLogLocationArgs']]] log_locations: Information about an Object Storage log location for a DR Protection Group.
        :param pulumi.Input[str] status: The status of the step execution.
        :param pulumi.Input[str] status_details: Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        :param pulumi.Input[str] step_id: The unique id of this step. Must not be modified by user.  Example: `sgid1.step..&lt;unique_id&gt;`
        :param pulumi.Input[str] time_ended: The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[str] time_started: The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param pulumi.Input[str] type: The plan group type.
        """
        DrPlanExecutionGroupExecutionStepExecutionArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            execution_duration_in_sec=execution_duration_in_sec,
            group_id=group_id,
            log_locations=log_locations,
            status=status,
            status_details=status_details,
            step_id=step_id,
            time_ended=time_ended,
            time_started=time_started,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: Optional[pulumi.Input[str]] = None,
             execution_duration_in_sec: Optional[pulumi.Input[int]] = None,
             group_id: Optional[pulumi.Input[str]] = None,
             log_locations: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionStepExecutionLogLocationArgs']]]] = None,
             status: Optional[pulumi.Input[str]] = None,
             status_details: Optional[pulumi.Input[str]] = None,
             step_id: Optional[pulumi.Input[str]] = None,
             time_ended: Optional[pulumi.Input[str]] = None,
             time_started: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if display_name is not None:
            _setter("display_name", display_name)
        if execution_duration_in_sec is not None:
            _setter("execution_duration_in_sec", execution_duration_in_sec)
        if group_id is not None:
            _setter("group_id", group_id)
        if log_locations is not None:
            _setter("log_locations", log_locations)
        if status is not None:
            _setter("status", status)
        if status_details is not None:
            _setter("status_details", status_details)
        if step_id is not None:
            _setter("step_id", step_id)
        if time_ended is not None:
            _setter("time_ended", time_ended)
        if time_started is not None:
            _setter("time_started", time_started)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the DR Plan Execution.  Example: `Execution - EBS Switchover PHX to IAD`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="executionDurationInSec")
    def execution_duration_in_sec(self) -> Optional[pulumi.Input[int]]:
        """
        The total duration in seconds taken to complete step execution.  Example: `35`
        """
        return pulumi.get(self, "execution_duration_in_sec")

    @execution_duration_in_sec.setter
    def execution_duration_in_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "execution_duration_in_sec", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionStepExecutionLogLocationArgs']]]]:
        """
        Information about an Object Storage log location for a DR Protection Group.
        """
        return pulumi.get(self, "log_locations")

    @log_locations.setter
    def log_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanExecutionGroupExecutionStepExecutionLogLocationArgs']]]]):
        pulumi.set(self, "log_locations", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the step execution.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        """
        return pulumi.get(self, "status_details")

    @status_details.setter
    def status_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_details", value)

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique id of this step. Must not be modified by user.  Example: `sgid1.step..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "step_id")

    @step_id.setter
    def step_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step_id", value)

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_ended")

    @time_ended.setter
    def time_ended(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_ended", value)

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_started", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The plan group type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DrPlanExecutionGroupExecutionStepExecutionLogLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        :param pulumi.Input[str] namespace: The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param pulumi.Input[str] object: The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        DrPlanExecutionGroupExecutionStepExecutionLogLocationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            object=object,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: Optional[pulumi.Input[str]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             object: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if bucket is not None:
            _setter("bucket", bucket)
        if namespace is not None:
            _setter("namespace", namespace)
        if object is not None:
            _setter("object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class DrPlanExecutionLogLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        :param pulumi.Input[str] namespace: The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param pulumi.Input[str] object: The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        DrPlanExecutionLogLocationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            object=object,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: Optional[pulumi.Input[str]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             object: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if bucket is not None:
            _setter("bucket", bucket)
        if namespace is not None:
            _setter("namespace", namespace)
        if object is not None:
            _setter("object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class DrPlanPlanGroupArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanPlanGroupStepArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] display_name: (Updatable) The display name of the DR Plan being created.  Example: `EBS Switchover PHX to IAD`
        :param pulumi.Input[str] id: The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        :param pulumi.Input[Sequence[pulumi.Input['DrPlanPlanGroupStepArgs']]] steps: The list of steps in this plan group.
        :param pulumi.Input[str] type: The type of DR Plan to be created. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        DrPlanPlanGroupArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            id=id,
            steps=steps,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: Optional[pulumi.Input[str]] = None,
             id: Optional[pulumi.Input[str]] = None,
             steps: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanPlanGroupStepArgs']]]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if display_name is not None:
            _setter("display_name", display_name)
        if id is not None:
            _setter("id", id)
        if steps is not None:
            _setter("steps", steps)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the DR Plan being created.  Example: `EBS Switchover PHX to IAD`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanPlanGroupStepArgs']]]]:
        """
        The list of steps in this plan group.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanPlanGroupStepArgs']]]]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of DR Plan to be created. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DrPlanPlanGroupStepArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 error_mode: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 member_id: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_defined_steps: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanPlanGroupStepUserDefinedStepArgs']]]] = None):
        """
        :param pulumi.Input[str] display_name: (Updatable) The display name of the DR Plan being created.  Example: `EBS Switchover PHX to IAD`
        :param pulumi.Input[str] error_mode: The error mode for this step.
        :param pulumi.Input[str] group_id: The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        :param pulumi.Input[str] id: The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        :param pulumi.Input[bool] is_enabled: A flag indicating whether this step should be enabled for execution.  Example: `true`
        :param pulumi.Input[str] member_id: The OCID of the member associated with this step.  Example: `ocid1.database.oc1.phx.&lt;unique_id&gt;`
        :param pulumi.Input[int] timeout: The timeout in seconds for executing this step.  Example: `600`
        :param pulumi.Input[str] type: The type of DR Plan to be created. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['DrPlanPlanGroupStepUserDefinedStepArgs']]] user_defined_steps: The details for a user-defined step in a DR Plan.
        """
        DrPlanPlanGroupStepArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            error_mode=error_mode,
            group_id=group_id,
            id=id,
            is_enabled=is_enabled,
            member_id=member_id,
            timeout=timeout,
            type=type,
            user_defined_steps=user_defined_steps,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: Optional[pulumi.Input[str]] = None,
             error_mode: Optional[pulumi.Input[str]] = None,
             group_id: Optional[pulumi.Input[str]] = None,
             id: Optional[pulumi.Input[str]] = None,
             is_enabled: Optional[pulumi.Input[bool]] = None,
             member_id: Optional[pulumi.Input[str]] = None,
             timeout: Optional[pulumi.Input[int]] = None,
             type: Optional[pulumi.Input[str]] = None,
             user_defined_steps: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanPlanGroupStepUserDefinedStepArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if display_name is not None:
            _setter("display_name", display_name)
        if error_mode is not None:
            _setter("error_mode", error_mode)
        if group_id is not None:
            _setter("group_id", group_id)
        if id is not None:
            _setter("id", id)
        if is_enabled is not None:
            _setter("is_enabled", is_enabled)
        if member_id is not None:
            _setter("member_id", member_id)
        if timeout is not None:
            _setter("timeout", timeout)
        if type is not None:
            _setter("type", type)
        if user_defined_steps is not None:
            _setter("user_defined_steps", user_defined_steps)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the DR Plan being created.  Example: `EBS Switchover PHX to IAD`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="errorMode")
    def error_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The error mode for this step.
        """
        return pulumi.get(self, "error_mode")

    @error_mode.setter
    def error_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_mode", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether this step should be enabled for execution.  Example: `true`
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="memberId")
    def member_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the member associated with this step.  Example: `ocid1.database.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "member_id")

    @member_id.setter
    def member_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "member_id", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout in seconds for executing this step.  Example: `600`
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of DR Plan to be created. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userDefinedSteps")
    def user_defined_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanPlanGroupStepUserDefinedStepArgs']]]]:
        """
        The details for a user-defined step in a DR Plan.
        """
        return pulumi.get(self, "user_defined_steps")

    @user_defined_steps.setter
    def user_defined_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanPlanGroupStepUserDefinedStepArgs']]]]):
        pulumi.set(self, "user_defined_steps", value)


@pulumi.input_type
class DrPlanPlanGroupStepUserDefinedStepArgs:
    def __init__(__self__, *,
                 function_id: Optional[pulumi.Input[str]] = None,
                 function_region: Optional[pulumi.Input[str]] = None,
                 object_storage_script_locations: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocationArgs']]]] = None,
                 request_body: Optional[pulumi.Input[str]] = None,
                 run_as_user: Optional[pulumi.Input[str]] = None,
                 run_on_instance_id: Optional[pulumi.Input[str]] = None,
                 run_on_instance_region: Optional[pulumi.Input[str]] = None,
                 script_command: Optional[pulumi.Input[str]] = None,
                 step_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] function_id: The OCID of function to be invoked.  Example: `ocid1.fnfunc.oc1.iad.&lt;unique_id&gt;`
        :param pulumi.Input[str] function_region: The region in which the function is deployed.  Example: `us-ashburn-1`
        :param pulumi.Input[Sequence[pulumi.Input['DrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocationArgs']]] object_storage_script_locations: Information about an Object Storage script location for a user-defined step in a DR Plan.
        :param pulumi.Input[str] request_body: The request body for the function.  Example: `{ "FnParam1", "FnParam2" }`
        :param pulumi.Input[str] run_as_user: The userid on the instance to be used for executing the script or command.  Example: `opc`
        :param pulumi.Input[str] run_on_instance_id: The OCID of the instance where this script or command should be executed.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        :param pulumi.Input[str] run_on_instance_region: The region of the instance where this script or command should be executed.  Example: `us-phoenix-1`
        :param pulumi.Input[str] script_command: The script name and arguments.  Example: `/usr/bin/python3 /home/opc/scripts/my_app_script.py arg1 arg2 arg3`
        :param pulumi.Input[str] step_type: The type of the step.
        """
        DrPlanPlanGroupStepUserDefinedStepArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            function_id=function_id,
            function_region=function_region,
            object_storage_script_locations=object_storage_script_locations,
            request_body=request_body,
            run_as_user=run_as_user,
            run_on_instance_id=run_on_instance_id,
            run_on_instance_region=run_on_instance_region,
            script_command=script_command,
            step_type=step_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             function_id: Optional[pulumi.Input[str]] = None,
             function_region: Optional[pulumi.Input[str]] = None,
             object_storage_script_locations: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocationArgs']]]] = None,
             request_body: Optional[pulumi.Input[str]] = None,
             run_as_user: Optional[pulumi.Input[str]] = None,
             run_on_instance_id: Optional[pulumi.Input[str]] = None,
             run_on_instance_region: Optional[pulumi.Input[str]] = None,
             script_command: Optional[pulumi.Input[str]] = None,
             step_type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if function_id is not None:
            _setter("function_id", function_id)
        if function_region is not None:
            _setter("function_region", function_region)
        if object_storage_script_locations is not None:
            _setter("object_storage_script_locations", object_storage_script_locations)
        if request_body is not None:
            _setter("request_body", request_body)
        if run_as_user is not None:
            _setter("run_as_user", run_as_user)
        if run_on_instance_id is not None:
            _setter("run_on_instance_id", run_on_instance_id)
        if run_on_instance_region is not None:
            _setter("run_on_instance_region", run_on_instance_region)
        if script_command is not None:
            _setter("script_command", script_command)
        if step_type is not None:
            _setter("step_type", step_type)

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of function to be invoked.  Example: `ocid1.fnfunc.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "function_id")

    @function_id.setter
    def function_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_id", value)

    @property
    @pulumi.getter(name="functionRegion")
    def function_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which the function is deployed.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "function_region")

    @function_region.setter
    def function_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_region", value)

    @property
    @pulumi.getter(name="objectStorageScriptLocations")
    def object_storage_script_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocationArgs']]]]:
        """
        Information about an Object Storage script location for a user-defined step in a DR Plan.
        """
        return pulumi.get(self, "object_storage_script_locations")

    @object_storage_script_locations.setter
    def object_storage_script_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocationArgs']]]]):
        pulumi.set(self, "object_storage_script_locations", value)

    @property
    @pulumi.getter(name="requestBody")
    def request_body(self) -> Optional[pulumi.Input[str]]:
        """
        The request body for the function.  Example: `{ "FnParam1", "FnParam2" }`
        """
        return pulumi.get(self, "request_body")

    @request_body.setter
    def request_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_body", value)

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[str]]:
        """
        The userid on the instance to be used for executing the script or command.  Example: `opc`
        """
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_as_user", value)

    @property
    @pulumi.getter(name="runOnInstanceId")
    def run_on_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the instance where this script or command should be executed.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "run_on_instance_id")

    @run_on_instance_id.setter
    def run_on_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_on_instance_id", value)

    @property
    @pulumi.getter(name="runOnInstanceRegion")
    def run_on_instance_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the instance where this script or command should be executed.  Example: `us-phoenix-1`
        """
        return pulumi.get(self, "run_on_instance_region")

    @run_on_instance_region.setter
    def run_on_instance_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_on_instance_region", value)

    @property
    @pulumi.getter(name="scriptCommand")
    def script_command(self) -> Optional[pulumi.Input[str]]:
        """
        The script name and arguments.  Example: `/usr/bin/python3 /home/opc/scripts/my_app_script.py arg1 arg2 arg3`
        """
        return pulumi.get(self, "script_command")

    @script_command.setter
    def script_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_command", value)

    @property
    @pulumi.getter(name="stepType")
    def step_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the step.
        """
        return pulumi.get(self, "step_type")

    @step_type.setter
    def step_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step_type", value)


@pulumi.input_type
class DrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: The bucket name inside the Object Storage namespace.  Example: `custom_dr_scripts`
        :param pulumi.Input[str] namespace: The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param pulumi.Input[str] object: The object name inside the Object Storage bucket.  Example: `validate_app_start.sh`
        """
        DrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            object=object,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: Optional[pulumi.Input[str]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             object: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if bucket is not None:
            _setter("bucket", bucket)
        if namespace is not None:
            _setter("namespace", namespace)
        if object is not None:
            _setter("object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The bucket name inside the Object Storage namespace.  Example: `custom_dr_scripts`
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        The object name inside the Object Storage bucket.  Example: `validate_app_start.sh`
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class DrProtectionGroupAssociationArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[str],
                 peer_id: Optional[pulumi.Input[str]] = None,
                 peer_region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] role: The role of this DR Protection Group.
        :param pulumi.Input[str] peer_id: The OCID of the peer (remote) DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.iad.&lt;unique_id&gt;`
        :param pulumi.Input[str] peer_region: The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        """
        DrProtectionGroupAssociationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            role=role,
            peer_id=peer_id,
            peer_region=peer_region,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             role: pulumi.Input[str],
             peer_id: Optional[pulumi.Input[str]] = None,
             peer_region: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("role", role)
        if peer_id is not None:
            _setter("peer_id", peer_id)
        if peer_region is not None:
            _setter("peer_region", peer_region)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[str]:
        """
        The role of this DR Protection Group.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the peer (remote) DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "peer_id")

    @peer_id.setter
    def peer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_id", value)

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "peer_region")

    @peer_region.setter
    def peer_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_region", value)


@pulumi.input_type
class DrProtectionGroupLogLocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: (Updatable) The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        :param pulumi.Input[str] namespace: (Updatable) The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param pulumi.Input[str] object: The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        DrProtectionGroupLogLocationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            object=object,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: pulumi.Input[str],
             namespace: pulumi.Input[str],
             object: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)
        if object is not None:
            _setter("object", object)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        (Updatable) The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        (Updatable) The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class DrProtectionGroupMemberArgs:
    def __init__(__self__, *,
                 member_id: pulumi.Input[str],
                 member_type: pulumi.Input[str],
                 destination_capacity_reservation_id: Optional[pulumi.Input[str]] = None,
                 destination_compartment_id: Optional[pulumi.Input[str]] = None,
                 destination_dedicated_vm_host_id: Optional[pulumi.Input[str]] = None,
                 is_movable: Optional[pulumi.Input[bool]] = None,
                 is_retain_fault_domain: Optional[pulumi.Input[bool]] = None,
                 password_vault_secret_id: Optional[pulumi.Input[str]] = None,
                 vnic_mapping: Optional[pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberVnicMappingArgs']]]] = None,
                 vnic_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberVnicMappingArgs']]]] = None):
        """
        :param pulumi.Input[str] member_id: (Updatable) The OCID of the member.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        :param pulumi.Input[str] member_type: (Updatable) The type of the member.
        :param pulumi.Input[str] destination_capacity_reservation_id: (Updatable) The OCID of the capacity reservation in the destination region using which this compute instance should be launched.  Example: `ocid1.capacityreservation.oc1..&lt;unique_id&gt;`
        :param pulumi.Input[str] destination_compartment_id: (Updatable) The OCID of the compartment for this compute instance in the destination region.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        :param pulumi.Input[str] destination_dedicated_vm_host_id: (Updatable) The OCID of the dedicated VM Host in the destination region where this compute instance should be launched  Example: `ocid1.dedicatedvmhost.oc1.iad.&lt;unique_id&gt;`
        :param pulumi.Input[bool] is_movable: (Updatable) A flag indicating if this compute instance should be moved during DR operations.  Example: `false`
        :param pulumi.Input[bool] is_retain_fault_domain: (Updatable) A flag indicating if this compute instance should be moved to the same fault domain.  Compute instance launch will fail if this flag is set to true and capacity is not available in that specific fault domain in the destination region.  Example: `false`
        :param pulumi.Input[str] password_vault_secret_id: (Updatable) The OCID of the vault secret where the database password is stored.  Example: `ocid1.vaultsecret.oc1.phx.&lt;unique_id&gt;`
        :param pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberVnicMappingArgs']]] vnic_mapping: (Updatable) A list of Compute Instance VNIC mappings.
        :param pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberVnicMappingArgs']]] vnic_mappings: (Updatable) A list of Compute Instance VNIC mappings.
        """
        DrProtectionGroupMemberArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            member_id=member_id,
            member_type=member_type,
            destination_capacity_reservation_id=destination_capacity_reservation_id,
            destination_compartment_id=destination_compartment_id,
            destination_dedicated_vm_host_id=destination_dedicated_vm_host_id,
            is_movable=is_movable,
            is_retain_fault_domain=is_retain_fault_domain,
            password_vault_secret_id=password_vault_secret_id,
            vnic_mapping=vnic_mapping,
            vnic_mappings=vnic_mappings,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             member_id: pulumi.Input[str],
             member_type: pulumi.Input[str],
             destination_capacity_reservation_id: Optional[pulumi.Input[str]] = None,
             destination_compartment_id: Optional[pulumi.Input[str]] = None,
             destination_dedicated_vm_host_id: Optional[pulumi.Input[str]] = None,
             is_movable: Optional[pulumi.Input[bool]] = None,
             is_retain_fault_domain: Optional[pulumi.Input[bool]] = None,
             password_vault_secret_id: Optional[pulumi.Input[str]] = None,
             vnic_mapping: Optional[pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberVnicMappingArgs']]]] = None,
             vnic_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberVnicMappingArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("member_id", member_id)
        _setter("member_type", member_type)
        if destination_capacity_reservation_id is not None:
            _setter("destination_capacity_reservation_id", destination_capacity_reservation_id)
        if destination_compartment_id is not None:
            _setter("destination_compartment_id", destination_compartment_id)
        if destination_dedicated_vm_host_id is not None:
            _setter("destination_dedicated_vm_host_id", destination_dedicated_vm_host_id)
        if is_movable is not None:
            _setter("is_movable", is_movable)
        if is_retain_fault_domain is not None:
            _setter("is_retain_fault_domain", is_retain_fault_domain)
        if password_vault_secret_id is not None:
            _setter("password_vault_secret_id", password_vault_secret_id)
        if vnic_mapping is not None:
            _setter("vnic_mapping", vnic_mapping)
        if vnic_mappings is not None:
            _setter("vnic_mappings", vnic_mappings)

    @property
    @pulumi.getter(name="memberId")
    def member_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the member.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "member_id")

    @member_id.setter
    def member_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "member_id", value)

    @property
    @pulumi.getter(name="memberType")
    def member_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of the member.
        """
        return pulumi.get(self, "member_type")

    @member_type.setter
    def member_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "member_type", value)

    @property
    @pulumi.getter(name="destinationCapacityReservationId")
    def destination_capacity_reservation_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the capacity reservation in the destination region using which this compute instance should be launched.  Example: `ocid1.capacityreservation.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_capacity_reservation_id")

    @destination_capacity_reservation_id.setter
    def destination_capacity_reservation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_capacity_reservation_id", value)

    @property
    @pulumi.getter(name="destinationCompartmentId")
    def destination_compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment for this compute instance in the destination region.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_compartment_id")

    @destination_compartment_id.setter
    def destination_compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_compartment_id", value)

    @property
    @pulumi.getter(name="destinationDedicatedVmHostId")
    def destination_dedicated_vm_host_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the dedicated VM Host in the destination region where this compute instance should be launched  Example: `ocid1.dedicatedvmhost.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_dedicated_vm_host_id")

    @destination_dedicated_vm_host_id.setter
    def destination_dedicated_vm_host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_dedicated_vm_host_id", value)

    @property
    @pulumi.getter(name="isMovable")
    def is_movable(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A flag indicating if this compute instance should be moved during DR operations.  Example: `false`
        """
        return pulumi.get(self, "is_movable")

    @is_movable.setter
    def is_movable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_movable", value)

    @property
    @pulumi.getter(name="isRetainFaultDomain")
    def is_retain_fault_domain(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A flag indicating if this compute instance should be moved to the same fault domain.  Compute instance launch will fail if this flag is set to true and capacity is not available in that specific fault domain in the destination region.  Example: `false`
        """
        return pulumi.get(self, "is_retain_fault_domain")

    @is_retain_fault_domain.setter
    def is_retain_fault_domain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_retain_fault_domain", value)

    @property
    @pulumi.getter(name="passwordVaultSecretId")
    def password_vault_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the vault secret where the database password is stored.  Example: `ocid1.vaultsecret.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "password_vault_secret_id")

    @password_vault_secret_id.setter
    def password_vault_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_vault_secret_id", value)

    @property
    @pulumi.getter(name="vnicMapping")
    def vnic_mapping(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberVnicMappingArgs']]]]:
        """
        (Updatable) A list of Compute Instance VNIC mappings.
        """
        return pulumi.get(self, "vnic_mapping")

    @vnic_mapping.setter
    def vnic_mapping(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberVnicMappingArgs']]]]):
        pulumi.set(self, "vnic_mapping", value)

    @property
    @pulumi.getter(name="vnicMappings")
    def vnic_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberVnicMappingArgs']]]]:
        """
        (Updatable) A list of Compute Instance VNIC mappings.
        """
        return pulumi.get(self, "vnic_mappings")

    @vnic_mappings.setter
    def vnic_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DrProtectionGroupMemberVnicMappingArgs']]]]):
        pulumi.set(self, "vnic_mappings", value)


@pulumi.input_type
class DrProtectionGroupMemberVnicMappingArgs:
    def __init__(__self__, *,
                 destination_nsg_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_primary_private_ip_address: Optional[pulumi.Input[str]] = None,
                 destination_primary_private_ip_hostname_label: Optional[pulumi.Input[str]] = None,
                 destination_subnet_id: Optional[pulumi.Input[str]] = None,
                 source_vnic_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_nsg_id_lists: (Updatable) A list of network security group (NSG) IDs in the destination region which this VNIC should use.  Example: `[ ocid1.networksecuritygroup.oc1..&lt;unique_id&gt;, ocid1.networksecuritygroup.oc1..&lt;unique_id&gt; ]`
        :param pulumi.Input[str] destination_primary_private_ip_address: (Updatable) The primary private IP address to assign. This address must belong to the destination subnet.  Example: `10.0.3.3`
        :param pulumi.Input[str] destination_primary_private_ip_hostname_label: (Updatable) The hostname to assign for this primary private IP. The value is the hostname portion of the private IP's fully qualified domain name (FQDN)  (for example, bminstance1 in FQDN bminstance1.subnet123.vcn1.oraclevcn.com).  Example: `bminstance1`
        :param pulumi.Input[str] destination_subnet_id: (Updatable) The OCID of the destination (remote) subnet to which this VNIC should connect.  Example: `ocid1.subnet.oc1..&lt;unique_id&gt;`
        :param pulumi.Input[str] source_vnic_id: (Updatable) The OCID of the VNIC.  Example: `ocid1.vnic.oc1..&lt;unique_id&gt;`
        """
        DrProtectionGroupMemberVnicMappingArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            destination_nsg_id_lists=destination_nsg_id_lists,
            destination_primary_private_ip_address=destination_primary_private_ip_address,
            destination_primary_private_ip_hostname_label=destination_primary_private_ip_hostname_label,
            destination_subnet_id=destination_subnet_id,
            source_vnic_id=source_vnic_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             destination_nsg_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             destination_primary_private_ip_address: Optional[pulumi.Input[str]] = None,
             destination_primary_private_ip_hostname_label: Optional[pulumi.Input[str]] = None,
             destination_subnet_id: Optional[pulumi.Input[str]] = None,
             source_vnic_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if destination_nsg_id_lists is not None:
            _setter("destination_nsg_id_lists", destination_nsg_id_lists)
        if destination_primary_private_ip_address is not None:
            _setter("destination_primary_private_ip_address", destination_primary_private_ip_address)
        if destination_primary_private_ip_hostname_label is not None:
            _setter("destination_primary_private_ip_hostname_label", destination_primary_private_ip_hostname_label)
        if destination_subnet_id is not None:
            _setter("destination_subnet_id", destination_subnet_id)
        if source_vnic_id is not None:
            _setter("source_vnic_id", source_vnic_id)

    @property
    @pulumi.getter(name="destinationNsgIdLists")
    def destination_nsg_id_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of network security group (NSG) IDs in the destination region which this VNIC should use.  Example: `[ ocid1.networksecuritygroup.oc1..&lt;unique_id&gt;, ocid1.networksecuritygroup.oc1..&lt;unique_id&gt; ]`
        """
        return pulumi.get(self, "destination_nsg_id_lists")

    @destination_nsg_id_lists.setter
    def destination_nsg_id_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_nsg_id_lists", value)

    @property
    @pulumi.getter(name="destinationPrimaryPrivateIpAddress")
    def destination_primary_private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The primary private IP address to assign. This address must belong to the destination subnet.  Example: `10.0.3.3`
        """
        return pulumi.get(self, "destination_primary_private_ip_address")

    @destination_primary_private_ip_address.setter
    def destination_primary_private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_primary_private_ip_address", value)

    @property
    @pulumi.getter(name="destinationPrimaryPrivateIpHostnameLabel")
    def destination_primary_private_ip_hostname_label(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The hostname to assign for this primary private IP. The value is the hostname portion of the private IP's fully qualified domain name (FQDN)  (for example, bminstance1 in FQDN bminstance1.subnet123.vcn1.oraclevcn.com).  Example: `bminstance1`
        """
        return pulumi.get(self, "destination_primary_private_ip_hostname_label")

    @destination_primary_private_ip_hostname_label.setter
    def destination_primary_private_ip_hostname_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_primary_private_ip_hostname_label", value)

    @property
    @pulumi.getter(name="destinationSubnetId")
    def destination_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the destination (remote) subnet to which this VNIC should connect.  Example: `ocid1.subnet.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_subnet_id")

    @destination_subnet_id.setter
    def destination_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_subnet_id", value)

    @property
    @pulumi.getter(name="sourceVnicId")
    def source_vnic_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the VNIC.  Example: `ocid1.vnic.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "source_vnic_id")

    @source_vnic_id.setter
    def source_vnic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_vnic_id", value)


@pulumi.input_type
class GetDrPlanExecutionsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDrPlanExecutionsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetDrPlansFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDrPlansFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetDrProtectionGroupsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDrProtectionGroupsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


