# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDrPlansResult',
    'AwaitableGetDrPlansResult',
    'get_dr_plans',
    'get_dr_plans_output',
]

@pulumi.output_type
class GetDrPlansResult:
    """
    A collection of values returned by getDrPlans.
    """
    def __init__(__self__, display_name=None, dr_plan_collections=None, dr_plan_id=None, dr_plan_type=None, dr_protection_group_id=None, filters=None, id=None, state=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dr_plan_collections and not isinstance(dr_plan_collections, list):
            raise TypeError("Expected argument 'dr_plan_collections' to be a list")
        pulumi.set(__self__, "dr_plan_collections", dr_plan_collections)
        if dr_plan_id and not isinstance(dr_plan_id, str):
            raise TypeError("Expected argument 'dr_plan_id' to be a str")
        pulumi.set(__self__, "dr_plan_id", dr_plan_id)
        if dr_plan_type and not isinstance(dr_plan_type, str):
            raise TypeError("Expected argument 'dr_plan_type' to be a str")
        pulumi.set(__self__, "dr_plan_type", dr_plan_type)
        if dr_protection_group_id and not isinstance(dr_protection_group_id, str):
            raise TypeError("Expected argument 'dr_protection_group_id' to be a str")
        pulumi.set(__self__, "dr_protection_group_id", dr_protection_group_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of this DR Plan Group.  Example: `DATABASE_SWITCHOVER`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="drPlanCollections")
    def dr_plan_collections(self) -> Sequence['outputs.GetDrPlansDrPlanCollectionResult']:
        """
        The list of dr_plan_collection.
        """
        return pulumi.get(self, "dr_plan_collections")

    @property
    @pulumi.getter(name="drPlanId")
    def dr_plan_id(self) -> Optional[str]:
        return pulumi.get(self, "dr_plan_id")

    @property
    @pulumi.getter(name="drPlanType")
    def dr_plan_type(self) -> Optional[str]:
        return pulumi.get(self, "dr_plan_type")

    @property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> str:
        """
        The OCID of the DR Protection Group with which this DR Plan is associated.  Example: `ocid1.drplan.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDrPlansFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the DR Plan.
        """
        return pulumi.get(self, "state")


class AwaitableGetDrPlansResult(GetDrPlansResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDrPlansResult(
            display_name=self.display_name,
            dr_plan_collections=self.dr_plan_collections,
            dr_plan_id=self.dr_plan_id,
            dr_plan_type=self.dr_plan_type,
            dr_protection_group_id=self.dr_protection_group_id,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_dr_plans(display_name: Optional[str] = None,
                 dr_plan_id: Optional[str] = None,
                 dr_plan_type: Optional[str] = None,
                 dr_protection_group_id: Optional[str] = None,
                 filters: Optional[Sequence[pulumi.InputType['GetDrPlansFilterArgs']]] = None,
                 state: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDrPlansResult:
    """
    This data source provides the list of Dr Plans in Oracle Cloud Infrastructure Disaster Recovery service.

    Gets a summary list of all DR Plans for a DR Protection Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dr_plans = oci.DisasterRecovery.get_dr_plans(dr_protection_group_id=oci_disaster_recovery_dr_protection_group["test_dr_protection_group"]["id"],
        display_name=var["dr_plan_display_name"],
        dr_plan_id=oci_disaster_recovery_dr_plan["test_dr_plan"]["id"],
        dr_plan_type=var["dr_plan_dr_plan_type"],
        state=var["dr_plan_state"])
    ```


    :param str display_name: A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
    :param str dr_plan_id: The OCID of the DR Plan.  Example: `ocid1.drplan.oc1.iad.exampleocid`
    :param str dr_plan_type: The DR Plan type.
    :param str dr_protection_group_id: The OCID of the DR Protection Group. Mandatory query param.  Example: `ocid1.drprotectiongroup.oc1.phx.exampleocid`
    :param str state: A filter to return only DR Plans that match the given lifecycleState.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['drPlanId'] = dr_plan_id
    __args__['drPlanType'] = dr_plan_type
    __args__['drProtectionGroupId'] = dr_protection_group_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DisasterRecovery/getDrPlans:getDrPlans', __args__, opts=opts, typ=GetDrPlansResult).value

    return AwaitableGetDrPlansResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        dr_plan_collections=pulumi.get(__ret__, 'dr_plan_collections'),
        dr_plan_id=pulumi.get(__ret__, 'dr_plan_id'),
        dr_plan_type=pulumi.get(__ret__, 'dr_plan_type'),
        dr_protection_group_id=pulumi.get(__ret__, 'dr_protection_group_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_dr_plans)
def get_dr_plans_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                        dr_plan_id: Optional[pulumi.Input[Optional[str]]] = None,
                        dr_plan_type: Optional[pulumi.Input[Optional[str]]] = None,
                        dr_protection_group_id: Optional[pulumi.Input[str]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDrPlansFilterArgs']]]]] = None,
                        state: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDrPlansResult]:
    """
    This data source provides the list of Dr Plans in Oracle Cloud Infrastructure Disaster Recovery service.

    Gets a summary list of all DR Plans for a DR Protection Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dr_plans = oci.DisasterRecovery.get_dr_plans(dr_protection_group_id=oci_disaster_recovery_dr_protection_group["test_dr_protection_group"]["id"],
        display_name=var["dr_plan_display_name"],
        dr_plan_id=oci_disaster_recovery_dr_plan["test_dr_plan"]["id"],
        dr_plan_type=var["dr_plan_dr_plan_type"],
        state=var["dr_plan_state"])
    ```


    :param str display_name: A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
    :param str dr_plan_id: The OCID of the DR Plan.  Example: `ocid1.drplan.oc1.iad.exampleocid`
    :param str dr_plan_type: The DR Plan type.
    :param str dr_protection_group_id: The OCID of the DR Protection Group. Mandatory query param.  Example: `ocid1.drprotectiongroup.oc1.phx.exampleocid`
    :param str state: A filter to return only DR Plans that match the given lifecycleState.
    """
    ...
