# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'QuotaLock',
    'GetLimitDefinitionsFilterResult',
    'GetLimitDefinitionsLimitDefinitionResult',
    'GetLimitValuesFilterResult',
    'GetLimitValuesLimitValueResult',
    'GetQuotaLockResult',
    'GetQuotasFilterResult',
    'GetQuotasQuotaResult',
    'GetQuotasQuotaLockResult',
    'GetServicesFilterResult',
    'GetServicesServiceResult',
]

@pulumi.output_type
class QuotaLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuotaLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuotaLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuotaLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 message: Optional[str] = None,
                 related_resource_id: Optional[str] = None,
                 time_created: Optional[str] = None):
        """
        :param str type: Lock type.
        :param str message: A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        :param str related_resource_id: The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        :param str time_created: Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
        QuotaLock._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            message=message,
            related_resource_id=related_resource_id,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: str,
             message: Optional[str] = None,
             related_resource_id: Optional[str] = None,
             time_created: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("type", type)
        if message is not None:
            _setter("message", message)
        if related_resource_id is not None:
            _setter("related_resource_id", related_resource_id)
        if time_created is not None:
            _setter("time_created", time_created)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Lock type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[str]:
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[str]:
        """
        Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetLimitDefinitionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Optional field, filter for a specific resource limit.
        """
        GetLimitDefinitionsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional field, filter for a specific resource limit.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLimitDefinitionsLimitDefinitionResult(dict):
    def __init__(__self__, *,
                 are_quotas_supported: bool,
                 description: str,
                 is_deprecated: bool,
                 is_dynamic: bool,
                 is_eligible_for_limit_increase: bool,
                 is_resource_availability_supported: bool,
                 name: str,
                 scope_type: str,
                 service_name: str):
        """
        :param bool are_quotas_supported: If true, quota policies can be created on top of this resource limit.
        :param str description: The limit description.
        :param bool is_deprecated: Indicates if the limit has been deprecated.
        :param bool is_dynamic: The limit for this resource has a dynamic value that is based on consumption across all Oracle Cloud Infrastructure services.
        :param bool is_eligible_for_limit_increase: Indicates if the customer can request a limit increase for this resource.
        :param bool is_resource_availability_supported: Reflects whether or not the GetResourceAvailability API is supported for this limit. If not, the API returns an empty JSON response.
        :param str name: Optional field, filter for a specific resource limit.
        :param str scope_type: Reflects the scope of the resource limit, whether Global (across all regions), regional, or availability domain-specific.
        :param str service_name: The target service name.
        """
        GetLimitDefinitionsLimitDefinitionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            are_quotas_supported=are_quotas_supported,
            description=description,
            is_deprecated=is_deprecated,
            is_dynamic=is_dynamic,
            is_eligible_for_limit_increase=is_eligible_for_limit_increase,
            is_resource_availability_supported=is_resource_availability_supported,
            name=name,
            scope_type=scope_type,
            service_name=service_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             are_quotas_supported: bool,
             description: str,
             is_deprecated: bool,
             is_dynamic: bool,
             is_eligible_for_limit_increase: bool,
             is_resource_availability_supported: bool,
             name: str,
             scope_type: str,
             service_name: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("are_quotas_supported", are_quotas_supported)
        _setter("description", description)
        _setter("is_deprecated", is_deprecated)
        _setter("is_dynamic", is_dynamic)
        _setter("is_eligible_for_limit_increase", is_eligible_for_limit_increase)
        _setter("is_resource_availability_supported", is_resource_availability_supported)
        _setter("name", name)
        _setter("scope_type", scope_type)
        _setter("service_name", service_name)

    @property
    @pulumi.getter(name="areQuotasSupported")
    def are_quotas_supported(self) -> bool:
        """
        If true, quota policies can be created on top of this resource limit.
        """
        return pulumi.get(self, "are_quotas_supported")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The limit description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isDeprecated")
    def is_deprecated(self) -> bool:
        """
        Indicates if the limit has been deprecated.
        """
        return pulumi.get(self, "is_deprecated")

    @property
    @pulumi.getter(name="isDynamic")
    def is_dynamic(self) -> bool:
        """
        The limit for this resource has a dynamic value that is based on consumption across all Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "is_dynamic")

    @property
    @pulumi.getter(name="isEligibleForLimitIncrease")
    def is_eligible_for_limit_increase(self) -> bool:
        """
        Indicates if the customer can request a limit increase for this resource.
        """
        return pulumi.get(self, "is_eligible_for_limit_increase")

    @property
    @pulumi.getter(name="isResourceAvailabilitySupported")
    def is_resource_availability_supported(self) -> bool:
        """
        Reflects whether or not the GetResourceAvailability API is supported for this limit. If not, the API returns an empty JSON response.
        """
        return pulumi.get(self, "is_resource_availability_supported")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional field, filter for a specific resource limit.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scopeType")
    def scope_type(self) -> str:
        """
        Reflects the scope of the resource limit, whether Global (across all regions), regional, or availability domain-specific.
        """
        return pulumi.get(self, "scope_type")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The target service name.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class GetLimitValuesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Optional field, can be used to see a specific resource limit value.
        """
        GetLimitValuesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional field, can be used to see a specific resource limit value.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLimitValuesLimitValueResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 name: str,
                 scope_type: str,
                 value: str):
        """
        :param str availability_domain: Filter entries by availability domain. This implies that only AD-specific values are returned.
        :param str name: Optional field, can be used to see a specific resource limit value.
        :param str scope_type: Filter entries by scope type.
        :param str value: The resource limit value.
        """
        GetLimitValuesLimitValueResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            name=name,
            scope_type=scope_type,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: str,
             name: str,
             scope_type: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("availability_domain", availability_domain)
        _setter("name", name)
        _setter("scope_type", scope_type)
        _setter("value", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        Filter entries by availability domain. This implies that only AD-specific values are returned.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional field, can be used to see a specific resource limit value.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scopeType")
    def scope_type(self) -> str:
        """
        Filter entries by scope type.
        """
        return pulumi.get(self, "scope_type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The resource limit value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetQuotaLockResult(dict):
    def __init__(__self__, *,
                 message: str,
                 related_resource_id: str,
                 time_created: str,
                 type: str):
        """
        :param str message: A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        :param str related_resource_id: The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        :param str time_created: Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        :param str type: Lock type.
        """
        GetQuotaLockResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            message=message,
            related_resource_id=related_resource_id,
            time_created=time_created,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             message: str,
             related_resource_id: str,
             time_created: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("message", message)
        _setter("related_resource_id", related_resource_id)
        _setter("time_created", time_created)
        _setter("type", type)

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> str:
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Lock type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetQuotasFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: name
        """
        GetQuotasFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetQuotasQuotaResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_lock_override: bool,
                 locks: Sequence['outputs.GetQuotasQuotaLockResult'],
                 name: str,
                 state: str,
                 statements: Sequence[str],
                 time_created: str):
        """
        :param str compartment_id: The OCID of the parent compartment (remember that the tenancy is simply the root compartment).
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str description: The description you assign to the quota.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the quota.
        :param Sequence['GetQuotasQuotaLockArgs'] locks: Locks associated with this resource.
        :param str name: name
        :param str state: Filters returned quotas based on the given state.
        :param Sequence[str] statements: An array of one or more quota statements written in the declarative quota statement language.
        :param str time_created: Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
        GetQuotasQuotaResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            freeform_tags=freeform_tags,
            id=id,
            is_lock_override=is_lock_override,
            locks=locks,
            name=name,
            state=state,
            statements=statements,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_lock_override: bool,
             locks: Sequence['outputs.GetQuotasQuotaLockResult'],
             name: str,
             state: str,
             statements: Sequence[str],
             time_created: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_lock_override", is_lock_override)
        _setter("locks", locks)
        _setter("name", name)
        _setter("state", state)
        _setter("statements", statements)
        _setter("time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the parent compartment (remember that the tenancy is simply the root compartment).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description you assign to the quota.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the quota.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> bool:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetQuotasQuotaLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Filters returned quotas based on the given state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def statements(self) -> Sequence[str]:
        """
        An array of one or more quota statements written in the declarative quota statement language.
        """
        return pulumi.get(self, "statements")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetQuotasQuotaLockResult(dict):
    def __init__(__self__, *,
                 message: str,
                 related_resource_id: str,
                 time_created: str,
                 type: str):
        """
        :param str message: A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        :param str related_resource_id: The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        :param str time_created: Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        :param str type: Lock type.
        """
        GetQuotasQuotaLockResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            message=message,
            related_resource_id=related_resource_id,
            time_created=time_created,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             message: str,
             related_resource_id: str,
             time_created: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("message", message)
        _setter("related_resource_id", related_resource_id)
        _setter("time_created", time_created)
        _setter("type", type)

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A message added by the lock creator. The message typically gives an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> str:
        """
        The resource ID that is locking this resource. Indicates that deleting this resource removes the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Lock type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServicesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The service name. Use this when calling other APIs.
        """
        GetServicesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The service name. Use this when calling other APIs.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetServicesServiceResult(dict):
    def __init__(__self__, *,
                 description: str,
                 name: str):
        """
        :param str description: The friendly service name.
        :param str name: The service name. Use this when calling other APIs.
        """
        GetServicesServiceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: str,
             name: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("description", description)
        _setter("name", name)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The friendly service name.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The service name. Use this when calling other APIs.
        """
        return pulumi.get(self, "name")


