# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'LogConfiguration',
    'LogConfigurationSource',
    'UnifiedAgentConfigurationGroupAssociation',
    'UnifiedAgentConfigurationServiceConfiguration',
    'UnifiedAgentConfigurationServiceConfigurationDestination',
    'UnifiedAgentConfigurationServiceConfigurationSource',
    'UnifiedAgentConfigurationServiceConfigurationSourceParser',
    'UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser',
    'UnifiedAgentConfigurationServiceConfigurationSourceParserPattern',
    'GetLogConfigurationResult',
    'GetLogConfigurationSourceResult',
    'GetLogGroupsFilterResult',
    'GetLogGroupsLogGroupResult',
    'GetLogSavedSearchesFilterResult',
    'GetLogSavedSearchesLogSavedSearchSummaryCollectionResult',
    'GetLogSavedSearchesLogSavedSearchSummaryCollectionItemResult',
    'GetLogsFilterResult',
    'GetLogsLogResult',
    'GetLogsLogConfigurationResult',
    'GetLogsLogConfigurationSourceResult',
    'GetUnifiedAgentConfigurationGroupAssociationResult',
    'GetUnifiedAgentConfigurationServiceConfigurationResult',
    'GetUnifiedAgentConfigurationServiceConfigurationDestinationResult',
    'GetUnifiedAgentConfigurationServiceConfigurationSourceResult',
    'GetUnifiedAgentConfigurationServiceConfigurationSourceParserResult',
    'GetUnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserResult',
    'GetUnifiedAgentConfigurationServiceConfigurationSourceParserPatternResult',
    'GetUnifiedAgentConfigurationsFilterResult',
    'GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionResult',
    'GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionItemResult',
]

@pulumi.output_type
class LogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source: 'outputs.LogConfigurationSource',
                 compartment_id: Optional[str] = None):
        """
        :param 'LogConfigurationSourceArgs' source: The source the log object comes from.
        :param str compartment_id: The OCID of the compartment that the resource belongs to.
        """
        LogConfiguration._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            source=source,
            compartment_id=compartment_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             source: 'outputs.LogConfigurationSource',
             compartment_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("source", source)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)

    @property
    @pulumi.getter
    def source(self) -> 'outputs.LogConfigurationSource':
        """
        The source the log object comes from.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")


@pulumi.output_type
class LogConfigurationSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogConfigurationSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogConfigurationSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogConfigurationSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: str,
                 resource: str,
                 service: str,
                 source_type: str):
        """
        :param str category: Log object category.
        :param str resource: The unique identifier of the resource emitting the log.
        :param str service: Service generating log.
        :param str source_type: The log source.
               * **OCISERVICE:** Oracle Service.
        """
        LogConfigurationSource._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            category=category,
            resource=resource,
            service=service,
            source_type=source_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             category: str,
             resource: str,
             service: str,
             source_type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("category", category)
        _setter("resource", resource)
        _setter("service", service)
        _setter("source_type", source_type)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Log object category.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        The unique identifier of the resource emitting the log.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Service generating log.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The log source.
        * **OCISERVICE:** Oracle Service.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class UnifiedAgentConfigurationGroupAssociation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupLists":
            suggest = "group_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationGroupAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationGroupAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationGroupAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_lists: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] group_lists: (Updatable) list of group/dynamic group ids associated with this configuration.
        """
        UnifiedAgentConfigurationGroupAssociation._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            group_lists=group_lists,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             group_lists: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if group_lists is not None:
            _setter("group_lists", group_lists)

    @property
    @pulumi.getter(name="groupLists")
    def group_lists(self) -> Optional[Sequence[str]]:
        """
        (Updatable) list of group/dynamic group ids associated with this configuration.
        """
        return pulumi.get(self, "group_lists")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationType":
            suggest = "configuration_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_type: str,
                 destination: 'outputs.UnifiedAgentConfigurationServiceConfigurationDestination',
                 sources: Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationSource']):
        """
        :param str configuration_type: (Updatable) Type of Unified Agent service configuration.
        :param 'UnifiedAgentConfigurationServiceConfigurationDestinationArgs' destination: (Updatable) Logging destination object.
        :param Sequence['UnifiedAgentConfigurationServiceConfigurationSourceArgs'] sources: (Updatable) Logging source object.
        """
        UnifiedAgentConfigurationServiceConfiguration._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            configuration_type=configuration_type,
            destination=destination,
            sources=sources,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             configuration_type: str,
             destination: 'outputs.UnifiedAgentConfigurationServiceConfigurationDestination',
             sources: Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationSource'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("configuration_type", configuration_type)
        _setter("destination", destination)
        _setter("sources", sources)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> str:
        """
        (Updatable) Type of Unified Agent service configuration.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.UnifiedAgentConfigurationServiceConfigurationDestination':
        """
        (Updatable) Logging destination object.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationSource']:
        """
        (Updatable) Logging source object.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logObjectId":
            suggest = "log_object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_object_id: str):
        """
        :param str log_object_id: (Updatable) The OCID of the resource.
        """
        UnifiedAgentConfigurationServiceConfigurationDestination._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            log_object_id=log_object_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             log_object_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("log_object_id", log_object_id)

    @property
    @pulumi.getter(name="logObjectId")
    def log_object_id(self) -> str:
        """
        (Updatable) The OCID of the resource.
        """
        return pulumi.get(self, "log_object_id")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_type: str,
                 channels: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 parser: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParser'] = None,
                 paths: Optional[Sequence[str]] = None):
        """
        :param str source_type: (Updatable) Unified schema logging source type.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param Sequence[str] channels: (Updatable) Windows event log channels.
        :param str name: (Updatable) The name key to tag this grok pattern.
        :param 'UnifiedAgentConfigurationServiceConfigurationSourceParserArgs' parser: (Updatable) source parser object.
        :param Sequence[str] paths: (Updatable) Absolute paths for log source files. Wildcard can be used.
        """
        UnifiedAgentConfigurationServiceConfigurationSource._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            source_type=source_type,
            channels=channels,
            name=name,
            parser=parser,
            paths=paths,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             source_type: str,
             channels: Optional[Sequence[str]] = None,
             name: Optional[str] = None,
             parser: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParser'] = None,
             paths: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("source_type", source_type)
        if channels is not None:
            _setter("channels", channels)
        if name is not None:
            _setter("name", name)
        if parser is not None:
            _setter("parser", parser)
        if paths is not None:
            _setter("paths", paths)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        (Updatable) Unified schema logging source type.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def channels(self) -> Optional[Sequence[str]]:
        """
        (Updatable) Windows event log channels.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) The name key to tag this grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parser(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParser']:
        """
        (Updatable) source parser object.
        """
        return pulumi.get(self, "parser")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        """
        (Updatable) Absolute paths for log source files. Wildcard can be used.
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationSourceParser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parserType":
            suggest = "parser_type"
        elif key == "fieldTimeKey":
            suggest = "field_time_key"
        elif key == "formatFirstline":
            suggest = "format_firstline"
        elif key == "grokFailureKey":
            suggest = "grok_failure_key"
        elif key == "grokNameKey":
            suggest = "grok_name_key"
        elif key == "isEstimateCurrentEvent":
            suggest = "is_estimate_current_event"
        elif key == "isKeepTimeKey":
            suggest = "is_keep_time_key"
        elif key == "isMergeCriFields":
            suggest = "is_merge_cri_fields"
        elif key == "isNullEmptyString":
            suggest = "is_null_empty_string"
        elif key == "isSupportColonlessIdent":
            suggest = "is_support_colonless_ident"
        elif key == "isWithPriority":
            suggest = "is_with_priority"
        elif key == "messageFormat":
            suggest = "message_format"
        elif key == "messageKey":
            suggest = "message_key"
        elif key == "multiLineStartRegexp":
            suggest = "multi_line_start_regexp"
        elif key == "nestedParser":
            suggest = "nested_parser"
        elif key == "nullValuePattern":
            suggest = "null_value_pattern"
        elif key == "rfc5424timeFormat":
            suggest = "rfc5424time_format"
        elif key == "syslogParserType":
            suggest = "syslog_parser_type"
        elif key == "timeFormat":
            suggest = "time_format"
        elif key == "timeType":
            suggest = "time_type"
        elif key == "timeoutInMilliseconds":
            suggest = "timeout_in_milliseconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationSourceParser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceParser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceParser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parser_type: str,
                 delimiter: Optional[str] = None,
                 expression: Optional[str] = None,
                 field_time_key: Optional[str] = None,
                 format_firstline: Optional[str] = None,
                 formats: Optional[Sequence[str]] = None,
                 grok_failure_key: Optional[str] = None,
                 grok_name_key: Optional[str] = None,
                 is_estimate_current_event: Optional[bool] = None,
                 is_keep_time_key: Optional[bool] = None,
                 is_merge_cri_fields: Optional[bool] = None,
                 is_null_empty_string: Optional[bool] = None,
                 is_support_colonless_ident: Optional[bool] = None,
                 is_with_priority: Optional[bool] = None,
                 keys: Optional[Sequence[str]] = None,
                 message_format: Optional[str] = None,
                 message_key: Optional[str] = None,
                 multi_line_start_regexp: Optional[str] = None,
                 nested_parser: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser'] = None,
                 null_value_pattern: Optional[str] = None,
                 patterns: Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParserPattern']] = None,
                 rfc5424time_format: Optional[str] = None,
                 syslog_parser_type: Optional[str] = None,
                 time_format: Optional[str] = None,
                 time_type: Optional[str] = None,
                 timeout_in_milliseconds: Optional[int] = None,
                 types: Optional[Mapping[str, Any]] = None):
        """
        :param str parser_type: (Updatable) Type of fluent parser.
        :param str delimiter: (Updatable) csv delimiter.
        :param str expression: (Updatable) Regex pattern.
        :param str field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str format_firstline: (Updatable) First line pattern format.
        :param Sequence[str] formats: (Updatable) Mutiline pattern format.
        :param str grok_failure_key: (Updatable) grok failure key.
        :param str grok_name_key: (Updatable) grok name key.
        :param bool is_estimate_current_event: (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when time_key is specified.
        :param bool is_keep_time_key: (Updatable) If true, keep time field in the record.
        :param bool is_merge_cri_fields: (Updatable) If you don't need stream/logtag fields, set this to false.
        :param bool is_null_empty_string: (Updatable) If true, an empty string field is replaced with nil.
        :param bool is_support_colonless_ident: (Updatable) Support colonless ident or not.
        :param bool is_with_priority: (Updatable) With priority or not.
        :param Sequence[str] keys: (Updatable) csv keys.
        :param str message_format: (Updatable) Message format of syslog.
        :param str message_key: (Updatable) Specifies the field name to contain logs.
        :param str multi_line_start_regexp: (Updatable) Multiline start regexp pattern.
        :param 'UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs' nested_parser: (Updatable) Optional nested JSON Parser for CRI Parser. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        :param str null_value_pattern: (Updatable) Specify the null value pattern.
        :param Sequence['UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs'] patterns: (Updatable) grok pattern object.
        :param str rfc5424time_format: (Updatable) rfc5424 time format.
        :param str syslog_parser_type: (Updatable) Syslog parser type.
        :param str time_format: (Updatable) Process time value using the specified format.
        :param str time_type: (Updatable) Time type of JSON parser.
        :param int timeout_in_milliseconds: (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        :param Mapping[str, Any] types: (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
               
               This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"
               
               is parsed as: 1362020400 (2013/02/28/ 12:00:00)
               
               record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        UnifiedAgentConfigurationServiceConfigurationSourceParser._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            parser_type=parser_type,
            delimiter=delimiter,
            expression=expression,
            field_time_key=field_time_key,
            format_firstline=format_firstline,
            formats=formats,
            grok_failure_key=grok_failure_key,
            grok_name_key=grok_name_key,
            is_estimate_current_event=is_estimate_current_event,
            is_keep_time_key=is_keep_time_key,
            is_merge_cri_fields=is_merge_cri_fields,
            is_null_empty_string=is_null_empty_string,
            is_support_colonless_ident=is_support_colonless_ident,
            is_with_priority=is_with_priority,
            keys=keys,
            message_format=message_format,
            message_key=message_key,
            multi_line_start_regexp=multi_line_start_regexp,
            nested_parser=nested_parser,
            null_value_pattern=null_value_pattern,
            patterns=patterns,
            rfc5424time_format=rfc5424time_format,
            syslog_parser_type=syslog_parser_type,
            time_format=time_format,
            time_type=time_type,
            timeout_in_milliseconds=timeout_in_milliseconds,
            types=types,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             parser_type: str,
             delimiter: Optional[str] = None,
             expression: Optional[str] = None,
             field_time_key: Optional[str] = None,
             format_firstline: Optional[str] = None,
             formats: Optional[Sequence[str]] = None,
             grok_failure_key: Optional[str] = None,
             grok_name_key: Optional[str] = None,
             is_estimate_current_event: Optional[bool] = None,
             is_keep_time_key: Optional[bool] = None,
             is_merge_cri_fields: Optional[bool] = None,
             is_null_empty_string: Optional[bool] = None,
             is_support_colonless_ident: Optional[bool] = None,
             is_with_priority: Optional[bool] = None,
             keys: Optional[Sequence[str]] = None,
             message_format: Optional[str] = None,
             message_key: Optional[str] = None,
             multi_line_start_regexp: Optional[str] = None,
             nested_parser: Optional['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser'] = None,
             null_value_pattern: Optional[str] = None,
             patterns: Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParserPattern']] = None,
             rfc5424time_format: Optional[str] = None,
             syslog_parser_type: Optional[str] = None,
             time_format: Optional[str] = None,
             time_type: Optional[str] = None,
             timeout_in_milliseconds: Optional[int] = None,
             types: Optional[Mapping[str, Any]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("parser_type", parser_type)
        if delimiter is not None:
            _setter("delimiter", delimiter)
        if expression is not None:
            _setter("expression", expression)
        if field_time_key is not None:
            _setter("field_time_key", field_time_key)
        if format_firstline is not None:
            _setter("format_firstline", format_firstline)
        if formats is not None:
            _setter("formats", formats)
        if grok_failure_key is not None:
            _setter("grok_failure_key", grok_failure_key)
        if grok_name_key is not None:
            _setter("grok_name_key", grok_name_key)
        if is_estimate_current_event is not None:
            _setter("is_estimate_current_event", is_estimate_current_event)
        if is_keep_time_key is not None:
            _setter("is_keep_time_key", is_keep_time_key)
        if is_merge_cri_fields is not None:
            _setter("is_merge_cri_fields", is_merge_cri_fields)
        if is_null_empty_string is not None:
            _setter("is_null_empty_string", is_null_empty_string)
        if is_support_colonless_ident is not None:
            _setter("is_support_colonless_ident", is_support_colonless_ident)
        if is_with_priority is not None:
            _setter("is_with_priority", is_with_priority)
        if keys is not None:
            _setter("keys", keys)
        if message_format is not None:
            _setter("message_format", message_format)
        if message_key is not None:
            _setter("message_key", message_key)
        if multi_line_start_regexp is not None:
            _setter("multi_line_start_regexp", multi_line_start_regexp)
        if nested_parser is not None:
            _setter("nested_parser", nested_parser)
        if null_value_pattern is not None:
            _setter("null_value_pattern", null_value_pattern)
        if patterns is not None:
            _setter("patterns", patterns)
        if rfc5424time_format is not None:
            _setter("rfc5424time_format", rfc5424time_format)
        if syslog_parser_type is not None:
            _setter("syslog_parser_type", syslog_parser_type)
        if time_format is not None:
            _setter("time_format", time_format)
        if time_type is not None:
            _setter("time_type", time_type)
        if timeout_in_milliseconds is not None:
            _setter("timeout_in_milliseconds", timeout_in_milliseconds)
        if types is not None:
            _setter("types", types)

    @property
    @pulumi.getter(name="parserType")
    def parser_type(self) -> str:
        """
        (Updatable) Type of fluent parser.
        """
        return pulumi.get(self, "parser_type")

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        (Updatable) csv delimiter.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        (Updatable) Regex pattern.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[str]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="formatFirstline")
    def format_firstline(self) -> Optional[str]:
        """
        (Updatable) First line pattern format.
        """
        return pulumi.get(self, "format_firstline")

    @property
    @pulumi.getter
    def formats(self) -> Optional[Sequence[str]]:
        """
        (Updatable) Mutiline pattern format.
        """
        return pulumi.get(self, "formats")

    @property
    @pulumi.getter(name="grokFailureKey")
    def grok_failure_key(self) -> Optional[str]:
        """
        (Updatable) grok failure key.
        """
        return pulumi.get(self, "grok_failure_key")

    @property
    @pulumi.getter(name="grokNameKey")
    def grok_name_key(self) -> Optional[str]:
        """
        (Updatable) grok name key.
        """
        return pulumi.get(self, "grok_name_key")

    @property
    @pulumi.getter(name="isEstimateCurrentEvent")
    def is_estimate_current_event(self) -> Optional[bool]:
        """
        (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when time_key is specified.
        """
        return pulumi.get(self, "is_estimate_current_event")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[bool]:
        """
        (Updatable) If true, keep time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="isMergeCriFields")
    def is_merge_cri_fields(self) -> Optional[bool]:
        """
        (Updatable) If you don't need stream/logtag fields, set this to false.
        """
        return pulumi.get(self, "is_merge_cri_fields")

    @property
    @pulumi.getter(name="isNullEmptyString")
    def is_null_empty_string(self) -> Optional[bool]:
        """
        (Updatable) If true, an empty string field is replaced with nil.
        """
        return pulumi.get(self, "is_null_empty_string")

    @property
    @pulumi.getter(name="isSupportColonlessIdent")
    def is_support_colonless_ident(self) -> Optional[bool]:
        """
        (Updatable) Support colonless ident or not.
        """
        return pulumi.get(self, "is_support_colonless_ident")

    @property
    @pulumi.getter(name="isWithPriority")
    def is_with_priority(self) -> Optional[bool]:
        """
        (Updatable) With priority or not.
        """
        return pulumi.get(self, "is_with_priority")

    @property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[str]]:
        """
        (Updatable) csv keys.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[str]:
        """
        (Updatable) Message format of syslog.
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="messageKey")
    def message_key(self) -> Optional[str]:
        """
        (Updatable) Specifies the field name to contain logs.
        """
        return pulumi.get(self, "message_key")

    @property
    @pulumi.getter(name="multiLineStartRegexp")
    def multi_line_start_regexp(self) -> Optional[str]:
        """
        (Updatable) Multiline start regexp pattern.
        """
        return pulumi.get(self, "multi_line_start_regexp")

    @property
    @pulumi.getter(name="nestedParser")
    def nested_parser(self) -> Optional['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser']:
        """
        (Updatable) Optional nested JSON Parser for CRI Parser. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        """
        return pulumi.get(self, "nested_parser")

    @property
    @pulumi.getter(name="nullValuePattern")
    def null_value_pattern(self) -> Optional[str]:
        """
        (Updatable) Specify the null value pattern.
        """
        return pulumi.get(self, "null_value_pattern")

    @property
    @pulumi.getter
    def patterns(self) -> Optional[Sequence['outputs.UnifiedAgentConfigurationServiceConfigurationSourceParserPattern']]:
        """
        (Updatable) grok pattern object.
        """
        return pulumi.get(self, "patterns")

    @property
    @pulumi.getter(name="rfc5424timeFormat")
    def rfc5424time_format(self) -> Optional[str]:
        """
        (Updatable) rfc5424 time format.
        """
        return pulumi.get(self, "rfc5424time_format")

    @property
    @pulumi.getter(name="syslogParserType")
    def syslog_parser_type(self) -> Optional[str]:
        """
        (Updatable) Syslog parser type.
        """
        return pulumi.get(self, "syslog_parser_type")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[str]:
        """
        (Updatable) Time type of JSON parser.
        """
        return pulumi.get(self, "time_type")

    @property
    @pulumi.getter(name="timeoutInMilliseconds")
    def timeout_in_milliseconds(self) -> Optional[int]:
        """
        (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        """
        return pulumi.get(self, "timeout_in_milliseconds")

    @property
    @pulumi.getter
    def types(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>

        This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"

        is parsed as: 1362020400 (2013/02/28/ 12:00:00)

        record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        return pulumi.get(self, "types")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldTimeKey":
            suggest = "field_time_key"
        elif key == "isKeepTimeKey":
            suggest = "is_keep_time_key"
        elif key == "timeFormat":
            suggest = "time_format"
        elif key == "timeType":
            suggest = "time_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_time_key: Optional[str] = None,
                 is_keep_time_key: Optional[bool] = None,
                 time_format: Optional[str] = None,
                 time_type: Optional[str] = None):
        """
        :param str field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param bool is_keep_time_key: (Updatable) If true, keep time field in the record.
        :param str time_format: (Updatable) Process time value using the specified format.
        :param str time_type: (Updatable) Time type of JSON parser.
        """
        UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParser._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            field_time_key=field_time_key,
            is_keep_time_key=is_keep_time_key,
            time_format=time_format,
            time_type=time_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             field_time_key: Optional[str] = None,
             is_keep_time_key: Optional[bool] = None,
             time_format: Optional[str] = None,
             time_type: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if field_time_key is not None:
            _setter("field_time_key", field_time_key)
        if is_keep_time_key is not None:
            _setter("is_keep_time_key", is_keep_time_key)
        if time_format is not None:
            _setter("time_format", time_format)
        if time_type is not None:
            _setter("time_type", time_type)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[str]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[bool]:
        """
        (Updatable) If true, keep time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[str]:
        """
        (Updatable) Time type of JSON parser.
        """
        return pulumi.get(self, "time_type")


@pulumi.output_type
class UnifiedAgentConfigurationServiceConfigurationSourceParserPattern(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldTimeFormat":
            suggest = "field_time_format"
        elif key == "fieldTimeKey":
            suggest = "field_time_key"
        elif key == "fieldTimeZone":
            suggest = "field_time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnifiedAgentConfigurationServiceConfigurationSourceParserPattern. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceParserPattern.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnifiedAgentConfigurationServiceConfigurationSourceParserPattern.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_time_format: Optional[str] = None,
                 field_time_key: Optional[str] = None,
                 field_time_zone: Optional[str] = None,
                 name: Optional[str] = None,
                 pattern: Optional[str] = None):
        """
        :param str field_time_format: (Updatable) Process value using the specified format. This is available only when time_type is a string.
        :param str field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str field_time_zone: (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        :param str name: (Updatable) The name key to tag this grok pattern.
        :param str pattern: (Updatable) The grok pattern.
        """
        UnifiedAgentConfigurationServiceConfigurationSourceParserPattern._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            field_time_format=field_time_format,
            field_time_key=field_time_key,
            field_time_zone=field_time_zone,
            name=name,
            pattern=pattern,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             field_time_format: Optional[str] = None,
             field_time_key: Optional[str] = None,
             field_time_zone: Optional[str] = None,
             name: Optional[str] = None,
             pattern: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if field_time_format is not None:
            _setter("field_time_format", field_time_format)
        if field_time_key is not None:
            _setter("field_time_key", field_time_key)
        if field_time_zone is not None:
            _setter("field_time_zone", field_time_zone)
        if name is not None:
            _setter("name", name)
        if pattern is not None:
            _setter("pattern", pattern)

    @property
    @pulumi.getter(name="fieldTimeFormat")
    def field_time_format(self) -> Optional[str]:
        """
        (Updatable) Process value using the specified format. This is available only when time_type is a string.
        """
        return pulumi.get(self, "field_time_format")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[str]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="fieldTimeZone")
    def field_time_zone(self) -> Optional[str]:
        """
        (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        """
        return pulumi.get(self, "field_time_zone")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) The name key to tag this grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        """
        (Updatable) The grok pattern.
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class GetLogConfigurationResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 sources: Sequence['outputs.GetLogConfigurationSourceResult']):
        """
        :param str compartment_id: The OCID of the compartment that the resource belongs to.
        :param Sequence['GetLogConfigurationSourceArgs'] sources: The source the log object comes from.
        """
        GetLogConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            sources=sources,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             sources: Sequence['outputs.GetLogConfigurationSourceResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("sources", sources)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetLogConfigurationSourceResult']:
        """
        The source the log object comes from.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class GetLogConfigurationSourceResult(dict):
    def __init__(__self__, *,
                 category: str,
                 resource: str,
                 service: str,
                 source_type: str):
        """
        :param str category: Log object category.
        :param str resource: The unique identifier of the resource emitting the log.
        :param str service: Service generating log.
        :param str source_type: The log source.
               * **OCISERVICE:** Oracle Service.
        """
        GetLogConfigurationSourceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            category=category,
            resource=resource,
            service=service,
            source_type=source_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             category: str,
             resource: str,
             service: str,
             source_type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("category", category)
        _setter("resource", resource)
        _setter("service", service)
        _setter("source_type", source_type)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Log object category.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        The unique identifier of the resource emitting the log.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Service generating log.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The log source.
        * **OCISERVICE:** Oracle Service.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetLogGroupsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetLogGroupsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLogGroupsLogGroupResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 state: str,
                 time_created: str,
                 time_last_modified: str):
        """
        :param str compartment_id: Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str description: Description for this resource.
        :param str display_name: Resource name.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the resource.
        :param str state: The log group object state.
        :param str time_created: Time the resource was created.
        :param str time_last_modified: Time the resource was last modified.
        """
        GetLogGroupsLogGroupResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            state=state,
            time_created=time_created,
            time_last_modified=time_last_modified,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             state: str,
             time_created: str,
             time_last_modified: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_last_modified", time_last_modified)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description for this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The log group object state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> str:
        """
        Time the resource was last modified.
        """
        return pulumi.get(self, "time_last_modified")


@pulumi.output_type
class GetLogSavedSearchesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Resource name.
        """
        GetLogSavedSearchesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLogSavedSearchesLogSavedSearchSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetLogSavedSearchesLogSavedSearchSummaryCollectionItemResult']):
        GetLogSavedSearchesLogSavedSearchSummaryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetLogSavedSearchesLogSavedSearchSummaryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetLogSavedSearchesLogSavedSearchSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetLogSavedSearchesLogSavedSearchSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 name: str,
                 query: str,
                 state: str,
                 time_created: str,
                 time_last_modified: str):
        """
        :param str compartment_id: Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str description: Description for this resource.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the resource.
        :param str name: Resource name.
        :param str query: The search query that is saved.
        :param str state: The state of the LogSavedSearch
        :param str time_created: Time the resource was created.
        :param str time_last_modified: Time the resource was last modified.
        """
        GetLogSavedSearchesLogSavedSearchSummaryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            freeform_tags=freeform_tags,
            id=id,
            name=name,
            query=query,
            state=state,
            time_created=time_created,
            time_last_modified=time_last_modified,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             name: str,
             query: str,
             state: str,
             time_created: str,
             time_last_modified: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("name", name)
        _setter("query", query)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_last_modified", time_last_modified)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description for this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        The search query that is saved.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the LogSavedSearch
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> str:
        """
        Time the resource was last modified.
        """
        return pulumi.get(self, "time_last_modified")


@pulumi.output_type
class GetLogsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetLogsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLogsLogResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 configurations: Sequence['outputs.GetLogsLogConfigurationResult'],
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_enabled: bool,
                 log_group_id: str,
                 log_type: str,
                 retention_duration: int,
                 state: str,
                 tenancy_id: str,
                 time_created: str,
                 time_last_modified: str):
        """
        :param str compartment_id: The OCID of the compartment that the resource belongs to.
        :param Sequence['GetLogsLogConfigurationArgs'] configurations: Log object configuration.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: Resource name.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the resource.
        :param bool is_enabled: Whether or not this resource is currently enabled.
        :param str log_group_id: OCID of a log group to work with.
        :param str log_type: The logType that the log object is for, whether custom or service.
        :param int retention_duration: Log retention duration in 30-day increments (30, 60, 90 and so on until 180).
        :param str state: Lifecycle state of the log object
        :param str tenancy_id: The OCID of the tenancy.
        :param str time_created: Time the resource was created.
        :param str time_last_modified: Time the resource was last modified.
        """
        GetLogsLogResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            configurations=configurations,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            is_enabled=is_enabled,
            log_group_id=log_group_id,
            log_type=log_type,
            retention_duration=retention_duration,
            state=state,
            tenancy_id=tenancy_id,
            time_created=time_created,
            time_last_modified=time_last_modified,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             configurations: Sequence['outputs.GetLogsLogConfigurationResult'],
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_enabled: bool,
             log_group_id: str,
             log_type: str,
             retention_duration: int,
             state: str,
             tenancy_id: str,
             time_created: str,
             time_last_modified: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("configurations", configurations)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_enabled", is_enabled)
        _setter("log_group_id", log_group_id)
        _setter("log_type", log_type)
        _setter("retention_duration", retention_duration)
        _setter("state", state)
        _setter("tenancy_id", tenancy_id)
        _setter("time_created", time_created)
        _setter("time_last_modified", time_last_modified)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetLogsLogConfigurationResult']:
        """
        Log object configuration.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether or not this resource is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> str:
        """
        OCID of a log group to work with.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The logType that the log object is for, whether custom or service.
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> int:
        """
        Log retention duration in 30-day increments (30, 60, 90 and so on until 180).
        """
        return pulumi.get(self, "retention_duration")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Lifecycle state of the log object
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> str:
        """
        The OCID of the tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> str:
        """
        Time the resource was last modified.
        """
        return pulumi.get(self, "time_last_modified")


@pulumi.output_type
class GetLogsLogConfigurationResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 sources: Sequence['outputs.GetLogsLogConfigurationSourceResult']):
        """
        :param str compartment_id: The OCID of the compartment that the resource belongs to.
        :param Sequence['GetLogsLogConfigurationSourceArgs'] sources: The source the log object comes from.
        """
        GetLogsLogConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            sources=sources,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             sources: Sequence['outputs.GetLogsLogConfigurationSourceResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("sources", sources)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetLogsLogConfigurationSourceResult']:
        """
        The source the log object comes from.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class GetLogsLogConfigurationSourceResult(dict):
    def __init__(__self__, *,
                 category: str,
                 resource: str,
                 service: str,
                 source_type: str):
        """
        :param str category: Log object category.
        :param str resource: The unique identifier of the resource emitting the log.
        :param str service: Service generating log.
        :param str source_type: The log source.
               * **OCISERVICE:** Oracle Service.
        """
        GetLogsLogConfigurationSourceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            category=category,
            resource=resource,
            service=service,
            source_type=source_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             category: str,
             resource: str,
             service: str,
             source_type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("category", category)
        _setter("resource", resource)
        _setter("service", service)
        _setter("source_type", source_type)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Log object category.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        The unique identifier of the resource emitting the log.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Service generating log.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The log source.
        * **OCISERVICE:** Oracle Service.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetUnifiedAgentConfigurationGroupAssociationResult(dict):
    def __init__(__self__, *,
                 group_lists: Sequence[str]):
        """
        :param Sequence[str] group_lists: list of group/dynamic group ids associated with this configuration.
        """
        GetUnifiedAgentConfigurationGroupAssociationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            group_lists=group_lists,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             group_lists: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("group_lists", group_lists)

    @property
    @pulumi.getter(name="groupLists")
    def group_lists(self) -> Sequence[str]:
        """
        list of group/dynamic group ids associated with this configuration.
        """
        return pulumi.get(self, "group_lists")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationResult(dict):
    def __init__(__self__, *,
                 configuration_type: str,
                 destinations: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationDestinationResult'],
                 sources: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceResult']):
        """
        :param str configuration_type: Type of Unified Agent service configuration.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationDestinationArgs'] destinations: Logging destination object.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationSourceArgs'] sources: Logging source object.
        """
        GetUnifiedAgentConfigurationServiceConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            configuration_type=configuration_type,
            destinations=destinations,
            sources=sources,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             configuration_type: str,
             destinations: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationDestinationResult'],
             sources: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("configuration_type", configuration_type)
        _setter("destinations", destinations)
        _setter("sources", sources)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> str:
        """
        Type of Unified Agent service configuration.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationDestinationResult']:
        """
        Logging destination object.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceResult']:
        """
        Logging source object.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationDestinationResult(dict):
    def __init__(__self__, *,
                 log_object_id: str):
        """
        :param str log_object_id: The OCID of the resource.
        """
        GetUnifiedAgentConfigurationServiceConfigurationDestinationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            log_object_id=log_object_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             log_object_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("log_object_id", log_object_id)

    @property
    @pulumi.getter(name="logObjectId")
    def log_object_id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "log_object_id")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationSourceResult(dict):
    def __init__(__self__, *,
                 channels: Sequence[str],
                 name: str,
                 parsers: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserResult'],
                 paths: Sequence[str],
                 source_type: str):
        """
        :param Sequence[str] channels: Windows event log channels.
        :param str name: The name key to tag this grok pattern.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationSourceParserArgs'] parsers: source parser object.
        :param Sequence[str] paths: Absolute paths for log source files. Wildcard can be used.
        :param str source_type: Unified schema logging source type.
        """
        GetUnifiedAgentConfigurationServiceConfigurationSourceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            channels=channels,
            name=name,
            parsers=parsers,
            paths=paths,
            source_type=source_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             channels: Sequence[str],
             name: str,
             parsers: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserResult'],
             paths: Sequence[str],
             source_type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("channels", channels)
        _setter("name", name)
        _setter("parsers", parsers)
        _setter("paths", paths)
        _setter("source_type", source_type)

    @property
    @pulumi.getter
    def channels(self) -> Sequence[str]:
        """
        Windows event log channels.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name key to tag this grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parsers(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserResult']:
        """
        source parser object.
        """
        return pulumi.get(self, "parsers")

    @property
    @pulumi.getter
    def paths(self) -> Sequence[str]:
        """
        Absolute paths for log source files. Wildcard can be used.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        Unified schema logging source type.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationSourceParserResult(dict):
    def __init__(__self__, *,
                 delimiter: str,
                 expression: str,
                 field_time_key: str,
                 format_firstline: str,
                 formats: Sequence[str],
                 grok_failure_key: str,
                 grok_name_key: str,
                 is_estimate_current_event: bool,
                 is_keep_time_key: bool,
                 is_merge_cri_fields: bool,
                 is_null_empty_string: bool,
                 is_support_colonless_ident: bool,
                 is_with_priority: bool,
                 keys: Sequence[str],
                 message_format: str,
                 message_key: str,
                 multi_line_start_regexp: str,
                 nested_parsers: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserResult'],
                 null_value_pattern: str,
                 parser_type: str,
                 patterns: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserPatternResult'],
                 rfc5424time_format: str,
                 syslog_parser_type: str,
                 time_format: str,
                 time_type: str,
                 timeout_in_milliseconds: int,
                 types: Mapping[str, Any]):
        """
        :param str delimiter: csv delimiter.
        :param str expression: Regex pattern.
        :param str field_time_key: Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str format_firstline: First line pattern format.
        :param Sequence[str] formats: Mutiline pattern format.
        :param str grok_failure_key: grok failure key.
        :param str grok_name_key: grok name key.
        :param bool is_estimate_current_event: If true, use Fluent::EventTime.now(current time) as a timestamp when time_key is specified.
        :param bool is_keep_time_key: If true, keep time field in the record.
        :param bool is_merge_cri_fields: If you don't need stream/logtag fields, set this to false for CRI parser.
        :param bool is_null_empty_string: If true, an empty string field is replaced with nil.
        :param bool is_support_colonless_ident: Support colonless ident or not.
        :param bool is_with_priority: With priority or not.
        :param Sequence[str] keys: csv keys.
        :param str message_format: Message format of syslog.
        :param str message_key: Specifies the field name to contain logs.
        :param str multi_line_start_regexp: Multiline start regexp pattern.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs'] nested_parsers: Optional nested JSON Parser for CRI Parser. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        :param str null_value_pattern: Specify the null value pattern.
        :param str parser_type: Type of fluent parser.
        :param Sequence['GetUnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs'] patterns: grok pattern object.
        :param str rfc5424time_format: rfc5424 time format.
        :param str syslog_parser_type: Syslog parser type.
        :param str time_format: Process time value using the specified format.
        :param str time_type: Time type of JSON parser.
        :param int timeout_in_milliseconds: Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        :param Mapping[str, Any] types: Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
        """
        GetUnifiedAgentConfigurationServiceConfigurationSourceParserResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            delimiter=delimiter,
            expression=expression,
            field_time_key=field_time_key,
            format_firstline=format_firstline,
            formats=formats,
            grok_failure_key=grok_failure_key,
            grok_name_key=grok_name_key,
            is_estimate_current_event=is_estimate_current_event,
            is_keep_time_key=is_keep_time_key,
            is_merge_cri_fields=is_merge_cri_fields,
            is_null_empty_string=is_null_empty_string,
            is_support_colonless_ident=is_support_colonless_ident,
            is_with_priority=is_with_priority,
            keys=keys,
            message_format=message_format,
            message_key=message_key,
            multi_line_start_regexp=multi_line_start_regexp,
            nested_parsers=nested_parsers,
            null_value_pattern=null_value_pattern,
            parser_type=parser_type,
            patterns=patterns,
            rfc5424time_format=rfc5424time_format,
            syslog_parser_type=syslog_parser_type,
            time_format=time_format,
            time_type=time_type,
            timeout_in_milliseconds=timeout_in_milliseconds,
            types=types,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             delimiter: str,
             expression: str,
             field_time_key: str,
             format_firstline: str,
             formats: Sequence[str],
             grok_failure_key: str,
             grok_name_key: str,
             is_estimate_current_event: bool,
             is_keep_time_key: bool,
             is_merge_cri_fields: bool,
             is_null_empty_string: bool,
             is_support_colonless_ident: bool,
             is_with_priority: bool,
             keys: Sequence[str],
             message_format: str,
             message_key: str,
             multi_line_start_regexp: str,
             nested_parsers: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserResult'],
             null_value_pattern: str,
             parser_type: str,
             patterns: Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserPatternResult'],
             rfc5424time_format: str,
             syslog_parser_type: str,
             time_format: str,
             time_type: str,
             timeout_in_milliseconds: int,
             types: Mapping[str, Any],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("delimiter", delimiter)
        _setter("expression", expression)
        _setter("field_time_key", field_time_key)
        _setter("format_firstline", format_firstline)
        _setter("formats", formats)
        _setter("grok_failure_key", grok_failure_key)
        _setter("grok_name_key", grok_name_key)
        _setter("is_estimate_current_event", is_estimate_current_event)
        _setter("is_keep_time_key", is_keep_time_key)
        _setter("is_merge_cri_fields", is_merge_cri_fields)
        _setter("is_null_empty_string", is_null_empty_string)
        _setter("is_support_colonless_ident", is_support_colonless_ident)
        _setter("is_with_priority", is_with_priority)
        _setter("keys", keys)
        _setter("message_format", message_format)
        _setter("message_key", message_key)
        _setter("multi_line_start_regexp", multi_line_start_regexp)
        _setter("nested_parsers", nested_parsers)
        _setter("null_value_pattern", null_value_pattern)
        _setter("parser_type", parser_type)
        _setter("patterns", patterns)
        _setter("rfc5424time_format", rfc5424time_format)
        _setter("syslog_parser_type", syslog_parser_type)
        _setter("time_format", time_format)
        _setter("time_type", time_type)
        _setter("timeout_in_milliseconds", timeout_in_milliseconds)
        _setter("types", types)

    @property
    @pulumi.getter
    def delimiter(self) -> str:
        """
        csv delimiter.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Regex pattern.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> str:
        """
        Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="formatFirstline")
    def format_firstline(self) -> str:
        """
        First line pattern format.
        """
        return pulumi.get(self, "format_firstline")

    @property
    @pulumi.getter
    def formats(self) -> Sequence[str]:
        """
        Mutiline pattern format.
        """
        return pulumi.get(self, "formats")

    @property
    @pulumi.getter(name="grokFailureKey")
    def grok_failure_key(self) -> str:
        """
        grok failure key.
        """
        return pulumi.get(self, "grok_failure_key")

    @property
    @pulumi.getter(name="grokNameKey")
    def grok_name_key(self) -> str:
        """
        grok name key.
        """
        return pulumi.get(self, "grok_name_key")

    @property
    @pulumi.getter(name="isEstimateCurrentEvent")
    def is_estimate_current_event(self) -> bool:
        """
        If true, use Fluent::EventTime.now(current time) as a timestamp when time_key is specified.
        """
        return pulumi.get(self, "is_estimate_current_event")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> bool:
        """
        If true, keep time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="isMergeCriFields")
    def is_merge_cri_fields(self) -> bool:
        """
        If you don't need stream/logtag fields, set this to false for CRI parser.
        """
        return pulumi.get(self, "is_merge_cri_fields")

    @property
    @pulumi.getter(name="isNullEmptyString")
    def is_null_empty_string(self) -> bool:
        """
        If true, an empty string field is replaced with nil.
        """
        return pulumi.get(self, "is_null_empty_string")

    @property
    @pulumi.getter(name="isSupportColonlessIdent")
    def is_support_colonless_ident(self) -> bool:
        """
        Support colonless ident or not.
        """
        return pulumi.get(self, "is_support_colonless_ident")

    @property
    @pulumi.getter(name="isWithPriority")
    def is_with_priority(self) -> bool:
        """
        With priority or not.
        """
        return pulumi.get(self, "is_with_priority")

    @property
    @pulumi.getter
    def keys(self) -> Sequence[str]:
        """
        csv keys.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> str:
        """
        Message format of syslog.
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="messageKey")
    def message_key(self) -> str:
        """
        Specifies the field name to contain logs.
        """
        return pulumi.get(self, "message_key")

    @property
    @pulumi.getter(name="multiLineStartRegexp")
    def multi_line_start_regexp(self) -> str:
        """
        Multiline start regexp pattern.
        """
        return pulumi.get(self, "multi_line_start_regexp")

    @property
    @pulumi.getter(name="nestedParsers")
    def nested_parsers(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserResult']:
        """
        Optional nested JSON Parser for CRI Parser. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        """
        return pulumi.get(self, "nested_parsers")

    @property
    @pulumi.getter(name="nullValuePattern")
    def null_value_pattern(self) -> str:
        """
        Specify the null value pattern.
        """
        return pulumi.get(self, "null_value_pattern")

    @property
    @pulumi.getter(name="parserType")
    def parser_type(self) -> str:
        """
        Type of fluent parser.
        """
        return pulumi.get(self, "parser_type")

    @property
    @pulumi.getter
    def patterns(self) -> Sequence['outputs.GetUnifiedAgentConfigurationServiceConfigurationSourceParserPatternResult']:
        """
        grok pattern object.
        """
        return pulumi.get(self, "patterns")

    @property
    @pulumi.getter(name="rfc5424timeFormat")
    def rfc5424time_format(self) -> str:
        """
        rfc5424 time format.
        """
        return pulumi.get(self, "rfc5424time_format")

    @property
    @pulumi.getter(name="syslogParserType")
    def syslog_parser_type(self) -> str:
        """
        Syslog parser type.
        """
        return pulumi.get(self, "syslog_parser_type")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> str:
        """
        Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> str:
        """
        Time type of JSON parser.
        """
        return pulumi.get(self, "time_type")

    @property
    @pulumi.getter(name="timeoutInMilliseconds")
    def timeout_in_milliseconds(self) -> int:
        """
        Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        """
        return pulumi.get(self, "timeout_in_milliseconds")

    @property
    @pulumi.getter
    def types(self) -> Mapping[str, Any]:
        """
        Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
        """
        return pulumi.get(self, "types")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserResult(dict):
    def __init__(__self__, *,
                 field_time_key: str,
                 is_keep_time_key: bool,
                 time_format: str,
                 time_type: str):
        """
        :param str field_time_key: Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param bool is_keep_time_key: If true, keep time field in the record.
        :param str time_format: Process time value using the specified format.
        :param str time_type: Time type of JSON parser.
        """
        GetUnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            field_time_key=field_time_key,
            is_keep_time_key=is_keep_time_key,
            time_format=time_format,
            time_type=time_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             field_time_key: str,
             is_keep_time_key: bool,
             time_format: str,
             time_type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("field_time_key", field_time_key)
        _setter("is_keep_time_key", is_keep_time_key)
        _setter("time_format", time_format)
        _setter("time_type", time_type)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> str:
        """
        Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> bool:
        """
        If true, keep time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> str:
        """
        Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> str:
        """
        Time type of JSON parser.
        """
        return pulumi.get(self, "time_type")


@pulumi.output_type
class GetUnifiedAgentConfigurationServiceConfigurationSourceParserPatternResult(dict):
    def __init__(__self__, *,
                 field_time_format: str,
                 field_time_key: str,
                 field_time_zone: str,
                 name: str,
                 pattern: str):
        """
        :param str field_time_format: Process value using the specified format. This is available only when time_type is a string.
        :param str field_time_key: Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param str field_time_zone: Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        :param str name: The name key to tag this grok pattern.
        :param str pattern: The grok pattern.
        """
        GetUnifiedAgentConfigurationServiceConfigurationSourceParserPatternResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            field_time_format=field_time_format,
            field_time_key=field_time_key,
            field_time_zone=field_time_zone,
            name=name,
            pattern=pattern,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             field_time_format: str,
             field_time_key: str,
             field_time_zone: str,
             name: str,
             pattern: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("field_time_format", field_time_format)
        _setter("field_time_key", field_time_key)
        _setter("field_time_zone", field_time_zone)
        _setter("name", name)
        _setter("pattern", pattern)

    @property
    @pulumi.getter(name="fieldTimeFormat")
    def field_time_format(self) -> str:
        """
        Process value using the specified format. This is available only when time_type is a string.
        """
        return pulumi.get(self, "field_time_format")

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> str:
        """
        Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @property
    @pulumi.getter(name="fieldTimeZone")
    def field_time_zone(self) -> str:
        """
        Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        """
        return pulumi.get(self, "field_time_zone")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name key to tag this grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        The grok pattern.
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class GetUnifiedAgentConfigurationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name key to tag this grok pattern.
        """
        GetUnifiedAgentConfigurationsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name key to tag this grok pattern.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionItemResult']):
        GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 configuration_state: str,
                 configuration_type: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_enabled: bool,
                 state: str,
                 time_created: str,
                 time_last_modified: str):
        """
        :param str compartment_id: Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
        :param str configuration_state: State of unified agent service configuration.
        :param str configuration_type: Type of Unified Agent service configuration.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str description: Description for this resource.
        :param str display_name: Resource name.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the resource.
        :param bool is_enabled: Whether or not this resource is currently enabled.
        :param str state: Lifecycle state of the log object
        :param str time_created: Time the resource was created.
        :param str time_last_modified: Time the resource was last modified.
        """
        GetUnifiedAgentConfigurationsUnifiedAgentConfigurationCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            configuration_state=configuration_state,
            configuration_type=configuration_type,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            is_enabled=is_enabled,
            state=state,
            time_created=time_created,
            time_last_modified=time_last_modified,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             configuration_state: str,
             configuration_type: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_enabled: bool,
             state: str,
             time_created: str,
             time_last_modified: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("configuration_state", configuration_state)
        _setter("configuration_type", configuration_type)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_enabled", is_enabled)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_last_modified", time_last_modified)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment OCID to list resources in. See compartmentIdInSubtree for nested compartments traversal.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configurationState")
    def configuration_state(self) -> str:
        """
        State of unified agent service configuration.
        """
        return pulumi.get(self, "configuration_state")

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> str:
        """
        Type of Unified Agent service configuration.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description for this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether or not this resource is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Lifecycle state of the log object
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastModified")
    def time_last_modified(self) -> str:
        """
        Time the resource was last modified.
        """
        return pulumi.get(self, "time_last_modified")


