# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScheduleArgs', 'Schedule']

@pulumi.input_type
class ScheduleArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 result_location: pulumi.Input['ScheduleResultLocationArgs'],
                 schedule_recurrences: pulumi.Input[str],
                 time_scheduled: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_file_format: Optional[pulumi.Input[str]] = None,
                 query_properties: Optional[pulumi.Input['ScheduleQueryPropertiesArgs']] = None,
                 saved_report_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Schedule resource.
        :param pulumi.Input[str] compartment_id: The customer tenancy.
        :param pulumi.Input['ScheduleResultLocationArgs'] result_location: (Updatable) The location where usage or cost CSVs will be uploaded defined by `locationType`, which corresponds with type-specific characteristics.
        :param pulumi.Input[str] schedule_recurrences: Specifies the frequency according to when the schedule will be run,  in the x-obmcs-recurring-time format described in [RFC 5545 section 3.3.10](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported values are : ONE_TIME, DAILY, WEEKLY and MONTHLY.
        :param pulumi.Input[str] time_scheduled: The date and time of the first time job execution.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) The description of the schedule.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] name: The unique name of the user-created schedule.
        :param pulumi.Input[str] output_file_format: (Updatable) Specifies supported output file format.
        :param pulumi.Input['ScheduleQueryPropertiesArgs'] query_properties: The query properties.
        :param pulumi.Input[str] saved_report_id: The saved report id which can also be used to generate query.
        """
        ScheduleArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            result_location=result_location,
            schedule_recurrences=schedule_recurrences,
            time_scheduled=time_scheduled,
            defined_tags=defined_tags,
            description=description,
            freeform_tags=freeform_tags,
            name=name,
            output_file_format=output_file_format,
            query_properties=query_properties,
            saved_report_id=saved_report_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             result_location: pulumi.Input['ScheduleResultLocationArgs'],
             schedule_recurrences: pulumi.Input[str],
             time_scheduled: pulumi.Input[str],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             name: Optional[pulumi.Input[str]] = None,
             output_file_format: Optional[pulumi.Input[str]] = None,
             query_properties: Optional[pulumi.Input['ScheduleQueryPropertiesArgs']] = None,
             saved_report_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("result_location", result_location)
        _setter("schedule_recurrences", schedule_recurrences)
        _setter("time_scheduled", time_scheduled)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if name is not None:
            _setter("name", name)
        if output_file_format is not None:
            _setter("output_file_format", output_file_format)
        if query_properties is not None:
            _setter("query_properties", query_properties)
        if saved_report_id is not None:
            _setter("saved_report_id", saved_report_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The customer tenancy.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="resultLocation")
    def result_location(self) -> pulumi.Input['ScheduleResultLocationArgs']:
        """
        (Updatable) The location where usage or cost CSVs will be uploaded defined by `locationType`, which corresponds with type-specific characteristics.
        """
        return pulumi.get(self, "result_location")

    @result_location.setter
    def result_location(self, value: pulumi.Input['ScheduleResultLocationArgs']):
        pulumi.set(self, "result_location", value)

    @property
    @pulumi.getter(name="scheduleRecurrences")
    def schedule_recurrences(self) -> pulumi.Input[str]:
        """
        Specifies the frequency according to when the schedule will be run,  in the x-obmcs-recurring-time format described in [RFC 5545 section 3.3.10](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported values are : ONE_TIME, DAILY, WEEKLY and MONTHLY.
        """
        return pulumi.get(self, "schedule_recurrences")

    @schedule_recurrences.setter
    def schedule_recurrences(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule_recurrences", value)

    @property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> pulumi.Input[str]:
        """
        The date and time of the first time job execution.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_scheduled")

    @time_scheduled.setter
    def time_scheduled(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_scheduled", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the schedule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the user-created schedule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputFileFormat")
    def output_file_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies supported output file format.
        """
        return pulumi.get(self, "output_file_format")

    @output_file_format.setter
    def output_file_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_file_format", value)

    @property
    @pulumi.getter(name="queryProperties")
    def query_properties(self) -> Optional[pulumi.Input['ScheduleQueryPropertiesArgs']]:
        """
        The query properties.
        """
        return pulumi.get(self, "query_properties")

    @query_properties.setter
    def query_properties(self, value: Optional[pulumi.Input['ScheduleQueryPropertiesArgs']]):
        pulumi.set(self, "query_properties", value)

    @property
    @pulumi.getter(name="savedReportId")
    def saved_report_id(self) -> Optional[pulumi.Input[str]]:
        """
        The saved report id which can also be used to generate query.
        """
        return pulumi.get(self, "saved_report_id")

    @saved_report_id.setter
    def saved_report_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saved_report_id", value)


@pulumi.input_type
class _ScheduleState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_file_format: Optional[pulumi.Input[str]] = None,
                 query_properties: Optional[pulumi.Input['ScheduleQueryPropertiesArgs']] = None,
                 result_location: Optional[pulumi.Input['ScheduleResultLocationArgs']] = None,
                 saved_report_id: Optional[pulumi.Input[str]] = None,
                 schedule_recurrences: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_next_run: Optional[pulumi.Input[str]] = None,
                 time_scheduled: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Schedule resources.
        :param pulumi.Input[str] compartment_id: The customer tenancy.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) The description of the schedule.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] name: The unique name of the user-created schedule.
        :param pulumi.Input[str] output_file_format: (Updatable) Specifies supported output file format.
        :param pulumi.Input['ScheduleQueryPropertiesArgs'] query_properties: The query properties.
        :param pulumi.Input['ScheduleResultLocationArgs'] result_location: (Updatable) The location where usage or cost CSVs will be uploaded defined by `locationType`, which corresponds with type-specific characteristics.
        :param pulumi.Input[str] saved_report_id: The saved report id which can also be used to generate query.
        :param pulumi.Input[str] schedule_recurrences: Specifies the frequency according to when the schedule will be run,  in the x-obmcs-recurring-time format described in [RFC 5545 section 3.3.10](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported values are : ONE_TIME, DAILY, WEEKLY and MONTHLY.
        :param pulumi.Input[str] state: The schedule lifecycle state.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the schedule was created.
        :param pulumi.Input[str] time_next_run: The date and time of the next job execution.
        :param pulumi.Input[str] time_scheduled: The date and time of the first time job execution.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        _ScheduleState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            freeform_tags=freeform_tags,
            name=name,
            output_file_format=output_file_format,
            query_properties=query_properties,
            result_location=result_location,
            saved_report_id=saved_report_id,
            schedule_recurrences=schedule_recurrences,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_next_run=time_next_run,
            time_scheduled=time_scheduled,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             name: Optional[pulumi.Input[str]] = None,
             output_file_format: Optional[pulumi.Input[str]] = None,
             query_properties: Optional[pulumi.Input['ScheduleQueryPropertiesArgs']] = None,
             result_location: Optional[pulumi.Input['ScheduleResultLocationArgs']] = None,
             saved_report_id: Optional[pulumi.Input[str]] = None,
             schedule_recurrences: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_next_run: Optional[pulumi.Input[str]] = None,
             time_scheduled: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if name is not None:
            _setter("name", name)
        if output_file_format is not None:
            _setter("output_file_format", output_file_format)
        if query_properties is not None:
            _setter("query_properties", query_properties)
        if result_location is not None:
            _setter("result_location", result_location)
        if saved_report_id is not None:
            _setter("saved_report_id", saved_report_id)
        if schedule_recurrences is not None:
            _setter("schedule_recurrences", schedule_recurrences)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_next_run is not None:
            _setter("time_next_run", time_next_run)
        if time_scheduled is not None:
            _setter("time_scheduled", time_scheduled)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The customer tenancy.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the schedule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the user-created schedule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputFileFormat")
    def output_file_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies supported output file format.
        """
        return pulumi.get(self, "output_file_format")

    @output_file_format.setter
    def output_file_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_file_format", value)

    @property
    @pulumi.getter(name="queryProperties")
    def query_properties(self) -> Optional[pulumi.Input['ScheduleQueryPropertiesArgs']]:
        """
        The query properties.
        """
        return pulumi.get(self, "query_properties")

    @query_properties.setter
    def query_properties(self, value: Optional[pulumi.Input['ScheduleQueryPropertiesArgs']]):
        pulumi.set(self, "query_properties", value)

    @property
    @pulumi.getter(name="resultLocation")
    def result_location(self) -> Optional[pulumi.Input['ScheduleResultLocationArgs']]:
        """
        (Updatable) The location where usage or cost CSVs will be uploaded defined by `locationType`, which corresponds with type-specific characteristics.
        """
        return pulumi.get(self, "result_location")

    @result_location.setter
    def result_location(self, value: Optional[pulumi.Input['ScheduleResultLocationArgs']]):
        pulumi.set(self, "result_location", value)

    @property
    @pulumi.getter(name="savedReportId")
    def saved_report_id(self) -> Optional[pulumi.Input[str]]:
        """
        The saved report id which can also be used to generate query.
        """
        return pulumi.get(self, "saved_report_id")

    @saved_report_id.setter
    def saved_report_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saved_report_id", value)

    @property
    @pulumi.getter(name="scheduleRecurrences")
    def schedule_recurrences(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the frequency according to when the schedule will be run,  in the x-obmcs-recurring-time format described in [RFC 5545 section 3.3.10](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported values are : ONE_TIME, DAILY, WEEKLY and MONTHLY.
        """
        return pulumi.get(self, "schedule_recurrences")

    @schedule_recurrences.setter
    def schedule_recurrences(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_recurrences", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The schedule lifecycle state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the schedule was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeNextRun")
    def time_next_run(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the next job execution.
        """
        return pulumi.get(self, "time_next_run")

    @time_next_run.setter
    def time_next_run(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_next_run", value)

    @property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the first time job execution.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_scheduled")

    @time_scheduled.setter
    def time_scheduled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_scheduled", value)


class Schedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_file_format: Optional[pulumi.Input[str]] = None,
                 query_properties: Optional[pulumi.Input[pulumi.InputType['ScheduleQueryPropertiesArgs']]] = None,
                 result_location: Optional[pulumi.Input[pulumi.InputType['ScheduleResultLocationArgs']]] = None,
                 saved_report_id: Optional[pulumi.Input[str]] = None,
                 schedule_recurrences: Optional[pulumi.Input[str]] = None,
                 time_scheduled: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Schedule resource in Oracle Cloud Infrastructure Metering Computation service.

        Returns the created schedule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_schedule = oci.metering_computation.Schedule("testSchedule",
            compartment_id=var["compartment_id"],
            result_location=oci.metering_computation.ScheduleResultLocationArgs(
                bucket=var["schedule_result_location_bucket"],
                location_type=var["schedule_result_location_location_type"],
                namespace=var["schedule_result_location_namespace"],
                region=var["schedule_result_location_region"],
            ),
            schedule_recurrences=var["schedule_schedule_recurrences"],
            time_scheduled=var["schedule_time_scheduled"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["schedule_description"],
            freeform_tags={
                "bar-key": "value",
            },
            output_file_format=var["schedule_output_file_format"],
            query_properties=oci.metering_computation.ScheduleQueryPropertiesArgs(
                date_range=oci.metering_computation.ScheduleQueryPropertiesDateRangeArgs(
                    date_range_type=var["schedule_query_properties_date_range_date_range_type"],
                    dynamic_date_range_type=var["schedule_query_properties_date_range_dynamic_date_range_type"],
                    time_usage_ended=var["schedule_query_properties_date_range_time_usage_ended"],
                    time_usage_started=var["schedule_query_properties_date_range_time_usage_started"],
                ),
                granularity=var["schedule_query_properties_granularity"],
                compartment_depth=var["schedule_query_properties_compartment_depth"],
                filter=var["schedule_query_properties_filter"],
                group_bies=var["schedule_query_properties_group_by"],
                group_by_tags=[oci.metering_computation.ScheduleQueryPropertiesGroupByTagArgs(
                    key=var["schedule_query_properties_group_by_tag_key"],
                    namespace=var["schedule_query_properties_group_by_tag_namespace"],
                    value=var["schedule_query_properties_group_by_tag_value"],
                )],
                is_aggregate_by_time=var["schedule_query_properties_is_aggregate_by_time"],
                query_type=var["schedule_query_properties_query_type"],
            ),
            saved_report_id=oci_data_safe_report["test_report"]["id"])
        ```

        ## Import

        Schedules can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:MeteringComputation/schedule:Schedule test_schedule "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The customer tenancy.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) The description of the schedule.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] name: The unique name of the user-created schedule.
        :param pulumi.Input[str] output_file_format: (Updatable) Specifies supported output file format.
        :param pulumi.Input[pulumi.InputType['ScheduleQueryPropertiesArgs']] query_properties: The query properties.
        :param pulumi.Input[pulumi.InputType['ScheduleResultLocationArgs']] result_location: (Updatable) The location where usage or cost CSVs will be uploaded defined by `locationType`, which corresponds with type-specific characteristics.
        :param pulumi.Input[str] saved_report_id: The saved report id which can also be used to generate query.
        :param pulumi.Input[str] schedule_recurrences: Specifies the frequency according to when the schedule will be run,  in the x-obmcs-recurring-time format described in [RFC 5545 section 3.3.10](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported values are : ONE_TIME, DAILY, WEEKLY and MONTHLY.
        :param pulumi.Input[str] time_scheduled: The date and time of the first time job execution.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Schedule resource in Oracle Cloud Infrastructure Metering Computation service.

        Returns the created schedule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_schedule = oci.metering_computation.Schedule("testSchedule",
            compartment_id=var["compartment_id"],
            result_location=oci.metering_computation.ScheduleResultLocationArgs(
                bucket=var["schedule_result_location_bucket"],
                location_type=var["schedule_result_location_location_type"],
                namespace=var["schedule_result_location_namespace"],
                region=var["schedule_result_location_region"],
            ),
            schedule_recurrences=var["schedule_schedule_recurrences"],
            time_scheduled=var["schedule_time_scheduled"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["schedule_description"],
            freeform_tags={
                "bar-key": "value",
            },
            output_file_format=var["schedule_output_file_format"],
            query_properties=oci.metering_computation.ScheduleQueryPropertiesArgs(
                date_range=oci.metering_computation.ScheduleQueryPropertiesDateRangeArgs(
                    date_range_type=var["schedule_query_properties_date_range_date_range_type"],
                    dynamic_date_range_type=var["schedule_query_properties_date_range_dynamic_date_range_type"],
                    time_usage_ended=var["schedule_query_properties_date_range_time_usage_ended"],
                    time_usage_started=var["schedule_query_properties_date_range_time_usage_started"],
                ),
                granularity=var["schedule_query_properties_granularity"],
                compartment_depth=var["schedule_query_properties_compartment_depth"],
                filter=var["schedule_query_properties_filter"],
                group_bies=var["schedule_query_properties_group_by"],
                group_by_tags=[oci.metering_computation.ScheduleQueryPropertiesGroupByTagArgs(
                    key=var["schedule_query_properties_group_by_tag_key"],
                    namespace=var["schedule_query_properties_group_by_tag_namespace"],
                    value=var["schedule_query_properties_group_by_tag_value"],
                )],
                is_aggregate_by_time=var["schedule_query_properties_is_aggregate_by_time"],
                query_type=var["schedule_query_properties_query_type"],
            ),
            saved_report_id=oci_data_safe_report["test_report"]["id"])
        ```

        ## Import

        Schedules can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:MeteringComputation/schedule:Schedule test_schedule "id"
        ```

        :param str resource_name: The name of the resource.
        :param ScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ScheduleArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_file_format: Optional[pulumi.Input[str]] = None,
                 query_properties: Optional[pulumi.Input[pulumi.InputType['ScheduleQueryPropertiesArgs']]] = None,
                 result_location: Optional[pulumi.Input[pulumi.InputType['ScheduleResultLocationArgs']]] = None,
                 saved_report_id: Optional[pulumi.Input[str]] = None,
                 schedule_recurrences: Optional[pulumi.Input[str]] = None,
                 time_scheduled: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduleArgs.__new__(ScheduleArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["name"] = name
            __props__.__dict__["output_file_format"] = output_file_format
            if query_properties is not None and not isinstance(query_properties, ScheduleQueryPropertiesArgs):
                query_properties = query_properties or {}
                def _setter(key, value):
                    query_properties[key] = value
                ScheduleQueryPropertiesArgs._configure(_setter, **query_properties)
            __props__.__dict__["query_properties"] = query_properties
            if result_location is not None and not isinstance(result_location, ScheduleResultLocationArgs):
                result_location = result_location or {}
                def _setter(key, value):
                    result_location[key] = value
                ScheduleResultLocationArgs._configure(_setter, **result_location)
            if result_location is None and not opts.urn:
                raise TypeError("Missing required property 'result_location'")
            __props__.__dict__["result_location"] = result_location
            __props__.__dict__["saved_report_id"] = saved_report_id
            if schedule_recurrences is None and not opts.urn:
                raise TypeError("Missing required property 'schedule_recurrences'")
            __props__.__dict__["schedule_recurrences"] = schedule_recurrences
            if time_scheduled is None and not opts.urn:
                raise TypeError("Missing required property 'time_scheduled'")
            __props__.__dict__["time_scheduled"] = time_scheduled
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_next_run"] = None
        super(Schedule, __self__).__init__(
            'oci:MeteringComputation/schedule:Schedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            output_file_format: Optional[pulumi.Input[str]] = None,
            query_properties: Optional[pulumi.Input[pulumi.InputType['ScheduleQueryPropertiesArgs']]] = None,
            result_location: Optional[pulumi.Input[pulumi.InputType['ScheduleResultLocationArgs']]] = None,
            saved_report_id: Optional[pulumi.Input[str]] = None,
            schedule_recurrences: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_next_run: Optional[pulumi.Input[str]] = None,
            time_scheduled: Optional[pulumi.Input[str]] = None) -> 'Schedule':
        """
        Get an existing Schedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The customer tenancy.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) The description of the schedule.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] name: The unique name of the user-created schedule.
        :param pulumi.Input[str] output_file_format: (Updatable) Specifies supported output file format.
        :param pulumi.Input[pulumi.InputType['ScheduleQueryPropertiesArgs']] query_properties: The query properties.
        :param pulumi.Input[pulumi.InputType['ScheduleResultLocationArgs']] result_location: (Updatable) The location where usage or cost CSVs will be uploaded defined by `locationType`, which corresponds with type-specific characteristics.
        :param pulumi.Input[str] saved_report_id: The saved report id which can also be used to generate query.
        :param pulumi.Input[str] schedule_recurrences: Specifies the frequency according to when the schedule will be run,  in the x-obmcs-recurring-time format described in [RFC 5545 section 3.3.10](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported values are : ONE_TIME, DAILY, WEEKLY and MONTHLY.
        :param pulumi.Input[str] state: The schedule lifecycle state.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the schedule was created.
        :param pulumi.Input[str] time_next_run: The date and time of the next job execution.
        :param pulumi.Input[str] time_scheduled: The date and time of the first time job execution.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduleState.__new__(_ScheduleState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["name"] = name
        __props__.__dict__["output_file_format"] = output_file_format
        __props__.__dict__["query_properties"] = query_properties
        __props__.__dict__["result_location"] = result_location
        __props__.__dict__["saved_report_id"] = saved_report_id
        __props__.__dict__["schedule_recurrences"] = schedule_recurrences
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_next_run"] = time_next_run
        __props__.__dict__["time_scheduled"] = time_scheduled
        return Schedule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The customer tenancy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the schedule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The unique name of the user-created schedule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputFileFormat")
    def output_file_format(self) -> pulumi.Output[str]:
        """
        (Updatable) Specifies supported output file format.
        """
        return pulumi.get(self, "output_file_format")

    @property
    @pulumi.getter(name="queryProperties")
    def query_properties(self) -> pulumi.Output['outputs.ScheduleQueryProperties']:
        """
        The query properties.
        """
        return pulumi.get(self, "query_properties")

    @property
    @pulumi.getter(name="resultLocation")
    def result_location(self) -> pulumi.Output['outputs.ScheduleResultLocation']:
        """
        (Updatable) The location where usage or cost CSVs will be uploaded defined by `locationType`, which corresponds with type-specific characteristics.
        """
        return pulumi.get(self, "result_location")

    @property
    @pulumi.getter(name="savedReportId")
    def saved_report_id(self) -> pulumi.Output[str]:
        """
        The saved report id which can also be used to generate query.
        """
        return pulumi.get(self, "saved_report_id")

    @property
    @pulumi.getter(name="scheduleRecurrences")
    def schedule_recurrences(self) -> pulumi.Output[str]:
        """
        Specifies the frequency according to when the schedule will be run,  in the x-obmcs-recurring-time format described in [RFC 5545 section 3.3.10](https://datatracker.ietf.org/doc/html/rfc5545#section-3.3.10). Supported values are : ONE_TIME, DAILY, WEEKLY and MONTHLY.
        """
        return pulumi.get(self, "schedule_recurrences")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The schedule lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the schedule was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeNextRun")
    def time_next_run(self) -> pulumi.Output[str]:
        """
        The date and time of the next job execution.
        """
        return pulumi.get(self, "time_next_run")

    @property
    @pulumi.getter(name="timeScheduled")
    def time_scheduled(self) -> pulumi.Output[str]:
        """
        The date and time of the first time job execution.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_scheduled")

