# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetOceInstancesFilterResult',
    'GetOceInstancesOceInstanceResult',
]

@pulumi.output_type
class GetOceInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: OceInstance Name
        """
        GetOceInstancesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        OceInstance Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOceInstancesOceInstanceResult(dict):
    def __init__(__self__, *,
                 add_on_features: Sequence[str],
                 admin_email: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 dr_region: str,
                 freeform_tags: Mapping[str, Any],
                 guid: str,
                 id: str,
                 idcs_access_token: str,
                 idcs_tenancy: str,
                 instance_access_type: str,
                 instance_license_type: str,
                 instance_usage_type: str,
                 lifecycle_details: str,
                 name: str,
                 object_storage_namespace: str,
                 service: Mapping[str, Any],
                 state: str,
                 state_message: str,
                 system_tags: Mapping[str, Any],
                 tenancy_id: str,
                 tenancy_name: str,
                 time_created: str,
                 time_updated: str,
                 upgrade_schedule: str,
                 waf_primary_domain: str):
        """
        :param Sequence[str] add_on_features: a list of add-on features for the ocm instance
        :param str admin_email: Admin Email for Notification
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: OceInstance description, can be updated
        :param str dr_region: disaster recovery paired ragion name
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str guid: Unique GUID identifier that is immutable on creation
        :param str id: Unique identifier that is immutable on creation
        :param str idcs_tenancy: IDCS Tenancy Identifier
        :param str instance_access_type: Flag indicating whether the instance access is private or public
        :param str instance_license_type: Flag indicating whether the instance license is new cloud or bring your own license
        :param str instance_usage_type: Instance type based on its usage
        :param str lifecycle_details: Details of the current state of the instance lifecycle
        :param str name: OceInstance Name
        :param str object_storage_namespace: Object Storage Namespace of tenancy
        :param Mapping[str, Any] service: SERVICE data. Example: `{"service": {"IDCS": "value"}}`
        :param str state: Filter results on lifecycleState.
        :param str state_message: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str tenancy_id: The ID of the tenancy in which to list resources.
        :param str tenancy_name: Tenancy Name
        :param str time_created: The time the the OceInstance was created. An RFC3339 formatted datetime string
        :param str time_updated: The time the OceInstance was updated. An RFC3339 formatted datetime string
        :param str upgrade_schedule: Upgrade schedule type representing service to be upgraded immediately whenever latest version is released or delay upgrade of the service to previous released version
        :param str waf_primary_domain: Web Application Firewall(WAF) primary domain
        """
        GetOceInstancesOceInstanceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            add_on_features=add_on_features,
            admin_email=admin_email,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            dr_region=dr_region,
            freeform_tags=freeform_tags,
            guid=guid,
            id=id,
            idcs_access_token=idcs_access_token,
            idcs_tenancy=idcs_tenancy,
            instance_access_type=instance_access_type,
            instance_license_type=instance_license_type,
            instance_usage_type=instance_usage_type,
            lifecycle_details=lifecycle_details,
            name=name,
            object_storage_namespace=object_storage_namespace,
            service=service,
            state=state,
            state_message=state_message,
            system_tags=system_tags,
            tenancy_id=tenancy_id,
            tenancy_name=tenancy_name,
            time_created=time_created,
            time_updated=time_updated,
            upgrade_schedule=upgrade_schedule,
            waf_primary_domain=waf_primary_domain,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             add_on_features: Sequence[str],
             admin_email: str,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             dr_region: str,
             freeform_tags: Mapping[str, Any],
             guid: str,
             id: str,
             idcs_access_token: str,
             idcs_tenancy: str,
             instance_access_type: str,
             instance_license_type: str,
             instance_usage_type: str,
             lifecycle_details: str,
             name: str,
             object_storage_namespace: str,
             service: Mapping[str, Any],
             state: str,
             state_message: str,
             system_tags: Mapping[str, Any],
             tenancy_id: str,
             tenancy_name: str,
             time_created: str,
             time_updated: str,
             upgrade_schedule: str,
             waf_primary_domain: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("add_on_features", add_on_features)
        _setter("admin_email", admin_email)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("dr_region", dr_region)
        _setter("freeform_tags", freeform_tags)
        _setter("guid", guid)
        _setter("id", id)
        _setter("idcs_access_token", idcs_access_token)
        _setter("idcs_tenancy", idcs_tenancy)
        _setter("instance_access_type", instance_access_type)
        _setter("instance_license_type", instance_license_type)
        _setter("instance_usage_type", instance_usage_type)
        _setter("lifecycle_details", lifecycle_details)
        _setter("name", name)
        _setter("object_storage_namespace", object_storage_namespace)
        _setter("service", service)
        _setter("state", state)
        _setter("state_message", state_message)
        _setter("system_tags", system_tags)
        _setter("tenancy_id", tenancy_id)
        _setter("tenancy_name", tenancy_name)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("upgrade_schedule", upgrade_schedule)
        _setter("waf_primary_domain", waf_primary_domain)

    @property
    @pulumi.getter(name="addOnFeatures")
    def add_on_features(self) -> Sequence[str]:
        """
        a list of add-on features for the ocm instance
        """
        return pulumi.get(self, "add_on_features")

    @property
    @pulumi.getter(name="adminEmail")
    def admin_email(self) -> str:
        """
        Admin Email for Notification
        """
        return pulumi.get(self, "admin_email")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        OceInstance description, can be updated
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="drRegion")
    def dr_region(self) -> str:
        """
        disaster recovery paired ragion name
        """
        return pulumi.get(self, "dr_region")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def guid(self) -> str:
        """
        Unique GUID identifier that is immutable on creation
        """
        return pulumi.get(self, "guid")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> str:
        return pulumi.get(self, "idcs_access_token")

    @property
    @pulumi.getter(name="idcsTenancy")
    def idcs_tenancy(self) -> str:
        """
        IDCS Tenancy Identifier
        """
        return pulumi.get(self, "idcs_tenancy")

    @property
    @pulumi.getter(name="instanceAccessType")
    def instance_access_type(self) -> str:
        """
        Flag indicating whether the instance access is private or public
        """
        return pulumi.get(self, "instance_access_type")

    @property
    @pulumi.getter(name="instanceLicenseType")
    def instance_license_type(self) -> str:
        """
        Flag indicating whether the instance license is new cloud or bring your own license
        """
        return pulumi.get(self, "instance_license_type")

    @property
    @pulumi.getter(name="instanceUsageType")
    def instance_usage_type(self) -> str:
        """
        Instance type based on its usage
        """
        return pulumi.get(self, "instance_usage_type")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details of the current state of the instance lifecycle
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        OceInstance Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectStorageNamespace")
    def object_storage_namespace(self) -> str:
        """
        Object Storage Namespace of tenancy
        """
        return pulumi.get(self, "object_storage_namespace")

    @property
    @pulumi.getter
    def service(self) -> Mapping[str, Any]:
        """
        SERVICE data. Example: `{"service": {"IDCS": "value"}}`
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Filter results on lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> str:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> str:
        """
        The ID of the tenancy in which to list resources.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="tenancyName")
    def tenancy_name(self) -> str:
        """
        Tenancy Name
        """
        return pulumi.get(self, "tenancy_name")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the OceInstance was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the OceInstance was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="upgradeSchedule")
    def upgrade_schedule(self) -> str:
        """
        Upgrade schedule type representing service to be upgraded immediately whenever latest version is released or delay upgrade of the service to previous released version
        """
        return pulumi.get(self, "upgrade_schedule")

    @property
    @pulumi.getter(name="wafPrimaryDomain")
    def waf_primary_domain(self) -> str:
        """
        Web Application Firewall(WAF) primary domain
        """
        return pulumi.get(self, "waf_primary_domain")


