# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSupportedVmwareSoftwareVersionsResult',
    'AwaitableGetSupportedVmwareSoftwareVersionsResult',
    'get_supported_vmware_software_versions',
    'get_supported_vmware_software_versions_output',
]

@pulumi.output_type
class GetSupportedVmwareSoftwareVersionsResult:
    """
    A collection of values returned by getSupportedVmwareSoftwareVersions.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, items=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSupportedVmwareSoftwareVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSupportedVmwareSoftwareVersionsItemResult']:
        """
        A list of the supported versions of bundled VMware software.
        """
        return pulumi.get(self, "items")


class AwaitableGetSupportedVmwareSoftwareVersionsResult(GetSupportedVmwareSoftwareVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSupportedVmwareSoftwareVersionsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            items=self.items)


def get_supported_vmware_software_versions(compartment_id: Optional[str] = None,
                                           filters: Optional[Sequence[pulumi.InputType['GetSupportedVmwareSoftwareVersionsFilterArgs']]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSupportedVmwareSoftwareVersionsResult:
    """
    This data source provides the list of Supported Vmware Software Versions in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Lists the versions of bundled VMware software supported by the Oracle Cloud
    VMware Solution.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_supported_vmware_software_versions = oci.Ocvp.get_supported_vmware_software_versions(compartment_id=var["compartment_id"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Ocvp/getSupportedVmwareSoftwareVersions:getSupportedVmwareSoftwareVersions', __args__, opts=opts, typ=GetSupportedVmwareSoftwareVersionsResult).value

    return AwaitableGetSupportedVmwareSoftwareVersionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'))


@_utilities.lift_output_func(get_supported_vmware_software_versions)
def get_supported_vmware_software_versions_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                                  filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSupportedVmwareSoftwareVersionsFilterArgs']]]]] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSupportedVmwareSoftwareVersionsResult]:
    """
    This data source provides the list of Supported Vmware Software Versions in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Lists the versions of bundled VMware software supported by the Oracle Cloud
    VMware Solution.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_supported_vmware_software_versions = oci.Ocvp.get_supported_vmware_software_versions(compartment_id=var["compartment_id"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    ...
