# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetManagedInstanceEventReportResult',
    'AwaitableGetManagedInstanceEventReportResult',
    'get_managed_instance_event_report',
    'get_managed_instance_event_report_output',
]

@pulumi.output_type
class GetManagedInstanceEventReportResult:
    """
    A collection of values returned by getManagedInstanceEventReport.
    """
    def __init__(__self__, compartment_id=None, counts=None, id=None, latest_timestamp_greater_than_or_equal_to=None, latest_timestamp_less_than=None, managed_instance_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if counts and not isinstance(counts, int):
            raise TypeError("Expected argument 'counts' to be a int")
        pulumi.set(__self__, "counts", counts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if latest_timestamp_greater_than_or_equal_to and not isinstance(latest_timestamp_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'latest_timestamp_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "latest_timestamp_greater_than_or_equal_to", latest_timestamp_greater_than_or_equal_to)
        if latest_timestamp_less_than and not isinstance(latest_timestamp_less_than, str):
            raise TypeError("Expected argument 'latest_timestamp_less_than' to be a str")
        pulumi.set(__self__, "latest_timestamp_less_than", latest_timestamp_less_than)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def counts(self) -> int:
        return pulumi.get(self, "counts")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="latestTimestampGreaterThanOrEqualTo")
    def latest_timestamp_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "latest_timestamp_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="latestTimestampLessThan")
    def latest_timestamp_less_than(self) -> Optional[str]:
        return pulumi.get(self, "latest_timestamp_less_than")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> str:
        return pulumi.get(self, "managed_instance_id")


class AwaitableGetManagedInstanceEventReportResult(GetManagedInstanceEventReportResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedInstanceEventReportResult(
            compartment_id=self.compartment_id,
            counts=self.counts,
            id=self.id,
            latest_timestamp_greater_than_or_equal_to=self.latest_timestamp_greater_than_or_equal_to,
            latest_timestamp_less_than=self.latest_timestamp_less_than,
            managed_instance_id=self.managed_instance_id)


def get_managed_instance_event_report(compartment_id: Optional[str] = None,
                                      latest_timestamp_greater_than_or_equal_to: Optional[str] = None,
                                      latest_timestamp_less_than: Optional[str] = None,
                                      managed_instance_id: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedInstanceEventReportResult:
    """
    This data source provides details about a specific Managed Instance Event Report resource in Oracle Cloud Infrastructure OS Management service.

    Get summary information about events on this instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_event_report = oci.OsManagement.get_managed_instance_event_report(compartment_id=var["compartment_id"],
        managed_instance_id=oci_osmanagement_managed_instance["test_managed_instance"]["id"],
        latest_timestamp_greater_than_or_equal_to=var["managed_instance_event_report_latest_timestamp_greater_than_or_equal_to"],
        latest_timestamp_less_than=var["managed_instance_event_report_latest_timestamp_less_than"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str latest_timestamp_greater_than_or_equal_to: filter event occurrence. Selecting only those last occurred on or after given date in ISO 8601 format Example: 2017-07-14T02:40:00.000Z
    :param str latest_timestamp_less_than: filter event occurrence. Selecting only those last occurred before given date in ISO 8601 format Example: 2017-07-14T02:40:00.000Z
    :param str managed_instance_id: Instance Oracle Cloud identifier (ocid)
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['latestTimestampGreaterThanOrEqualTo'] = latest_timestamp_greater_than_or_equal_to
    __args__['latestTimestampLessThan'] = latest_timestamp_less_than
    __args__['managedInstanceId'] = managed_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagement/getManagedInstanceEventReport:getManagedInstanceEventReport', __args__, opts=opts, typ=GetManagedInstanceEventReportResult).value

    return AwaitableGetManagedInstanceEventReportResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        counts=pulumi.get(__ret__, 'counts'),
        id=pulumi.get(__ret__, 'id'),
        latest_timestamp_greater_than_or_equal_to=pulumi.get(__ret__, 'latest_timestamp_greater_than_or_equal_to'),
        latest_timestamp_less_than=pulumi.get(__ret__, 'latest_timestamp_less_than'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'))


@_utilities.lift_output_func(get_managed_instance_event_report)
def get_managed_instance_event_report_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                             latest_timestamp_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                             latest_timestamp_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                             managed_instance_id: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedInstanceEventReportResult]:
    """
    This data source provides details about a specific Managed Instance Event Report resource in Oracle Cloud Infrastructure OS Management service.

    Get summary information about events on this instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_event_report = oci.OsManagement.get_managed_instance_event_report(compartment_id=var["compartment_id"],
        managed_instance_id=oci_osmanagement_managed_instance["test_managed_instance"]["id"],
        latest_timestamp_greater_than_or_equal_to=var["managed_instance_event_report_latest_timestamp_greater_than_or_equal_to"],
        latest_timestamp_less_than=var["managed_instance_event_report_latest_timestamp_less_than"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str latest_timestamp_greater_than_or_equal_to: filter event occurrence. Selecting only those last occurred on or after given date in ISO 8601 format Example: 2017-07-14T02:40:00.000Z
    :param str latest_timestamp_less_than: filter event occurrence. Selecting only those last occurred before given date in ISO 8601 format Example: 2017-07-14T02:40:00.000Z
    :param str managed_instance_id: Instance Oracle Cloud identifier (ocid)
    """
    ...
