# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetOrganizationSubscriptionsFilterResult',
    'GetOrganizationSubscriptionsSubscriptionResult',
    'GetOrganizationSubscriptionsSubscriptionCurrencyResult',
]

@pulumi.output_type
class GetOrganizationSubscriptionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Currency name
        """
        GetOrganizationSubscriptionsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Currency name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOrganizationSubscriptionsSubscriptionResult(dict):
    def __init__(__self__, *,
                 currencies: Sequence['outputs.GetOrganizationSubscriptionsSubscriptionCurrencyResult'],
                 id: str,
                 service_name: str,
                 status: str,
                 time_end: str,
                 time_start: str,
                 total_value: str,
                 type: str):
        """
        :param Sequence['GetOrganizationSubscriptionsSubscriptionCurrencyArgs'] currencies: Currency details
        :param str id: SPM internal Subscription ID
        :param str service_name: Customer friendly service name provided by PRG
        :param str status: Status of the plan
        :param str time_end: Represents the date when the last service of the subscription ends
        :param str time_start: Represents the date when the first service of the subscription was activated
        :param str total_value: Total aggregate TCLV of all lines for the subscription including expired, active, and signed
        :param str type: Subscription Type i.e. IAAS,SAAS,PAAS
        """
        GetOrganizationSubscriptionsSubscriptionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            currencies=currencies,
            id=id,
            service_name=service_name,
            status=status,
            time_end=time_end,
            time_start=time_start,
            total_value=total_value,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             currencies: Sequence['outputs.GetOrganizationSubscriptionsSubscriptionCurrencyResult'],
             id: str,
             service_name: str,
             status: str,
             time_end: str,
             time_start: str,
             total_value: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("currencies", currencies)
        _setter("id", id)
        _setter("service_name", service_name)
        _setter("status", status)
        _setter("time_end", time_end)
        _setter("time_start", time_start)
        _setter("total_value", total_value)
        _setter("type", type)

    @property
    @pulumi.getter
    def currencies(self) -> Sequence['outputs.GetOrganizationSubscriptionsSubscriptionCurrencyResult']:
        """
        Currency details
        """
        return pulumi.get(self, "currencies")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        SPM internal Subscription ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        Customer friendly service name provided by PRG
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the plan
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> str:
        """
        Represents the date when the last service of the subscription ends
        """
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> str:
        """
        Represents the date when the first service of the subscription was activated
        """
        return pulumi.get(self, "time_start")

    @property
    @pulumi.getter(name="totalValue")
    def total_value(self) -> str:
        """
        Total aggregate TCLV of all lines for the subscription including expired, active, and signed
        """
        return pulumi.get(self, "total_value")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Subscription Type i.e. IAAS,SAAS,PAAS
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetOrganizationSubscriptionsSubscriptionCurrencyResult(dict):
    def __init__(__self__, *,
                 iso_code: str,
                 name: str,
                 std_precision: str):
        """
        :param str iso_code: Currency Code
        :param str name: Currency name
        :param str std_precision: Standard Precision of the Currency
        """
        GetOrganizationSubscriptionsSubscriptionCurrencyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            iso_code=iso_code,
            name=name,
            std_precision=std_precision,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             iso_code: str,
             name: str,
             std_precision: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("iso_code", iso_code)
        _setter("name", name)
        _setter("std_precision", std_precision)

    @property
    @pulumi.getter(name="isoCode")
    def iso_code(self) -> str:
        """
        Currency Code
        """
        return pulumi.get(self, "iso_code")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Currency name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="stdPrecision")
    def std_precision(self) -> str:
        """
        Standard Precision of the Currency
        """
        return pulumi.get(self, "std_precision")


