# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'StreamPoolCustomEncryptionKeyArgs',
    'StreamPoolKafkaSettingsArgs',
    'StreamPoolPrivateEndpointSettingsArgs',
    'GetConnectHarnessesFilterArgs',
    'GetStreamPoolsFilterArgs',
    'GetStreamsFilterArgs',
]

@pulumi.input_type
class StreamPoolCustomEncryptionKeyArgs:
    def __init__(__self__, *,
                 kms_key_id: pulumi.Input[str],
                 key_state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key_id: (Updatable) Custom Encryption Key (Master Key) ocid.
        :param pulumi.Input[str] key_state: Life cycle State of the custom key
        """
        StreamPoolCustomEncryptionKeyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kms_key_id=kms_key_id,
            key_state=key_state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kms_key_id: pulumi.Input[str],
             key_state: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("kms_key_id", kms_key_id)
        if key_state is not None:
            _setter("key_state", key_state)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Custom Encryption Key (Master Key) ocid.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="keyState")
    def key_state(self) -> Optional[pulumi.Input[str]]:
        """
        Life cycle State of the custom key
        """
        return pulumi.get(self, "key_state")

    @key_state.setter
    def key_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_state", value)


@pulumi.input_type
class StreamPoolKafkaSettingsArgs:
    def __init__(__self__, *,
                 auto_create_topics_enable: Optional[pulumi.Input[bool]] = None,
                 bootstrap_servers: Optional[pulumi.Input[str]] = None,
                 log_retention_hours: Optional[pulumi.Input[int]] = None,
                 num_partitions: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[bool] auto_create_topics_enable: (Updatable) Enable auto creation of topic on the server.
        :param pulumi.Input[str] bootstrap_servers: (Updatable) Bootstrap servers.
        :param pulumi.Input[int] log_retention_hours: (Updatable) The number of hours to keep a log file before deleting it (in hours).
        :param pulumi.Input[int] num_partitions: (Updatable) The default number of log partitions per topic.
        """
        StreamPoolKafkaSettingsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            auto_create_topics_enable=auto_create_topics_enable,
            bootstrap_servers=bootstrap_servers,
            log_retention_hours=log_retention_hours,
            num_partitions=num_partitions,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             auto_create_topics_enable: Optional[pulumi.Input[bool]] = None,
             bootstrap_servers: Optional[pulumi.Input[str]] = None,
             log_retention_hours: Optional[pulumi.Input[int]] = None,
             num_partitions: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if auto_create_topics_enable is not None:
            _setter("auto_create_topics_enable", auto_create_topics_enable)
        if bootstrap_servers is not None:
            _setter("bootstrap_servers", bootstrap_servers)
        if log_retention_hours is not None:
            _setter("log_retention_hours", log_retention_hours)
        if num_partitions is not None:
            _setter("num_partitions", num_partitions)

    @property
    @pulumi.getter(name="autoCreateTopicsEnable")
    def auto_create_topics_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Enable auto creation of topic on the server.
        """
        return pulumi.get(self, "auto_create_topics_enable")

    @auto_create_topics_enable.setter
    def auto_create_topics_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_create_topics_enable", value)

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Bootstrap servers.
        """
        return pulumi.get(self, "bootstrap_servers")

    @bootstrap_servers.setter
    def bootstrap_servers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_servers", value)

    @property
    @pulumi.getter(name="logRetentionHours")
    def log_retention_hours(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of hours to keep a log file before deleting it (in hours).
        """
        return pulumi.get(self, "log_retention_hours")

    @log_retention_hours.setter
    def log_retention_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_retention_hours", value)

    @property
    @pulumi.getter(name="numPartitions")
    def num_partitions(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The default number of log partitions per topic.
        """
        return pulumi.get(self, "num_partitions")

    @num_partitions.setter
    def num_partitions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_partitions", value)


@pulumi.input_type
class StreamPoolPrivateEndpointSettingsArgs:
    def __init__(__self__, *,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: The optional list of network security groups to be used with the private endpoint of the stream pool. That value cannot be changed.
        :param pulumi.Input[str] private_endpoint_ip: The optional private IP you want to be associated with your private stream pool. That parameter can only be specified when the subnetId parameter is set. It cannot be changed. The private IP needs to be part of the CIDR range of the specified subnetId or the creation will fail. If not specified a random IP inside the subnet will be chosen. After the stream pool is created, a custom FQDN, pointing to this private IP, is created. The FQDN is then used to access the service instead of the private IP.
        :param pulumi.Input[str] subnet_id: If specified, the stream pool will be private and only accessible from inside that subnet. Producing-to and consuming-from a stream inside a private stream pool can also only be done from inside the subnet. That value cannot be changed. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        StreamPoolPrivateEndpointSettingsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            nsg_ids=nsg_ids,
            private_endpoint_ip=private_endpoint_ip,
            subnet_id=subnet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             private_endpoint_ip: Optional[pulumi.Input[str]] = None,
             subnet_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if nsg_ids is not None:
            _setter("nsg_ids", nsg_ids)
        if private_endpoint_ip is not None:
            _setter("private_endpoint_ip", private_endpoint_ip)
        if subnet_id is not None:
            _setter("subnet_id", subnet_id)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The optional list of network security groups to be used with the private endpoint of the stream pool. That value cannot be changed.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The optional private IP you want to be associated with your private stream pool. That parameter can only be specified when the subnetId parameter is set. It cannot be changed. The private IP needs to be part of the CIDR range of the specified subnetId or the creation will fail. If not specified a random IP inside the subnet will be chosen. After the stream pool is created, a custom FQDN, pointing to this private IP, is created. The FQDN is then used to access the service instead of the private IP.
        """
        return pulumi.get(self, "private_endpoint_ip")

    @private_endpoint_ip.setter
    def private_endpoint_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_endpoint_ip", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        If specified, the stream pool will be private and only accessible from inside that subnet. Producing-to and consuming-from a stream inside a private stream pool can also only be done from inside the subnet. That value cannot be changed. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class GetConnectHarnessesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the given name exactly.
        """
        GetConnectHarnessesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetStreamPoolsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the given name exactly.
        """
        GetStreamPoolsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetStreamsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the given name exactly.
        """
        GetStreamsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


