"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - A new authorizationToken has been introduced in the authenticationAPI response payload. It can be used to replace the sessionToken in any of the API calls and can be passed as \"Authorization\" header. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46.   # noqa: E501

    The version of the OpenAPI document: 22.5.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from symphony.bdk.gen.api_client import ApiClient, Endpoint as _Endpoint
from symphony.bdk.gen.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from symphony.bdk.gen.agent_model.v1_health_check_response import V1HealthCheckResponse
from symphony.bdk.gen.agent_model.v2_health_check_response import V2HealthCheckResponse
from symphony.bdk.gen.agent_model.v3_health import V3Health


class SystemApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.v1_health_check_get_endpoint = _Endpoint(
            settings={
                'response_type': (V1HealthCheckResponse,),
                'auth': [],
                'endpoint_path': '/v1/HealthCheck',
                'operation_id': 'v1_health_check_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v2_health_check_get_endpoint = _Endpoint(
            settings={
                'response_type': (V2HealthCheckResponse,),
                'auth': [],
                'endpoint_path': '/v2/HealthCheck',
                'operation_id': 'v2_health_check_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'show_firehose_errors',
                    'fail_on_pod_connectivity',
                    'fail_on_key_manager_connectivity',
                    'fail_on_agent_service_user',
                    'fail_on_ce_service_user',
                    'fail_on_encrypt_decrypt_success',
                    'fail_on_any',
                    'fail_on_datafeed_connectivity',
                    'session_token',
                    'key_manager_token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'show_firehose_errors':
                        (bool,),
                    'fail_on_pod_connectivity':
                        (bool,),
                    'fail_on_key_manager_connectivity':
                        (bool,),
                    'fail_on_agent_service_user':
                        (bool,),
                    'fail_on_ce_service_user':
                        (bool,),
                    'fail_on_encrypt_decrypt_success':
                        (bool,),
                    'fail_on_any':
                        (bool,),
                    'fail_on_datafeed_connectivity':
                        (bool,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                },
                'attribute_map': {
                    'show_firehose_errors': 'showFirehoseErrors',
                    'fail_on_pod_connectivity': 'failOnPodConnectivity',
                    'fail_on_key_manager_connectivity': 'failOnKeyManagerConnectivity',
                    'fail_on_agent_service_user': 'failOnAgentServiceUser',
                    'fail_on_ce_service_user': 'failOnCeServiceUser',
                    'fail_on_encrypt_decrypt_success': 'failOnEncryptDecryptSuccess',
                    'fail_on_any': 'failOnAny',
                    'fail_on_datafeed_connectivity': 'failOnDatafeedConnectivity',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                },
                'location_map': {
                    'show_firehose_errors': 'query',
                    'fail_on_pod_connectivity': 'query',
                    'fail_on_key_manager_connectivity': 'query',
                    'fail_on_agent_service_user': 'query',
                    'fail_on_ce_service_user': 'query',
                    'fail_on_encrypt_decrypt_success': 'query',
                    'fail_on_any': 'query',
                    'fail_on_datafeed_connectivity': 'query',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v3_extended_health_endpoint = _Endpoint(
            settings={
                'response_type': (V3Health,),
                'auth': [],
                'endpoint_path': '/v3/health/extended',
                'operation_id': 'v3_extended_health',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v3_health_endpoint = _Endpoint(
            settings={
                'response_type': (V3Health,),
                'auth': [],
                'endpoint_path': '/v3/health',
                'operation_id': 'v3_health',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def v1_health_check_get(
        self,
        **kwargs
    ):
        """Checks the health of the Agent.  # noqa: E501

        Used to validate the configuration of the agent. Makes a request to the HealthCheck on the Symphony cloud. Makes a request to the HealthCheck on the Key Manager service.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_health_check_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1HealthCheckResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.v1_health_check_get_endpoint.call_with_http_info(**kwargs)

    def v2_health_check_get(
        self,
        **kwargs
    ):
        """Checks the health of the Agent.  # noqa: E501

        [deprecated] : This endpoint is deprecated. The health check endpoint to be used instead is '/v3/health/extended'. Unlike this deprecated endpoint, the extended health check endpoint provides status on external component such as pod, key manager, ceservice, agentservice...   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v2_health_check_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            show_firehose_errors (bool): [deprecated] Firehose Service has never been deployed. However, this request parameter has been kept here for specs backward compatibility. . [optional]
            fail_on_pod_connectivity (bool): Defines the HealthCheck status code response whenever the Pod connectivity fails. When set to \"true\", in case of Pod connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". . [optional]
            fail_on_key_manager_connectivity (bool): Defines the HealthCheck status code response whenever the Key Manager connectivity fails. When set to \"true\", in case of Key Manager connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". . [optional]
            fail_on_agent_service_user (bool): Defines the HealthCheck status code response whenever the Agent Service User connectivity fails. When set to \"true\", in case of Agent Service connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". . [optional]
            fail_on_ce_service_user (bool): This query parameter is not used as the ceservice is deprecated and it is kept for backward compatibility. Default value is \"false\" but it will not change the response status code if set to true. . [optional]
            fail_on_encrypt_decrypt_success (bool): Defines the status code response whenever the Encrypt/Decrypt message check fails. When set to \"true\", in case of Encrypt or Decrypt failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". . [optional]
            fail_on_any (bool): Defines the status code response whenever at least one of the checks fails. When set to \"true\", in case of any failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". . [optional]
            fail_on_datafeed_connectivity (bool): Defines the HealthCheck status code response whenever the Datafeed2 connectivity fails. When set to \"true\", in case of Datafeed connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". . [optional]
            session_token (str): Session authentication token.. [optional]
            key_manager_token (str): Key Manager authentication token.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V2HealthCheckResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.v2_health_check_get_endpoint.call_with_http_info(**kwargs)

    def v3_extended_health(
        self,
        **kwargs
    ):
        """Checks health status of services and users  # noqa: E501

        _Available on Agent 2.57.0 and above._  Returns the connectivity status of the Agent services (**pod**, **key manager** and **datafeed**) as well as users connectivity (**agentservice** and **ceservice**).  The global status will be set to `DOWN` if at least one of the sub-status is also `DOWN`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v3_extended_health(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V3Health
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.v3_extended_health_endpoint.call_with_http_info(**kwargs)

    def v3_health(
        self,
        **kwargs
    ):
        """Checks health status  # noqa: E501

        _Available on Agent 2.57.0 and above._  Returns the connectivity status of your Agent server. If your Agent server is started and running, the status value will be `UP`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v3_health(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V3Health
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.v3_health_endpoint.call_with_http_info(**kwargs)

