import re
import builtins

KEYWORD_PATTERNS = [
    (r'\bИНАЧЕ ЕСЛИ\b', 'elif'),
    (r'\bНЕ ЭТО\b', 'is not'),
    (r'\bВЫЗВАТЬ ИСКЛЮЧЕНИЕ\b', 'raise'),
    (r'\bЕСЛИ\b', 'if'),
    (r'\bИНАЧЕ\b', 'else'),
    (r'\bПОКА\b', 'while'),
    (r'\bДЛЯ\b', 'for'),
    (r'\bВ\b', 'in'),
    (r'\bПРОДОЛЖИТЬ\b', 'continue'),
    (r'\bПРЕРВАТЬ\b', 'break'),
    (r'\bПОПЫТКА\b', 'try'),
    (r'\bИСКЛЮЧЕНИЕ\b', 'except'),
    (r'\bНАКОНЕЦ\b', 'finally'),
    (r'\bС\b', 'with'),
    (r'\bКАК\b', 'as'),
    (r'\bОПРЕДЕЛИТЬ\b', 'def'),
    (r'\bКЛАСС\b', 'class'),
    (r'\bВЕРНУТЬ\b', 'return'),
    (r'\bПОРОДИТЬ\b', 'yield'),
    (r'\bЛАМБДА\b', 'lambda'),
    (r'\bАСИНХРОННЫЙ\b', 'async'),
    (r'\bОЖИДАТЬ\b', 'await'),
    (r'\bИСТИНА\b', 'True'),
    (r'\bЛОЖЬ\b', 'False'),
    (r'\bНИЧТО\b', 'None'),
    (r'\bИ\b', 'and'),
    (r'\bИЛИ\b', 'or'),
    (r'\bНЕ\b', 'not'),
    (r'\bЭТО\b', 'is'),
    (r'\bИМПОРТ\b', 'import'),
    (r'\bИЗ\b', 'from'),
    (r'\bПРОПУСТИТЬ\b', 'pass'),
    (r'\bУДАЛИТЬ\b', 'del'),
    (r'\bГЛОБАЛЬНЫЙ\b', 'global'),
    (r'\bНЕЛОКАЛЬНЫЙ\b', 'nonlocal'),
    (r'\bУТВЕРЖДАТЬ\b', 'assert'),
    (r'\bВЫВЕСТИ\b', 'print'),
    (r'\bДЛИНА\b', 'len'),
    (r'\bТИП\b', 'type'),
    (r'\bВВОД\b', 'input'),
    (r'\bДИАПАЗОН\b', 'range'),
    (r'\bЦЕЛОЕ\b', 'int'),
    (r'\bСТРОКА\b', 'str'),
    (r'\bСПИСОК\b', 'list'),
    (r'\bСЛОВАРЬ\b', 'dict'),
    (r'\bМНОЖЕСТВО\b', 'set'),
    (r'\bКОРТЕЖ\b', 'tuple'),
]

def перевести_на_python(русский_код):
    """
    Переводит строку кода с русскими ключевыми словами на стандартный Python.
    """
    python_код = русский_код
    for рус_паттерн, англ_ключ in KEYWORD_PATTERNS:
        python_код = re.sub(рус_паттерн, англ_ключ, python_код)
    return python_код

def выполнить_русский_код(русский_код, глобальные_переменные=None, локальные_переменные=None):
    """
    Выполняет строку кода, написанную с использованием русских ключевых слов.
    """
    python_код = перевести_на_python(русский_код)
    
    effective_globals = {}
    if глобальные_переменные is not None:
        effective_globals.update(глобальные_переменные)
    
    if '__builtins__' not in effective_globals:
        effective_globals['__builtins__'] = builtins

    if локальные_переменные is None:
        локальные_переменные = effective_globals
        
    exec(python_код, effective_globals, локальные_переменные)

def загрузить_и_выполнить_файл(путь_к_файлу, кодировка='utf-8'):
    """
    Загружает файл с русским кодом, переводит его и выполняет.
    Возвращает словарь с глобальными переменными, определенными в файле.
    """
    with open(путь_к_файлу, 'r', encoding=кодировка) as файл:
        русский_код = файл.read()
    
    пространство_имен_файла = {'__builtins__': builtins}
    
    выполнить_русский_код(русский_код, глобальные_переменные=пространство_имен_файла)
    return пространство_имен_файла



