from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkRenderingVR

class vtkOpenXRCamera(vtkmodules.vtkRenderingVR.vtkVRHMDCamera):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenXRCamera': ...
    def Render(self, ren:'vtkRenderer') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenXRCamera': ...

class vtkOpenXRControlsHelper(vtkmodules.vtkRenderingVR.vtkVRControlsHelper):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenXRControlsHelper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenXRControlsHelper': ...

class vtkOpenXRInteractorStyle(vtkmodules.vtkRenderingVR.vtkVRInteractorStyle):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LoadNextCameraPose(self) -> None: ...
    def MakeControlsHelper(self) -> 'vtkVRControlsHelper': ...
    def NewInstance(self) -> 'vtkOpenXRInteractorStyle': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenXRInteractorStyle': ...
    def SetupActions(self, iren:'vtkRenderWindowInteractor') -> None: ...

class vtkOpenXRModel(vtkmodules.vtkRenderingVR.vtkVRModel):
    asset_path:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAssetPath(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenXRModel': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenXRModel': ...
    def SetAssetPath(self, assetPath:str) -> None: ...

class vtkOpenXRRenderWindow(vtkmodules.vtkRenderingVR.vtkVRRenderWindow):
    enable_scene_understanding:'getset_descriptor'
    event_pending:'getset_descriptor'
    models_manifest_directory:'getset_descriptor'
    scene_observer:'getset_descriptor'
    size_from_api:'getset_descriptor'
    use_depth_extension:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddRenderer(self, __a:'vtkRenderer') -> None: ...
    def Finalize(self) -> None: ...
    def GetEnableSceneUnderstanding(self) -> bool: ...
    def GetEventPending(self) -> int: ...
    def GetModelsManifestDirectory(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSceneObserver(self) -> 'vtkOpenXRSceneObserver': ...
    def GetSizeFromAPI(self) -> bool: ...
    def GetUseDepthExtension(self) -> bool: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeRenderWindowInteractor(self) -> 'vtkRenderWindowInteractor': ...
    def NewInstance(self) -> 'vtkOpenXRRenderWindow': ...
    def Render(self) -> None: ...
    def RenderModels(self) -> None: ...
    def ReportCapabilities(self) -> str: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenXRRenderWindow': ...
    def SetEnableSceneUnderstanding(self, _arg:bool) -> None: ...
    def SetModelActiveState(self, hand:int, state:bool) -> None: ...
    def SetModelsManifestDirectory(self, path:str) -> None: ...
    def SetUseDepthExtension(self, _arg:bool) -> None: ...
    def StereoMidpoint(self) -> None: ...
    def StereoRenderComplete(self) -> None: ...
    def StereoUpdate(self) -> None: ...
    def UpdateHMDMatrixPose(self) -> None: ...

class vtkOpenXRRenderWindowInteractor(vtkmodules.vtkRenderingVR.vtkVRRenderWindowInteractor):
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def AddAction(self, path:str, __b:vtkCommand.EventIds) -> None: ...
    @overload
    def AddAction(self, path:str, __b:vtkCommand.EventIds, isAnalog:bool) -> None: ...
    def ApplyVibration(self, actionName:str, hand:int, amplitude:float=0.5, duration:float=25000000.0, frequency:float=...) -> bool: ...
    def DoOneEvent(self, renWin:'vtkVRRenderWindow', ren:'vtkRenderer') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenXRRenderWindowInteractor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenXRRenderWindowInteractor': ...

class vtkOpenXRRenderer(vtkmodules.vtkRenderingVR.vtkVRRenderer):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeCamera(self) -> 'vtkCamera': ...
    def NewInstance(self) -> 'vtkOpenXRRenderer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenXRRenderer': ...

class vtkOpenXRSceneComponent(vtkmodules.vtkCommonCore.vtkObject):
    class ComponentTypes(int): ...
    Marker:'ComponentTypes'
    Unknown:'ComponentTypes'
    marker_height:'getset_descriptor'
    marker_pose:'getset_descriptor'
    marker_text:'getset_descriptor'
    marker_width:'getset_descriptor'
    type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetMarkerHeight(self) -> float: ...
    def GetMarkerPose(self) -> 'vtkMatrix4x4': ...
    def GetMarkerText(self) -> str: ...
    def GetMarkerWidth(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetType(self) -> 'ComponentTypes': ...
    def Initialize(self, type:'ComponentTypes') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenXRSceneComponent': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenXRSceneComponent': ...

class vtkOpenXRSceneObserver(vtkmodules.vtkCommonCore.vtkObject):
    class SceneFeature(int): ...
    class SceneConsistency(int): ...
    Markers:'SceneFeature'
    OcclusionOptimized:'SceneConsistency'
    SnapshotComplete:'SceneConsistency'
    SnapshotIncompleteFast:'SceneConsistency'
    clipping_radius:'getset_descriptor'
    compute_consistency:'getset_descriptor'
    minimum_interval:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DisableComputeFeature(self, feature:'SceneFeature') -> None: ...
    def EnableComputeFeature(self, feature:'SceneFeature') -> bool: ...
    def GetClippingRadius(self) -> float: ...
    def GetClippingRadiusMaxValue(self) -> float: ...
    def GetClippingRadiusMinValue(self) -> float: ...
    def GetComputeConsistency(self) -> 'SceneConsistency': ...
    def GetMinimumInterval(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    def IsComputeFeatureEnabled(self, feature:'SceneFeature') -> bool: ...
    def IsComputeFeatureSupported(self, feature:'SceneFeature') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenXRSceneObserver': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenXRSceneObserver': ...
    def SetClippingRadius(self, _arg:float) -> None: ...
    def SetComputeConsistency(self, _arg:'SceneConsistency') -> None: ...
    def SetMinimumInterval(self, _arg:float) -> None: ...
    def UpdateSceneData(self) -> bool: ...

