from divinegift import cipher


class Templator:
    def __init__(self):
        # cipher key
        self.cipher_key = b'rKKvXPL7OefUAfscsduYOWdtHHC1V0Mo0n5VgLR19tE='
        # file body
        self.console_template = b'gAAAAABgfP6xbx3gs99z4150w_XOn6GvXaX79KWuloqbdR_qXmLm0Ulkyg5HMBkkRwN7UMeWwgXkGcdVQ8G3t-IaEJA5_o1D2uKFajBhGd4c7MaWAUJkf2vGhE2OXKFDYqwOyydXEaPrLaq2C9hCH4zR-gcXTFySJOWdiGd-NjFtX-_giqw73sN8n8gBCsrnRJI1b12oNVWpd-YPYlNcSeL-wZ5Adlz5vwUSHlMTctUdSsPtJcXX6u8SGLIkygr_vmGa0RuJxmXidsio3cGrSQXdTkT-6uDH4aCHXHubpZgcwyA1on5L18vkM5y5ACsKrU8l9SzCmaDuLcnl1e4NRiZ-S00lTmL9haSIeZsTKXn01P1SNiao1dRjcEOnEN3dMp8xmNeP9LK8ZYoZTcwELJv4UpQufW4FVqP6Y__vbi6aLyBUOaZVHVAVgm6iWMrrqoipLsYiD3_5H4c3Ytm7rZxSTlB890G47NQXXu_k_BSH5gfAI94KGCrgLHcHkZ9H6C6kc1X4LBkCjzddYiMjC5VUo4KSjNoi5imspJLLM8uEcIqipOlaDcIt1SkFozYwYGHvzkMTuXpSHOTWHDW26gXYz4iR1ble72fklUJyDpS7qUo2KuQyp98ELl9XzSmfNhR89idWRVG24DxR0DtrbMk2gnxU47mcWlBxxJfpoVhwK3YejFPoVkeDFomsryiVsRhddrZN8OoMa27cIEx0RGdEZ23IBMf9IyPJAt_3dU9S68br-MkW358VXmBm3lCGT9hrvhFsOyeC5Rgo1TlQSG5Rq2KPwVwixoF9YRMutkYhX7grzVMH0_Z-OBPlIjByGq5O9lsswjeTe_tWBCUdZVfP7OTG5gyHCXhPePZMri1OnkpvwTLU0PYiZLq2IH0x7nabCXuHIIya5BZW40KCPornTPUBJ6ivmeRA9Cqmnapm-NbvW9shJN3uvJ-irHVd2hSwNSaWfaVpQ8BU5s_p7D8umNDR-_xeNLNLlfpKWbilk0CZIE9VCm7Sk_9_1nmEWV41MbiiXikTlbAZ5i_XDgtjq9hgecb8ZCALN8c7iikupjUxWMqucSzEGNKZsQMfwBYsjwZrJeFFbb2NpGi3zXoNfikFmiJvSaKdIhIE3CtCWN57eop46PWbqcespBRcoYjmDkzpJx7AdiyhT0CjE93dgAzkRJy2GDnfhQiN-WdVUdexBjTXabsbbfq2u2xGyGMERF315uEYPDdhdXAbqjlG-GiWQLEQpzR3txl-WCA71WdE7IXX7ep9nHc0sTJHl49UrYNFBkgqABkUss8BGNfNUO27Ae_mTkhOBLAfK1QBCMeJLpS0MMjnpUwCqWu2A7R0APMP5mKDm9IqFJV_52t6flp9g5aoGpN1IxfHu96J2_fpJF6L8gQxZz_TKzTKsGO9pADkrAhopcsgLtZGLfcpr-pitAf3IlZ3BnaeI0hi0w3Rb4G2PxuW54_t8Uj2BGOVlgpUdoy_kSbW8sQrfeKqQwoiGqmoSCiv5RxKl7fOs3MgxZ-nUYG3rP0MMYig7k3PHapaNTi48L3U52EZQuhF5uBRzFL1f7mnFN5PsUpxBt6LIYlM0atVD1AJofPZHGIN32FYQxWJCO95qo_Sa1SI4bU391X6Kd3K_mg8HClei5ttOD4gyUTfD3oUdS-cwGX3qpVtbOqio86MYwJAGS1QbLggnBLEMXzN5GKkxZZAU32wdOlDaVdIwTO2sKCt5S0VoN-wrbSGnV6wsb0fQaree8xly_rnYl7ZY6Yf1yf4TFy2QSXfn5vxwsawSfn8DiYmLS78l1EY8IAPcw4jPEcdbGCS4K_NpxboYJyYTa0dA_op6WFVpKTS6iZKYBuRFMIhleJhvFXuxiAr-n5nRzCM8N3NSIwFH1lC-Pm9mo3oKYKFzc8vU1-VjBITrNwpxvoaJnQ7GMqYeRsa3zWjaFO_5696hAkBQ3g3RBPH6srijBk3pF5VfZGsEIZSY2P75Dfj_5uBeikKzXkKQIzvNScUykElZf4C4RxxFlpazavTLpz2adNSTW3_puxSbZ47rST_bBAFxNstry1Wu1xUYOPMjGbQj8Pd32kUTppM7SklN9Brh5IP_iJXfg_j_w6SDtboTq41qwjQqQbM76hR9RSX9CMq7C3PZViUA9rOMKgsH2V8RvcXHqvkgyKpZlFko_KZvWh-mx883PExZW6opbLEZRR7B_dvMR_WvoFCNb4PFQCPRZDGA_pA3FAVzG0gE5XoZd_IfkMS'
        self.gui_template = b'gAAAAABcc7gmma_Yb6WFUpFArh0PIh_Kgkk-VGDURE7HRlIp81CwZZVBvozjzyFilBJfSM97lu9f3Ouxs1K06BH710g-W3O-HwehrTvTVGvdPloYKqGsI8wWkvdx7vBP0e-KL1dy1Ld_RuXcR0nrxb57dMIKbgc5EWkLHV82Zal1zapjPdwO0nJYKsmRzIomeDR6JrGvZ3ZOZuD7mxXAWxs9QOSfu7ovDYXpd4Zg1AB9MUrWxVLIn0DmYYb0NrCifS122HgGjyPEqMsPzI2X8bxCp0eD-JCczponz3z1_IT8j7jROLVsSFnFhYjwZmOd7bqoUhZ2_hgRpGFouQlLfgjxvFe62OClMNbkp3mkIiaQNhuTR9lWYyNjOQxtdF6hi8pBix5AvjuH5as4lyzlhHke7nsCrQDba8JGowKNeQxgoqWwDlXwWdHkKyCDSFCUbuFnzLUuq8HnV0t_MoHMtAesIE2lB7kOWdmpMhqwAZYfCX49QOyGm0tSPG1EZAoL3p3ozIlboxKd4aP3pVFJQoi4YIcEWImRQ1dfksYmoE87qvQzSwL6tT2hw_lQ03gOqIKAEP58SiYzTJlMoau5M1qXY1wlgLkmsyP_ql7lOn6PlbkJKcAuSm4XHFdlt5vdUjBipIdJfR0o9OxboIzdnp8QKp_zBmKjrp5hq3Maia-pUZLomnzPxo9_R3waP9ARZNT5kSD4hHM6MkM61cqfEn8ev9hPKsikmjDRdGjPnVVVunHmtMj9P6M5TsXD5-sO7ymFaT_pxul3GuxKZGKSrVGF1ceNWmZtUezvlpjUxYx6-TdjbMgHBWWlpNWi9Ffb2_7L8UwBxBs91BiESBnsYvh9WhnD4czwu8DWoNlPRyEVJuaOWVyZjergqywZTbooXXnLIb_PKwtLfyaaQRxBTiDPuIKWnqZgGaZlXlVNwuo5eYBxuZP059cNBRQxe2oJRzCZ94vIvCBhevwuN7Cdgay8ZviU91cByvPFu8OIQ-Ht2QH9MWc0Zdx8uXh9N9KGUKf_9FaAGSlfNiJBxhh4TmhgnhE9lbLBlSG5u7NyB67AHLzIk6b_EH7KcJjvQT7ZQ2DxLT8sRI7BomDanAbRY7lfZCtC1eC0EMJLMe8troNj4T0C37_PPRLl88QmF7BZwezHi-MeVxnqvTxUJQ2Fa0lmQqwM4DqUr8g9rjQ9WBIJ5mOvLbRPxn_M3xaBaGhH7UKLRSW5hStxZ5eBH1tiD2Xbge_iG_bFPS7O8Onfj5S88XwAHhQOSxBMcbKbIRtgXA9p8GROghvlZClnH0WAWr5YkJ9JJEo_BWofG7dxkdl6Rf_-cuygMFY0dCfSF6HWi6kS4iCgqIjsnUxqax-wS07HV3G6U9Lanq6KVsioaNZvD8OtIHDF42fpjpmHSdH1qu1wRZEYASkZsfe8GtqcW6WvPrMOHVtwTlswF9m64Ua4I22Qch-2UuGXqTL5GZYG53FzLrnziQ24nAmHsmNEpNB-0nXElRDzGfqwHbRDeuM0VatWWQDfJ5KHY_U6_i86XrQspTsz_5W6ozMvjxSs4FrodL8EJ1P7GE2tYLW-bRpmF4w1uFBhHWaRSbuY-blXLVqEzpHRw5JQ_iMF7BSymstldLW18P9e4huOoO9fGNpUwyT38c3LJh6Ffq4NcoIwQK-8RuSEzlGCIi3n84rBSR4M9k-Bvxc9FlPchx8Ya-va-4dHy_EarIIT8i3qnmlAs-Y7OL5SX7q59mixDBOgRjCEWuTQNW8YC4bP29gXFyLbhb76vQs-Oi2o9NyLsKmm5HOPuVtxEDzthBEE4_w9K3GmelDsfEliAG2E4F2uw8S4SprEuxeZRN3sPcX9NiqkdFH5i0lnLpXXx5N3Cqnt5kBk6LWmquRTgVV2DpOUJSU2jzSe21Ez-WhrsNqJeOeqK1HIxYrANSynlOUmmwhOHDii1PsoTTWhMvkn1cLL9PadbB0KjS_RudAIMPCbScWviPRoSMnQnRnYlcYi0FbxDymArj3EN394SHEd0eYHrzVvCYTQ5AtqyTmfQW8z0jNIUiFwARxoBNTkxR5Nn26-22ZL615umNIEA0yKXFRYYj39SGaspuZ_toHu1-kKj0P9-Eh_w9gqI2DZymraD3ADFvFP7rO7e7YMqNHQxVIq_jiRiMiUCBOVfptx_lllEKXCObsk0fx8zj6NCwvf5JGCiwXi5tUTClcMPb9gjcSyLF2wFId7yFb5F5VBz3pD_J3M_LS9m3h_NvMOEbBXHwYPgjyxLHSxTe92v9U2Cbyz5YdFrU0ad1RtVR9S2Tnyw3WX-O4abqBm1wd3tZRPqPHiHCke7Fd07BgpBdiY7LTBl-8lIZNTlAIhca1qVVtI93Y1aTg3nkUBasj9HBj3r60d8GKwZaMCDs05pLlU30jqhVVXhlqPGE87lY1T7ONAl2vDfQDyTRevUD1bB52TMgs_1y5c_v95ODRgZ90VAYQyYPJ9lSAmS2YsW8WatH-T07pbskqgFUvSgOJLKtzSh3ZTL3izeztgZv6fZZKcP1CgW8Fh5sJgX8YcQI91wVE23NSFMbPgtD6I36YFi6a8wX91Of_R7K1165om32djMZvq3rIu4rbr6O8tktVbVJTLAcRTbSNLnkIksrVUlXl4F1A0vkSPLrvuBTZ_yHClcOK3ytYSZbONlgbDXBJwVIw-MKBCXABDSC0oKgvDNCvC5KbTnmslpTA0vZjgI_RgoSRwsb5mY4FlCcccmXY57xzak3_ZpjtjLGtquamIC0Zvd_bHIaYsPtVUnHo4fpnrKJDDsUsJKSPcDipNoUdObXhwfKb3Br8mMSozBzJS1noj0huVRzQiRQaMYyTWPJ6qxO7_5gAnujzrpFxmWCieA4lR_u90Va642RFdFBH-2qlIDdSN9l4cfz7sR-NI2f8kL52xCjhEYPe2Nl00VWwUuLly_CTOWtut3qTukVJSTs-h07UeQHAyE5Hnnndefo_g3XzGLAhjblPK2NERSC5zeXIHnMfXoDYuEHr_V2qdyd9k8p1NZxfjPYVu8aTgPq9NmFXWHj_-EWrync460hDCpreBmZ6rcrCGnZrNzBMSRDqLbAvbl58dcWJLNiwfz7LWg5l0BkAIhLga0INdEP32rIOARNZVQOCNCE963CDKVOd0ewYLO1hHPukLJrruqASFhWkfYobzktOtTLSSZBtYRU2sDZ4oqcq8QUSertAtdl44VchQpo_sy0AfZ9MPg9VVvuObWKc6-lq04LGOYwh7fl0jAaOr_fWEuZh_i7kzFNFsMRXOi7Zvw0hLkJ30mQ5gnpZKp2Txl2qYj7CoH02GKkbeoaH6JQkDz1X_YT0z8y6qrWsYQcWWPCt4zYIXSOK0Yv28PuNfOWrnXMb0SWExBHKK5eCPwRi1fR_HpMu7udPvajCs9IfJE6bm8mYlaX8OGxVSAFfzoi0bTvhY7gup8P_pa5buEUE9AP477shoyg-bhx3zVHMGV7Rr3SJn1L0cBcGci5-GGXSAUSgXVLdq11mu5Tfeplm6LSb3LZNVv87OnaVU9ZFUpI-2ePsH0_-6UeNWE1Z79YCA_vuCg5TIMnip7O71rykxU5NdONqPpVybvWoa98vMcRLzwafbKYzX9t9Bj63TRPrIlkQ8jp09BObL_ZHbtkREjmw0R4V4uPxHAtB7nY9SwA-sF3pdrLr9MoLPlFkIkghjhK-ZqaW8Rn-TvTiab0ygserx5hqAgxMzVT008DnXKAEYXjMixLwWdCOpJgq8cQMQYH1DB7rFMFvuypLNjPG56wo6L-yL8tFGBB0CmzH5nfisvBioGQ=='
        self.config_template = b'gAAAAABgfQAWaJYNh8e_PWG4OJqBQVUEnAVswR2tsmliJXdzPP2yGXhzzORo7ZyyQ-0NWAqgdhZ0CM9SS9_9AL0LwPR3pwtHxpvYU6zQB1LR8ITWAhzKQPnrk2UuxN1FS4JrJMdywH0GRl5iRKxZTykPgApDS9DX09fkCC11PZVx-IoYOZ6VCh69dE7eMkaOlbdxepyA1GZqGi7k87GIQi4NslyHIq9BqDc6ogDaVFr3PKHrGnVVPDk03rTJqyrcxwvRROAA4zj5vK_3NPfZmvd0XMFsevcaFSW_3qeoy9u5rPpBJlQNn28J-eUanaQcq8FdlHXpv9kovuFr_-ubBwXQIVYl0cx578Lo56jPYJ6Fj1pfu8sAx68hRtQN2Jbc5YVpdCUoQL6LldaRfp7bnZDljv2E91DhnulD5hrhRbHrJp-RkgynOclA0XN5RwitATBkxDV5AEXDZOino8IydM7Yj6ZM2a5m_8VeqTTnHqHfV0RNfw4k1MxngCdNaeW2JzRRaktspZDNM3t9cSQqGGt_nhyB8bLNYM-k3sgtcU8d_WZ7ULgs9aTtefso_XmAPxKjAbb7lcVWXvfUZdN72EK4YFrnDMZ3RNt9et92wHP9RXdnFaBuc4qJF2PQlSczoQtsLb3yMjidOU6FiZw5BrZZsOBKk5wQ5q4H4WWsGDq0XtasxO6XLcxRLBY8yvBhi3BlpjkL-ehe'

        self.cipher = cipher.get_cipher(self.cipher_key)

    def create_file(self, filename: str, text: bytes):
        with open(filename, 'w') as f:
            f.write(cipher.decrypt_str(text, self.cipher))

    def create_console(self, filename: str = 'main.py'):
        if not filename.endswith('.py'):
            filename += '.py'
        self.create_file(filename, self.console_template)

    def create_gui(self, filename: str = 'main_gui.py'):
        if not filename.endswith('.py'):
            filename += '.py'
        self.create_file(filename, self.gui_template)

    def create_config(self, filename: str = 'settings.ini'):
        self.create_file(filename, self.config_template)


if __name__ == '__main__':
    pass
