// Copyright (c) 2023 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma once

#include "paddle/phi/core/dense_tensor.h"
#include "paddle/phi/core/tensor_utils.h"

namespace phi {

template <typename T, typename Context>
void FetchKernel(const Context& dev_ctx,
                 const DenseTensor& x,
                 DenseTensor* out) {
  if (!x.IsInitialized()) {
    return;
  }
  phi::Copy(dev_ctx, x, phi::CPUPlace(), true, out);
}

template <typename T, typename Context>
void FetchArrayKernel(const Context& dev_ctx,
                      const TensorArray& x,
                      TensorArray* out) {
  out->resize(x.size());
  for (size_t i = 0; i < x.size(); ++i) {
    phi::Copy(dev_ctx, x[i], phi::CPUPlace(), true, &(out->at(i)));
  }
}

}  // namespace phi
