import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_UpdateApplicationCommand, se_UpdateApplicationCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class UpdateApplicationCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeDeploy_20141006", "UpdateApplication", {})
    .n("CodeDeployClient", "UpdateApplicationCommand")
    .f(void 0, void 0)
    .ser(se_UpdateApplicationCommand)
    .de(de_UpdateApplicationCommand)
    .build() {
}
