/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.SwitchPatternHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public final class SwitchHelper {
    public static void simplifySwitchOnEnum(@NotNull SwitchStatement switchStatement) {
        ArrayExprent array;
        Map<Exprent, Exprent> mapping;
        SwitchExprent switchExprent = (SwitchExprent)switchStatement.getHeadExprent();
        Exprent value = Objects.requireNonNull(switchExprent).getValue();
        if (!SwitchHelper.isEnumArray(value)) {
            return;
        }
        List<List<@Nullable Exprent>> caseValues = switchStatement.getCaseValues();
        List<List<@Nullable Exprent>> realCaseValues = SwitchHelper.findRealCaseValues(caseValues, mapping = SwitchHelper.evaluateCaseLabelsToFieldsMapping(caseValues, array = (ArrayExprent)value));
        if (realCaseValues == null) {
            return;
        }
        caseValues.clear();
        caseValues.addAll(realCaseValues);
        switchExprent.replaceExprent(value, ((InvocationExprent)array.getIndex()).getInstance().copy());
    }

    public static void simplifySwitchesOnReferences(@NotNull RootStatement root, StructClass cl) {
        ArrayList<SwitchOnCandidate> candidates = new ArrayList<SwitchOnCandidate>();
        ArrayList<SwitchRecognizer> recognizers = new ArrayList<SwitchRecognizer>(Arrays.asList(new StringSwitchRecognizer.JavacStringRecognizer(), new StringSwitchRecognizer.EcjStringRecognizer()));
        if (cl.hasRecordPatternSupport() && DecompilerContext.getOption("cps")) {
            recognizers.add(new SwitchPatternHelper.JavacReferenceRecognizer());
        }
        SwitchHelper.collectSwitchesOn(root, recognizers, candidates, new HashSet<SwitchStatement>());
        if (candidates.isEmpty()) {
            return;
        }
        ArrayList<TempVarAssignmentItem> tempVarAssignments = new ArrayList<TempVarAssignmentItem>();
        candidates.forEach(candidate -> tempVarAssignments.addAll(candidate.prepareTempAssignments()));
        if (!SwitchHelper.checkAssignmentsToDelete(root, tempVarAssignments)) {
            return;
        }
        candidates.forEach(candidate -> candidate.simplify());
        SwitchHelper.removeTempVariableDeclarations(tempVarAssignments);
    }

    static boolean checkAssignmentsToDelete(@NotNull Statement parent, @NotNull List<TempVarAssignmentItem> items) {
        Map<VarExprent, List<VarExprent>> collected = items.stream().map(t -> t.varExprent()).collect(Collectors.groupingBy(t -> t));
        return SwitchHelper.checkRecursivelyAssignmentsToDelete(parent, collected);
    }

    private static boolean checkRecursivelyAssignmentsToDelete(@NotNull Statement statement, @NotNull Map<VarExprent, List<VarExprent>> collected) {
        List<Exprent> exprents = statement.getExprents();
        if (exprents != null) {
            for (Exprent exprent : exprents) {
                Exprent operand;
                FunctionExprent functionExprent;
                if (!(exprent instanceof AssignmentExprent)) continue;
                AssignmentExprent assignmentExprent = (AssignmentExprent)exprent;
                Exprent right = assignmentExprent.getRight();
                Exprent left = assignmentExprent.getLeft();
                boolean containsLeft = SwitchHelper.containVar(collected, left);
                if (right instanceof VarExprent) {
                    VarExprent varExprent = (VarExprent)right;
                    boolean containsRight = SwitchHelper.containVar(collected, varExprent);
                    if (containsLeft || !containsRight) continue;
                    return false;
                }
                if (!(right instanceof FunctionExprent) || (functionExprent = (FunctionExprent)right).getFuncType() != 29 || functionExprent.getLstOperands().size() != 2 || !(functionExprent.getLstOperands().get(1) instanceof ConstExprent) || !((operand = functionExprent.getLstOperands().get(0)) instanceof VarExprent)) continue;
                VarExprent varExprent = (VarExprent)operand;
                boolean containsRight = SwitchHelper.containVar(collected, varExprent);
                if (containsLeft || !containsRight) continue;
                return false;
            }
        }
        for (Statement child : statement.getStats()) {
            if (SwitchHelper.checkRecursivelyAssignmentsToDelete(child, collected)) continue;
            return false;
        }
        return true;
    }

    private static void collectSwitchesOn(@NotNull Statement statement, @NotNull List<SwitchRecognizer> recognizers, @NotNull List<SwitchOnCandidate> candidates, @NotNull Set<SwitchStatement> usedSwitchStatement) {
        SwitchExprent switchExprent;
        Exprent switchSelector;
        SwitchStatement switchStatement;
        if (statement instanceof SwitchStatement && !usedSwitchStatement.contains(switchStatement = (SwitchStatement)statement) && (switchSelector = Objects.requireNonNull(switchExprent = (SwitchExprent)switchStatement.getHeadExprent()).getValue()) instanceof InvocationExprent) {
            for (SwitchRecognizer recognizer : recognizers) {
                SwitchOnCandidate switchCandidate = recognizer.recognize(switchStatement, (InvocationExprent)switchSelector);
                if (switchCandidate == null) continue;
                candidates.add(0, switchCandidate);
                usedSwitchStatement.addAll(switchCandidate.usedSwitch());
                break;
            }
        }
        for (Statement child : statement.getStats()) {
            SwitchHelper.collectSwitchesOn(child, recognizers, candidates, usedSwitchStatement);
        }
    }

    @NotNull
    private static Map<Exprent, Exprent> evaluateCaseLabelsToFieldsMapping(@NotNull List<List<Exprent>> caseValues, @NotNull ArrayExprent array) {
        HashMap<Exprent, Exprent> mapping = new HashMap<Exprent, Exprent>(caseValues.size());
        if (array.getArray().type == 5) {
            FieldExprent arrayField = (FieldExprent)array.getArray();
            ClassesProcessor.ClassNode classNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(arrayField.getClassname());
            if (classNode == null) {
                return mapping;
            }
            MethodWrapper wrapper = classNode.getWrapper().getMethodWrapper("<clinit>", "()V");
            if (wrapper != null && wrapper.root != null) {
                wrapper.getOrBuildGraph().iterateExprents(exprent -> {
                    if (exprent instanceof AssignmentExprent) {
                        AssignmentExprent assignment = (AssignmentExprent)exprent;
                        Exprent left = assignment.getLeft();
                        if (left.type == 1 && ((ArrayExprent)left).getArray().equals(arrayField)) {
                            mapping.put(assignment.getRight(), ((InvocationExprent)((ArrayExprent)left).getIndex()).getInstance());
                        }
                    }
                    return 0;
                });
            }
        } else if (array.getArray().type == 8) {
            InvocationExprent invocationExprent = (InvocationExprent)array.getArray();
            ClassesProcessor.ClassNode classNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(invocationExprent.getClassName());
            if (classNode == null) {
                return mapping;
            }
            MethodWrapper wrapper = classNode.getWrapper().getMethodWrapper(invocationExprent.getName(), "()[I");
            if (wrapper != null && wrapper.root != null) {
                wrapper.getOrBuildGraph().iterateExprents(exprent -> {
                    if (exprent instanceof AssignmentExprent) {
                        AssignmentExprent assignment = (AssignmentExprent)exprent;
                        Exprent left = assignment.getLeft();
                        if (left.type == 1) {
                            Exprent indexExprent = ((ArrayExprent)left).getIndex();
                            if (indexExprent.type == 8 && ((InvocationExprent)indexExprent).getName().equals("ordinal")) {
                                mapping.put(assignment.getRight(), ((InvocationExprent)((ArrayExprent)left).getIndex()).getInstance());
                            }
                        }
                    }
                    return 0;
                });
            }
        }
        return mapping;
    }

    @Nullable
    private static @Nullable List<List<@Nullable Exprent>> findRealCaseValues(@NotNull List<List<Exprent>> caseValues, @NotNull Map<Exprent, Exprent> mapping) {
        ArrayList<List<@Nullable Exprent>> result = new ArrayList<List<Exprent>>(caseValues.size());
        for (List<Exprent> caseValue : caseValues) {
            ArrayList<@Nullable Exprent> values = new ArrayList<Exprent>(caseValue.size());
            result.add(values);
            for (Exprent exprent : caseValue) {
                if (exprent == null) {
                    values.add(null);
                    continue;
                }
                Exprent realConst = mapping.get(exprent);
                if (realConst == null) {
                    DecompilerContext.getLogger().writeMessage("Unable to simplify switch on enum: " + String.valueOf(exprent) + " not found, available: " + String.valueOf(mapping), IFernflowerLogger.Severity.ERROR);
                    return null;
                }
                values.add(realConst.copy());
            }
        }
        return result;
    }

    private static boolean isEnumArray(Exprent exprent) {
        if (!(exprent instanceof ArrayExprent)) {
            return false;
        }
        Exprent field = ((ArrayExprent)exprent).getArray();
        Exprent index = ((ArrayExprent)exprent).getIndex();
        boolean isJavacEnumArray = field instanceof FieldExprent && (((FieldExprent)field).getName().startsWith("$SwitchMap") || index instanceof InvocationExprent && ((InvocationExprent)index).getName().equals("ordinal"));
        boolean isEclipseEnumArray = field instanceof InvocationExprent && ((InvocationExprent)field).getName().startsWith("$SWITCH_TABLE");
        return isJavacEnumArray || isEclipseEnumArray;
    }

    static void removeTempVariableDeclarations(@NotNull List<TempVarAssignmentItem> tempVarAssignments) {
        if (tempVarAssignments.isEmpty()) {
            return;
        }
        HashSet<Statement> visited = new HashSet<Statement>();
        Set statements = tempVarAssignments.stream().filter(a -> a.delete).map(a -> a.statement()).collect(Collectors.toSet());
        Map<VarExprent, List<VarExprent>> vars = tempVarAssignments.stream().filter(a -> a.delete).map(a -> a.varExprent()).collect(Collectors.groupingBy(t -> t));
        Set preserve = tempVarAssignments.stream().filter(a -> !a.delete).map(t -> t.varExprent).collect(Collectors.toSet());
        Iterator iterator = statements.iterator();
        while (iterator.hasNext()) {
            Statement statement;
            for (Statement parent = statement = (Statement)iterator.next(); parent != null && !visited.contains(parent); parent = parent.getParent()) {
                visited.add(parent);
                List<Exprent> candidates = parent.getFirst() != null && parent.getFirst().type == Statement.StatementType.BASIC_BLOCK ? parent.getFirst().getExprents() : (parent.type == Statement.StatementType.TRY_CATCH || parent.type == Statement.StatementType.SEQUENCE ? parent.getVarDefinitions() : Collections.emptyList());
                if (candidates == null) {
                    candidates = new ArrayList<Exprent>();
                }
                ArrayList<List<Exprent>> listVarExprents = new ArrayList<List<Exprent>>();
                listVarExprents.add(candidates);
                if (parent.getExprents() != null) {
                    listVarExprents.add(parent.getExprents());
                }
                ArrayList<VarExprent> toDelete = new ArrayList<VarExprent>();
                for (List list : listVarExprents) {
                    for (int i = 0; i < list.size(); ++i) {
                        VarExprent varExprent;
                        Exprent exprent = (Exprent)list.get(i);
                        Exprent assignmentExprent = null;
                        if (exprent.type == 2) {
                            assignmentExprent = exprent;
                            exprent = ((AssignmentExprent)exprent).getLeft();
                        }
                        if (exprent.type != 12 || !SwitchHelper.containVar(vars, varExprent = (VarExprent)exprent) && (!varExprent.isDefinition() || !vars.containsKey(varExprent)) || varExprent.isDefinition() && preserve.contains(varExprent)) continue;
                        toDelete.add((VarExprent)(assignmentExprent == null ? varExprent : assignmentExprent));
                    }
                    list.removeAll(toDelete);
                }
            }
        }
    }

    private static boolean containVar(@NotNull Map<VarExprent, List<VarExprent>> vars, @Nullable Exprent exprent) {
        if (exprent == null) {
            return false;
        }
        List<VarExprent> exprents = vars.get(exprent);
        if (exprents == null) {
            return false;
        }
        for (VarExprent varExprent : exprents) {
            if (exprent != varExprent) continue;
            return true;
        }
        return false;
    }

    public static void prepareForRules(@NotNull Statement statement, @NotNull StructClass cl) {
        SwitchStatement switchStatement;
        if (!cl.hasEnhancedSwitchSupport()) {
            return;
        }
        if (statement instanceof SwitchStatement && SwitchHelper.canBeRules(switchStatement = (SwitchStatement)statement)) {
            switchStatement.setCanBeRule(true);
            SwitchHelper.prepareForRules(switchStatement);
        }
        for (Statement child : statement.getStats()) {
            SwitchHelper.prepareForRules(child, cl);
        }
    }

    private static boolean canBeRules(@NotNull SwitchStatement statement) {
        if (statement.isLabeled()) {
            return false;
        }
        for (List<Exprent> value : statement.getCaseValues()) {
            if (value.size() == 1) continue;
            return false;
        }
        for (Statement caseStatement : statement.getCaseStatements()) {
            if (caseStatement instanceof SequenceStatement || !caseStatement.getStats().isEmpty() || caseStatement.getExprents() != null && caseStatement.getExprents().size() > 1) {
                return false;
            }
            List<StatEdge> successorEdges = caseStatement.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
            if (successorEdges.size() != 1) {
                return false;
            }
            StatEdge edge = successorEdges.get(0);
            if (edge.getType() == StatEdge.EdgeType.BREAK) continue;
            return false;
        }
        return true;
    }

    private static void prepareForRules(@NotNull SwitchStatement statement) {
        for (Statement caseStatement : statement.getCaseStatements()) {
            StatEdge edge;
            List<StatEdge> successorEdges = caseStatement.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
            if (successorEdges.size() != 1 || (edge = successorEdges.get(0)).getType() != StatEdge.EdgeType.BREAK || !edge.explicit || edge.labeled) continue;
            edge.explicit = false;
        }
    }

    private static abstract class StringSwitchRecognizer
    implements SwitchRecognizer {
        private StringSwitchRecognizer() {
        }

        @Override
        @Nullable
        public abstract SwitchOnStringCandidate recognize(@NotNull SwitchStatement var1, @NotNull InvocationExprent var2);

        @NotNull
        Set<Object> findRealCaseValuesHashCodes(@NotNull SwitchStatement switchStatement) {
            return switchStatement.getCaseValues().stream().filter(values -> values.stream().noneMatch(Objects::isNull)).flatMap(Collection::stream).map(value -> (ConstExprent)value).map(ConstExprent::getValue).collect(Collectors.toSet());
        }

        @Nullable
        String findRealCaseValue(@NotNull IfStatement ifStatement, @NotNull Exprent selectorQualifier) {
            Exprent ifCondition = ifStatement.getHeadexprent().getCondition();
            if (ifCondition.type != 8) {
                return null;
            }
            InvocationExprent invocationCondition = (InvocationExprent)ifCondition;
            if (!invocationCondition.isInstanceCall("java/lang/String", "equals", 1)) {
                return null;
            }
            if (!invocationCondition.getInstance().equals(selectorQualifier)) {
                return null;
            }
            Exprent equalsParameter = invocationCondition.getParameters().get(0);
            if (equalsParameter.type != 3) {
                return null;
            }
            Object caseLabelValue = ((ConstExprent)equalsParameter).getValue();
            return caseLabelValue instanceof String ? (String)caseLabelValue : null;
        }

        private static class EcjStringRecognizer
        extends StringSwitchRecognizer {
            private EcjStringRecognizer() {
            }

            @Override
            @Nullable
            public SwitchOnStringCandidate recognize(@NotNull SwitchStatement switchStatement, @NotNull InvocationExprent switchSelector) {
                if (!switchSelector.isInstanceCall("java/lang/String", "hashCode", 0)) {
                    return null;
                }
                Set<Object> realCaseValueHashCodes = this.findRealCaseValuesHashCodes(switchStatement);
                Exprent switchSelectorQualifier = switchSelector.getInstance();
                HashMap<Integer, String> mappedCaseLabelValues = new HashMap<Integer, String>();
                HashMap<Integer, IfStatement> ifBodyStatements = new HashMap<Integer, IfStatement>();
                VarExprent tempVar = null;
                for (Statement statement : switchStatement.getCaseStatements()) {
                    if (statement.type != Statement.StatementType.IF) {
                        Statement defaultStatement = switchStatement.getDefaultEdge().getDestination();
                        if (defaultStatement == statement) continue;
                        return null;
                    }
                    Exprent tempSwitchSelectorQualifier = switchSelectorQualifier;
                    if (switchSelectorQualifier.type == 2) {
                        tempSwitchSelectorQualifier = ((AssignmentExprent)switchSelectorQualifier).getLeft();
                    } else if (switchSelectorQualifier.type == 3 && switchStatement.getFirst().getExprents() != null) {
                        Exprent finalSwitchSelectorQualifier = switchSelectorQualifier;
                        tempSwitchSelectorQualifier = switchStatement.getFirst().getExprents().stream().filter(exprent -> exprent instanceof AssignmentExprent).map(exprent -> (AssignmentExprent)exprent).filter(exprent -> exprent.getRight().equals(finalSwitchSelectorQualifier)).map(AssignmentExprent::getLeft).findFirst().orElse(null);
                        if (tempSwitchSelectorQualifier == null) {
                            return null;
                        }
                    }
                    if (tempVar != null && !tempVar.equals(tempSwitchSelectorQualifier)) {
                        return null;
                    }
                    IfStatement ifStatement = (IfStatement)statement;
                    tempVar = (VarExprent)tempSwitchSelectorQualifier;
                    String caseLabelValue = this.findRealCaseValue(ifStatement, tempVar);
                    if (caseLabelValue == null) {
                        return null;
                    }
                    int caseLabelHash = caseLabelValue.hashCode();
                    if (!realCaseValueHashCodes.remove(caseLabelHash)) {
                        return null;
                    }
                    mappedCaseLabelValues.put(caseLabelHash, caseLabelValue);
                    ifBodyStatements.put(caseLabelHash, ifStatement);
                }
                if (tempVar == null || !realCaseValueHashCodes.isEmpty()) {
                    return null;
                }
                if (switchSelectorQualifier instanceof AssignmentExprent) {
                    switchSelectorQualifier = ((AssignmentExprent)switchSelectorQualifier).getRight();
                }
                return new SwitchOnStringCandidate.EcjSwitchCandidate(switchStatement, switchSelectorQualifier, tempVar, ifBodyStatements, mappedCaseLabelValues);
            }
        }

        private static class JavacStringRecognizer
        extends StringSwitchRecognizer {
            private JavacStringRecognizer() {
            }

            @Override
            @Nullable
            public SwitchOnStringCandidate recognize(@NotNull SwitchStatement firstSwitch, @NotNull InvocationExprent switchSelector) {
                if (switchSelector.getInstance() == null || switchSelector.getInstance().type != 12) {
                    return null;
                }
                if (!switchSelector.isInstanceCall("java/lang/String", "hashCode", 0)) {
                    return null;
                }
                Set<Object> realCaseValueHashCodes = this.findRealCaseValuesHashCodes(firstSwitch);
                VarExprent firstSwitchSelectorQualifier = (VarExprent)switchSelector.getInstance();
                VarExprent tmpVarAssignTo = null;
                SwitchStatement secondSwitch = null;
                HashMap<Integer, String> mappedCaseLabelValues = new HashMap<Integer, String>();
                for (Statement statement : firstSwitch.getCaseStatements()) {
                    if (statement.type != Statement.StatementType.IF) {
                        Statement defaultStatement = firstSwitch.getDefaultEdge().getDestination();
                        if (defaultStatement == statement) continue;
                        return null;
                    }
                    IfStatement ifStatement = (IfStatement)statement;
                    String caseLabelValue = this.findRealCaseValue(ifStatement, firstSwitchSelectorQualifier);
                    if (caseLabelValue == null) {
                        return null;
                    }
                    if (!realCaseValueHashCodes.remove(caseLabelValue.hashCode())) {
                        return null;
                    }
                    if (ifStatement.getIfstat() == null) {
                        return null;
                    }
                    List<Exprent> ifStatementExprents = ifStatement.getIfstat().getExprents();
                    if (ifStatementExprents == null || ifStatementExprents.size() != 1) {
                        return null;
                    }
                    if (ifStatementExprents.get((int)0).type != 2) {
                        return null;
                    }
                    AssignmentExprent assignment = (AssignmentExprent)ifStatementExprents.get(0);
                    if (assignment.getLeft().type != 12 || assignment.getRight().type != 3) {
                        return null;
                    }
                    if (tmpVarAssignTo != null && !tmpVarAssignTo.equals(assignment.getLeft())) {
                        return null;
                    }
                    tmpVarAssignTo = (VarExprent)assignment.getLeft();
                    Object valueAssignedToTmpVar = ((ConstExprent)assignment.getRight()).getValue();
                    if (!(valueAssignedToTmpVar instanceof Integer)) {
                        return null;
                    }
                    mappedCaseLabelValues.put((Integer)valueAssignedToTmpVar, caseLabelValue);
                    if (ifStatement.getLabelEdges().size() != 1) {
                        return null;
                    }
                    Statement edgeDestination = ifStatement.getLabelEdges().iterator().next().getDestination();
                    if (edgeDestination.type == Statement.StatementType.SEQUENCE) {
                        edgeDestination = edgeDestination.getFirst();
                    }
                    if (edgeDestination.type != Statement.StatementType.SWITCH) {
                        return null;
                    }
                    if (secondSwitch != null && secondSwitch != edgeDestination) {
                        return null;
                    }
                    secondSwitch = (SwitchStatement)edgeDestination;
                }
                if (secondSwitch == null || !realCaseValueHashCodes.isEmpty()) {
                    return null;
                }
                Exprent siblingSwitchExprent = secondSwitch.getHeadExprent();
                if (siblingSwitchExprent == null) {
                    return null;
                }
                if (siblingSwitchExprent.type != 11) {
                    return null;
                }
                if (!tmpVarAssignTo.equals(((SwitchExprent)siblingSwitchExprent).getValue())) {
                    return null;
                }
                Exprent secondSwitchSelector = secondSwitch.getHeadExprent();
                if (secondSwitchSelector == null || secondSwitchSelector.type != 11) {
                    return null;
                }
                Statement firstStatementInFirstSwitch = firstSwitch.getFirst();
                if (firstStatementInFirstSwitch.type != Statement.StatementType.BASIC_BLOCK) {
                    return null;
                }
                Statement firstStatementInSecondSwitch = secondSwitch.getFirst();
                if (firstStatementInSecondSwitch.type != Statement.StatementType.BASIC_BLOCK) {
                    return null;
                }
                List<Exprent> firstSwitchExprents = firstStatementInFirstSwitch.getExprents();
                if (firstSwitchExprents == null || firstStatementInSecondSwitch.getExprents() == null) {
                    return null;
                }
                return new SwitchOnStringCandidate.JavacSwitchCandidate(firstSwitch, firstSwitchSelectorQualifier, tmpVarAssignTo, secondSwitch, mappedCaseLabelValues, firstSwitchExprents, secondSwitchSelector, firstStatementInSecondSwitch);
            }
        }
    }

    static interface SwitchRecognizer {
        @Nullable
        public SwitchOnCandidate recognize(@NotNull SwitchStatement var1, @NotNull InvocationExprent var2);
    }

    static interface SwitchOnCandidate {
        public void simplify();

        public Set<SwitchStatement> usedSwitch();

        public List<TempVarAssignmentItem> prepareTempAssignments();
    }

    record TempVarAssignmentItem(@NotNull VarExprent varExprent, @NotNull Statement statement, boolean delete) {
        TempVarAssignmentItem(@NotNull VarExprent varExprent, @NotNull Statement statement) {
            this(varExprent, statement, true);
        }
    }

    private static abstract class SwitchOnStringCandidate
    implements SwitchOnCandidate {
        private SwitchOnStringCandidate() {
        }

        @Nullable
        private static AssignmentExprent addTempVarAssignment(@NotNull Exprent exprent, @NotNull VarExprent varExprent, @NotNull Statement statement, @NotNull List<TempVarAssignmentItem> tempVarAssignments) {
            if (exprent.type != 2) {
                return null;
            }
            AssignmentExprent assignment = (AssignmentExprent)exprent;
            if (!varExprent.isDefinition() && varExprent.equals(assignment.getLeft())) {
                tempVarAssignments.add(new TempVarAssignmentItem(varExprent, statement));
                return assignment;
            }
            return null;
        }

        private static class EcjSwitchCandidate
        extends SwitchOnStringCandidate {
            @NotNull
            private final SwitchStatement switchStatement;
            @NotNull
            private final Exprent switchSelector;
            @NotNull
            private final @NotNull Map<Integer, @NotNull IfStatement> mappedIfStatements;
            @NotNull
            private final @NotNull Map<Integer, @NotNull String> mappedCaseLabelValues;
            @NotNull
            private final List<TempVarAssignmentItem> tempVarAssignments = new ArrayList<TempVarAssignmentItem>();

            private EcjSwitchCandidate(@NotNull SwitchStatement switchStatement, @NotNull Exprent switchSelector, @NotNull VarExprent tmpVar, @NotNull Map<Integer, IfStatement> mappedIfStatements, @NotNull Map<Integer, String> mappedCaseLabelValues) {
                this.switchStatement = switchStatement;
                this.switchSelector = switchSelector;
                this.mappedIfStatements = mappedIfStatements;
                this.mappedCaseLabelValues = mappedCaseLabelValues;
                this.tempVarAssignments.add(new TempVarAssignmentItem(tmpVar, switchStatement));
            }

            @Override
            public void simplify() {
                Exprent switchSelector = this.switchStatement.getHeadExprent();
                if (switchSelector == null || switchSelector.type != 11) {
                    return;
                }
                for (List<Exprent> values : this.switchStatement.getCaseValues()) {
                    for (int i = 0; i < values.size(); ++i) {
                        ConstExprent constExprent = (ConstExprent)values.get(i);
                        if (constExprent == null) continue;
                        int caseLabelHash = constExprent.getIntValue();
                        String labelValue = this.mappedCaseLabelValues.get(caseLabelHash);
                        values.set(i, new ConstExprent(VarType.VARTYPE_STRING, labelValue, null));
                        IfStatement ifStatement = this.mappedIfStatements.get(caseLabelHash);
                        assert (!ifStatement.getStats().isEmpty());
                        if (ifStatement.getStats().size() == 1) {
                            ifStatement.getParent().replaceStatement(ifStatement, (Statement)ifStatement.getStats().get(0));
                            continue;
                        }
                        EcjSwitchCandidate.removeOuterBreakEdge(ifStatement);
                        ifStatement.getParent().replaceStatement(ifStatement, new SequenceStatement(ifStatement.getStats()));
                    }
                }
                switchSelector.replaceExprent(((SwitchExprent)switchSelector).getValue(), this.switchSelector);
            }

            @Override
            public Set<SwitchStatement> usedSwitch() {
                return Set.of(this.switchStatement);
            }

            @Override
            public List<TempVarAssignmentItem> prepareTempAssignments() {
                return this.tempVarAssignments;
            }

            private static void removeOuterBreakEdge(@NotNull IfStatement ifStatement) {
                List<StatEdge> ifStatementBreakEdges = ifStatement.getSuccessorEdges(StatEdge.EdgeType.BREAK);
                if (ifStatementBreakEdges.size() != 1) {
                    return;
                }
                Statement lastStatement = (Statement)ifStatement.getStats().get(ifStatement.getStats().size() - 1);
                List<StatEdge> lastStatementBreakEdges = lastStatement.getSuccessorEdges(StatEdge.EdgeType.BREAK);
                if (lastStatementBreakEdges.size() != 1) {
                    return;
                }
                StatEdge firstIfStatementBreakEdge = ifStatementBreakEdges.get(0);
                StatEdge lastStatementBreakEdge = lastStatementBreakEdges.get(0);
                if (firstIfStatementBreakEdge.getDestination() != lastStatementBreakEdge.getDestination()) {
                    ifStatement.removeSuccessor(firstIfStatementBreakEdge);
                }
            }
        }

        private static class JavacSwitchCandidate
        extends SwitchOnStringCandidate {
            @NotNull
            private final SwitchStatement firstSwitch;
            @NotNull
            private final SwitchStatement secondSwitch;
            @NotNull
            private final VarExprent firstSwitchSelector;
            @NotNull
            private final Exprent secondSwitchSelector;
            @NotNull
            private final VarExprent tmpVarInFirstSwitch;
            @NotNull
            private final @NotNull Map<Integer, @NotNull String> mappedCaseLabelValues;
            @NotNull
            private final List<Exprent> firstSwitchExprents;
            @NotNull
            private final Statement firstStatementInSecondSwitch;
            @NotNull
            private final NewSelector newSelector;
            @NotNull
            private final List<TempVarAssignmentItem> tempVarAssignments = new ArrayList<TempVarAssignmentItem>();

            JavacSwitchCandidate(@NotNull SwitchStatement firstSwitch, @NotNull VarExprent firstSwitchSelector, @NotNull VarExprent tmpVarInFirstSwitch, @NotNull SwitchStatement secondSwitch, @NotNull Map<Integer, String> mappedCaseLabelValues, @NotNull List<Exprent> firstSwitchExprents, @NotNull Exprent secondSwitchSelector, @NotNull Statement firstStatementInSecondSwitch) {
                this.firstSwitch = firstSwitch;
                this.secondSwitch = secondSwitch;
                this.firstSwitchSelector = firstSwitchSelector;
                this.secondSwitchSelector = secondSwitchSelector;
                this.tmpVarInFirstSwitch = tmpVarInFirstSwitch;
                this.mappedCaseLabelValues = mappedCaseLabelValues;
                this.firstSwitchExprents = firstSwitchExprents;
                this.firstStatementInSecondSwitch = firstStatementInSecondSwitch;
                this.newSelector = this.getSelector(this.tempVarAssignments, firstSwitchExprents);
            }

            @Override
            public void simplify() {
                List<Exprent> exprents;
                boolean parentsAreTheSame;
                for (List<Exprent> values : this.secondSwitch.getCaseValues()) {
                    for (int i = 0; i < values.size(); ++i) {
                        ConstExprent constExprent = (ConstExprent)values.get(i);
                        if (constExprent == null) continue;
                        String labelValue = this.mappedCaseLabelValues.get(constExprent.getIntValue());
                        values.set(i, new ConstExprent(VarType.VARTYPE_STRING, labelValue, null));
                    }
                }
                List<Object> newExprents = this.newSelector.lastExprentIndex() > 0 ? List.copyOf(this.firstSwitchExprents.subList(0, this.newSelector.lastExprentIndex())) : Collections.emptyList();
                Statement firstSwitchParent = this.firstSwitch.getParent();
                Statement secondSwitchParent = this.secondSwitch.getParent();
                boolean bl = parentsAreTheSame = firstSwitchParent == secondSwitchParent;
                if (parentsAreTheSame || secondSwitchParent == this.firstSwitch) {
                    firstSwitchParent.replaceStatement(this.firstSwitch, this.secondSwitch);
                } else if (secondSwitchParent.getParent() == this.firstSwitch) {
                    firstSwitchParent.replaceStatement(this.firstSwitch, secondSwitchParent);
                }
                if (parentsAreTheSame) {
                    firstSwitchParent.getStats().removeWithKey(this.secondSwitch.id);
                }
                if ((exprents = this.firstStatementInSecondSwitch.getExprents()) != null) {
                    exprents.addAll(0, newExprents);
                }
                this.secondSwitchSelector.replaceExprent(((SwitchExprent)this.secondSwitchSelector).getValue(), this.newSelector.newSelector());
            }

            @Override
            public Set<SwitchStatement> usedSwitch() {
                return Set.of(this.firstSwitch, this.secondSwitch);
            }

            @NotNull
            private NewSelector getSelector(@NotNull List<TempVarAssignmentItem> tempVarAssignments, List<Exprent> firstSwitchExprents) {
                AssignmentExprent assignment;
                AssignmentExprent assignment2;
                int lastExprentIndex = firstSwitchExprents.size();
                if (lastExprentIndex > 0 && (assignment2 = SwitchOnStringCandidate.addTempVarAssignment(firstSwitchExprents.get(lastExprentIndex - 1), this.tmpVarInFirstSwitch, this.secondSwitch, tempVarAssignments)) != null) {
                    --lastExprentIndex;
                }
                Exprent newSelector = this.firstSwitchSelector;
                if (lastExprentIndex > 0 && (assignment = SwitchOnStringCandidate.addTempVarAssignment(firstSwitchExprents.get(lastExprentIndex - 1), this.firstSwitchSelector, this.secondSwitch, tempVarAssignments)) != null) {
                    --lastExprentIndex;
                    newSelector = assignment.getRight();
                }
                return new NewSelector(lastExprentIndex, newSelector);
            }

            @Override
            public List<TempVarAssignmentItem> prepareTempAssignments() {
                return this.tempVarAssignments;
            }

            private record NewSelector(int lastExprentIndex, Exprent newSelector) {
            }
        }
    }
}

