/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersion;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.TextBuffer;

public abstract class Exprent
implements IMatchable {
    public static final int MULTIPLE_USES = 1;
    public static final int SIDE_EFFECTS_FREE = 2;
    public static final int BOTH_FLAGS = 3;
    public static final int EXPRENT_ARRAY = 1;
    public static final int EXPRENT_ASSIGNMENT = 2;
    public static final int EXPRENT_CONST = 3;
    public static final int EXPRENT_EXIT = 4;
    public static final int EXPRENT_FIELD = 5;
    public static final int EXPRENT_FUNCTION = 6;
    public static final int EXPRENT_IF = 7;
    public static final int EXPRENT_INVOCATION = 8;
    public static final int EXPRENT_MONITOR = 9;
    public static final int EXPRENT_NEW = 10;
    public static final int EXPRENT_SWITCH = 11;
    public static final int EXPRENT_VAR = 12;
    public static final int EXPRENT_ANNOTATION = 13;
    public static final int EXPRENT_ASSERT = 14;
    public final int type;
    public final int id;
    @Nullable
    public BitSet bytecode = null;

    public Exprent(int type) {
        this.type = type;
        this.id = DecompilerContext.getCounterContainer().getCounterAndIncrement(1);
    }

    public int getPrecedence() {
        return 0;
    }

    @NotNull
    public VarType getExprType() {
        return VarType.VARTYPE_VOID;
    }

    public void inferExprType(VarType upperBound) {
    }

    public int getExprentUse() {
        return 0;
    }

    public CheckTypesResult checkExprTypeBounds() {
        return null;
    }

    public boolean containsExprent(Exprent exprent) {
        if (this.equals(exprent)) {
            return true;
        }
        List<Exprent> lst = this.getAllExprents();
        for (int i = lst.size() - 1; i >= 0; --i) {
            if (!lst.get(i).containsExprent(exprent)) continue;
            return true;
        }
        return false;
    }

    public final List<Exprent> getAllExprents(boolean recursive) {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        this.getAllExprents(recursive, lst);
        return lst;
    }

    private List<Exprent> getAllExprents(boolean recursive, List<Exprent> list) {
        int start = list.size();
        this.getAllExprents(list);
        int end = list.size();
        if (recursive) {
            for (int i = end - 1; i >= start; --i) {
                list.get(i).getAllExprents(true, list);
            }
        }
        return list;
    }

    public Set<VarVersion> getAllVariables() {
        List<Exprent> lstAllExprents = this.getAllExprents(true);
        lstAllExprents.add(this);
        HashSet<VarVersion> set = new HashSet<VarVersion>();
        for (Exprent expr : lstAllExprents) {
            if (expr.type != 12) continue;
            set.add(new VarVersion((VarExprent)expr));
        }
        return set;
    }

    public final List<Exprent> getAllExprents() {
        ArrayList<Exprent> list = new ArrayList<Exprent>();
        this.getAllExprents(list);
        return list;
    }

    protected abstract List<Exprent> getAllExprents(List<Exprent> var1);

    public Exprent copy() {
        throw new RuntimeException("not implemented");
    }

    public TextBuffer toJava() {
        return this.toJava(0, BytecodeMappingTracer.DUMMY);
    }

    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        throw new RuntimeException("not implemented");
    }

    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
    }

    public void addBytecodeOffsets(@Nullable BitSet bytecodeOffsets) {
        if (bytecodeOffsets != null) {
            if (this.bytecode == null) {
                this.bytecode = new BitSet();
            }
            this.bytecode.or(bytecodeOffsets);
        }
    }

    public abstract void fillBytecodeRange(@Nullable BitSet var1);

    protected void measureBytecode(@Nullable BitSet values) {
        if (this.bytecode != null && values != null) {
            values.or(this.bytecode);
        }
    }

    protected static void measureBytecode(@Nullable BitSet values, @Nullable Exprent exprent) {
        if (exprent != null) {
            exprent.fillBytecodeRange(values);
        }
    }

    protected static void measureBytecode(@Nullable BitSet values, @Nullable List<? extends Exprent> list) {
        if (list != null && !list.isEmpty()) {
            for (Exprent exprent : list) {
                exprent.fillBytecodeRange(values);
            }
        }
    }

    public static List<? extends Exprent> sortIndexed(List<? extends Exprent> lst) {
        ArrayList ret = new ArrayList();
        ArrayList<VarExprent> defs = new ArrayList<VarExprent>();
        Comparator<VarExprent> comp = Comparator.comparingInt(VarExprent::getIndex);
        for (Exprent exprent : lst) {
            boolean isDef;
            boolean bl = isDef = exprent instanceof VarExprent && ((VarExprent)exprent).isDefinition();
            if (!isDef) {
                if (!defs.isEmpty()) {
                    Collections.sort(defs, comp);
                    ret.addAll(defs);
                    defs.clear();
                }
                ret.add(exprent);
                continue;
            }
            defs.add((VarExprent)exprent);
        }
        if (!defs.isEmpty()) {
            Collections.sort(defs, comp);
            ret.addAll(defs);
        }
        return ret;
    }

    protected VarType gatherGenerics(VarType upperBound, VarType ret, List<String> fparams, List<VarType> genericArgs) {
        HashMap<VarType, VarType> map = new HashMap<VarType, VarType>();
        if (upperBound != null && upperBound.isGeneric() && ret.isGeneric()) {
            List<VarType> leftArgs = ((GenericType)upperBound).getArguments();
            List<VarType> rightArgs = ((GenericType)ret).getArguments();
            if (leftArgs.size() == rightArgs.size() && rightArgs.size() == fparams.size()) {
                for (int i = 0; i < leftArgs.size(); ++i) {
                    VarType left = leftArgs.get(i);
                    VarType right = rightArgs.get(i);
                    if (left == null || !right.getValue().equals(fparams.get(i))) {
                        genericArgs.clear();
                        map.clear();
                        break;
                    }
                    genericArgs.add(left);
                    map.put(right, left);
                }
            }
        }
        return map.isEmpty() ? ret : ret.remap(map);
    }

    protected void appendParameters(TextBuffer buf, List<VarType> genericArgs) {
        if (genericArgs.isEmpty()) {
            return;
        }
        buf.append("<");
        for (int i = 0; i < genericArgs.size(); ++i) {
            buf.append(ExprProcessor.getCastTypeName(genericArgs.get(i), Collections.emptyList()));
            if (i + 1 >= genericArgs.size()) continue;
            buf.append(", ");
        }
        buf.append(">");
    }

    protected Map<VarType, List<VarType>> getNamedGenerics() {
        GenericMethodDescriptor mtd;
        GenericClassDescriptor cls;
        HashMap<VarType, List<VarType>> ret = new HashMap<VarType, List<VarType>>();
        ClassesProcessor.ClassNode class_ = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        MethodWrapper method = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
        GenericClassDescriptor genericClassDescriptor = cls = class_ == null ? null : class_.classStruct.getSignature();
        if (cls != null) {
            for (int x = 0; x < cls.fparameters.size(); ++x) {
                ret.put(GenericType.parse("T" + cls.fparameters.get(x) + ";"), cls.fbounds.get(x));
            }
        }
        GenericMethodDescriptor genericMethodDescriptor = mtd = method == null ? null : method.methodStruct.getSignature();
        if (mtd != null) {
            for (int x = 0; x < mtd.typeParameters.size(); ++x) {
                ret.put(GenericType.parse("T" + mtd.typeParameters.get(x) + ";"), mtd.typeParameterBounds.get(x));
            }
        }
        return ret;
    }

    protected void wrapInCast(VarType left, VarType right, TextBuffer buf, int precedence) {
        boolean needsCast;
        boolean bl = needsCast = left != null && !left.isSuperset(right) && (right.equals(VarType.VARTYPE_OBJECT) || left.getType() != 8);
        if (left != null && right != null && (left.isGeneric() || right.isGeneric())) {
            List<VarType> types;
            Map<VarType, List<VarType>> names = this.getNamedGenerics();
            int arrayDim = 0;
            if (left.getArrayDim() == right.getArrayDim() && left.getArrayDim() > 0) {
                arrayDim = left.getArrayDim();
                left = left.resizeArrayDim(0);
                right = right.resizeArrayDim(0);
            }
            if ((types = names.get(right)) == null) {
                types = names.get(left);
            }
            if (types != null) {
                boolean anyMatch = false;
                for (VarType type : types) {
                    if (!(type.equals(VarType.VARTYPE_OBJECT) && right.equals(VarType.VARTYPE_OBJECT) || !(anyMatch = right.getValue() == null || DecompilerContext.getStructContext().instanceOf(right.getValue(), type.getValue())))) break;
                }
                if (anyMatch) {
                    needsCast = false;
                }
            }
            if (arrayDim != 0) {
                left = left.resizeArrayDim(arrayDim);
            }
        }
        if (!needsCast) {
            return;
        }
        if (precedence >= FunctionExprent.getPrecedence(29)) {
            buf.enclose("(", ")");
        }
        buf.prepend("(" + ExprProcessor.getCastTypeName(left, Collections.emptyList()) + ")");
    }

    @Override
    public IMatchable findObject(MatchNode matchNode, int index) {
        if (matchNode.getType() != 1) {
            return null;
        }
        List<Exprent> lstAllExprents = this.getAllExprents();
        if (lstAllExprents.isEmpty()) {
            return null;
        }
        String position = (String)matchNode.getRuleValue(IMatchable.MatchProperties.EXPRENT_POSITION);
        if (position != null) {
            if (position.matches("-?\\d+")) {
                return lstAllExprents.get((lstAllExprents.size() + Integer.parseInt(position)) % lstAllExprents.size());
            }
        } else if (index < lstAllExprents.size()) {
            return lstAllExprents.get(index);
        }
        return null;
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (matchNode.getType() != 1) {
            return false;
        }
        for (Map.Entry<IMatchable.MatchProperties, MatchNode.RuleValue> rule : matchNode.getRules().entrySet()) {
            IMatchable.MatchProperties key = rule.getKey();
            if (key == IMatchable.MatchProperties.EXPRENT_TYPE && this.type != (Integer)rule.getValue().value) {
                return false;
            }
            if (key != IMatchable.MatchProperties.EXPRENT_RET || engine.checkAndSetVariableValue((String)rule.getValue().value, this)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toJava(0, BytecodeMappingTracer.DUMMY).toString();
    }
}

