# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDeviceResult',
    'AwaitableGetDeviceResult',
    'get_device',
    'get_device_output',
]

@pulumi.output_type
class GetDeviceResult:
    """
    A collection of values returned by getDevice.
    """
    def __init__(__self__, devices=None, id=None, name=None, serial_number=None):
        if devices and not isinstance(devices, list):
            raise TypeError("Expected argument 'devices' to be a list")
        pulumi.set(__self__, "devices", devices)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if serial_number and not isinstance(serial_number, str):
            raise TypeError("Expected argument 'serial_number' to be a str")
        pulumi.set(__self__, "serial_number", serial_number)

    @property
    @pulumi.getter
    def devices(self) -> Sequence['outputs.GetDeviceDeviceResult']:
        """
        List of returned devices
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the object
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The hostname of a device
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[str]:
        """
        Serial number for device. Could be board or virtual identifier
        """
        return pulumi.get(self, "serial_number")


class AwaitableGetDeviceResult(GetDeviceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeviceResult(
            devices=self.devices,
            id=self.id,
            name=self.name,
            serial_number=self.serial_number)


def get_device(name: Optional[str] = None,
               serial_number: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeviceResult:
    """
    This data source can read the Device .

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_device(serial_number="12B53B6E42654E01B98C77C347CE216E",
        name="Controller01")
    ```


    :param str name: The hostname of a device
    :param str serial_number: Serial number for device. Could be board or virtual identifier
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['serialNumber'] = serial_number
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getDevice:getDevice', __args__, opts=opts, typ=GetDeviceResult).value

    return AwaitableGetDeviceResult(
        devices=pulumi.get(__ret__, 'devices'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        serial_number=pulumi.get(__ret__, 'serial_number'))
def get_device_output(name: Optional[pulumi.Input[Optional[str]]] = None,
                      serial_number: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDeviceResult]:
    """
    This data source can read the Device .

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_device(serial_number="12B53B6E42654E01B98C77C347CE216E",
        name="Controller01")
    ```


    :param str name: The hostname of a device
    :param str serial_number: Serial number for device. Could be board or virtual identifier
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['serialNumber'] = serial_number
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getDevice:getDevice', __args__, opts=opts, typ=GetDeviceResult)
    return __ret__.apply(lambda __response__: GetDeviceResult(
        devices=pulumi.get(__response__, 'devices'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        serial_number=pulumi.get(__response__, 'serial_number')))
