# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSystemAaaFeatureResult',
    'AwaitableGetSystemAaaFeatureResult',
    'get_system_aaa_feature',
    'get_system_aaa_feature_output',
]

@pulumi.output_type
class GetSystemAaaFeatureResult:
    """
    A collection of values returned by getSystemAaaFeature.
    """
    def __init__(__self__, accounting_group=None, accounting_group_variable=None, accounting_rules=None, authentication_group=None, authentication_group_variable=None, authorization_config_commands=None, authorization_config_commands_variable=None, authorization_console=None, authorization_console_variable=None, authorization_rules=None, description=None, feature_profile_id=None, id=None, name=None, radius_groups=None, server_auth_orders=None, tacacs_groups=None, users=None, version=None):
        if accounting_group and not isinstance(accounting_group, bool):
            raise TypeError("Expected argument 'accounting_group' to be a bool")
        pulumi.set(__self__, "accounting_group", accounting_group)
        if accounting_group_variable and not isinstance(accounting_group_variable, str):
            raise TypeError("Expected argument 'accounting_group_variable' to be a str")
        pulumi.set(__self__, "accounting_group_variable", accounting_group_variable)
        if accounting_rules and not isinstance(accounting_rules, list):
            raise TypeError("Expected argument 'accounting_rules' to be a list")
        pulumi.set(__self__, "accounting_rules", accounting_rules)
        if authentication_group and not isinstance(authentication_group, bool):
            raise TypeError("Expected argument 'authentication_group' to be a bool")
        pulumi.set(__self__, "authentication_group", authentication_group)
        if authentication_group_variable and not isinstance(authentication_group_variable, str):
            raise TypeError("Expected argument 'authentication_group_variable' to be a str")
        pulumi.set(__self__, "authentication_group_variable", authentication_group_variable)
        if authorization_config_commands and not isinstance(authorization_config_commands, bool):
            raise TypeError("Expected argument 'authorization_config_commands' to be a bool")
        pulumi.set(__self__, "authorization_config_commands", authorization_config_commands)
        if authorization_config_commands_variable and not isinstance(authorization_config_commands_variable, str):
            raise TypeError("Expected argument 'authorization_config_commands_variable' to be a str")
        pulumi.set(__self__, "authorization_config_commands_variable", authorization_config_commands_variable)
        if authorization_console and not isinstance(authorization_console, bool):
            raise TypeError("Expected argument 'authorization_console' to be a bool")
        pulumi.set(__self__, "authorization_console", authorization_console)
        if authorization_console_variable and not isinstance(authorization_console_variable, str):
            raise TypeError("Expected argument 'authorization_console_variable' to be a str")
        pulumi.set(__self__, "authorization_console_variable", authorization_console_variable)
        if authorization_rules and not isinstance(authorization_rules, list):
            raise TypeError("Expected argument 'authorization_rules' to be a list")
        pulumi.set(__self__, "authorization_rules", authorization_rules)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if feature_profile_id and not isinstance(feature_profile_id, str):
            raise TypeError("Expected argument 'feature_profile_id' to be a str")
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if radius_groups and not isinstance(radius_groups, list):
            raise TypeError("Expected argument 'radius_groups' to be a list")
        pulumi.set(__self__, "radius_groups", radius_groups)
        if server_auth_orders and not isinstance(server_auth_orders, list):
            raise TypeError("Expected argument 'server_auth_orders' to be a list")
        pulumi.set(__self__, "server_auth_orders", server_auth_orders)
        if tacacs_groups and not isinstance(tacacs_groups, list):
            raise TypeError("Expected argument 'tacacs_groups' to be a list")
        pulumi.set(__self__, "tacacs_groups", tacacs_groups)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="accountingGroup")
    def accounting_group(self) -> bool:
        """
        Accounting configurations parameters
        """
        return pulumi.get(self, "accounting_group")

    @property
    @pulumi.getter(name="accountingGroupVariable")
    def accounting_group_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "accounting_group_variable")

    @property
    @pulumi.getter(name="accountingRules")
    def accounting_rules(self) -> Sequence['outputs.GetSystemAaaFeatureAccountingRuleResult']:
        """
        Configure the accounting rules
        """
        return pulumi.get(self, "accounting_rules")

    @property
    @pulumi.getter(name="authenticationGroup")
    def authentication_group(self) -> bool:
        """
        Authentication configurations parameters
        """
        return pulumi.get(self, "authentication_group")

    @property
    @pulumi.getter(name="authenticationGroupVariable")
    def authentication_group_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_group_variable")

    @property
    @pulumi.getter(name="authorizationConfigCommands")
    def authorization_config_commands(self) -> bool:
        """
        For configuration mode commands.
        """
        return pulumi.get(self, "authorization_config_commands")

    @property
    @pulumi.getter(name="authorizationConfigCommandsVariable")
    def authorization_config_commands_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_config_commands_variable")

    @property
    @pulumi.getter(name="authorizationConsole")
    def authorization_console(self) -> bool:
        """
        For enabling console authorization
        """
        return pulumi.get(self, "authorization_console")

    @property
    @pulumi.getter(name="authorizationConsoleVariable")
    def authorization_console_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_console_variable")

    @property
    @pulumi.getter(name="authorizationRules")
    def authorization_rules(self) -> Sequence['outputs.GetSystemAaaFeatureAuthorizationRuleResult']:
        """
        Configure the Authorization Rules
        """
        return pulumi.get(self, "authorization_rules")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> str:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the Feature
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="radiusGroups")
    def radius_groups(self) -> Sequence['outputs.GetSystemAaaFeatureRadiusGroupResult']:
        """
        Configure the Radius serverGroup
        """
        return pulumi.get(self, "radius_groups")

    @property
    @pulumi.getter(name="serverAuthOrders")
    def server_auth_orders(self) -> Sequence[str]:
        """
        ServerGroups priority order
        """
        return pulumi.get(self, "server_auth_orders")

    @property
    @pulumi.getter(name="tacacsGroups")
    def tacacs_groups(self) -> Sequence['outputs.GetSystemAaaFeatureTacacsGroupResult']:
        """
        Configure the TACACS serverGroup
        """
        return pulumi.get(self, "tacacs_groups")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetSystemAaaFeatureUserResult']:
        """
        Create local login account
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")


class AwaitableGetSystemAaaFeatureResult(GetSystemAaaFeatureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSystemAaaFeatureResult(
            accounting_group=self.accounting_group,
            accounting_group_variable=self.accounting_group_variable,
            accounting_rules=self.accounting_rules,
            authentication_group=self.authentication_group,
            authentication_group_variable=self.authentication_group_variable,
            authorization_config_commands=self.authorization_config_commands,
            authorization_config_commands_variable=self.authorization_config_commands_variable,
            authorization_console=self.authorization_console,
            authorization_console_variable=self.authorization_console_variable,
            authorization_rules=self.authorization_rules,
            description=self.description,
            feature_profile_id=self.feature_profile_id,
            id=self.id,
            name=self.name,
            radius_groups=self.radius_groups,
            server_auth_orders=self.server_auth_orders,
            tacacs_groups=self.tacacs_groups,
            users=self.users,
            version=self.version)


def get_system_aaa_feature(feature_profile_id: Optional[str] = None,
                           id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSystemAaaFeatureResult:
    """
    This data source can read the System AAA Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_system_aaa_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param str feature_profile_id: Feature Profile ID
    :param str id: The id of the Feature
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getSystemAaaFeature:getSystemAaaFeature', __args__, opts=opts, typ=GetSystemAaaFeatureResult).value

    return AwaitableGetSystemAaaFeatureResult(
        accounting_group=pulumi.get(__ret__, 'accounting_group'),
        accounting_group_variable=pulumi.get(__ret__, 'accounting_group_variable'),
        accounting_rules=pulumi.get(__ret__, 'accounting_rules'),
        authentication_group=pulumi.get(__ret__, 'authentication_group'),
        authentication_group_variable=pulumi.get(__ret__, 'authentication_group_variable'),
        authorization_config_commands=pulumi.get(__ret__, 'authorization_config_commands'),
        authorization_config_commands_variable=pulumi.get(__ret__, 'authorization_config_commands_variable'),
        authorization_console=pulumi.get(__ret__, 'authorization_console'),
        authorization_console_variable=pulumi.get(__ret__, 'authorization_console_variable'),
        authorization_rules=pulumi.get(__ret__, 'authorization_rules'),
        description=pulumi.get(__ret__, 'description'),
        feature_profile_id=pulumi.get(__ret__, 'feature_profile_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        radius_groups=pulumi.get(__ret__, 'radius_groups'),
        server_auth_orders=pulumi.get(__ret__, 'server_auth_orders'),
        tacacs_groups=pulumi.get(__ret__, 'tacacs_groups'),
        users=pulumi.get(__ret__, 'users'),
        version=pulumi.get(__ret__, 'version'))
def get_system_aaa_feature_output(feature_profile_id: Optional[pulumi.Input[str]] = None,
                                  id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSystemAaaFeatureResult]:
    """
    This data source can read the System AAA Feature.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_system_aaa_feature(id="f6b2c44c-693c-4763-b010-895aa3d236bd",
        feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac")
    ```


    :param str feature_profile_id: Feature Profile ID
    :param str id: The id of the Feature
    """
    __args__ = dict()
    __args__['featureProfileId'] = feature_profile_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getSystemAaaFeature:getSystemAaaFeature', __args__, opts=opts, typ=GetSystemAaaFeatureResult)
    return __ret__.apply(lambda __response__: GetSystemAaaFeatureResult(
        accounting_group=pulumi.get(__response__, 'accounting_group'),
        accounting_group_variable=pulumi.get(__response__, 'accounting_group_variable'),
        accounting_rules=pulumi.get(__response__, 'accounting_rules'),
        authentication_group=pulumi.get(__response__, 'authentication_group'),
        authentication_group_variable=pulumi.get(__response__, 'authentication_group_variable'),
        authorization_config_commands=pulumi.get(__response__, 'authorization_config_commands'),
        authorization_config_commands_variable=pulumi.get(__response__, 'authorization_config_commands_variable'),
        authorization_console=pulumi.get(__response__, 'authorization_console'),
        authorization_console_variable=pulumi.get(__response__, 'authorization_console_variable'),
        authorization_rules=pulumi.get(__response__, 'authorization_rules'),
        description=pulumi.get(__response__, 'description'),
        feature_profile_id=pulumi.get(__response__, 'feature_profile_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        radius_groups=pulumi.get(__response__, 'radius_groups'),
        server_auth_orders=pulumi.get(__response__, 'server_auth_orders'),
        tacacs_groups=pulumi.get(__response__, 'tacacs_groups'),
        users=pulumi.get(__response__, 'users'),
        version=pulumi.get(__response__, 'version')))
