"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, (0, core_1.generateIntegStackName)(__filename));
stack.templateOptions.description = 'Integration Test for aws-apigateway-sagemakerendpoint';
// Definitions
const requestTemplate = `{
    "instances": [
#set( $user_id = $input.params("user_id") )
#set( $items = $input.params("items") )
#foreach( $item in $items.split(",") )
    {"in0": [$user_id], "in1": [$item]}#if( $foreach.hasNext ),#end
    $esc.newline
#end
    ]
}`;
const props = {
    endpointName: 'my-endpoint',
    resourcePath: '{user_id}',
    requestMappingTemplate: requestTemplate
};
new lib_1.ApiGatewayToSageMakerEndpoint(stack, 'test-apigateway-sagemakerendpoint-default', props);
// Synth
new integ_tests_alpha_1.IntegTest(stack, 'Integ', { testCases: [
        stack
    ] });
//# sourceMappingURL=data:application/json;base64,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